/*
 * Decompiled with CFR 0.152.
 */
package pilotdb.ui.recordsetview;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JTextField;
import pilotdb.PilotDBRecord;
import pilotdb.ui.Application;
import pilotdb.ui.recordsetview.EditorComponent;
import pilotdb.ui.util.UnderlineLabel;

public class StringEditor
extends JPanel
implements EditorComponent {
    JTextField jtf = new JTextField();
    UnderlineLabel jl = new UnderlineLabel();

    public StringEditor() {
        this.jtf.setBorder(BorderFactory.createLineBorder(Color.lightGray));
        this.setLayout(null);
        this.jtf.setBounds(0, 0, 225, 20);
        this.jl.setBounds(0, 0, 225, 20);
        this.jl.setDrawLineFullWidth(true);
        this.add(this.jtf);
        this.add(this.jl);
        this.setPreferredSize(new Dimension(225, 20));
    }

    public boolean isValid() {
        return true;
    }

    public String getInvalidReason() {
        return null;
    }

    public Component getEditorComponent() {
        return this;
    }

    public void display(PilotDBRecord record, int fieldIndex) throws Exception {
        String val = record.getString(fieldIndex);
        if (val == null) {
            return;
        }
        this.jl.setText(val);
        this.jtf.setVisible(false);
        this.jl.setVisible(true);
    }

    public void stopEditing(PilotDBRecord record, int fieldIndex) throws Exception {
        this.jtf.setEnabled(false);
        String s = this.jtf.getText();
        record.setString(fieldIndex, s);
    }

    public void startEditing(PilotDBRecord record, int fieldIndex) throws Exception {
        this.jl.setVisible(false);
        this.jtf.setEnabled(true);
        this.jtf.setVisible(true);
        String val = record.getString(fieldIndex);
        if (val == null) {
            return;
        }
        this.jtf.setText(val);
    }

    public void cancelEditing(PilotDBRecord record, int fieldIndex) {
        this.jtf.setEnabled(false);
        try {
            String string = record.getString(fieldIndex);
            if (string == null) {
                return;
            }
            this.jtf.setText(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setBridge(Application bridge) {
    }
}

