/*
 * Decompiled with CFR 0.152.
 */
package pilotdb.ui.simplecreator.csv;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.CellEditor;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.DefaultTableCellRenderer;
import pilotdb.PilotDBDatabase;
import pilotdb.tools.PluginMonitor;
import pilotdb.tools.simplecreator.csv.CSVImportModel;
import pilotdb.tools.simplecreator.csv.Plugin;
import pilotdb.ui.Application;
import pilotdb.ui.command.Command;
import pilotdb.ui.images.Images;
import pilotdb.ui.simplecreator.csv.CsvFieldsTableModel;
import pilotdb.ui.simplecreator.csv.CsvViewListTableModel;
import pilotdb.ui.simplecreator.csv.CsvViewTableModel;
import pilotdb.ui.util.FlatJButton;
import pilotdb.ui.util.FlatTableCellRenderer;
import pilotdb.ui.util.UIBanner;

public class Wizard
extends JPanel
implements ActionListener,
ListSelectionListener,
ItemListener,
DocumentListener,
PluginMonitor {
    JPanel jpIntro;
    JPanel jpCsvFile;
    JPanel jpDbInfo;
    JPanel jpFields;
    JPanel jpViews;
    JPanel jpFormats;
    JPanel jpOptions;
    JPanel jpFinish;
    JCheckBox jchkIntroLoadConfig;
    JCheckBox jchkIntroCreateConfig;
    JLabel jlIntroLoadConfig;
    JButton jbIntroLoadConfig;
    JLabel jlCsvSelectFile;
    JLabel jlCsvFile;
    JButton jbCsvSelectFile;
    JCheckBox jchkDbNew;
    JCheckBox jchkDbExisting;
    JTextField jtfDbNew;
    JComboBox jcbDbExisting;
    JLabel jlFormatTime;
    JLabel jlFormatDate;
    JLabel jlFormatSeparator;
    JTextField jtfFormatTime;
    JTextField jtfFormatDate;
    JTextField jtfFormatSeparator;
    JCheckBox jchkFormatExtended;
    JCheckBox jchkOptionsCopyright;
    JCheckBox jchkOptionsReadOnly;
    JButton jbViewsAdd;
    JButton jbViewsRemove;
    JButton jbViewsUp;
    JButton jbViewsDown;
    JTable jtblViewsViews;
    JTable jtblViewsFields;
    JScrollPane jspViewsViews;
    JScrollPane jspViewsFields;
    CsvViewListTableModel viewsModelList;
    CsvViewTableModel viewsModelViewFields;
    JButton jbFieldsAdd;
    JButton jbFieldsRemove;
    JTable jtblFields;
    JScrollPane jspFields;
    CsvFieldsTableModel fieldsModel;
    JProgressBar progressBar;
    JButton jbFinishSaveConfig;
    JPanel jpWindow;
    JPanel jpButtons;
    JButton jbNext;
    JButton jbCancel;
    JButton jbPrevious;
    JButton jbFinish;
    UIBanner uib = new UIBanner("CSV Import Wizard", 500, null);
    transient Vector actionListeners = new Vector();
    private static final int INTRO = 0;
    private static final int CSVFILE = 1;
    private static final int DBINFO = 2;
    private static final int FIELDS = 3;
    private static final int VIEWS = 4;
    private static final int FORMATS = 5;
    private static final int OPTIONS = 6;
    private static final int FINISH = 7;
    private static final byte BUTTON_NEXT = 1;
    private static final byte BUTTON_PREV = 2;
    private static final byte BUTTON_CANC = 4;
    private static final byte BUTTON_FINI = 8;
    private Application application = null;
    private CSVImportModel model = null;
    private int state = -1;
    static /* synthetic */ Class class$0;

    public Wizard(Application application) {
        this.application = application;
        this.jpWindow = new JPanel();
        this.jpButtons = new JPanel();
        this.jbNext = new FlatJButton();
        this.jbPrevious = new FlatJButton();
        this.jbCancel = new FlatJButton();
        this.jbFinish = new FlatJButton();
        this.model = new CSVImportModel();
        this.jbNext.setText("next");
        this.jbPrevious.setText("back");
        this.jbFinish.setText("finish");
        this.jbCancel.setText("cancel");
        this.jpButtons.setLayout(new FlowLayout(2));
        this.jpButtons.add(this.jbCancel);
        this.jpButtons.add(this.jbPrevious);
        this.jpButtons.add(this.jbNext);
        this.jpButtons.add(this.jbFinish);
        this.jbCancel.setPreferredSize(new Dimension(75, 25));
        this.jbFinish.setPreferredSize(new Dimension(75, 25));
        this.jbNext.setPreferredSize(new Dimension(75, 25));
        this.jbPrevious.setPreferredSize(new Dimension(75, 25));
        this.setPreferredSize(new Dimension(350, 230));
        this.jpWindow.setLayout(new BorderLayout());
        this.setLayout(new BorderLayout());
        this.add((Component)this.uib, "North");
        this.add((Component)this.jpWindow, "Center");
        this.add((Component)this.jpButtons, "South");
        this.jbNext.addActionListener(this);
        this.jbPrevious.addActionListener(this);
        this.jbCancel.addActionListener(this);
        this.jbFinish.addActionListener(this);
        this.display(0);
    }

    private void display(int panelNumber) {
        this.state = panelNumber;
        this.jpWindow.setVisible(false);
        this.jpWindow.removeAll();
        JPanel c = null;
        switch (panelNumber) {
            case 0: {
                c = this.getIntroPanel();
                break;
            }
            case 1: {
                c = this.getCsvFilePanel();
                this.jlCsvFile.setText(this.model.getCsvPath());
                break;
            }
            case 2: {
                c = this.getDbInfoPanel();
                if (!this.jchkDbNew.isSelected()) break;
                this.jtfDbNew.setText(this.model.getDatabaseTitle());
                break;
            }
            case 3: {
                c = this.getFieldsPanel();
                break;
            }
            case 4: {
                c = this.getViewsPanel();
                break;
            }
            case 5: {
                c = this.getFormatsPanel();
                this.jtfFormatDate.setText(this.model.getDateFormat());
                this.jtfFormatTime.setText(this.model.getTimeFormat());
                this.jtfFormatSeparator.setText(String.valueOf(this.model.getSeparator()));
                this.jchkFormatExtended.setSelected(this.model.isExtendedCsvFormat());
                break;
            }
            case 6: {
                c = this.getOptionsPanel();
                this.jchkOptionsCopyright.setSelected(this.model.isCopyPrevention());
                this.jchkOptionsReadOnly.setSelected(this.model.isReadOnly());
                break;
            }
            case 7: {
                c = this.getFinishPanel();
                break;
            }
            default: {
                throw new RuntimeException("invalid panel number");
            }
        }
        this.uib.setText(c.getName());
        this.jpWindow.add((Component)c, "Center");
        this.jpWindow.setVisible(true);
        this.updateButtons();
        if (this.state == 7) {
            Runnable r = new Runnable(){

                public void run() {
                    Wizard.this.startImport();
                }
            };
            Thread t = new Thread(r);
            t.setPriority(1);
            t.setDaemon(true);
            t.start();
        }
    }

    private void startImport() {
        Plugin plugin = new Plugin();
        plugin.setImportModel(this.model);
        plugin.setPluginMonitor(this);
        try {
            plugin.execute();
            PilotDBDatabase db = plugin.getDb();
            this.application.getCurrentEnvironment().openDatabase(this.model.getDatabaseTitle());
            Command c = new Command(this, "msg-created-database", db);
            this.application.postEvent(c);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void next() {
        this.updateModel(this.state);
        this.display(this.state + 1);
    }

    private void previous() {
        this.updateModel(this.state);
        this.display(this.state - 1);
    }

    private void finish() {
        if (this.state == 7) {
            this.cancel();
        } else {
            this.updateModel(this.state);
            this.display(7);
        }
    }

    private void cancel() {
        this.fireActionEvent("cancel");
    }

    private String updateModel(int panelNumber) {
        String error = null;
        switch (panelNumber) {
            case 0: {
                break;
            }
            case 1: {
                this.model.setCsvPath(this.jlCsvFile.getText());
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                this.model.setDateFormat(this.jtfFormatDate.getText());
                this.model.setTimeFormat(this.jtfFormatTime.getText());
                this.model.setSeparator(this.jtfFormatSeparator.getText().charAt(0));
                this.model.setExtendedCsvFormat(this.jchkFormatExtended.isSelected());
                break;
            }
            case 6: {
                this.model.setReadOnly(this.jchkOptionsReadOnly.isSelected());
                this.model.setCopyPrevention(this.jchkOptionsCopyright.isSelected());
                break;
            }
            case 7: {
                break;
            }
            default: {
                throw new RuntimeException("invalid panel number");
            }
        }
        return error;
    }

    private void updateButtons() {
        int enabled = 0;
        this.jbFinish.setText("finish");
        switch (this.state) {
            case 0: {
                enabled = (byte)(enabled | 4);
                if (this.jchkIntroCreateConfig.isSelected()) {
                    enabled = (byte)(enabled | 1);
                    break;
                }
                if (!this.checkFile(this.jlIntroLoadConfig.getText())) break;
                enabled = (byte)(enabled | 1);
                break;
            }
            case 1: {
                enabled = (byte)(enabled | 4);
                enabled = (byte)(enabled | 2);
                if (!this.checkFile(this.jlCsvFile.getText())) break;
                enabled = (byte)(enabled | 1);
                break;
            }
            case 2: {
                enabled = (byte)(enabled | 4);
                enabled = (byte)(enabled | 2);
                if (this.model.getDatabaseTitle() == null || this.model.getDatabaseTitle().length() == 0) break;
                enabled = (byte)(enabled | 1);
                break;
            }
            case 3: {
                enabled = (byte)(enabled | 4);
                enabled = (byte)(enabled | 2);
                if (this.model.getFieldCount() <= 0) break;
                enabled = (byte)(enabled | 1);
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                enabled = (byte)(enabled | 4);
                enabled = (byte)(enabled | 2);
                enabled = (byte)(enabled | 1);
                break;
            }
            case 7: {
                enabled = (byte)(enabled | 2);
                enabled = (byte)(enabled | 8);
                this.jbFinish.setText("close");
                break;
            }
            default: {
                throw new RuntimeException("invalid panel number");
            }
        }
        if (this.model.isComplete()) {
            enabled = (byte)(enabled | 8);
        }
        this.jbNext.setEnabled((enabled & 1) > 0);
        this.jbPrevious.setEnabled((enabled & 2) > 0);
        this.jbCancel.setEnabled((enabled & 4) > 0);
        this.jbFinish.setEnabled((enabled & 8) > 0);
    }

    private boolean checkFile(String path) {
        try {
            File f = new File(path);
            if (!f.exists()) {
                return false;
            }
            return f.canRead();
        }
        catch (Exception e) {
            return false;
        }
    }

    private JPanel getFormatsPanel() {
        if (this.jpFormats != null) {
            return this.jpFormats;
        }
        this.jpFormats = new JPanel();
        this.jpFormats.setLayout(null);
        this.jchkFormatExtended = new JCheckBox();
        this.jlFormatDate = new JLabel();
        this.jlFormatTime = new JLabel();
        this.jlFormatSeparator = new JLabel();
        this.jtfFormatDate = new JTextField();
        this.jtfFormatTime = new JTextField();
        this.jtfFormatSeparator = new JTextField();
        this.jlFormatDate.setText("Date");
        this.jlFormatTime.setText("Time");
        this.jlFormatSeparator.setText("Separator");
        this.jchkFormatExtended.setText("Extended CSV Format");
        this.jchkFormatExtended.setIcon(Images.CHECKBOX_UNCHECKED_ICON);
        this.jchkFormatExtended.setSelectedIcon(Images.CHECKBOX_CHECKED_ICON);
        this.jpFormats.add(this.jchkFormatExtended);
        this.jpFormats.add(this.jlFormatDate);
        this.jpFormats.add(this.jlFormatTime);
        this.jpFormats.add(this.jlFormatSeparator);
        this.jpFormats.add(this.jtfFormatDate);
        this.jpFormats.add(this.jtfFormatTime);
        this.jpFormats.add(this.jtfFormatSeparator);
        this.jlFormatDate.setBounds(10, 10, 100, 20);
        this.jlFormatTime.setBounds(10, 40, 100, 20);
        this.jlFormatSeparator.setBounds(10, 70, 100, 20);
        this.jchkFormatExtended.setBounds(10, 200, 75, 20);
        this.jtfFormatDate.setBounds(110, 10, 100, 20);
        this.jtfFormatTime.setBounds(110, 40, 100, 20);
        this.jtfFormatSeparator.setBounds(110, 70, 20, 20);
        this.jtfFormatSeparator.setBorder(BorderFactory.createLineBorder(Color.lightGray));
        this.jtfFormatTime.setBorder(BorderFactory.createLineBorder(Color.lightGray));
        this.jtfFormatDate.setBorder(BorderFactory.createLineBorder(Color.lightGray));
        this.jpFormats.setName("Formats");
        return this.jpFormats;
    }

    private JPanel getOptionsPanel() {
        if (this.jpOptions != null) {
            return this.jpOptions;
        }
        this.jpOptions = new JPanel();
        this.jpOptions.setName("Options");
        this.jchkOptionsCopyright = new JCheckBox();
        this.jchkOptionsReadOnly = new JCheckBox();
        this.jchkOptionsCopyright.setText("Copyright");
        this.jchkOptionsReadOnly.setText("Read Only");
        this.jchkOptionsCopyright.setIcon(Images.CHECKBOX_UNCHECKED_ICON);
        this.jchkOptionsCopyright.setSelectedIcon(Images.CHECKBOX_CHECKED_ICON);
        this.jchkOptionsReadOnly.setIcon(Images.CHECKBOX_UNCHECKED_ICON);
        this.jchkOptionsReadOnly.setSelectedIcon(Images.CHECKBOX_CHECKED_ICON);
        this.jpOptions.setLayout(null);
        this.jpOptions.add(this.jchkOptionsCopyright);
        this.jpOptions.add(this.jchkOptionsReadOnly);
        this.jchkOptionsCopyright.setBounds(10, 10, 100, 20);
        this.jchkOptionsReadOnly.setBounds(10, 40, 100, 20);
        return this.jpOptions;
    }

    private JPanel getFinishPanel() {
        if (this.jpFinish != null) {
            return this.jpFinish;
        }
        this.jpFinish = new JPanel();
        this.jpFinish.setName("Finish");
        this.progressBar = new JProgressBar();
        this.jbFinishSaveConfig = new FlatJButton();
        this.progressBar.setBorder(BorderFactory.createLineBorder(Color.lightGray));
        this.jbFinishSaveConfig.setIcon(Images.SAVE_ICON);
        this.jbFinishSaveConfig.setText("Save Configuration");
        this.jpFinish.setLayout(null);
        this.jpFinish.add(this.progressBar);
        this.jpFinish.add(this.jbFinishSaveConfig);
        this.progressBar.setBounds(10, 50, 330, 20);
        this.jbFinishSaveConfig.setBounds(75, 100, 200, 25);
        this.jbFinishSaveConfig.addActionListener(this);
        return this.jpFinish;
    }

    private JPanel getViewsPanel() {
        if (this.jpViews != null) {
            return this.jpViews;
        }
        this.jpViews = new JPanel();
        this.jpViews.setName("Database Views");
        this.viewsModelList = new CsvViewListTableModel();
        this.viewsModelViewFields = new CsvViewTableModel();
        this.jbViewsAdd = new FlatJButton();
        this.jbViewsRemove = new FlatJButton();
        this.jbViewsDown = new FlatJButton();
        this.jbViewsUp = new FlatJButton();
        this.jtblViewsFields = new JTable(this.viewsModelViewFields);
        this.jspViewsFields = new JScrollPane(this.jtblViewsFields);
        this.jtblViewsViews = new JTable(this.viewsModelList);
        this.jspViewsViews = new JScrollPane(this.jtblViewsViews);
        FlatTableCellRenderer ftcr = new FlatTableCellRenderer();
        ftcr.setBackground(Color.black);
        ftcr.setForeground(Color.white);
        this.jtblViewsFields.getTableHeader().setDefaultRenderer(ftcr);
        this.jtblViewsViews.getTableHeader().setDefaultRenderer(ftcr);
        this.jspViewsFields.setBorder(BorderFactory.createLineBorder(Color.lightGray));
        this.jspViewsViews.setBorder(BorderFactory.createLineBorder(Color.lightGray));
        this.jbViewsAdd.setIcon(Images.ADD_VIEW_ICON);
        this.jbViewsRemove.setIcon(Images.DELETEVIEW_ICON);
        this.jbViewsUp.setIcon(Images.ARROW_UP_ICON);
        this.jbViewsDown.setIcon(Images.ARROW_DOWN_ICON);
        this.viewsModelList.setModel(this.model);
        this.viewsModelViewFields.setModel(this.model);
        this.jpViews.setLayout(null);
        this.jpViews.add(this.jbViewsAdd);
        this.jpViews.add(this.jbViewsRemove);
        this.jpViews.add(this.jbViewsDown);
        this.jpViews.add(this.jbViewsUp);
        this.jpViews.add(this.jspViewsFields);
        this.jpViews.add(this.jspViewsViews);
        this.jspViewsViews.setBounds(10, 10, 100, 140);
        this.jspViewsFields.setBounds(150, 10, 160, 140);
        this.jbViewsAdd.setBounds(120, 45, 20, 20);
        this.jbViewsRemove.setBounds(120, 75, 20, 20);
        this.jbViewsUp.setBounds(320, 45, 20, 20);
        this.jbViewsDown.setBounds(320, 75, 20, 20);
        this.jbViewsDown.addActionListener(this);
        this.jbViewsUp.addActionListener(this);
        this.jbViewsAdd.addActionListener(this);
        this.jbViewsRemove.addActionListener(this);
        this.jtblViewsViews.getSelectionModel().addListSelectionListener(this);
        return this.jpViews;
    }

    private JPanel getFieldsPanel() {
        if (this.jpFields != null) {
            return this.jpFields;
        }
        this.jpFields = new JPanel();
        this.jpFields.setName("CSV Fields");
        this.jbFieldsAdd = new FlatJButton();
        this.jbFieldsRemove = new FlatJButton();
        this.fieldsModel = new CsvFieldsTableModel();
        this.jtblFields = new JTable(this.fieldsModel);
        this.jspFields = new JScrollPane(this.jtblFields);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.Integer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.jtblFields.setDefaultEditor(clazz, new FieldTypeCellEditor());
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("java.lang.Integer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.jtblFields.setDefaultRenderer(clazz2, new FieldTypeCellRenderer());
        this.fieldsModel.setModel(this.model);
        this.jbFieldsAdd.setIcon(Images.ADD_RECORD_ICON);
        this.jbFieldsRemove.setIcon(Images.DELETERECORD_ICON);
        this.jspFields.setBorder(BorderFactory.createLineBorder(Color.lightGray));
        FlatTableCellRenderer ftcr = new FlatTableCellRenderer();
        ftcr.setBackground(Color.black);
        ftcr.setForeground(Color.white);
        this.jtblFields.getTableHeader().setDefaultRenderer(ftcr);
        this.jpFields.setLayout(null);
        this.jpFields.add(this.jbFieldsAdd);
        this.jpFields.add(this.jbFieldsRemove);
        this.jpFields.add(this.jspFields);
        this.jspFields.setBounds(10, 10, 300, 140);
        this.jbFieldsAdd.setBounds(320, 55, 20, 20);
        this.jbFieldsRemove.setBounds(320, 85, 20, 20);
        this.jbFieldsAdd.addActionListener(this);
        this.jbFieldsRemove.addActionListener(this);
        return this.jpFields;
    }

    private JPanel getIntroPanel() {
        if (this.jpIntro != null) {
            return this.jpIntro;
        }
        this.jpIntro = new JPanel();
        this.jpIntro.setName("CSV Import");
        this.jchkIntroLoadConfig = new JCheckBox();
        this.jchkIntroLoadConfig.setText("Load Configuration");
        this.jchkIntroLoadConfig.setIcon(Images.CHECKBOX_UNCHECKED_ICON);
        this.jchkIntroLoadConfig.setSelectedIcon(Images.CHECKBOX_CHECKED_ICON);
        this.jchkIntroCreateConfig = new JCheckBox();
        this.jchkIntroCreateConfig.setText("Create New Configuration");
        this.jchkIntroCreateConfig.setIcon(Images.CHECKBOX_UNCHECKED_ICON);
        this.jchkIntroCreateConfig.setSelectedIcon(Images.CHECKBOX_CHECKED_ICON);
        this.jlIntroLoadConfig = new JLabel();
        this.jlIntroLoadConfig.setText("<select .ifo file>");
        this.jlIntroLoadConfig.setBorder(BorderFactory.createLineBorder(Color.lightGray));
        this.jbIntroLoadConfig = new FlatJButton();
        this.jbIntroLoadConfig.setIcon(Images.OPEN_ICON);
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.jchkIntroCreateConfig);
        bg.add(this.jchkIntroLoadConfig);
        this.jpIntro.setLayout(null);
        this.jpIntro.add(this.jchkIntroCreateConfig);
        this.jpIntro.add(this.jchkIntroLoadConfig);
        this.jpIntro.add(this.jbIntroLoadConfig);
        this.jpIntro.add(this.jlIntroLoadConfig);
        this.jchkIntroCreateConfig.setBounds(10, 10, 200, 20);
        this.jchkIntroLoadConfig.setBounds(10, 40, 200, 20);
        this.jlIntroLoadConfig.setBounds(30, 70, 280, 20);
        this.jbIntroLoadConfig.setBounds(320, 70, 20, 20);
        this.jchkIntroCreateConfig.addItemListener(this);
        this.jchkIntroLoadConfig.addItemListener(this);
        this.jbIntroLoadConfig.addActionListener(this);
        this.jchkIntroCreateConfig.setSelected(true);
        return this.jpIntro;
    }

    private JPanel getCsvFilePanel() {
        if (this.jpCsvFile != null) {
            return this.jpCsvFile;
        }
        this.jpCsvFile = new JPanel();
        this.jpCsvFile.setName("CSV File");
        this.jlCsvFile = new JLabel();
        this.jlCsvSelectFile = new JLabel();
        this.jbCsvSelectFile = new FlatJButton();
        this.jbCsvSelectFile.setIcon(Images.OPEN_ICON);
        this.jlCsvSelectFile.setText("Select CSV File");
        this.jlCsvFile.setText("");
        this.jlCsvFile.setBorder(BorderFactory.createLineBorder(Color.lightGray));
        this.jpCsvFile.setLayout(null);
        this.jpCsvFile.add(this.jlCsvFile);
        this.jpCsvFile.add(this.jlCsvSelectFile);
        this.jpCsvFile.add(this.jbCsvSelectFile);
        this.jlCsvSelectFile.setBounds(10, 10, 200, 20);
        this.jlCsvFile.setBounds(30, 40, 280, 20);
        this.jbCsvSelectFile.setBounds(320, 40, 20, 20);
        this.jbCsvSelectFile.addActionListener(this);
        return this.jpCsvFile;
    }

    private JPanel getDbInfoPanel() {
        if (this.jpDbInfo != null) {
            return this.jpDbInfo;
        }
        int dbcount = this.application.getCurrentEnvironment().getDatabaseCount();
        String[] dbnames = new String[dbcount];
        int i = 0;
        while (i < dbcount) {
            dbnames[i] = this.application.getCurrentEnvironment().getDatabase(i).getTitle();
            ++i;
        }
        this.jpDbInfo = new JPanel();
        this.jpDbInfo.setName("Import to...");
        this.jchkDbExisting = new JCheckBox();
        this.jtfDbNew = new JTextField();
        this.jchkDbNew = new JCheckBox();
        this.jcbDbExisting = new JComboBox<String>(dbnames);
        this.jcbDbExisting.setBorder(BorderFactory.createLineBorder(Color.lightGray));
        this.jtfDbNew.setBorder(BorderFactory.createLineBorder(Color.lightGray));
        this.jchkDbNew.setIcon(Images.CHECKBOX_UNCHECKED_ICON);
        this.jchkDbNew.setSelectedIcon(Images.CHECKBOX_CHECKED_ICON);
        this.jchkDbExisting.setIcon(Images.CHECKBOX_UNCHECKED_ICON);
        this.jchkDbExisting.setSelectedIcon(Images.CHECKBOX_CHECKED_ICON);
        this.jchkDbExisting.setText("Import as Existing Database");
        this.jchkDbNew.setText("Create a new Database");
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.jchkDbExisting);
        bg.add(this.jchkDbNew);
        this.jpDbInfo.setLayout(null);
        this.jpDbInfo.add(this.jchkDbExisting);
        this.jpDbInfo.add(this.jchkDbNew);
        this.jpDbInfo.add(this.jtfDbNew);
        this.jpDbInfo.add(this.jcbDbExisting);
        this.jchkDbNew.setBounds(10, 10, 200, 20);
        this.jtfDbNew.setBounds(30, 40, 200, 20);
        this.jchkDbExisting.setBounds(10, 70, 200, 20);
        this.jcbDbExisting.setBounds(30, 100, 150, 20);
        if (this.model.getDatabaseTitle() != null) {
            this.jtfDbNew.setText(this.model.getDatabaseTitle());
        }
        this.jchkDbExisting.addItemListener(this);
        this.jchkDbNew.addItemListener(this);
        this.jtfDbNew.getDocument().addDocumentListener(this);
        this.jchkDbNew.setSelected(true);
        return this.jpDbInfo;
    }

    public void actionPerformed(ActionEvent arg0) {
        Object source = arg0.getSource();
        if (source == this.jbNext) {
            this.next();
        } else if (source == this.jbPrevious) {
            this.previous();
        } else if (source == this.jbViewsAdd) {
            this.model.addView("newview");
            this.viewsModelList.fireTableDataChanged();
        } else if (source == this.jbViewsRemove) {
            int selectedRow = this.jtblViewsViews.getSelectedRow();
            if (selectedRow == -1) {
                return;
            }
            this.model.removeView(selectedRow);
            this.viewsModelList.fireTableDataChanged();
            this.viewsModelViewFields.setViewName(null);
        } else if (source == this.jbViewsDown) {
            int selectedRow = this.jtblViewsFields.getSelectedRow();
            if (selectedRow > -1) {
                this.viewsModelViewFields.moveDown(selectedRow);
            }
        } else if (source == this.jbViewsUp) {
            int selectedRow = this.jtblViewsFields.getSelectedRow();
            if (selectedRow > -1) {
                this.viewsModelViewFields.moveUp(selectedRow);
            }
        } else if (source == this.jbFieldsAdd) {
            this.model.addField("newfield", 0, null);
            this.fieldsModel.fireTableDataChanged();
        } else if (source == this.jbFieldsRemove) {
            int selectedRow = this.jtblFields.getSelectedRow();
            if (selectedRow == -1) {
                return;
            }
            this.model.removeField(selectedRow);
            this.fieldsModel.fireTableDataChanged();
        } else if (source == this.jbIntroLoadConfig) {
            this.showLoadConfigDialog();
            try {
                this.model.read(new BufferedReader(new FileReader(this.jlIntroLoadConfig.getText())));
                if (this.model.getDatabaseTitle() != null) {
                    File f = this.application.getCurrentEnvironment().getBaseDirectory();
                    f = new File(f, String.valueOf(this.model.getDatabaseTitle()) + ".pdb");
                    this.model.setDatabasePath(f.getAbsolutePath());
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        } else if (source == this.jbCsvSelectFile) {
            this.showLoadCsvDialog();
        } else if (source == this.jbCancel) {
            this.cancel();
        } else if (source == this.jbFinish) {
            this.finish();
        } else if (source == this.jbFinishSaveConfig) {
            this.showSaveConfigDialog();
        }
        this.updateButtons();
    }

    private void showSaveConfigDialog() {
        JFileChooser chooser = new JFileChooser();
        try {
            chooser.setCurrentDirectory(new File(this.application.getUserPreferences().getLastPath()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        chooser.setFileFilter(new FileFilter(){

            public boolean accept(File arg0) {
                return arg0.isDirectory() || arg0.getAbsolutePath().toUpperCase().endsWith(".IFO");
            }

            public String getDescription() {
                return "(*.ifo) IFO Configuration File";
            }
        });
        int ret = chooser.showSaveDialog(this);
        if (ret != 1) {
            File selected = chooser.getSelectedFile();
            File parent = selected.getParentFile();
            try {
                FileWriter fw = new FileWriter(selected);
                this.model.write(fw);
                fw.close();
            }
            catch (Exception e) {
                Command c = new Command(this, "cmd-show-error", "Unable to save file:\n" + e);
                this.application.postEvent(c);
            }
            this.model.setCsvPath(selected.getAbsolutePath());
            this.application.getUserPreferences().setLastPath(parent.getAbsolutePath());
            try {
                Application.savePreferences(this.application.getUserPreferences());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void showLoadCsvDialog() {
        JFileChooser chooser = new JFileChooser();
        try {
            chooser.setCurrentDirectory(new File(this.application.getUserPreferences().getLastPath()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        chooser.setFileFilter(new FileFilter(){

            public boolean accept(File arg0) {
                return arg0.isDirectory() || arg0.getAbsolutePath().toUpperCase().endsWith(".CSV");
            }

            public String getDescription() {
                return "(*.csv) CSV Text File";
            }
        });
        int ret = chooser.showOpenDialog(this);
        if (ret != 1) {
            File selected = chooser.getSelectedFile();
            File parent = selected.getParentFile();
            this.jlCsvFile.setText(selected.getAbsolutePath());
            this.model.setCsvPath(selected.getAbsolutePath());
            this.application.getUserPreferences().setLastPath(parent.getAbsolutePath());
            try {
                Application.savePreferences(this.application.getUserPreferences());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void showLoadConfigDialog() {
        JFileChooser chooser = new JFileChooser();
        try {
            chooser.setCurrentDirectory(new File(this.application.getUserPreferences().getLastPath()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        chooser.setFileFilter(new FileFilter(){

            public boolean accept(File arg0) {
                return arg0.isDirectory() || arg0.getAbsolutePath().toUpperCase().endsWith(".IFO");
            }

            public String getDescription() {
                return "(*.ifo) IFO Configuration File";
            }
        });
        int ret = chooser.showOpenDialog(this);
        if (ret != 1) {
            File selected = chooser.getSelectedFile();
            this.jlIntroLoadConfig.setText(selected.getAbsolutePath());
            File parent = selected.getParentFile();
            this.application.getUserPreferences().setLastPath(parent.getAbsolutePath());
            try {
                Application.savePreferences(this.application.getUserPreferences());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void valueChanged(ListSelectionEvent arg0) {
        if (arg0.getValueIsAdjusting()) {
            return;
        }
        Object source = arg0.getSource();
        if (source == this.jtblViewsViews.getSelectionModel()) {
            int selectedRow = this.jtblViewsViews.getSelectedRow();
            if (selectedRow == -1) {
                this.viewsModelViewFields.setViewName(null);
            } else {
                String name = (String)this.jtblViewsViews.getValueAt(selectedRow, 0);
                this.viewsModelViewFields.setViewName(name);
            }
        }
        this.updateButtons();
    }

    public void itemStateChanged(ItemEvent arg0) {
        Object source = arg0.getSource();
        if (source == this.jchkIntroCreateConfig) {
            this.jbIntroLoadConfig.setEnabled(this.jchkIntroLoadConfig.isSelected());
        } else if (source == this.jchkIntroLoadConfig) {
            this.jbIntroLoadConfig.setEnabled(this.jchkIntroLoadConfig.isSelected());
            if (this.checkFile(this.jlIntroLoadConfig.getText())) {
                try {
                    this.model.read(new BufferedReader(new FileReader(this.jlIntroLoadConfig.getText())));
                    if (this.model.getDatabaseTitle() != null) {
                        File f = this.application.getCurrentEnvironment().getBaseDirectory();
                        f = new File(f, String.valueOf(this.model.getDatabaseTitle()) + ".pdb");
                        this.model.setDatabasePath(f.getAbsolutePath());
                    }
                }
                catch (IOException f) {}
            }
        } else if (source == this.jchkDbExisting || source == this.jchkDbNew) {
            this.jcbDbExisting.setEnabled(this.jchkDbExisting.isSelected());
            this.jtfDbNew.setEnabled(this.jchkDbNew.isSelected());
            if (this.jchkDbExisting.isSelected()) {
                String dbName = (String)this.jcbDbExisting.getSelectedItem();
                this.model.setDatabaseTitle(dbName);
                File f = this.application.getCurrentEnvironment().getBaseDirectory();
                f = new File(f, String.valueOf(dbName) + ".pdb");
                this.model.setDatabasePath(f.getAbsolutePath());
            } else {
                String dbName = this.jtfDbNew.getText();
                this.model.setDatabaseTitle(dbName);
                File f = this.application.getCurrentEnvironment().getBaseDirectory();
                f = new File(f, String.valueOf(dbName) + ".pdb");
                this.model.setDatabasePath(f.getAbsolutePath());
            }
        } else if (source == this.jcbDbExisting) {
            String title = this.jcbDbExisting.getSelectedItem().toString();
            this.model.setDatabaseTitle(title);
            File f = this.application.getCurrentEnvironment().getBaseDirectory();
            f = new File(f, String.valueOf(title) + ".pdb");
            this.model.setDatabasePath(f.getAbsolutePath());
        }
        this.updateButtons();
    }

    private void updateDbTitle() {
        this.model.setDatabaseTitle(this.jtfDbNew.getText());
        File f = this.application.getCurrentEnvironment().getBaseDirectory();
        f = new File(f, String.valueOf(this.jtfDbNew.getText()) + ".pdb");
        this.model.setDatabasePath(f.getAbsolutePath());
        this.updateButtons();
    }

    public void changedUpdate(DocumentEvent arg0) {
        this.updateDbTitle();
    }

    public void insertUpdate(DocumentEvent arg0) {
        this.updateDbTitle();
    }

    public void removeUpdate(DocumentEvent arg0) {
        this.updateDbTitle();
    }

    public void done() {
        this.progressBar.setValue(this.progressBar.getMaximum());
        this.progressBar.setString("import completed");
    }

    public void setError(String error) {
        this.progressBar.setValue(0);
        this.progressBar.setString(error);
        this.progressBar.setForeground(Color.red);
    }

    public void setMessage(String message) {
        this.progressBar.setString(message);
    }

    public void setStep(int step, String message) {
        this.progressBar.setValue(step);
        this.progressBar.setString(message);
    }

    public void setStep(int step) {
        this.progressBar.setValue(step);
    }

    public void setSteps(int totalSteps) {
        this.progressBar.setMaximum(totalSteps);
    }

    public void start() {
        this.progressBar.setStringPainted(true);
        this.progressBar.setValue(0);
        this.progressBar.setString("working...");
    }

    public void addActionListener(ActionListener al) {
        this.actionListeners.add(al);
    }

    public void removeActionListener(ActionListener al) {
        this.actionListeners.remove(al);
    }

    protected synchronized void fireActionEvent(String event) {
        ActionEvent ae = new ActionEvent(this, 1001, event);
        int i = 0;
        while (i < this.actionListeners.size()) {
            ActionListener al = (ActionListener)this.actionListeners.get(i);
            al.actionPerformed(ae);
            ++i;
        }
    }

    public static class FieldTypeCellRenderer
    extends DefaultTableCellRenderer {
        public Component getTableCellRendererComponent(JTable arg0, Object arg1, boolean arg2, boolean arg3, int arg4, int arg5) {
            Component c = super.getTableCellRendererComponent(arg0, arg1, arg2, arg3, arg4, arg5);
            int typeValue = (Integer)arg1;
            int i = 0;
            while (i < CSVImportModel.SUPPORTED_TYPES_INT.length) {
                if (typeValue == CSVImportModel.SUPPORTED_TYPES_INT[i]) {
                    ((JLabel)c).setText(CSVImportModel.SUPPORTED_TYPES[i]);
                }
                ++i;
            }
            return c;
        }
    }

    public static class FieldTypeCellEditor
    extends DefaultCellEditor
    implements CellEditor {
        public FieldTypeCellEditor() {
            super(new JComboBox<String>(CSVImportModel.SUPPORTED_TYPES));
        }

        public Object getCellEditorValue() {
            JComboBox jcb = (JComboBox)this.editorComponent;
            return new Integer(CSVImportModel.SUPPORTED_TYPES_INT[jcb.getSelectedIndex()]);
        }

        public Component getTableCellEditorComponent(JTable arg0, Object arg1, boolean arg2, int arg3, int arg4) {
            Component c = super.getTableCellEditorComponent(arg0, arg1, arg2, arg3, arg4);
            JComboBox jcb = (JComboBox)c;
            int typeValue = (Integer)arg1;
            int i = 0;
            while (i < CSVImportModel.SUPPORTED_TYPES_INT.length) {
                if (typeValue == CSVImportModel.SUPPORTED_TYPES_INT[i]) {
                    jcb.setSelectedIndex(i);
                }
                ++i;
            }
            return c;
        }
    }
}

