/*
 * Decompiled with CFR 0.152.
 */
package pilotdb.ui.simplecreator.filemp3;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.LinkedList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.filechooser.FileFilter;
import pilotdb.PilotDBDatabase;
import pilotdb.tools.simplecreator.filemp3.Plugin;
import pilotdb.ui.Application;
import pilotdb.ui.command.Command;
import pilotdb.ui.images.Images;
import pilotdb.ui.util.FlatJButton;

public class FileImportPanel
extends JPanel
implements ActionListener,
Runnable {
    List actionListeners = new LinkedList();
    JButton addButton;
    Application app = null;
    JCheckBox jchkIncludeSubdirs;
    JCheckBox jchkMp3Album;
    JCheckBox jchkMp3Artist;
    JCheckBox jchkMp3Comment;
    JCheckBox jchkMp3Genre;
    JCheckBox jchkMp3Title;
    JCheckBox jchkMp3Year;
    JCheckBox jchkPFileExt;
    JCheckBox jchkPFileName;
    JCheckBox jchkPFileSize;
    JCheckBox jchkPLastModified;
    JLabel jlFilter;
    JList jlstFolders;
    JScrollPane jlstScrollPane = null;
    JPanel jpMp3PropertiesToInclude;
    JPanel jpOkCancel;
    JPanel jpPropertiesToInclude;
    JTextField jtfFilter;
    DefaultListModel listModel = null;
    JButton removeButton;
    JLabel topLabel;
    JButton jbOk;
    JButton jbCancel;

    public static void main(String[] args) {
        Frame f = new Frame();
        JDialog jd = new JDialog();
        jd.getContentPane().setLayout(new BorderLayout());
        FileImportPanel jp = new FileImportPanel();
        jp.setOpaque(true);
        jd.getContentPane().add((Component)jp, "Center");
        jd.pack();
        jd.setModal(true);
        jd.setVisible(true);
    }

    public JButton getJbCancel() {
        if (this.jbCancel == null) {
            this.jbCancel = new FlatJButton();
            this.jbCancel.setIcon(Images.CANCEL_ICON);
            this.jbCancel.setText("Cancel");
            this.jbCancel.addActionListener(this);
            this.jbCancel.setPreferredSize(new Dimension(75, 25));
        }
        return this.jbCancel;
    }

    public JButton getJbOk() {
        if (this.jbOk == null) {
            this.jbOk = new FlatJButton();
            this.jbOk.setIcon(Images.OK_ICON);
            this.jbOk.setText("OK");
            this.jbOk.addActionListener(this);
            this.jbOk.setPreferredSize(new Dimension(75, 25));
        }
        return this.jbOk;
    }

    public FileImportPanel() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.insets = new Insets(5, 5, 5, 5);
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.gridwidth = 4;
        gbc.gridheight = 1;
        gbc.fill = 0;
        gbc.anchor = 17;
        this.add((Component)this.getTopLabel(), gbc);
        gbc.gridwidth = 2;
        gbc.gridheight = 2;
        gbc.fill = 1;
        gbc.anchor = 10;
        gbc.gridy = 2;
        gbc.gridx = 1;
        gbc.weightx = 0.4;
        gbc.weighty = 1.0;
        this.add((Component)this.getJlstScrollPane(), gbc);
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.fill = 0;
        gbc.gridx = 3;
        gbc.gridy = 2;
        gbc.anchor = 11;
        this.add((Component)this.getAddButton(), gbc);
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.fill = 0;
        gbc.gridx = 3;
        gbc.gridy = 3;
        gbc.anchor = 11;
        this.add((Component)this.getRemoveButton(), gbc);
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.fill = 2;
        gbc.weightx = 0.0;
        gbc.gridx = 1;
        gbc.gridy = 4;
        gbc.anchor = 12;
        this.add((Component)this.getJlFilter(), gbc);
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.fill = 2;
        gbc.gridx = 2;
        gbc.gridy = 4;
        gbc.anchor = 18;
        gbc.weightx = 0.1;
        this.add((Component)this.getJtfFilter(), gbc);
        gbc.gridwidth = 1;
        gbc.gridheight = 4;
        gbc.weightx = 0.5;
        gbc.fill = 1;
        gbc.gridx = 4;
        gbc.gridy = 2;
        this.add((Component)this.getJpPropertiesToInclude(), gbc);
        gbc.gridwidth = 2;
        gbc.gridheight = 1;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.gridx = 1;
        gbc.gridy = 5;
        this.add((Component)this.getJchkIncludeSubdirs(), gbc);
        gbc.gridwidth = 4;
        gbc.gridheight = 1;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.gridx = 1;
        gbc.gridy = 6;
        this.add((Component)this.getJpOkCancel(), gbc);
        this.setPreferredSize(new Dimension(640, 480));
    }

    public FileImportPanel(Application app) {
        this();
        this.app = app;
    }

    public void actionPerformed(ActionEvent arg0) {
        if (arg0.getSource() == this.getAddButton()) {
            this.onAddDirectory();
        } else if (arg0.getSource() == this.getRemoveButton()) {
            this.onRemoveDirectory();
        } else if (arg0.getSource() == this.getJbOk()) {
            Thread t = new Thread(this);
            t.start();
        } else if (arg0.getSource() == this.getJbCancel()) {
            this.fireActionPerformed();
        }
    }

    public void run() {
        Plugin p = new Plugin();
        p.setImportAlbum(this.getJchkMp3Album().isSelected());
        p.setImportArtist(this.getJchkMp3Artist().isSelected());
        p.setImportComment(this.getJchkMp3Comment().isSelected());
        p.setImportFileExt(this.getJchkPFileExt().isSelected());
        p.setImportFileLastModified(this.getJchkPLastModified().isSelected());
        p.setImportFileName(this.getJchkPFileName().isSelected());
        p.setImportFileSize(this.getJchkPFileSize().isSelected());
        p.setImportGenre(this.getJchkMp3Genre().isSelected());
        p.setImportTitle(this.getJchkMp3Title().isSelected());
        p.setImportYear(this.getJchkMp3Year().isSelected());
        Object[] dirs = new File[this.listModel.size()];
        this.listModel.copyInto(dirs);
        p.setDirectories((File[])dirs);
        p.setIncludeSubdirectories(this.getJchkIncludeSubdirs().isSelected());
        p.setFileFilter(this.getJtfFilter().getText());
        p.setPluginMonitor(this.app.getMainWindow());
        try {
            this.getJbCancel().setEnabled(false);
            this.getJbOk().setEnabled(false);
            File basedir = this.app.getCurrentEnvironment().getBaseDirectory();
            String output = "mp3-" + System.currentTimeMillis() + ".pdb";
            File pdbFile = new File(basedir, output);
            p.setPdbFile(pdbFile);
            p.execute();
            PilotDBDatabase db = p.getDb();
            Command c = new Command(this, "msg-created-database", db);
            this.app.postEvent(c);
        }
        catch (Exception e) {
            this.getJbCancel().setEnabled(true);
            this.getJbOk().setEnabled(true);
            Command c = new Command(this, "cmd-show-error", e);
            this.app.postEvent(c);
        }
        this.fireActionPerformed();
    }

    public void addActionListener(ActionListener al) {
        if (this.actionListeners.contains(al)) {
            return;
        }
        this.actionListeners.add(al);
    }

    void fireActionPerformed() {
        int i = 0;
        while (i < this.actionListeners.size()) {
            ((ActionListener)this.actionListeners.get(i)).actionPerformed(new ActionEvent(this, 1001, "ok"));
            ++i;
        }
    }

    public JButton getAddButton() {
        if (this.addButton == null) {
            this.addButton = new FlatJButton(Images.GENERIC_ADD_ICON);
            this.addButton.addActionListener(this);
        }
        return this.addButton;
    }

    public JCheckBox getJchkIncludeSubdirs() {
        if (this.jchkIncludeSubdirs == null) {
            this.jchkIncludeSubdirs = new JCheckBox("Include Subdirectories");
            this.jchkIncludeSubdirs.setSelectedIcon(Images.CHECKBOX_CHECKED_ICON);
            this.jchkIncludeSubdirs.setIcon(Images.CHECKBOX_UNCHECKED_ICON);
        }
        return this.jchkIncludeSubdirs;
    }

    public JCheckBox getJchkMp3Album() {
        if (this.jchkMp3Album == null) {
            this.jchkMp3Album = new JCheckBox("Album");
            this.jchkMp3Album.setSelectedIcon(Images.CHECKBOX_CHECKED_ICON);
            this.jchkMp3Album.setIcon(Images.CHECKBOX_UNCHECKED_ICON);
        }
        return this.jchkMp3Album;
    }

    public JCheckBox getJchkMp3Artist() {
        if (this.jchkMp3Artist == null) {
            this.jchkMp3Artist = new JCheckBox("Artist");
            this.jchkMp3Artist.setSelectedIcon(Images.CHECKBOX_CHECKED_ICON);
            this.jchkMp3Artist.setIcon(Images.CHECKBOX_UNCHECKED_ICON);
        }
        return this.jchkMp3Artist;
    }

    public JCheckBox getJchkMp3Comment() {
        if (this.jchkMp3Comment == null) {
            this.jchkMp3Comment = new JCheckBox("Comment");
            this.jchkMp3Comment.setSelectedIcon(Images.CHECKBOX_CHECKED_ICON);
            this.jchkMp3Comment.setIcon(Images.CHECKBOX_UNCHECKED_ICON);
        }
        return this.jchkMp3Comment;
    }

    public JPanel getJpOkCancel() {
        if (this.jpOkCancel == null) {
            this.jpOkCancel = new JPanel();
            this.jpOkCancel.setLayout(new FlowLayout(2));
            this.jpOkCancel.add(this.getJbOk());
            this.jpOkCancel.add(this.getJbCancel());
        }
        return this.jpOkCancel;
    }

    public JCheckBox getJchkMp3Genre() {
        if (this.jchkMp3Genre == null) {
            this.jchkMp3Genre = new JCheckBox("Genre");
            this.jchkMp3Genre.setSelectedIcon(Images.CHECKBOX_CHECKED_ICON);
            this.jchkMp3Genre.setIcon(Images.CHECKBOX_UNCHECKED_ICON);
        }
        return this.jchkMp3Genre;
    }

    public JCheckBox getJchkMp3Title() {
        if (this.jchkMp3Title == null) {
            this.jchkMp3Title = new JCheckBox("Title");
            this.jchkMp3Title.setSelectedIcon(Images.CHECKBOX_CHECKED_ICON);
            this.jchkMp3Title.setIcon(Images.CHECKBOX_UNCHECKED_ICON);
        }
        return this.jchkMp3Title;
    }

    public JCheckBox getJchkMp3Year() {
        if (this.jchkMp3Year == null) {
            this.jchkMp3Year = new JCheckBox("Year");
            this.jchkMp3Year.setSelectedIcon(Images.CHECKBOX_CHECKED_ICON);
            this.jchkMp3Year.setIcon(Images.CHECKBOX_UNCHECKED_ICON);
        }
        return this.jchkMp3Year;
    }

    public JCheckBox getJchkPFileExt() {
        if (this.jchkPFileExt == null) {
            this.jchkPFileExt = new JCheckBox("File Extension");
            this.jchkPFileExt.setSelectedIcon(Images.CHECKBOX_CHECKED_ICON);
            this.jchkPFileExt.setIcon(Images.CHECKBOX_UNCHECKED_ICON);
            this.jchkPFileExt.setSelected(true);
        }
        return this.jchkPFileExt;
    }

    public JCheckBox getJchkPFileName() {
        if (this.jchkPFileName == null) {
            this.jchkPFileName = new JCheckBox("File Name");
            this.jchkPFileName.setSelectedIcon(Images.CHECKBOX_CHECKED_ICON);
            this.jchkPFileName.setIcon(Images.CHECKBOX_UNCHECKED_ICON);
            this.jchkPFileName.setSelected(true);
        }
        return this.jchkPFileName;
    }

    public JCheckBox getJchkPFileSize() {
        if (this.jchkPFileSize == null) {
            this.jchkPFileSize = new JCheckBox("Size");
            this.jchkPFileSize.setSelectedIcon(Images.CHECKBOX_CHECKED_ICON);
            this.jchkPFileSize.setIcon(Images.CHECKBOX_UNCHECKED_ICON);
            this.jchkPFileSize.setSelected(true);
        }
        return this.jchkPFileSize;
    }

    public JCheckBox getJchkPLastModified() {
        if (this.jchkPLastModified == null) {
            this.jchkPLastModified = new JCheckBox("Last Modified");
            this.jchkPLastModified.setSelectedIcon(Images.CHECKBOX_CHECKED_ICON);
            this.jchkPLastModified.setIcon(Images.CHECKBOX_UNCHECKED_ICON);
            this.jchkPLastModified.setSelected(true);
        }
        return this.jchkPLastModified;
    }

    public JLabel getJlFilter() {
        if (this.jlFilter == null) {
            this.jlFilter = new JLabel("File Filter");
        }
        return this.jlFilter;
    }

    public JList getJlstFolders() {
        if (this.jlstFolders == null) {
            this.listModel = new DefaultListModel();
            this.jlstFolders = new JList(this.listModel);
            this.jlstFolders.setCellRenderer(new ListCellRenderer(){
                JLabel jl = new JLabel();

                public Component getListCellRendererComponent(JList arg0, Object value, int idx, boolean selected, boolean focus) {
                    File f = (File)value;
                    this.jl.setText(f.getAbsolutePath());
                    this.jl.setOpaque(true);
                    this.jl.setBackground(selected ? SystemColor.textHighlight : SystemColor.text);
                    this.jl.setForeground(selected ? SystemColor.textHighlightText : SystemColor.textText);
                    return this.jl;
                }
            });
            this.jlstFolders.setPreferredSize(new Dimension(150, 200));
        }
        return this.jlstFolders;
    }

    public JScrollPane getJlstScrollPane() {
        if (this.jlstScrollPane == null) {
            this.jlstScrollPane = new JScrollPane(this.getJlstFolders());
        }
        return this.jlstScrollPane;
    }

    public JPanel getJpMp3PropertiesToInclude() {
        if (this.jpMp3PropertiesToInclude == null) {
            this.jpMp3PropertiesToInclude = new JPanel();
            this.jpMp3PropertiesToInclude.setLayout(new GridBagLayout());
            this.jpMp3PropertiesToInclude.setBorder(BorderFactory.createTitledBorder("MP3"));
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.weightx = 1.0;
            gbc.gridx = 1;
            gbc.gridy = 1;
            gbc.fill = 2;
            this.jpMp3PropertiesToInclude.add((Component)this.getJchkMp3Title(), gbc);
            ++gbc.gridy;
            this.jpMp3PropertiesToInclude.add((Component)this.getJchkMp3Artist(), gbc);
            ++gbc.gridy;
            this.jpMp3PropertiesToInclude.add((Component)this.getJchkMp3Album(), gbc);
            ++gbc.gridy;
            this.jpMp3PropertiesToInclude.add((Component)this.getJchkMp3Year(), gbc);
            ++gbc.gridy;
            this.jpMp3PropertiesToInclude.add((Component)this.getJchkMp3Comment(), gbc);
            ++gbc.gridy;
            this.jpMp3PropertiesToInclude.add((Component)this.getJchkMp3Genre(), gbc);
            ++gbc.gridy;
            gbc.fill = 1;
            this.jpMp3PropertiesToInclude.add((Component)new Box.Filler(new Dimension(0, 0), new Dimension(1, 1), new Dimension(1000, 1000)), gbc);
        }
        return this.jpMp3PropertiesToInclude;
    }

    public JPanel getJpPropertiesToInclude() {
        if (this.jpPropertiesToInclude == null) {
            this.jpPropertiesToInclude = new JPanel();
            this.jpPropertiesToInclude.setLayout(new GridBagLayout());
            this.jpPropertiesToInclude.setBorder(BorderFactory.createTitledBorder("Properties to Include"));
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 1;
            gbc.fill = 2;
            gbc.weightx = 1.0;
            gbc.weighty = 0.0;
            gbc.gridwidth = 1;
            gbc.gridheight = 1;
            this.jpPropertiesToInclude.add((Component)this.getJchkPFileName(), gbc);
            ++gbc.gridy;
            this.jpPropertiesToInclude.add((Component)this.getJchkPFileExt(), gbc);
            ++gbc.gridy;
            this.jpPropertiesToInclude.add((Component)this.getJchkPFileSize(), gbc);
            ++gbc.gridy;
            this.jpPropertiesToInclude.add((Component)this.getJchkPLastModified(), gbc);
            ++gbc.gridy;
            this.jpPropertiesToInclude.add((Component)this.getJpMp3PropertiesToInclude(), gbc);
            ++gbc.gridy;
            gbc.fill = 1;
            gbc.weighty = 1.0;
            Box.Filler f = new Box.Filler(new Dimension(1, 1), new Dimension(1, 1), new Dimension(1000, 1000));
            this.jpPropertiesToInclude.add((Component)f, gbc);
        }
        return this.jpPropertiesToInclude;
    }

    public JTextField getJtfFilter() {
        if (this.jtfFilter == null) {
            this.jtfFilter = new JTextField();
            this.jtfFilter.setText("*.*");
        }
        return this.jtfFilter;
    }

    public JButton getRemoveButton() {
        if (this.removeButton == null) {
            this.removeButton = new FlatJButton(Images.GENERIC_DELETE_ICON);
            this.removeButton.addActionListener(this);
        }
        return this.removeButton;
    }

    public JLabel getTopLabel() {
        if (this.topLabel == null) {
            this.topLabel = new JLabel("Create a new Database from a directory/MP3 List");
        }
        return this.topLabel;
    }

    public void onAddDirectory() {
        JFileChooser chooser = new JFileChooser();
        chooser.setApproveButtonText("Select");
        chooser.setFileSelectionMode(1);
        chooser.setDialogTitle("Select a Directory");
        chooser.setMultiSelectionEnabled(true);
        chooser.setAcceptAllFileFilterUsed(false);
        chooser.setFileFilter(new FileFilter(){

            public boolean accept(File arg0) {
                return arg0.isDirectory() && arg0.canRead();
            }

            public String getDescription() {
                return "Directories Only";
            }
        });
        chooser.showOpenDialog(this);
        File[] fs = chooser.getSelectedFiles();
        int i = 0;
        while (i < fs.length) {
            if (!this.listModel.contains(fs[i])) {
                this.listModel.addElement(fs[i]);
            }
            ++i;
        }
    }

    public void onRemoveDirectory() {
        int[] selected = this.getJlstFolders().getSelectedIndices();
        int i = selected.length - 1;
        while (i >= 0) {
            this.listModel.removeElementAt(selected[i]);
            --i;
        }
    }
}

