/*
 * Decompiled with CFR 0.152.
 */
package pilotdb.ui.simplecreator.html;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.Vector;
import javax.help.CSH;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import pilotdb.PilotDBDatabase;
import pilotdb.tools.PluginMonitor;
import pilotdb.tools.simplecreator.htmltable.Plugin;
import pilotdb.ui.Application;
import pilotdb.ui.command.Command;
import pilotdb.ui.images.Images;
import pilotdb.ui.util.FlatJButton;

public class ImportHtmlPanel
extends JPanel
implements ActionListener,
ItemListener {
    public static final int RESPONSE_OK = 0;
    public static final int RESPONSE_CANCEL = 1;
    private transient Vector actionListeners;
    JButton jbOk;
    JButton jbCancel;
    JButton jbHelp;
    JRadioButton jrbName;
    JRadioButton jrbExisting;
    JCheckBox jchkHasHeaderRows;
    ButtonGroup bgName;
    JComboBox jcbName;
    JComboBox jcbTableNumber;
    JLabel jlTableSourceUrl;
    JLabel jlDatabaseInfo;
    JLabel jlHtmlTableInfo;
    JLabel jlTableNumber;
    JProgressBar jpb;
    JTextField jtfDatabaseName;
    JTextField jtfTableSourceUrl;
    Plugin plugin = new Plugin();
    Application application = null;

    public ImportHtmlPanel(Application app) {
        this.application = app;
        this.plugin.setUp();
        this.uiInit();
    }

    private void uiInit() {
        int dbcount = this.application.getCurrentEnvironment().getDatabaseCount();
        String[] dbnames = new String[dbcount];
        int i = 0;
        while (i < dbcount) {
            dbnames[i] = this.application.getCurrentEnvironment().getDatabase(i).getTitle();
            ++i;
        }
        Integer[] tableNumbers = new Integer[20];
        int i2 = 0;
        while (i2 < tableNumbers.length) {
            tableNumbers[i2] = new Integer(i2++);
        }
        this.jchkHasHeaderRows = new JCheckBox();
        this.jpb = new JProgressBar();
        this.jlTableSourceUrl = new JLabel();
        this.jlDatabaseInfo = new JLabel();
        this.jlHtmlTableInfo = new JLabel();
        this.jlTableNumber = new JLabel();
        this.jbOk = new FlatJButton();
        this.jbCancel = new FlatJButton();
        this.bgName = new ButtonGroup();
        this.jrbExisting = new JRadioButton();
        this.jrbName = new JRadioButton();
        this.jcbName = new JComboBox<String>(dbnames);
        this.jcbTableNumber = new JComboBox<Integer>(tableNumbers);
        this.jtfDatabaseName = new JTextField();
        this.jtfTableSourceUrl = new JTextField();
        this.jpb.setStringPainted(true);
        this.jpb.setString("working...");
        this.jlTableSourceUrl.setText("html url");
        this.jlDatabaseInfo.setText("database info");
        this.jlHtmlTableInfo.setText("html table information");
        this.jlTableNumber.setText("table index");
        this.jchkHasHeaderRows.setText("has header row");
        this.jbOk.setText("ok");
        this.jbCancel.setText("cancel");
        this.jrbExisting.setText("select existing");
        this.jrbName.setText("new database name");
        this.jtfDatabaseName.setText("<database name>");
        this.jtfTableSourceUrl.setText("<enter url here>");
        this.jpb.setBorder(BorderFactory.createLineBorder(Color.lightGray));
        this.jlHtmlTableInfo.setBorder(BorderFactory.createLineBorder(Color.lightGray));
        this.jlDatabaseInfo.setBorder(BorderFactory.createLineBorder(Color.lightGray));
        this.jtfDatabaseName.setBorder(BorderFactory.createLineBorder(Color.lightGray));
        this.jcbTableNumber.setBorder(BorderFactory.createLineBorder(Color.lightGray));
        this.jcbName.setBorder(BorderFactory.createLineBorder(Color.lightGray));
        this.jtfTableSourceUrl.setBorder(BorderFactory.createLineBorder(Color.lightGray));
        this.bgName.add(this.jrbExisting);
        this.bgName.add(this.jrbName);
        this.jrbName.setSelected(true);
        this.jcbName.setEnabled(false);
        this.jchkHasHeaderRows.setSelectedIcon(Images.CHECKBOX_CHECKED_ICON);
        this.jchkHasHeaderRows.setIcon(Images.CHECKBOX_UNCHECKED_ICON);
        this.jrbName.setSelectedIcon(Images.CHECKBOX_CHECKED_ICON);
        this.jrbName.setIcon(Images.CHECKBOX_UNCHECKED_ICON);
        this.jrbExisting.setSelectedIcon(Images.CHECKBOX_CHECKED_ICON);
        this.jrbExisting.setIcon(Images.CHECKBOX_UNCHECKED_ICON);
        this.jbOk.setIcon(Images.OK_ICON);
        this.jbCancel.setIcon(Images.CANCEL_ICON);
        this.jlDatabaseInfo.setBounds(5, 5, 300, 20);
        this.jrbName.setBounds(15, 30, 150, 20);
        this.jtfDatabaseName.setBounds(40, 55, 200, 20);
        this.jrbExisting.setBounds(15, 80, 150, 20);
        this.jcbName.setBounds(40, 105, 200, 20);
        this.jlHtmlTableInfo.setBounds(5, 135, 300, 20);
        this.jlTableSourceUrl.setBounds(15, 160, 150, 20);
        this.jtfTableSourceUrl.setBounds(40, 185, 200, 20);
        this.jlTableNumber.setBounds(15, 205, 150, 20);
        this.jcbTableNumber.setBounds(40, 230, 50, 20);
        this.jchkHasHeaderRows.setBounds(15, 255, 150, 20);
        this.jbOk.setBounds(150, 285, 75, 25);
        this.jbCancel.setBounds(230, 285, 75, 25);
        this.jpb.setBounds(5, 285, 300, 20);
        this.jpb.setVisible(false);
        this.setLayout(null);
        this.add(this.jlDatabaseInfo);
        this.add(this.jrbName);
        this.add(this.jtfDatabaseName);
        this.add(this.jrbExisting);
        this.add(this.jcbName);
        this.add(this.jlHtmlTableInfo);
        this.add(this.jlTableSourceUrl);
        this.add(this.jtfTableSourceUrl);
        this.add(this.jlTableNumber);
        this.add(this.jcbTableNumber);
        this.add(this.jchkHasHeaderRows);
        this.add(this.jbOk);
        this.add(this.jbCancel);
        this.add(this.jpb);
        try {
            this.jbHelp = new FlatJButton();
            this.jbHelp.setText("help");
            this.jbHelp.setIcon(Images.QUESTION_ICON);
            this.jbHelp.setBounds(70, 285, 75, 25);
            CSH.setHelpIDString((Component)this.jbHelp, (String)"import.html");
            this.jbHelp.addActionListener((ActionListener)new CSH.DisplayHelpFromSource(this.application.getHelpBroker()));
            this.add(this.jbHelp);
        }
        catch (Throwable t) {
            this.jbHelp = null;
        }
        this.setPreferredSize(new Dimension(310, 315));
        this.jbOk.addActionListener(this);
        this.jbCancel.addActionListener(this);
        this.jrbExisting.addItemListener(this);
        this.jcbName.addItemListener(this);
        this.jcbTableNumber.addItemListener(this);
        PluginMonitor monitor = new PluginMonitor(){

            public void setSteps(int totalSteps) {
                ImportHtmlPanel.this.jpb.setMaximum(totalSteps);
                ImportHtmlPanel.this.jpb.setMinimum(0);
            }

            public void setStep(int step) {
                ImportHtmlPanel.this.jpb.setValue(step);
            }

            public void setStep(int step, String message) {
                this.setStep(step);
                this.setMessage(message);
            }

            public void setMessage(String message) {
                ImportHtmlPanel.this.jpb.setString(message);
            }

            public void setError(String error) {
                ImportHtmlPanel.this.jpb.setForeground(Color.red);
            }

            public void done() {
                ImportHtmlPanel.this.jpb.setVisible(false);
                ImportHtmlPanel.this.jbCancel.setVisible(true);
                ImportHtmlPanel.this.jbOk.setVisible(true);
                if (ImportHtmlPanel.this.jbHelp != null) {
                    ImportHtmlPanel.this.jbHelp.setVisible(true);
                }
            }

            public void start() {
                ImportHtmlPanel.this.jpb.setVisible(true);
                ImportHtmlPanel.this.jbCancel.setVisible(false);
                ImportHtmlPanel.this.jbOk.setVisible(false);
                if (ImportHtmlPanel.this.jbHelp != null) {
                    ImportHtmlPanel.this.jbHelp.setVisible(false);
                }
            }
        };
        this.plugin.setPluginMonitor(monitor);
    }

    public void actionPerformed(ActionEvent ae) {
        Object source = ae.getSource();
        if (source == this.jbOk) {
            Runnable r = new Runnable(){

                public void run() {
                    ImportHtmlPanel.this.onOk(null);
                }
            };
            Thread t = new Thread(r);
            t.setPriority(1);
            t.start();
        } else if (source == this.jbCancel) {
            this.onCancel(ae);
        }
    }

    public void updatePlugin() {
        if (this.jcbName.isEnabled()) {
            PilotDBDatabase db = this.application.getCurrentEnvironment().getDatabaseByTitle(this.jcbName.getSelectedItem().toString());
            this.plugin.setTitle(this.jcbName.getSelectedItem().toString());
            File f = this.application.getCurrentEnvironment().getFile(db);
            if (f == null) {
                f = new File(this.application.getCurrentEnvironment().getBaseDirectory(), String.valueOf(this.jcbName.getSelectedItem().toString()) + ".pdb");
            } else {
                Command closeDbCmd = new Command(this, "cmd-close-database", db);
                this.application.postEventAndWait(closeDbCmd);
                Command deleteDbCmd = new Command(this, "cmd-delete-database", db);
                this.application.postEventAndWait(deleteDbCmd);
            }
            this.plugin.setPdbFile(f);
        } else {
            this.plugin.setTitle(this.jtfDatabaseName.getText());
            File f = new File(this.application.getCurrentEnvironment().getBaseDirectory(), String.valueOf(this.jtfDatabaseName.getText()) + ".pdb");
            this.plugin.setPdbFile(f);
        }
        this.plugin.setTableNumber((Integer)this.jcbTableNumber.getSelectedItem());
        this.plugin.setTableSourceHref(this.jtfTableSourceUrl.getText());
        this.plugin.setHasTableHeaderRow(this.jchkHasHeaderRows.isSelected());
    }

    public void itemStateChanged(ItemEvent arg0) {
        Object source = arg0.getSource();
        if (source == this.jrbExisting) {
            this.jcbName.setEnabled(this.jrbExisting.isSelected());
            this.jtfDatabaseName.setEnabled(!this.jrbExisting.isSelected());
            String itemSelected = (String)this.jcbName.getSelectedItem();
            this.plugin.setTitle(itemSelected);
        } else if (source == this.jcbName) {
            String itemSelected = (String)this.jcbName.getSelectedItem();
            this.plugin.setTitle(itemSelected);
        } else if (source == this.jcbTableNumber) {
            Integer itemSelected = (Integer)arg0.getItem();
            this.plugin.setTableNumber(itemSelected);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onCancel(ActionEvent evt) {
        if (this.actionListeners != null) {
            Vector vector = this.actionListeners;
            synchronized (vector) {
                int i = 0;
                while (i < this.actionListeners.size()) {
                    ActionListener al = (ActionListener)this.actionListeners.get(i);
                    ActionEvent ae = new ActionEvent(this, 1, "cancel");
                    al.actionPerformed(ae);
                    ++i;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onOk(ActionEvent evt) {
        this.updatePlugin();
        if (!this.plugin.isReady()) {
            Command c2 = new Command(this.application.getMainWindow(), "cmd-show-error", "Parameters are missing or incorrect");
            this.application.postEvent(c2);
            return;
        }
        try {
            this.plugin.execute();
            PilotDBDatabase db = this.application.getCurrentEnvironment().openDatabase(this.plugin.getTitle());
            this.application.postEvent(new Command(this.application.getMainWindow(), "msg-created-database", db));
        }
        catch (Exception e) {
            Command c = new Command(this, "cmd-log-exception", e);
            Command c2 = new Command(this, "cmd-show-error", "An error has occured\n[" + e.getMessage() + "]");
            this.application.postEvent(c);
            this.application.postEvent(c2);
        }
        if (this.actionListeners != null) {
            Vector vector = this.actionListeners;
            synchronized (vector) {
                int i = 0;
                while (i < this.actionListeners.size()) {
                    ActionListener al = (ActionListener)this.actionListeners.get(i);
                    ActionEvent ae = new ActionEvent(this, 0, "ok");
                    al.actionPerformed(ae);
                    ++i;
                }
            }
        }
    }

    public synchronized void removeActionListener(ActionListener l) {
        if (this.actionListeners != null && this.actionListeners.contains(l)) {
            Vector v = (Vector)this.actionListeners.clone();
            v.removeElement(l);
            this.actionListeners = v;
        }
    }

    public synchronized void addActionListener(ActionListener l) {
        Vector v;
        Vector vector = v = this.actionListeners == null ? new Vector(2) : (Vector)this.actionListeners.clone();
        if (!v.contains(l)) {
            v.addElement(l);
            this.actionListeners = v;
        }
    }
}

