/*
 * Decompiled with CFR 0.152.
 */
package pilotdb.ui.simplecreator.xml;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.Vector;
import javax.help.CSH;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.AbstractTableModel;
import javax.swing.text.BadLocationException;
import pilotdb.PilotDBDatabase;
import pilotdb.tools.PluginMonitor;
import pilotdb.tools.simplecreator.xml.Plugin;
import pilotdb.ui.Application;
import pilotdb.ui.command.Command;
import pilotdb.ui.images.Images;
import pilotdb.ui.util.FlatJButton;
import pilotdb.ui.util.FlatTableCellRenderer;

public class ImportXmlPanel
extends JPanel
implements ActionListener,
ItemListener,
DocumentListener {
    public static final int RESPONSE_OK = 0;
    public static final int RESPONSE_CANCEL = 1;
    private transient Vector actionListeners;
    JProgressBar jpb;
    JButton jbOk;
    JButton jbCancel;
    JButton jbHelp;
    JButton jbSave;
    JButton jbLoad;
    JButton jbAdd;
    JButton jbRemove;
    JButton jbXmlFile;
    JRadioButton jrbName;
    JRadioButton jrbExisting;
    ButtonGroup bgName;
    JComboBox jcbName;
    JLabel jlXmlFileName;
    JLabel jlXmlFile;
    JLabel jlDatabaseInfo;
    JLabel jlXmlInfo;
    JLabel jlRepeatingElement;
    JLabel jlFieldMappings;
    JLabel jlConfigurationFiles;
    JTextField jtfDatabaseName;
    JTextField jtfRepeatingElement;
    JTable jtblFieldMappings;
    JScrollPane jspFieldMappings;
    AbstractTableModel fieldMappingsTableModel;
    Plugin plugin = new Plugin();
    Application application = null;
    static /* synthetic */ Class class$0;

    public ImportXmlPanel(Application app) {
        this.application = app;
        this.plugin.setUp();
        this.uiInit();
    }

    private void uiInit() {
        int dbcount = this.application.getCurrentEnvironment().getDatabaseCount();
        String[] dbnames = new String[dbcount];
        int i = 0;
        while (i < dbcount) {
            dbnames[i] = this.application.getCurrentEnvironment().getDatabase(i).getTitle();
            ++i;
        }
        this.fieldMappingsTableModel = new AbstractTableModel(){
            String[] columns = new String[]{"field", "xml path"};

            public int getRowCount() {
                return ImportXmlPanel.this.plugin.getPathCount();
            }

            public int getColumnCount() {
                return 2;
            }

            public String getColumnName(int arg0) {
                return this.columns[arg0];
            }

            public Class getColumnClass(int arg0) {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("java.lang.String");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return clazz;
            }

            public boolean isCellEditable(int arg0, int arg1) {
                return true;
            }

            public Object getValueAt(int arg0, int arg1) {
                return arg1 == 0 ? ImportXmlPanel.this.plugin.getField(arg0) : ImportXmlPanel.this.plugin.getPath(arg0);
            }

            public void setValueAt(Object arg0, int arg1, int arg2) {
                if (arg2 == 0) {
                    ImportXmlPanel.this.plugin.setField(arg1, (String)arg0);
                } else {
                    ImportXmlPanel.this.plugin.setPath(arg1, (String)arg0);
                }
            }
        };
        this.jlXmlFile = new JLabel();
        this.jlXmlFileName = new JLabel();
        this.jlDatabaseInfo = new JLabel();
        this.jlXmlInfo = new JLabel();
        this.jlRepeatingElement = new JLabel();
        this.jlFieldMappings = new JLabel();
        this.jlConfigurationFiles = new JLabel();
        this.jbOk = new FlatJButton();
        this.jbXmlFile = new FlatJButton();
        this.jbCancel = new FlatJButton();
        this.jbSave = new FlatJButton();
        this.jbLoad = new FlatJButton();
        this.jbAdd = new FlatJButton();
        this.jbRemove = new FlatJButton();
        this.bgName = new ButtonGroup();
        this.jrbExisting = new JRadioButton();
        this.jrbName = new JRadioButton();
        this.jcbName = new JComboBox<String>(dbnames);
        this.jtfDatabaseName = new JTextField();
        this.jtfRepeatingElement = new JTextField();
        this.jtblFieldMappings = new JTable(this.fieldMappingsTableModel);
        this.jspFieldMappings = new JScrollPane(this.jtblFieldMappings);
        this.jpb = new JProgressBar();
        this.jpb.setStringPainted(true);
        this.jpb.setString("working...");
        this.jlXmlFile.setText("<select xml file>");
        this.jlXmlFileName.setText("xml filename");
        this.jlDatabaseInfo.setText("database info");
        this.jlXmlInfo.setText("xml specifics");
        this.jlRepeatingElement.setText("repeating element");
        this.jlFieldMappings.setText("field mappings");
        this.jlConfigurationFiles.setText("configuration file");
        this.jbOk.setText("ok");
        this.jbCancel.setText("cancel");
        this.jbSave.setText("save configuration");
        this.jbLoad.setText("load configuration");
        this.jrbExisting.setText("select existing");
        this.jrbName.setText("new database name");
        this.jtfDatabaseName.setText("<database name>");
        this.jtfRepeatingElement.setText("<xml element name>");
        this.jlXmlInfo.setBorder(BorderFactory.createLineBorder(Color.lightGray));
        this.jlConfigurationFiles.setBorder(BorderFactory.createLineBorder(Color.lightGray));
        this.jlDatabaseInfo.setBorder(BorderFactory.createLineBorder(Color.lightGray));
        this.jspFieldMappings.setBorder(BorderFactory.createLineBorder(Color.lightGray));
        this.jtfDatabaseName.setBorder(BorderFactory.createLineBorder(Color.lightGray));
        this.jtfRepeatingElement.setBorder(BorderFactory.createLineBorder(Color.lightGray));
        this.jcbName.setBorder(BorderFactory.createLineBorder(Color.lightGray));
        this.bgName.add(this.jrbExisting);
        this.bgName.add(this.jrbName);
        this.jrbName.setSelected(true);
        this.jcbName.setEnabled(false);
        this.jbLoad.setIcon(Images.OPEN_ICON);
        this.jbSave.setIcon(Images.SAVE_ICON);
        this.jrbName.setSelectedIcon(Images.CHECKBOX_CHECKED_ICON);
        this.jrbName.setIcon(Images.CHECKBOX_UNCHECKED_ICON);
        this.jrbExisting.setSelectedIcon(Images.CHECKBOX_CHECKED_ICON);
        this.jrbExisting.setIcon(Images.CHECKBOX_UNCHECKED_ICON);
        this.jbXmlFile.setIcon(Images.OPEN_ICON);
        this.jbOk.setIcon(Images.OK_ICON);
        this.jbCancel.setIcon(Images.CANCEL_ICON);
        this.jbAdd.setIcon(Images.GENERIC_ADD_ICON);
        this.jbRemove.setIcon(Images.GENERIC_DELETE_ICON);
        FlatTableCellRenderer ftcr = new FlatTableCellRenderer();
        ftcr.setBackground(Color.black);
        ftcr.setForeground(Color.white);
        ftcr.setHorizontalAlignment(2);
        this.jtblFieldMappings.getTableHeader().setDefaultRenderer(ftcr);
        this.jlDatabaseInfo.setBounds(5, 5, 300, 20);
        this.jrbName.setBounds(15, 30, 150, 20);
        this.jtfDatabaseName.setBounds(40, 55, 200, 20);
        this.jrbExisting.setBounds(15, 80, 150, 20);
        this.jcbName.setBounds(40, 105, 200, 20);
        this.jlXmlInfo.setBounds(5, 135, 300, 20);
        this.jlXmlFileName.setBounds(15, 160, 150, 20);
        this.jlXmlFile.setBounds(40, 185, 200, 20);
        this.jbXmlFile.setBounds(245, 185, 20, 20);
        this.jlRepeatingElement.setBounds(15, 205, 150, 20);
        this.jtfRepeatingElement.setBounds(40, 230, 200, 20);
        this.jlFieldMappings.setBounds(15, 255, 150, 20);
        this.jspFieldMappings.setBounds(40, 280, 200, 100);
        this.jbAdd.setBounds(245, 315, 20, 20);
        this.jbRemove.setBounds(245, 340, 20, 20);
        this.jlConfigurationFiles.setBounds(5, 390, 300, 20);
        this.jbLoad.setBounds(15, 415, 140, 25);
        this.jbSave.setBounds(15, 445, 140, 25);
        this.jbOk.setBounds(150, 480, 75, 25);
        this.jbCancel.setBounds(230, 480, 75, 25);
        this.jpb.setBounds(5, 480, 300, 25);
        this.jpb.setVisible(false);
        this.setLayout(null);
        try {
            this.jbHelp = new FlatJButton();
            this.jbHelp.setIcon(Images.QUESTION_ICON);
            this.jbHelp.setText("help");
            this.jbHelp.setBounds(70, 480, 75, 25);
            CSH.setHelpIDString((Component)this.jbHelp, (String)"import.xml");
            this.jbHelp.addActionListener((ActionListener)new CSH.DisplayHelpFromSource(this.application.getHelpBroker()));
            this.add(this.jbHelp);
        }
        catch (Throwable t) {
            this.jbHelp = null;
        }
        this.add(this.jpb);
        this.add(this.jlDatabaseInfo);
        this.add(this.jlXmlInfo);
        this.add(this.jlXmlFile);
        this.add(this.jlXmlFileName);
        this.add(this.jlRepeatingElement);
        this.add(this.jlFieldMappings);
        this.add(this.jlConfigurationFiles);
        this.add(this.jbOk);
        this.add(this.jbXmlFile);
        this.add(this.jbCancel);
        this.add(this.jbSave);
        this.add(this.jbLoad);
        this.add(this.jbAdd);
        this.add(this.jbRemove);
        this.add(this.jrbExisting);
        this.add(this.jrbName);
        this.add(this.jcbName);
        this.add(this.jtfDatabaseName);
        this.add(this.jtfRepeatingElement);
        this.add(this.jspFieldMappings);
        this.setPreferredSize(new Dimension(310, 510));
        this.jbOk.addActionListener(this);
        this.jbLoad.addActionListener(this);
        this.jbSave.addActionListener(this);
        this.jbXmlFile.addActionListener(this);
        this.jbCancel.addActionListener(this);
        this.jbAdd.addActionListener(this);
        this.jbRemove.addActionListener(this);
        this.jrbExisting.addItemListener(this);
        this.jcbName.addItemListener(this);
        this.jtfDatabaseName.getDocument().addDocumentListener(this);
        this.jtfRepeatingElement.getDocument().addDocumentListener(this);
        PluginMonitor monitor = new PluginMonitor(){

            public void setSteps(int totalSteps) {
                ImportXmlPanel.this.jpb.setMaximum(totalSteps);
                ImportXmlPanel.this.jpb.setMinimum(0);
            }

            public void setStep(int step) {
                ImportXmlPanel.this.jpb.setValue(step);
            }

            public void setStep(int step, String message) {
                this.setStep(step);
                this.setMessage(message);
            }

            public void setMessage(String message) {
                ImportXmlPanel.this.jpb.setString(message);
            }

            public void setError(String error) {
                ImportXmlPanel.this.jpb.setForeground(Color.red);
            }

            public void done() {
                ImportXmlPanel.this.jpb.setVisible(false);
                ImportXmlPanel.this.jbCancel.setVisible(true);
                ImportXmlPanel.this.jbOk.setVisible(true);
                if (ImportXmlPanel.this.jbHelp != null) {
                    ImportXmlPanel.this.jbHelp.setVisible(true);
                }
            }

            public void start() {
                ImportXmlPanel.this.jpb.setVisible(true);
                ImportXmlPanel.this.jbCancel.setVisible(false);
                ImportXmlPanel.this.jbOk.setVisible(false);
                if (ImportXmlPanel.this.jbHelp != null) {
                    ImportXmlPanel.this.jbHelp.setVisible(false);
                }
            }
        };
        this.plugin.setPluginMonitor(monitor);
    }

    public void actionPerformed(ActionEvent ae) {
        Object source = ae.getSource();
        if (source == this.jbOk) {
            Runnable r = new Runnable(){

                public void run() {
                    ImportXmlPanel.this.onOk(null);
                }
            };
            Thread t = new Thread(r);
            t.setPriority(1);
            t.start();
        } else if (source == this.jbCancel) {
            this.onCancel(ae);
        } else if (source == this.jbAdd) {
            this.onAdd(ae);
        } else if (source == this.jbRemove) {
            this.onRemove(ae);
        } else if (source == this.jbXmlFile) {
            this.onXmlFile(ae);
        } else if (source == this.jbLoad) {
            this.onLoadConfiguration(ae);
        } else if (source == this.jbSave) {
            this.onSaveConfiguration(ae);
        }
    }

    void onXmlFile(ActionEvent ae) {
        JFileChooser chooser = new JFileChooser();
        chooser.setApproveButtonText("Select");
        chooser.setDialogTitle("Import XML");
        chooser.setFileFilter(new FileFilter(){

            public boolean accept(File arg0) {
                if (arg0.isDirectory()) {
                    return true;
                }
                return arg0.getAbsolutePath().toLowerCase().endsWith(".xml");
            }

            public String getDescription() {
                return "XML File (*.xml)";
            }
        });
        chooser.setFileSelectionMode(0);
        int val = chooser.showOpenDialog(this.application.getMainComponent());
        File outputFile = null;
        if (val == 0) {
            outputFile = chooser.getSelectedFile();
            try {
                this.plugin.setXmlPath(outputFile.getAbsolutePath());
                this.jlXmlFile.setText(outputFile.getAbsolutePath());
            }
            catch (Exception e) {
                this.jlXmlFile.setText("Error, bad file");
            }
        }
    }

    public void updatePdbFile() {
        if (this.jcbName.isEnabled()) {
            PilotDBDatabase db = this.application.getCurrentEnvironment().getDatabaseByTitle(this.jcbName.getSelectedItem().toString());
            File f = this.application.getCurrentEnvironment().getFile(db);
            if (f == null) {
                f = new File(this.application.getCurrentEnvironment().getBaseDirectory(), String.valueOf(this.jcbName.getSelectedItem().toString()) + ".pdb");
            } else {
                Command closeDbCmd = new Command(this, "cmd-close-database", db);
                this.application.postEventAndWait(closeDbCmd);
                Command deleteDbCmd = new Command(this, "cmd-delete-database", db);
                this.application.postEventAndWait(deleteDbCmd);
            }
            this.plugin.setPdbPath(f.getAbsolutePath());
            this.plugin.setDatabaseName(this.jcbName.getSelectedItem().toString());
        } else {
            File f = new File(this.application.getCurrentEnvironment().getBaseDirectory(), String.valueOf(this.jtfDatabaseName.getText()) + ".pdb");
            this.plugin.setPdbPath(f.getAbsolutePath());
            this.plugin.setDatabaseName(this.jtfDatabaseName.getText());
        }
        this.plugin.setRepeatingElementName(this.jtfRepeatingElement.getText());
    }

    public void itemStateChanged(ItemEvent arg0) {
        Object source = arg0.getSource();
        if (source == this.jrbExisting) {
            this.jcbName.setEnabled(this.jrbExisting.isSelected());
            this.jtfDatabaseName.setEnabled(!this.jrbExisting.isSelected());
            String itemSelected = (String)this.jcbName.getSelectedItem();
            this.plugin.setDatabaseName(itemSelected);
        } else if (source == this.jcbName) {
            String itemSelected = (String)this.jcbName.getSelectedItem();
            this.plugin.setDatabaseName(itemSelected);
        }
    }

    void onAdd(ActionEvent evt) {
        this.plugin.addFieldNamePathMapping("fieldName", "path");
        this.fieldMappingsTableModel.fireTableDataChanged();
    }

    void onRemove(ActionEvent evt) {
        int selected = this.jtblFieldMappings.getSelectedRow();
        if (selected < 0) {
            return;
        }
        this.plugin.removeFieldNamePathMapping(selected);
        this.fieldMappingsTableModel.fireTableDataChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onCancel(ActionEvent evt) {
        if (this.actionListeners != null) {
            Vector vector = this.actionListeners;
            synchronized (vector) {
                int i = 0;
                while (i < this.actionListeners.size()) {
                    ActionListener al = (ActionListener)this.actionListeners.get(i);
                    ActionEvent ae = new ActionEvent(this, 1, "cancel");
                    al.actionPerformed(ae);
                    ++i;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onOk(ActionEvent evt) {
        try {
            this.updatePdbFile();
            this.plugin.execute();
            PilotDBDatabase db = this.application.getCurrentEnvironment().openDatabase(this.plugin.getDatabaseName());
            this.application.postEvent(new Command(this, "msg-created-database", db));
        }
        catch (Exception e) {
            Command c = new Command(this, "cmd-log-exception", e);
            Command c2 = new Command(this, "cmd-show-error", "An error has occured\n[" + e.getMessage() + "]");
            this.application.postEvent(c);
            this.application.postEvent(c2);
        }
        if (this.actionListeners != null) {
            Vector vector = this.actionListeners;
            synchronized (vector) {
                int i = 0;
                while (i < this.actionListeners.size()) {
                    ActionListener al = (ActionListener)this.actionListeners.get(i);
                    ActionEvent ae = new ActionEvent(this, 0, "ok");
                    al.actionPerformed(ae);
                    ++i;
                }
            }
        }
    }

    public synchronized void removeActionListener(ActionListener l) {
        if (this.actionListeners != null && this.actionListeners.contains(l)) {
            Vector v = (Vector)this.actionListeners.clone();
            v.removeElement(l);
            this.actionListeners = v;
        }
    }

    public synchronized void addActionListener(ActionListener l) {
        Vector v;
        Vector vector = v = this.actionListeners == null ? new Vector(2) : (Vector)this.actionListeners.clone();
        if (!v.contains(l)) {
            v.addElement(l);
            this.actionListeners = v;
        }
    }

    public void changedUpdate(DocumentEvent arg0) {
        this.handleDocumentEvent(arg0);
    }

    public void insertUpdate(DocumentEvent arg0) {
        this.handleDocumentEvent(arg0);
    }

    public void removeUpdate(DocumentEvent arg0) {
        this.handleDocumentEvent(arg0);
    }

    void handleDocumentEvent(DocumentEvent de) {
        try {
            String s = de.getDocument().getText(0, de.getDocument().getLength());
            if (de.getDocument() == this.jtfDatabaseName.getDocument()) {
                this.setDatabaseName(s);
            } else {
                this.setRepeatingElement(s);
            }
        }
        catch (BadLocationException ble) {
            ble.printStackTrace();
        }
    }

    void setDatabaseName(String text) {
        this.plugin.setDatabaseName(text);
    }

    void setRepeatingElement(String text) {
        this.plugin.setRepeatingElementName(text);
    }

    void onLoadConfiguration(ActionEvent ae) {
        this.jtfDatabaseName.setText("error");
        this.jtfRepeatingElement.setText("error");
        this.plugin.removeAllFieldMappings();
        JFileChooser chooser = new JFileChooser();
        chooser.setApproveButtonText("Load");
        chooser.setDialogTitle("Load Configuration");
        chooser.setFileFilter(new FileFilter(){

            public boolean accept(File arg0) {
                if (arg0.isDirectory()) {
                    return true;
                }
                return arg0.getAbsolutePath().toLowerCase().endsWith(".cfg");
            }

            public String getDescription() {
                return "XML Import Configuration File (*.cfg)";
            }
        });
        chooser.setFileSelectionMode(0);
        int val = chooser.showOpenDialog(this.application.getMainComponent());
        File outputFile = null;
        if (val == 0) {
            outputFile = chooser.getSelectedFile();
            try {
                this.plugin.setConfigPath(outputFile.getAbsolutePath());
                this.fieldMappingsTableModel.fireTableDataChanged();
                this.jtfDatabaseName.setText(this.plugin.getDatabaseName());
                this.jtfRepeatingElement.setText(this.plugin.getRepeatingElementName());
            }
            catch (Exception e) {
                Command c = new Command(this, "cmd-show-error", "Invalid Configuration File");
                this.application.postEvent(c);
                c = new Command(this, "cmd-log-exception", "Invalid Configuration File");
                this.application.postEvent(c);
            }
        }
    }

    void onSaveConfiguration(ActionEvent ae) {
        JFileChooser chooser = new JFileChooser();
        chooser.setApproveButtonText("Save");
        chooser.setDialogTitle("Save Configuration");
        chooser.setFileFilter(new FileFilter(){

            public boolean accept(File arg0) {
                if (arg0.isDirectory()) {
                    return true;
                }
                return arg0.getAbsolutePath().toLowerCase().endsWith(".cfg");
            }

            public String getDescription() {
                return "XML Import Configuration File (*.cfg)";
            }
        });
        chooser.setFileSelectionMode(0);
        int val = chooser.showSaveDialog(this.application.getMainComponent());
        File outputFile = null;
        if (val == 0) {
            outputFile = chooser.getSelectedFile();
            try {
                this.plugin.writeConfiguration(outputFile);
                Command c = new Command(this, "cmd-show-msg", "The configuration file has been saved\nto " + outputFile.getAbsolutePath());
                this.application.postEvent(c);
            }
            catch (Exception e) {
                Command c = new Command(this, "cmd-show-error", "Invalid Configuration File");
                this.application.postEvent(c);
                c = new Command(this, "cmd-log-exception", "Invalid Configuration File");
                this.application.postEvent(c);
            }
        }
    }
}

