/*
 * Decompiled with CFR 0.152.
 */
package pilotdb.ui.tablemaker;

import java.awt.Component;
import java.awt.Rectangle;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import pilotdb.PilotDBDatabase;
import pilotdb.PilotDBEnvironment;
import pilotdb.PilotDBField;
import pilotdb.PilotDBSchema;
import pilotdb.ui.tablemaker.PropsEditor;

public class LinkPropsPanel
extends JPanel
implements PropsEditor {
    PilotDBField field;
    JLabel jLabel1;
    JLabel jLabel2;
    DefaultListModel dlmDatabase = new DefaultListModel();
    JList jlDatabase = new JList(this.dlmDatabase);
    JScrollPane jspDatabase = new JScrollPane(this.jlDatabase);
    DefaultListModel dlmFields = new DefaultListModel();
    JList jlField = new JList(this.dlmFields);
    JScrollPane jspField = new JScrollPane(this.jlField);
    PilotDBEnvironment env;

    public LinkPropsPanel(PilotDBEnvironment env) {
        this.env = env;
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void fillDatabaseList() {
        int count = this.env.getDatabaseCount();
        int i = 0;
        while (i < count) {
            this.dlmDatabase.add(i, this.env.getDatabase(i).getTitle());
            ++i;
        }
    }

    private void fillFieldList() {
        this.dlmFields.removeAllElements();
        int selectedDbIndex = this.jlDatabase.getSelectedIndex();
        PilotDBDatabase db = this.env.getDatabase(selectedDbIndex);
        PilotDBSchema schema = db.getSchema();
        int c = schema.getFieldCount();
        int i = 0;
        while (i < c) {
            PilotDBField field = schema.getField(i);
            this.dlmFields.add(i, field.getName());
            ++i;
        }
    }

    public void setTableField(PilotDBField field) {
        this.field = field;
        if (field.getLinkDbName() != null) {
            this.jlDatabase.setSelectedValue(field.getLinkDbName(), true);
            this.fillFieldList();
            if (field.getLinkColumnNumber() != -1) {
                this.jlField.setSelectedIndex(field.getLinkColumnNumber());
            }
        }
    }

    public void startEditing() {
    }

    public void stopEditing() {
        if (this.field != null) {
            this.field.setLinkDbName(null);
            this.field.setLinkFieldNum(-1);
            if (this.jlDatabase.getSelectedIndex() != -1 && this.jlField.getSelectedIndex() != -1) {
                this.field.setLinkDbName(this.jlDatabase.getSelectedValue().toString());
                this.field.setLinkFieldNum(this.jlField.getSelectedIndex());
            }
        }
    }

    public void cancelEditing() {
    }

    private void jbInit() throws Exception {
        this.fillDatabaseList();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.setLayout(null);
        this.jLabel1.setText("Database");
        this.jLabel2.setText("Field");
        this.jLabel1.setBounds(new Rectangle(10, 0, 130, 20));
        this.jspDatabase.setBounds(new Rectangle(10, 20, 130, 50));
        this.jspDatabase.setHorizontalScrollBarPolicy(31);
        this.jLabel2.setBounds(new Rectangle(10, 70, 130, 20));
        this.jspField.setBounds(new Rectangle(10, 90, 130, 50));
        this.jspField.setHorizontalScrollBarPolicy(31);
        this.add((Component)this.jLabel1, null);
        this.add((Component)this.jLabel2, null);
        this.add((Component)this.jspDatabase, null);
        this.add((Component)this.jspField, null);
        this.jlDatabase.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent lse) {
                if (!lse.getValueIsAdjusting()) {
                    LinkPropsPanel.this.fillFieldList();
                }
            }
        });
    }

    public String getInvalidReason() {
        return null;
    }

    public boolean validateData() {
        return true;
    }
}

