/*
 * Decompiled with CFR 0.152.
 */
package pilotdb.ui.tablemaker;

import java.awt.Component;
import java.awt.Rectangle;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import pilotdb.PilotDBDatabase;
import pilotdb.PilotDBEnvironment;
import pilotdb.PilotDBField;
import pilotdb.PilotDBSchema;
import pilotdb.ui.tablemaker.PropsEditor;

public class LinkedPropsPanel
extends JPanel
implements PropsEditor {
    PilotDBField field;
    JLabel jLabel1;
    JLabel jLabel2;
    DefaultListModel dlmLinkFields = new DefaultListModel();
    JList jlLinkFields = new JList(this.dlmLinkFields);
    JScrollPane jspLinkFields = new JScrollPane(this.jlLinkFields);
    DefaultListModel dlmFields = new DefaultListModel();
    JList jlField = new JList(this.dlmFields);
    JScrollPane jspField = new JScrollPane(this.jlField);
    PilotDBEnvironment env;

    public LinkedPropsPanel(PilotDBEnvironment env) {
        this.env = env;
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void fillLinkFieldsList() {
        PilotDBSchema schema = this.field.getSchema();
        int fc = schema.getFieldCount();
        int i = 0;
        while (i < fc) {
            PilotDBField field = schema.getField(i);
            if (field.getType() == 7) {
                this.dlmLinkFields.addElement(field.getName());
            }
            ++i;
        }
    }

    private void fillFieldList() {
        this.dlmFields.removeAllElements();
        String selectedLinkFieldName = this.jlLinkFields.getSelectedValue().toString();
        PilotDBField selectedLinkField = this.field.getSchema().getField(selectedLinkFieldName);
        PilotDBDatabase db = this.env.getDatabaseByTitle(selectedLinkField.getLinkDbName());
        PilotDBSchema schema = db.getSchema();
        int c = schema.getFieldCount();
        int i = 0;
        while (i < c) {
            PilotDBField field = schema.getField(i);
            this.dlmFields.add(i, field.getName());
            ++i;
        }
    }

    public void setTableField(PilotDBField field) {
        this.field = field;
        this.fillLinkFieldsList();
        if (field.getLinkedLinkFieldIndex() != -1) {
            int linkFieldIndex = field.getLinkedLinkFieldIndex();
            this.jlLinkFields.setSelectedValue(field.getSchema().getField(linkFieldIndex).getName(), true);
            this.fillFieldList();
            if (field.getLinkedTableColumnIndex() != -1) {
                this.jlField.setSelectedIndex(field.getLinkedTableColumnIndex());
            }
        }
    }

    public void startEditing() {
    }

    public void stopEditing() {
        if (this.field != null) {
            this.field.setLinkedLinkFieldIndex(-1);
            this.field.setLinkedTableColumnIndex(-1);
            if (this.jlLinkFields.getSelectedIndex() != -1 && this.jlField.getSelectedIndex() != -1) {
                this.field.setLinkedLinkFieldIndex(this.field.getSchema().indexOfField(this.jlLinkFields.getSelectedValue().toString()));
                this.field.setLinkedTableColumnIndex(this.jlField.getSelectedIndex());
            }
        }
    }

    public void cancelEditing() {
    }

    private void jbInit() throws Exception {
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.setLayout(null);
        this.jLabel1.setText("Database");
        this.jLabel2.setText("Field");
        this.jLabel1.setBounds(new Rectangle(10, 0, 130, 20));
        this.jspLinkFields.setBounds(new Rectangle(10, 20, 130, 50));
        this.jspLinkFields.setHorizontalScrollBarPolicy(31);
        this.jLabel2.setBounds(new Rectangle(10, 70, 130, 20));
        this.jspField.setBounds(new Rectangle(10, 90, 130, 50));
        this.jspField.setHorizontalScrollBarPolicy(31);
        this.add((Component)this.jLabel1, null);
        this.add((Component)this.jLabel2, null);
        this.add((Component)this.jspLinkFields, null);
        this.add((Component)this.jspField, null);
        this.jlLinkFields.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent lse) {
                if (!lse.getValueIsAdjusting()) {
                    LinkedPropsPanel.this.fillFieldList();
                }
            }
        });
    }

    public String getInvalidReason() {
        return null;
    }

    public boolean validateData() {
        return true;
    }
}

