/*
 * Decompiled with CFR 0.152.
 */
package pilotdb.ui.tablemaker;

import java.util.LinkedList;
import pilotdb.PilotDBDatabase;
import pilotdb.PilotDBField;
import pilotdb.PilotDBSchema;

public class SchemaEditModel {
    PilotDBDatabase originalDatabase = null;
    String name = null;
    PilotDBSchema schema = null;
    PilotDBField[] originalPositions = null;

    public SchemaEditModel() {
        this.schema = new PilotDBSchema();
    }

    public SchemaEditModel(PilotDBDatabase db) {
        this.originalDatabase = db;
        this.name = db.getTitle();
        this.schema = (PilotDBSchema)db.getSchema().clone();
        this.originalPositions = new PilotDBField[this.schema.getFieldCount()];
        int i = 0;
        while (i < this.schema.getFieldCount()) {
            PilotDBField f;
            this.originalPositions[i] = f = this.schema.getField(i);
            ++i;
        }
    }

    public int getOriginalPosition(PilotDBField field) {
        int i = 0;
        while (i < this.originalPositions.length) {
            if (this.originalPositions[i] == field) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int indexOf(PilotDBField tf) {
        return this.schema.indexOfField(tf.getName());
    }

    public boolean isValidSchema() {
        return this.getValidationErrors().length == 0;
    }

    public String[] getValidationErrors() {
        LinkedList<String> errors = new LinkedList<String>();
        if (!this.validName(this.name)) {
            errors.add("Database - The database name must be 1 or more characters");
        }
        LinkedList<String> names = new LinkedList<String>();
        int noteCount = 0;
        if (this.schema.getFieldCount() == 0) {
            errors.add("Database - There must be at least one field defined");
        }
        int i = 0;
        while (i < this.schema.getFieldCount()) {
            PilotDBField f = this.schema.getField(i);
            if (!this.validName(f.getName())) {
                errors.add("Field " + (i + 1) + "[" + f.getName() + "] - Field names must be 1 or more characters");
            } else {
                if (names.contains(f.getName())) {
                    errors.add("Field " + (i + 1) + "[" + f.getName() + "] - Field name must be unique");
                }
                names.add(f.getName());
            }
            if (f.getType() == 5 && ++noteCount > 1) {
                errors.add("Field " + (i + 1) + " - Databases are limited to one note field");
            }
            if (f.getType() == 7 && (f.getLinkColumnNumber() == -1 || f.getLinkDbName() == null)) {
                errors.add("Field " + (i + 1) + "[" + f.getName() + "] - Link field is not configured");
            }
            if (f.getType() == 10) {
                if (f.getLinkedTableColumnIndex() == -1 || f.getLinkedLinkFieldIndex() == -1) {
                    errors.add("Field " + (i + 1) + "[" + f.getName() + "] - Linked fields must be configured");
                } else {
                    int linkedFieldIdx = f.getLinkedLinkFieldIndex();
                    PilotDBField linkField = this.getField(linkedFieldIdx);
                    if (linkField.getType() != 7) {
                        errors.add("Field " + (i + 1) + "[" + f.getName() + "] - Linked field is not configured properly");
                    }
                }
            }
            ++i;
        }
        return errors.toArray(new String[0]);
    }

    private boolean validName(String in) {
        if (in == null) {
            return false;
        }
        if (in.trim().length() == 0) {
            return false;
        }
        int i = 0;
        while (i < in.length()) {
            char c = in.charAt(i);
            if (!Character.isJavaIdentifierPart(c) && !Character.isSpaceChar(c)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public PilotDBField createDefaultField() {
        PilotDBField field = new PilotDBField();
        field.setName("field" + this.schema.getFieldCount());
        field.setType(2);
        this.schema.addField(field);
        return field;
    }

    public void deleteRow(int idx) {
        this.schema.removeField(idx);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String n) {
        this.name = n;
    }

    public int getFieldCount() {
        return this.schema.getFieldCount();
    }

    public void moveUp(int idx) {
        if (idx == 0) {
            return;
        }
        PilotDBField field = this.schema.removeField(idx);
        this.schema.addField(idx - 1, field);
    }

    public void moveDown(int idx) {
        if (idx == this.schema.getFieldCount() - 1) {
            return;
        }
        PilotDBField field = this.schema.removeField(idx);
        this.schema.addField(idx + 1, field);
    }

    public PilotDBField getTableField(int idx) {
        return this.schema.getField(idx);
    }

    public String getFieldName(int idx) {
        return this.getTableField(idx).getName();
    }

    public int getFieldType(int idx) {
        return this.getTableField(idx).getType();
    }

    public PilotDBField getField(int idx) {
        return this.schema.getField(idx);
    }

    public PilotDBField getFieldByName(String n) {
        return this.schema.getField(n);
    }

    public int getIndexOfFieldName(String string) {
        return this.schema.indexOfField(string);
    }

    public PilotDBField createDefaultField(int row) {
        PilotDBField field = new PilotDBField();
        field.setName("field" + this.schema.getFieldCount());
        field.setType(2);
        this.schema.addField(row, field);
        return field;
    }

    public PilotDBSchema getSchema() {
        return this.schema;
    }

    public PilotDBDatabase getOriginalDatabase() {
        return this.originalDatabase;
    }
}

