/*
 * Decompiled with CFR 0.152.
 */
package pilotdb.ui.tablemaker;

import javax.swing.table.AbstractTableModel;
import pilotdb.PilotDBField;
import pilotdb.ui.tablemaker.SchemaEditModel;

public class SchemaTableModel
extends AbstractTableModel {
    String[] COLUMN_NAMES = new String[]{"Field Name", "Field Type", "Valid"};
    SchemaEditModel model;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public void setModel(SchemaEditModel model) {
        this.model = model;
        this.fireTableDataChanged();
    }

    public SchemaEditModel getModel() {
        return this.model;
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex < 2;
    }

    public void deleteRow(int idx) {
        if (this.model == null) {
            return;
        }
        this.model.deleteRow(idx);
        this.fireTableRowsDeleted(idx, idx);
    }

    public int getColumnCount() {
        return this.COLUMN_NAMES.length;
    }

    public String getColumnName(int column) {
        return this.COLUMN_NAMES[column];
    }

    public void moveDown(int idx) {
        if (this.model == null) {
            return;
        }
        this.model.moveDown(idx);
        this.fireTableRowsUpdated(idx, idx + 1);
    }

    public void moveUp(int idx) {
        if (this.model == null) {
            return;
        }
        this.model.moveUp(idx);
        this.fireTableRowsUpdated(idx - 1, idx);
    }

    public Object getValueAt(int row, int col) {
        if (this.model == null) {
            return null;
        }
        PilotDBField vf = this.model.getTableField(row);
        switch (col) {
            case 0: {
                return vf.getName();
            }
            case 1: {
                return PilotDBField.FIELD_TYPE_NAMES[vf.getType()];
            }
            case 2: {
                return String.valueOf(vf.isValid());
            }
        }
        return null;
    }

    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        PilotDBField vf = this.model.getTableField(rowIndex);
        switch (columnIndex) {
            case 0: {
                vf.setName(aValue.toString());
                break;
            }
            case 1: {
                String typeName = aValue.toString();
                int i = 0;
                while (i < PilotDBField.FIELD_TYPE_NAMES.length) {
                    if (PilotDBField.FIELD_TYPE_NAMES[i].equals(typeName)) {
                        vf.setType(i);
                    }
                    ++i;
                }
                break;
            }
        }
        this.fireTableCellUpdated(rowIndex, columnIndex);
    }

    public int getRowCount() {
        if (this.model == null) {
            return 0;
        }
        return this.model.getFieldCount();
    }

    public Class getColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("java.lang.String");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return clazz;
            }
            case 1: {
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("java.lang.Integer");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return clazz;
            }
            case 2: {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("java.lang.String");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return clazz;
            }
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }

    public int createDefaultRow(int row) {
        if (this.model == null) {
            return -1;
        }
        PilotDBField tf = this.model.createDefaultField(row);
        row = this.model.indexOf(tf);
        this.fireTableRowsInserted(row, row);
        return row;
    }
}

