/*
 * Decompiled with CFR 0.152.
 */
package pilotdb.ui.util;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.net.URL;
import javax.swing.JDesktopPane;

public class BGJDesktopPane
extends JDesktopPane {
    BufferedImage bgImg = null;
    int iw;
    int ih;
    private String image;

    public void setImage(String newImage) {
        if (newImage == null || newImage.trim().length() == 0) {
            this.image = null;
            return;
        }
        try {
            this.image = newImage;
            URL u = this.getClass().getResource(this.image);
            if (u == null) {
                return;
            }
            Image img = Toolkit.getDefaultToolkit().getImage(u);
            MediaTracker mt = new MediaTracker(this);
            mt.addImage(img, 0);
            try {
                mt.waitForID(0);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.bgImg = new BufferedImage(img.getWidth(this), img.getHeight(this), 1);
            Graphics2D g2d = this.bgImg.createGraphics();
            g2d.drawImage(img, 0, 0, this.bgImg.getWidth(), this.bgImg.getHeight(), this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getImage() {
        return this.image;
    }

    public void paint(Graphics g) {
        super.paint(g);
        if (this.bgImg != null) {
            int width = this.bgImg.getWidth(this);
            int height = this.bgImg.getHeight(this);
            int thisWidth = (int)this.getSize().getWidth();
            int thisHeight = (int)this.getSize().getHeight();
            int timesHorizontal = (int)Math.ceil(thisWidth / width) + 1;
            int timesVertical = (int)Math.ceil(thisHeight / height) + 1;
            int w = 0;
            while (w < timesHorizontal) {
                int h = 0;
                while (h < timesVertical) {
                    g.drawImage(this.bgImg, w * width, h * height, this);
                    ++h;
                }
                ++w;
            }
        }
        this.paintChildren(g);
        this.paintBorder(g);
    }
}

