/*
 * Decompiled with CFR 0.152.
 */
package pilotdb.ui.util;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import javax.swing.JDialog;
import javax.swing.JProgressBar;
import pilotdb.tools.PluginMonitor;

public class JProgressPluginMonitor
extends JDialog
implements PluginMonitor {
    JProgressBar jpb = new JProgressBar();

    public JProgressPluginMonitor(Frame frame) {
        super(frame, "Progress");
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.jpb, "Center");
        this.jpb.setValue(0);
        this.jpb.setVisible(true);
        this.jpb.setOpaque(true);
        int height = 50;
        int width = 400;
        this.setSize(width, height);
        Dimension screenDimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((screenDimension.width - (width + 6)) / 2, (screenDimension.height - (height + 6)) / 2);
    }

    public void start() {
        this.setVisible(true);
    }

    public void setSteps(int totalSteps) {
        this.jpb.setValue(0);
        this.jpb.setMaximum(totalSteps);
    }

    public void setStep(int step) {
        this.jpb.setValue(step);
    }

    public void setStep(int step, String message) {
        this.jpb.setValue(step);
        this.jpb.setStringPainted(message != null);
        this.jpb.setString(message);
    }

    public void setMessage(String message) {
        this.jpb.setStringPainted(message != null);
        this.jpb.setString(message);
        this.jpb.repaint();
    }

    public void setError(String error) {
        this.jpb.setStringPainted(error != null);
        this.jpb.setString(error);
    }

    public void done() {
        this.setVisible(false);
        this.dispose();
    }
}

