/*
 * Decompiled with CFR 0.152.
 */
package pilotdb.ui.viewmaker;

import java.util.Vector;
import pilotdb.PilotDBSchema;
import pilotdb.PilotDBView;

public class DBViewMakerModel {
    private static final Vector DEFAULT_FIELDS = new Vector();
    String oldName = null;
    String name = "unknown";
    Vector viewFields = new Vector();

    static {
        DEFAULT_FIELDS.add("test1");
        DEFAULT_FIELDS.add("test2");
        DEFAULT_FIELDS.add("test3");
    }

    public String getOldName() {
        return this.oldName;
    }

    public void setOldName(String oldName) {
        this.oldName = oldName;
    }

    public DBViewMakerModel() {
        this(DEFAULT_FIELDS);
    }

    public DBViewMakerModel(Vector availableFieldNames) {
        int i = 0;
        while (i < availableFieldNames.size()) {
            String fieldname = availableFieldNames.get(i).toString();
            boolean visible = true;
            int width = 140;
            this.viewFields.add(new ViewField(fieldname, visible, width));
            ++i;
        }
    }

    public DBViewMakerModel(ViewField[] aViewFields) {
        int i = 0;
        while (i < aViewFields.length) {
            this.viewFields.add(aViewFields[i++]);
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String n) {
        this.name = n;
    }

    public int getFieldCount() {
        return this.viewFields.size();
    }

    public void moveUp(int idx) {
        if (idx == 0) {
            return;
        }
        Object obj = this.viewFields.remove(idx);
        this.viewFields.add(idx - 1, obj);
    }

    public void moveDown(int idx) {
        if (idx == this.viewFields.size() - 1) {
            return;
        }
        Object obj = this.viewFields.remove(idx);
        this.viewFields.add(idx + 1, obj);
    }

    public ViewField getViewField(int idx) {
        return (ViewField)this.viewFields.get(idx);
    }

    public ViewField getViewField(String fieldName) {
        int i = 0;
        while (i < this.viewFields.size()) {
            if (this.getViewField((int)i).n.equals(fieldName)) {
                return this.getViewField(i);
            }
            ++i;
        }
        return null;
    }

    public boolean isFieldVisible(int idx) {
        return this.getViewField((int)idx).v;
    }

    public int getFieldWidth(int idx) {
        return this.getViewField((int)idx).w;
    }

    public String getFieldName(int idx) {
        return this.getViewField((int)idx).n;
    }

    public void updateFrom(PilotDBView viewToEdit) {
        this.name = this.oldName = viewToEdit.getName();
        PilotDBSchema schema = viewToEdit.getDatabase().getSchema();
        int viewColumnCount = viewToEdit.getColumnCount();
        int i = 0;
        while (i < this.getFieldCount()) {
            this.getViewField((int)i).v = false;
            ++i;
        }
        i = 0;
        while (i < viewColumnCount) {
            int fieldIdxInSchema = viewToEdit.getColumn(i).getFieldNumber();
            String fieldName = schema.getField(fieldIdxInSchema).getName();
            ViewField vf = this.getViewField(fieldName);
            vf.w = viewToEdit.getColumn(i).getFieldWidth();
            vf.v = true;
            this.viewFields.remove(vf);
            this.viewFields.add(i, vf);
            ++i;
        }
    }

    public static class ViewField {
        String n;
        boolean v;
        int w;

        ViewField(String name, boolean visible, int width) {
            this.n = name;
            this.v = visible;
            this.w = width;
        }
    }
}

