/*
 * Decompiled with CFR 0.152.
 */
package pilotdb.util;

import java.util.LinkedList;

public class StringUtils {
    public static String[] breakStringApart(String in, char separator) {
        StringBuffer curString = new StringBuffer();
        LinkedList<String> strings = new LinkedList<String>();
        boolean inquotedstring = false;
        int i = 0;
        while (i < in.length()) {
            char c = in.charAt(i);
            if (c == separator) {
                if (inquotedstring) {
                    curString.append(c);
                } else {
                    if (curString.length() > 0) {
                        strings.add(curString.toString());
                    }
                    curString = new StringBuffer();
                }
            } else {
                switch (c) {
                    case '\t': {
                        if (!inquotedstring) break;
                        curString.append('\t');
                        break;
                    }
                    case '\"': {
                        if (inquotedstring) {
                            if (i + 1 < in.length()) {
                                char peekChar = in.charAt(i + 1);
                                if (peekChar == '\"') {
                                    curString.append('\"');
                                    ++i;
                                    break;
                                }
                                inquotedstring = false;
                                break;
                            }
                            inquotedstring = false;
                            break;
                        }
                        curString = new StringBuffer();
                        inquotedstring = true;
                        break;
                    }
                    default: {
                        curString.append(c);
                    }
                }
            }
            ++i;
        }
        if (curString.length() > 0) {
            strings.add(curString.toString());
        }
        return strings.toArray(new String[0]);
    }

    public static String[] breakStringApartExtended(String in, char separator) {
        StringBuffer curString = new StringBuffer();
        LinkedList<String> strings = new LinkedList<String>();
        boolean escaped = false;
        boolean inquotedstring = false;
        int i = 0;
        while (i < in.length()) {
            char c = in.charAt(i);
            if (c == separator) {
                if (inquotedstring || escaped) {
                    curString.append(c);
                } else {
                    strings.add(curString.toString());
                    curString = new StringBuffer();
                }
            } else {
                switch (c) {
                    case '\t': {
                        if (!inquotedstring) break;
                        curString.append('\t');
                        break;
                    }
                    case '\"': {
                        if (escaped) {
                            curString.append('\"');
                            escaped = false;
                            break;
                        }
                        if (inquotedstring) {
                            inquotedstring = false;
                            break;
                        }
                        inquotedstring = true;
                        break;
                    }
                    case '\\': {
                        if (escaped) {
                            curString.append('\\');
                            break;
                        }
                        escaped = true;
                        break;
                    }
                    default: {
                        if (escaped) {
                            switch (c) {
                                case 'n': {
                                    curString.append('\n');
                                }
                                case 't': {
                                    curString.append('\t');
                                }
                                case 'r': {
                                    curString.append('\r');
                                }
                            }
                            curString.append(c);
                            break;
                        }
                        curString.append(c);
                    }
                }
            }
            ++i;
        }
        if (curString.length() > 0) {
            strings.add(curString.toString());
        }
        return strings.toArray(new String[0]);
    }
}

