package jrdesktop.viewer;

import java.awt.GraphicsDevice;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.Hashtable;
import java.util.zip.Deflater;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;

import jrdesktop.AboutGUI;
import jrdesktop.SysTray;
import jrdesktop.main;

/**
 * ViewerGUI.java
 * @author  benbac
 */

public class ViewerGUI extends javax.swing.JFrame {
        
    private final byte COLOR_FULL = 0;
    private final byte COLOR_16_BIT = 1;
    private final byte COLOR_256 = 2;
    private final byte COLOR_GRAY = 3;
    //private final byte COLOR_2 = 4;    
    
    private boolean fullScreenMode = false;
    
    private Recorder recorder;
   
    /** Creates new form MainFrame */
    public ViewerGUI(Recorder recorder) {
        this.recorder = recorder;
        initComponents();
        jScrollPane1.setViewportView(recorder.screenPlayer);        
        setVisible(true);
    }  
  
    public void Start() {
        jBtnStartStopActionPerformed(null);               
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jPopupMenuFileTranfer = new javax.swing.JPopupMenu();
        jMenuItemSendFiles = new javax.swing.JMenuItem();
        jMenuItemReceiveFiles = new javax.swing.JMenuItem();
        jToolBar1 = new javax.swing.JToolBar();
        jBtnStartStop = new javax.swing.JButton();
        jToggleBtnPauseResume = new javax.swing.JToggleButton();
        jBtnViewCtrl = new javax.swing.JButton();
        jSeparator1 = new javax.swing.JToolBar.Separator();
        jBtnFullNormal = new javax.swing.JButton();
        jBtnPartialComplete = new javax.swing.JButton();
        jSeparator9 = new javax.swing.JToolBar.Separator();
        jLabel2 = new javax.swing.JLabel();
        jComboBoxSc = new javax.swing.JComboBox();
        jSeparator7 = new javax.swing.JToolBar.Separator();
        jLabel3 = new javax.swing.JLabel();
        jCheckBoxDC = new javax.swing.JCheckBox();
        jComboBoxCL = new javax.swing.JComboBox();
        jSeparator4 = new javax.swing.JToolBar.Separator();
        jLabel4 = new javax.swing.JLabel();
        jCheckBoxCQ = new javax.swing.JCheckBox();
        jSlider1 = new javax.swing.JSlider();
        jSeparator11 = new javax.swing.JToolBar.Separator();
        jLabel1 = new javax.swing.JLabel();
        jComboBoxColorQuality = new javax.swing.JComboBox();
        jSeparator5 = new javax.swing.JToolBar.Separator();
        jLabel5 = new javax.swing.JLabel();
        jCheckBoxClipTrans = new javax.swing.JCheckBox();
        jBtnFileTransfer = new javax.swing.JButton();
        jSeparator6 = new javax.swing.JToolBar.Separator();
        jBtnConnectionInfos = new javax.swing.JButton();
        jBtnServerProps = new javax.swing.JButton();
        jSeparator12 = new javax.swing.JToolBar.Separator();
        jBtnAbout = new javax.swing.JButton();
        jBtnClose = new javax.swing.JButton();
        jSeparator10 = new javax.swing.JToolBar.Separator();
        jScrollPane1 = new javax.swing.JScrollPane();

        jMenuItemSendFiles.setText("Send files");
        jMenuItemSendFiles.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuItemSendFilesActionPerformed(evt);
            }
        });
        jPopupMenuFileTranfer.add(jMenuItemSendFiles);

        jMenuItemReceiveFiles.setText("Receive files");
        jMenuItemReceiveFiles.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuItemReceiveFilesActionPerformed(evt);
            }
        });
        jPopupMenuFileTranfer.add(jMenuItemReceiveFiles);

        setDefaultCloseOperation(javax.swing.WindowConstants.DO_NOTHING_ON_CLOSE);
        setTitle(" jrdesktop Viewer");
        setIconImage(new ImageIcon(main.WAIT_ICON).getImage());
        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                formWindowClosing(evt);
            }
        });

        jToolBar1.setFloatable(false);
        jToolBar1.setAlignmentY(0.5F);
        jToolBar1.setMaximumSize(new java.awt.Dimension(713, 35));

        jBtnStartStop.setIcon(new javax.swing.ImageIcon(getClass().getResource("/jrdesktop/images/player_stop.png"))); // NOI18N
        jBtnStartStop.setToolTipText("Start/Stop recording");
        jBtnStartStop.setFocusable(false);
        jBtnStartStop.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        jBtnStartStop.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
        jBtnStartStop.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jBtnStartStopActionPerformed(evt);
            }
        });
        jToolBar1.add(jBtnStartStop);

        jToggleBtnPauseResume.setIcon(new javax.swing.ImageIcon(getClass().getResource("/jrdesktop/images/player_pause.png"))); // NOI18N
        jToggleBtnPauseResume.setToolTipText("Pause/Resume recording");
        jToggleBtnPauseResume.setFocusable(false);
        jToggleBtnPauseResume.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jToggleBtnPauseResumeActionPerformed(evt);
            }
        });
        jToolBar1.add(jToggleBtnPauseResume);

        jBtnViewCtrl.setIcon(new javax.swing.ImageIcon(getClass().getResource("/jrdesktop/images/locked_inputs.png"))); // NOI18N
        jBtnViewCtrl.setToolTipText("View only / Full control");
        jBtnViewCtrl.setFocusable(false);
        jBtnViewCtrl.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        jBtnViewCtrl.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
        jBtnViewCtrl.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jBtnViewCtrlActionPerformed(evt);
            }
        });
        jToolBar1.add(jBtnViewCtrl);
        jToolBar1.add(jSeparator1);

        jBtnFullNormal.setIcon(new javax.swing.ImageIcon(getClass().getResource("/jrdesktop/images/view_fullscreen.png"))); // NOI18N
        jBtnFullNormal.setToolTipText("Full / Normal screen");
        jBtnFullNormal.setFocusable(false);
        jBtnFullNormal.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        jBtnFullNormal.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
        jBtnFullNormal.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jBtnFullNormalActionPerformed(evt);
            }
        });
        jToolBar1.add(jBtnFullNormal);

        jBtnPartialComplete.setIcon(new javax.swing.ImageIcon(getClass().getResource("/jrdesktop/images/custom_screen.png"))); // NOI18N
        jBtnPartialComplete.setToolTipText("Custom / Default screen");
        jBtnPartialComplete.setFocusable(false);
        jBtnPartialComplete.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        jBtnPartialComplete.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
        jBtnPartialComplete.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jBtnPartialCompleteActionPerformed(evt);
            }
        });
        jToolBar1.add(jBtnPartialComplete);
        jToolBar1.add(jSeparator9);

        jLabel2.setIcon(new javax.swing.ImageIcon(getClass().getResource("/jrdesktop/images/scale.png"))); // NOI18N
        jLabel2.setText(" ");
        jLabel2.setToolTipText("Screen zoom ");
        jLabel2.setFocusable(false);
        jToolBar1.add(jLabel2);

        jComboBoxSc.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "25", "50", "75", "100", "125", "150", "200" }));
        jComboBoxSc.setSelectedIndex(3);
        jComboBoxSc.setToolTipText("Change screen zoom");
        jComboBoxSc.setFocusable(false);
        jComboBoxSc.setMaximumSize(new java.awt.Dimension(55, 20));
        jComboBoxSc.setMinimumSize(new java.awt.Dimension(55, 20));
        jComboBoxSc.setPreferredSize(new java.awt.Dimension(55, 20));
        jComboBoxSc.addItemListener(new java.awt.event.ItemListener() {
            public void itemStateChanged(java.awt.event.ItemEvent evt) {
                jComboBoxScItemStateChanged(evt);
            }
        });
        jToolBar1.add(jComboBoxSc);
        jToolBar1.add(jSeparator7);

        jLabel3.setIcon(new javax.swing.ImageIcon(getClass().getResource("/jrdesktop/images/compress.png"))); // NOI18N
        jLabel3.setToolTipText("Data compression");
        jLabel3.setFocusable(false);
        jToolBar1.add(jLabel3);

        jCheckBoxDC.setSelected(true);
        jCheckBoxDC.setToolTipText("Enable/Disable Data compression");
        jCheckBoxDC.setFocusable(false);
        jCheckBoxDC.setHorizontalAlignment(javax.swing.SwingConstants.TRAILING);
        jCheckBoxDC.setHorizontalTextPosition(javax.swing.SwingConstants.LEFT);
        jCheckBoxDC.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
        jCheckBoxDC.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jCheckBoxDCActionPerformed(evt);
            }
        });
        jToolBar1.add(jCheckBoxDC);

        jComboBoxCL.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "Best", "Default", "Fastest", "Store" }));
        jComboBoxCL.setSelectedIndex(1);
        jComboBoxCL.setToolTipText("Change compression level");
        jComboBoxCL.setFocusable(false);
        jComboBoxCL.setMaximumSize(new java.awt.Dimension(85, 20));
        jComboBoxCL.setMinimumSize(new java.awt.Dimension(85, 20));
        jComboBoxCL.setPreferredSize(new java.awt.Dimension(85, 20));
        jComboBoxCL.addItemListener(new java.awt.event.ItemListener() {
            public void itemStateChanged(java.awt.event.ItemEvent evt) {
                jComboBoxCLItemStateChanged(evt);
            }
        });
        jToolBar1.add(jComboBoxCL);
        jToolBar1.add(jSeparator4);

        jLabel4.setIcon(new javax.swing.ImageIcon(getClass().getResource("/jrdesktop/images/jpeg.png"))); // NOI18N
        jLabel4.setToolTipText("JPEG image quality");
        jLabel4.setFocusable(false);
        jToolBar1.add(jLabel4);

        jCheckBoxCQ.setToolTipText("Enable/Disable JPEG image quality");
        jCheckBoxCQ.setFocusable(false);
        jCheckBoxCQ.setHorizontalTextPosition(javax.swing.SwingConstants.LEFT);
        jCheckBoxCQ.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
        jCheckBoxCQ.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jCheckBoxCQActionPerformed(evt);
            }
        });
        jToolBar1.add(jCheckBoxCQ);

        jSlider1.setMajorTickSpacing(1);
        jSlider1.setMaximum(10);
        jSlider1.setMinorTickSpacing(1);
        jSlider1.setPaintTicks(true);
        jSlider1.setToolTipText("Change JPEG image quality");
        jSlider1.setValue(7);
        jSlider1.setEnabled(false);
        jSlider1.setFocusable(false);
        jSlider1.setMaximumSize(new java.awt.Dimension(100, 33));
        jSlider1.setMinimumSize(new java.awt.Dimension(100, 33));
        jSlider1.setPreferredSize(new java.awt.Dimension(100, 33));
        jSlider1.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                jSlider1StateChanged(evt);
            }
        });
        jToolBar1.add(jSlider1);
        jToolBar1.add(jSeparator11);

        jLabel1.setIcon(new javax.swing.ImageIcon(getClass().getResource("/jrdesktop/images/colors.png"))); // NOI18N
        jLabel1.setText(" ");
        jLabel1.setToolTipText("Color quality");
        jLabel1.setFocusable(false);
        jToolBar1.add(jLabel1);

        jComboBoxColorQuality.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "Full colors", "16 bit colors", "256 colors", "Gray color" }));
        jComboBoxColorQuality.setToolTipText("Change color quality");
        jComboBoxColorQuality.setFocusable(false);
        jComboBoxColorQuality.setLightWeightPopupEnabled(false);
        jComboBoxColorQuality.setMaximumSize(new java.awt.Dimension(105, 20));
        jComboBoxColorQuality.setMinimumSize(new java.awt.Dimension(105, 20));
        jComboBoxColorQuality.setPreferredSize(new java.awt.Dimension(105, 20));
        jComboBoxColorQuality.addItemListener(new java.awt.event.ItemListener() {
            public void itemStateChanged(java.awt.event.ItemEvent evt) {
                jComboBoxColorQualityItemStateChanged(evt);
            }
        });
        jToolBar1.add(jComboBoxColorQuality);
        jToolBar1.add(jSeparator5);

        jLabel5.setIcon(new javax.swing.ImageIcon(getClass().getResource("/jrdesktop/images/clip_trans.png"))); // NOI18N
        jLabel5.setToolTipText("Clipboard tranfer");
        jLabel5.setFocusable(false);
        jToolBar1.add(jLabel5);

        jCheckBoxClipTrans.setSelected(true);
        jCheckBoxClipTrans.setToolTipText("Enable/Disable Clipboard transfer");
        jCheckBoxClipTrans.setFocusable(false);
        jCheckBoxClipTrans.setHorizontalTextPosition(javax.swing.SwingConstants.LEFT);
        jCheckBoxClipTrans.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
        jCheckBoxClipTrans.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jCheckBoxClipTransActionPerformed(evt);
            }
        });
        jToolBar1.add(jCheckBoxClipTrans);

        jBtnFileTransfer.setIcon(new javax.swing.ImageIcon(getClass().getResource("/jrdesktop/images/file_trans.png"))); // NOI18N
        jBtnFileTransfer.setToolTipText("File transfer");
        jBtnFileTransfer.setFocusable(false);
        jBtnFileTransfer.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        jBtnFileTransfer.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
        jBtnFileTransfer.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jBtnFileTransferActionPerformed(evt);
            }
        });
        jToolBar1.add(jBtnFileTransfer);
        jToolBar1.add(jSeparator6);

        jBtnConnectionInfos.setIcon(new javax.swing.ImageIcon(getClass().getResource("/jrdesktop/images/info.png"))); // NOI18N
        jBtnConnectionInfos.setToolTipText("Connection infos");
        jBtnConnectionInfos.setFocusable(false);
        jBtnConnectionInfos.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        jBtnConnectionInfos.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
        jBtnConnectionInfos.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jBtnConnectionInfosActionPerformed(evt);
            }
        });
        jToolBar1.add(jBtnConnectionInfos);

        jBtnServerProps.setIcon(new javax.swing.ImageIcon(getClass().getResource("/jrdesktop/images/props.png"))); // NOI18N
        jBtnServerProps.setToolTipText("Server properties");
        jBtnServerProps.setFocusable(false);
        jBtnServerProps.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        jBtnServerProps.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
        jBtnServerProps.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jBtnServerPropsActionPerformed(evt);
            }
        });
        jToolBar1.add(jBtnServerProps);
        jToolBar1.add(jSeparator12);

        jBtnAbout.setIcon(new javax.swing.ImageIcon(getClass().getResource("/jrdesktop/images/about.png"))); // NOI18N
        jBtnAbout.setToolTipText("About jrdesktop");
        jBtnAbout.setFocusable(false);
        jBtnAbout.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        jBtnAbout.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
        jBtnAbout.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jBtnAboutActionPerformed(evt);
            }
        });
        jToolBar1.add(jBtnAbout);

        jBtnClose.setIcon(new javax.swing.ImageIcon(getClass().getResource("/jrdesktop/images/exit.png"))); // NOI18N
        jBtnClose.setToolTipText("Exit viewer");
        jBtnClose.setFocusable(false);
        jBtnClose.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        jBtnClose.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
        jBtnClose.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jBtnCloseActionPerformed(evt);
            }
        });
        jToolBar1.add(jBtnClose);
        jToolBar1.add(jSeparator10);

        jScrollPane1.setFocusable(false);

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(jToolBar1, javax.swing.GroupLayout.DEFAULT_SIZE, 892, Short.MAX_VALUE)
            .addComponent(jScrollPane1, javax.swing.GroupLayout.DEFAULT_SIZE, 892, Short.MAX_VALUE)
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addComponent(jToolBar1, javax.swing.GroupLayout.PREFERRED_SIZE, 25, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jScrollPane1, javax.swing.GroupLayout.DEFAULT_SIZE, 435, Short.MAX_VALUE))
        );

        java.awt.Dimension screenSize = java.awt.Toolkit.getDefaultToolkit().getScreenSize();
        setBounds((screenSize.width-900)/2, (screenSize.height-500)/2, 900, 500);
    }// </editor-fold>//GEN-END:initComponents

    private void jBtnStartStopActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jBtnStartStopActionPerformed
        if (recorder.isRecording())
            recorder.Stop();
        else
            recorder.Start();
        
        if (recorder.isRecording()) {                       
            setIconImage(new ImageIcon(main.ALIVE_ICON).getImage());
            jBtnStartStop.setIcon(new ImageIcon(main.STOP_ICON));
            setTitle("jrdesktop Viewer [" +Config.server_address + "]");
        } else {
            setTitle("jrdesktop Viewer");
            setIconImage(new ImageIcon(main.WAIT_ICON).getImage());
            jBtnStartStop.setIcon(new ImageIcon(main.START_ICON));
            jToggleBtnPauseResume.setSelected(false);
            jBtnViewCtrl.setIcon(new ImageIcon(main.LOCKED_INPUTS_ICON));
            jBtnFullNormal.setIcon(new ImageIcon(main.FULL_SCREEN_ICON));
            jBtnPartialComplete.setIcon(new ImageIcon(main.CUSTOM_SCREEN_ICON));                       
        }
    }//GEN-LAST:event_jBtnStartStopActionPerformed

    private void jBtnViewCtrlActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jBtnViewCtrlActionPerformed
        recorder.setViewOnly(!recorder.isViewOnly());
        if (recorder.isViewOnly())
            jBtnViewCtrl.setIcon(new ImageIcon(main.INPUTS_ICON));
        else        
            jBtnViewCtrl.setIcon(new ImageIcon(main.LOCKED_INPUTS_ICON));
    }//GEN-LAST:event_jBtnViewCtrlActionPerformed

    private void jBtnFullNormalActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jBtnFullNormalActionPerformed
        changeFullScreenMode();
    }//GEN-LAST:event_jBtnFullNormalActionPerformed

    private void jBtnPartialCompleteActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jBtnPartialCompleteActionPerformed
        if (recorder.isRecording()) {
            if (recorder.screenPlayer.isPartialScreenMode()) {
                jBtnPartialComplete.setIcon(new ImageIcon(main.CUSTOM_SCREEN_ICON));
                recorder.screenPlayer.stopSelectingMode();
            } else
                recorder.screenPlayer.startSelectingMode();
        }
    }//GEN-LAST:event_jBtnPartialCompleteActionPerformed

    private void jSlider1StateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_jSlider1StateChanged
        if (jSlider1.getValueIsAdjusting()) {
            recorder.viewerData.setImageQuality((float)jSlider1.getValue() / 10.0f); 
            if (recorder.isRecording()) recorder.viewer.updateOptions();
        }
    }//GEN-LAST:event_jSlider1StateChanged

    private void jCheckBoxCQActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jCheckBoxCQActionPerformed
        jSlider1.setEnabled(jCheckBoxCQ.isSelected());
        if (!jCheckBoxCQ.isSelected())
            recorder.viewerData.setImageQuality(-1);
        else
           recorder.viewerData.setImageQuality((float)jSlider1.getValue() / 10.0f); 
        if (recorder.isRecording()) recorder.viewer.updateOptions();
}//GEN-LAST:event_jCheckBoxCQActionPerformed

    private void jBtnAboutActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jBtnAboutActionPerformed
        AboutGUI.main(null);
}//GEN-LAST:event_jBtnAboutActionPerformed

    private void jComboBoxColorQualityItemStateChanged(java.awt.event.ItemEvent evt) {//GEN-FIRST:event_jComboBoxColorQualityItemStateChanged
        setColorQuality(jComboBoxColorQuality.getSelectedIndex());
}//GEN-LAST:event_jComboBoxColorQualityItemStateChanged

    private void formWindowClosing(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_formWindowClosing
        if (evt.getID() == WindowEvent.WINDOW_CLOSING)
            jBtnCloseActionPerformed(null);        
        else
            super.processWindowEvent(evt);
    }//GEN-LAST:event_formWindowClosing

    private void jCheckBoxDCActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jCheckBoxDCActionPerformed
        jComboBoxCL.setEnabled(jCheckBoxDC.isSelected());
        recorder.viewerData.setDataCompression(jCheckBoxDC.isSelected());
        if (recorder.isRecording()) recorder.viewer.updateOptions();
}//GEN-LAST:event_jCheckBoxDCActionPerformed

    private void jComboBoxScItemStateChanged(java.awt.event.ItemEvent evt) {//GEN-FIRST:event_jComboBoxScItemStateChanged
        recorder.viewerData.setScreenScale(
                Float.valueOf(jComboBoxSc.getSelectedItem().toString()) / 100.0f);
        if (recorder.isRecording()) recorder.viewer.updateOptions();
}//GEN-LAST:event_jComboBoxScItemStateChanged

    private void jComboBoxCLItemStateChanged(java.awt.event.ItemEvent evt) {//GEN-FIRST:event_jComboBoxCLItemStateChanged
        setCompressionLevel(jComboBoxCL.getSelectedIndex());
    }//GEN-LAST:event_jComboBoxCLItemStateChanged

    private void jCheckBoxClipTransActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jCheckBoxClipTransActionPerformed
        setClipboardTransfer(jCheckBoxClipTrans.isSelected());
    }//GEN-LAST:event_jCheckBoxClipTransActionPerformed

    private void jBtnFileTransferActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jBtnFileTransferActionPerformed
        jPopupMenuFileTranfer.show(jBtnFileTransfer, 15, 15);
}//GEN-LAST:event_jBtnFileTransferActionPerformed

    private void jMenuItemSendFilesActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItemSendFilesActionPerformed
        if (!recorder.isRecording()) return;
        File[] files = recorder.clipbrdUtility.getFiles(); 
        if (files.length == 0) { // no files in clipboard, return
            JOptionPane.showMessageDialog(ViewerGUI.this, 
                            "No file in clipboard !!", 
                            "Information", JOptionPane.INFORMATION_MESSAGE);            
            return;
        }    
        recorder.fileManager.setFiles(files);
        recorder.viewer.AddObject(new File("."));
    }//GEN-LAST:event_jMenuItemSendFilesActionPerformed

    private void jMenuItemReceiveFilesActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItemReceiveFilesActionPerformed
        if (!recorder.isRecording()) return;     
        recorder.viewer.AddObject(new File("..")); 
    }//GEN-LAST:event_jMenuItemReceiveFilesActionPerformed

    private void jBtnServerPropsActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jBtnServerPropsActionPerformed
        if (!recorder.isRecording()) return;     
        recorder.viewer.AddObject(new Hashtable(0));      
}//GEN-LAST:event_jBtnServerPropsActionPerformed

    private void jBtnConnectionInfosActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jBtnConnectionInfosActionPerformed
        if (!recorder.isRecording()) return;
        recorder.connectionInfos.display();
}//GEN-LAST:event_jBtnConnectionInfosActionPerformed

private void jToggleBtnPauseResumeActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jToggleBtnPauseResumeActionPerformed
        if (recorder.isRecording()) {
            recorder.setPause(!recorder.isPaused());
            if (recorder.isPaused())
                jToggleBtnPauseResume.setSelected(true);
            else
                jToggleBtnPauseResume.setSelected(false);
        }
}//GEN-LAST:event_jToggleBtnPauseResumeActionPerformed

private void jBtnCloseActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jBtnCloseActionPerformed
    if (JOptionPane.showConfirmDialog(null, "Exit Viewer ?", "Confirm Dialog", 
            JOptionPane.OK_CANCEL_OPTION) == JOptionPane.OK_OPTION) {
          if (recorder.isRecording())                    
              recorder.viewer.Stop();
              if (SysTray.isSupported()) 
                  dispose();
              else
                  main.exit();
     }
}//GEN-LAST:event_jBtnCloseActionPerformed
        
    public boolean isFullScreenMode () {
        return fullScreenMode;
    }
    
    public void changeFullScreenMode() {        
        GraphicsDevice device = getGraphicsConfiguration().getDevice();
        if (!device.isFullScreenSupported()) return;
        
        fullScreenMode = !fullScreenMode;
        
        if (fullScreenMode) {  // Full screen mode
                dispose();
                setUndecorated(true);
                device.setFullScreenWindow(this);
                setVisible(true);
                jBtnFullNormal.setIcon(new ImageIcon(main.NORMAL_SCREEN_ICON));
        }
        else {     // Normal screen mode
                dispose();
                setUndecorated(false);
                device.setFullScreenWindow(null);
                setVisible(true);
                jBtnFullNormal.setIcon(new ImageIcon(main.FULL_SCREEN_ICON));
        }  
    }        

    public void setColorQuality(int colorQuality) {
        switch (colorQuality) {
            case COLOR_FULL: colorQuality = BufferedImage.TYPE_INT_ARGB; break;
            case COLOR_16_BIT: colorQuality = BufferedImage.TYPE_USHORT_555_RGB; break;
            case COLOR_256: colorQuality = BufferedImage.TYPE_BYTE_INDEXED; break;
            case COLOR_GRAY: colorQuality = BufferedImage.TYPE_BYTE_GRAY; break;
            //case COLOR_2: colorQuality = BufferedImage.TYPE_BYTE_BINARY; break;
        }
        recorder.viewerData.setColorQuality(colorQuality);
        if (recorder.isRecording()) recorder.viewer.updateOptions();                
    }
        
    public void setCompressionLevel(int index) {
        int level = Deflater.DEFAULT_COMPRESSION;                
        switch(index) {
            case 0: level = Deflater.BEST_COMPRESSION; break;
            case 1: level = Deflater.DEFAULT_COMPRESSION; break;            
            case 2: level = Deflater.BEST_SPEED; break;
           /* case 3: level = Deflater.DEFAULT_STRATEGY; break;
            case 4: level = Deflater.DEFLATED; break;
            case 5: level = Deflater.FILTERED; break;
            case 6: level = Deflater.HUFFMAN_ONLY; break;*/
            case 3: level = Deflater.NO_COMPRESSION; break;    
        }
        recorder.viewerData.setCompressionLevel(level);
        if (recorder.isRecording()) recorder.viewer.updateOptions();        
    }
    
    public void setClipboardTransfer(boolean bool) {
         recorder.viewerData.setClipboardTransfer(bool);
        if (bool)
            recorder.clipbrdUtility.addFlavorListener();
        else
            recorder.clipbrdUtility.removeFlavorListener();
        if (recorder.isRecording()) recorder.viewer.updateOptions();       
    }
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton jBtnAbout;
    private javax.swing.JButton jBtnClose;
    private javax.swing.JButton jBtnConnectionInfos;
    private javax.swing.JButton jBtnFileTransfer;
    private javax.swing.JButton jBtnFullNormal;
    public javax.swing.JButton jBtnPartialComplete;
    private javax.swing.JButton jBtnServerProps;
    private javax.swing.JButton jBtnStartStop;
    private javax.swing.JButton jBtnViewCtrl;
    private javax.swing.JCheckBox jCheckBoxCQ;
    private javax.swing.JCheckBox jCheckBoxClipTrans;
    private javax.swing.JCheckBox jCheckBoxDC;
    private javax.swing.JComboBox jComboBoxCL;
    private javax.swing.JComboBox jComboBoxColorQuality;
    private javax.swing.JComboBox jComboBoxSc;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JLabel jLabel4;
    private javax.swing.JLabel jLabel5;
    private javax.swing.JMenuItem jMenuItemReceiveFiles;
    private javax.swing.JMenuItem jMenuItemSendFiles;
    private javax.swing.JPopupMenu jPopupMenuFileTranfer;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JToolBar.Separator jSeparator1;
    private javax.swing.JToolBar.Separator jSeparator10;
    private javax.swing.JToolBar.Separator jSeparator11;
    private javax.swing.JToolBar.Separator jSeparator12;
    private javax.swing.JToolBar.Separator jSeparator4;
    private javax.swing.JToolBar.Separator jSeparator5;
    private javax.swing.JToolBar.Separator jSeparator6;
    private javax.swing.JToolBar.Separator jSeparator7;
    private javax.swing.JToolBar.Separator jSeparator9;
    private javax.swing.JSlider jSlider1;
    private javax.swing.JToggleButton jToggleBtnPauseResume;
    private javax.swing.JToolBar jToolBar1;
    // End of variables declaration//GEN-END:variables
    
}
