/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.cmd;

import java.io.IOException;
import org.jrobin.cmd.ColonSplitter;
import org.jrobin.cmd.RrdToolCmd;
import org.jrobin.core.RrdDb;
import org.jrobin.core.RrdException;
import org.jrobin.core.Sample;
import org.jrobin.core.Util;

class RrdUpdateCmd
extends RrdToolCmd {
    RrdUpdateCmd() {
    }

    String getCmdType() {
        return "update";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object execute() throws RrdException, IOException {
        String template = this.getOptionValue("t", "template");
        String[] dsNames = template != null ? new ColonSplitter(template).split() : null;
        String[] words = this.getRemainingWords();
        if (words.length < 3) {
            throw new RrdException("Insufficent number of parameters for rrdupdate command");
        }
        String path = words[1];
        RrdDb rrdDb = RrdUpdateCmd.getRrdDbReference(path);
        try {
            if (dsNames != null) {
                for (String dsName : dsNames) {
                    if (rrdDb.containsDs(dsName)) continue;
                    throw new RrdException("Invalid datasource name: " + dsName);
                }
            }
            long timestamp = -1L;
            for (int i = 2; i < words.length; ++i) {
                String[] tokens = new ColonSplitter(words[i]).split();
                if (dsNames != null && dsNames.length + 1 != tokens.length) {
                    throw new RrdException("Template requires " + dsNames.length + " values, " + (tokens.length - 1) + " value(s) found in: " + words[i]);
                }
                int dsCount = rrdDb.getHeader().getDsCount();
                if (dsNames == null && dsCount + 1 != tokens.length) {
                    throw new RrdException("Expected " + dsCount + " values, " + (tokens.length - 1) + " value(s) found in: " + words[i]);
                }
                timestamp = Util.getTimestamp(tokens[0]);
                Sample sample = rrdDb.createSample(timestamp);
                for (int j = 1; j < tokens.length; ++j) {
                    if (dsNames == null) {
                        sample.setValue(j - 1, RrdUpdateCmd.parseDouble(tokens[j]));
                        continue;
                    }
                    sample.setValue(dsNames[j - 1], RrdUpdateCmd.parseDouble(tokens[j]));
                }
                sample.update();
            }
            Long l = timestamp;
            return l;
        }
        finally {
            RrdUpdateCmd.releaseRrdDbReference(rrdDb);
        }
    }
}

