/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.graph;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Image;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Vector;
import org.jrobin.graph.DirectGif89Frame;
import org.jrobin.graph.Gif89Frame;
import org.jrobin.graph.GifColorTable;
import org.jrobin.graph.IndexGif89Frame;
import org.jrobin.graph.Put;

class GifEncoder {
    private Dimension dispDim = new Dimension(0, 0);
    private GifColorTable colorTable;
    private int bgIndex = 0;
    private int loopCount = 1;
    private String theComments;
    private Vector<Gif89Frame> vFrames = new Vector();

    GifEncoder() {
        this.colorTable = new GifColorTable();
    }

    GifEncoder(Image static_image) throws IOException {
        this();
        this.addFrame(static_image);
    }

    GifEncoder(Color[] colors) {
        this.colorTable = new GifColorTable(colors);
    }

    GifEncoder(Color[] colors, int width, int height, byte[] ci_pixels) throws IOException {
        this(colors);
        this.addFrame(width, height, ci_pixels);
    }

    int getFrameCount() {
        return this.vFrames.size();
    }

    Gif89Frame getFrameAt(int index) {
        return this.isOk(index) ? this.vFrames.elementAt(index) : null;
    }

    void addFrame(Gif89Frame gf) throws IOException {
        this.accommodateFrame(gf);
        this.vFrames.addElement(gf);
    }

    void addFrame(Image image) throws IOException {
        this.addFrame(new DirectGif89Frame(image));
    }

    void addFrame(int width, int height, byte[] ci_pixels) throws IOException {
        this.addFrame(new IndexGif89Frame(width, height, ci_pixels));
    }

    void insertFrame(int index, Gif89Frame gf) throws IOException {
        this.accommodateFrame(gf);
        this.vFrames.insertElementAt(gf, index);
    }

    void setTransparentIndex(int index) {
        this.colorTable.setTransparent(index);
    }

    void setLogicalDisplay(Dimension dim, int background) {
        this.dispDim = new Dimension(dim);
        this.bgIndex = background;
    }

    void setLoopCount(int count) {
        this.loopCount = count;
    }

    void setComments(String comments) {
        this.theComments = comments;
    }

    void setUniformDelay(int interval) {
        for (int i = 0; i < this.vFrames.size(); ++i) {
            this.vFrames.elementAt(i).setDelay(interval);
        }
    }

    void encode(OutputStream out) throws IOException {
        int nframes = this.getFrameCount();
        boolean is_sequence = nframes > 1;
        this.colorTable.closePixelProcessing();
        Put.ascii("GIF89a", out);
        this.writeLogicalScreenDescriptor(out);
        this.colorTable.encode(out);
        if (is_sequence && this.loopCount != 1) {
            this.writeNetscapeExtension(out);
        }
        if (this.theComments != null && this.theComments.length() > 0) {
            this.writeCommentExtension(out);
        }
        for (int i = 0; i < nframes; ++i) {
            this.vFrames.elementAt(i).encode(out, is_sequence, this.colorTable.getDepth(), this.colorTable.getTransparent());
        }
        out.write(59);
        out.flush();
    }

    private void accommodateFrame(Gif89Frame gf) throws IOException {
        this.dispDim.width = Math.max(this.dispDim.width, gf.getWidth());
        this.dispDim.height = Math.max(this.dispDim.height, gf.getHeight());
        this.colorTable.processPixels(gf);
    }

    private void writeLogicalScreenDescriptor(OutputStream os) throws IOException {
        Put.leShort(this.dispDim.width, os);
        Put.leShort(this.dispDim.height, os);
        os.write(0xF0 | this.colorTable.getDepth() - 1);
        os.write(this.bgIndex);
        os.write(0);
    }

    private void writeNetscapeExtension(OutputStream os) throws IOException {
        os.write(33);
        os.write(255);
        os.write(11);
        Put.ascii("NETSCAPE2.0", os);
        os.write(3);
        os.write(1);
        Put.leShort(this.loopCount > 1 ? this.loopCount - 1 : 0, os);
        os.write(0);
    }

    private void writeCommentExtension(OutputStream os) throws IOException {
        os.write(33);
        os.write(254);
        int remainder = this.theComments.length() % 255;
        int nsubblocks_full = this.theComments.length() / 255;
        int nsubblocks = nsubblocks_full + (remainder > 0 ? 1 : 0);
        int ibyte = 0;
        for (int isb = 0; isb < nsubblocks; ++isb) {
            int size = isb < nsubblocks_full ? 255 : remainder;
            os.write(size);
            Put.ascii(this.theComments.substring(ibyte, ibyte + size), os);
            ibyte += size;
        }
        os.write(0);
    }

    private boolean isOk(int frame_index) {
        return frame_index >= 0 && frame_index < this.vFrames.size();
    }
}

