/*
 * Decompiled with CFR 0.152.
 */
package net.phbwt.jtans;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Iterator;
import java.util.Observable;
import java.util.Observer;
import java.util.ResourceBundle;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import net.phbwt.jtans.guicommon.Config;
import net.phbwt.jtans.guiconfig.ConfigWindow;
import net.phbwt.jtans.guiinfo.InfoWindowController;
import net.phbwt.jtans.guimain.MainWindow;

public abstract class AbstractApplication
implements Observer {
    protected ConfigWindow configWindow;
    protected MainWindow mainWindow;
    protected InfoWindowController infoWindow;
    protected Config config;
    protected static ResourceBundle i18n = null;

    protected AbstractApplication() {
        if (i18n == null) {
            i18n = ResourceBundle.getBundle("net.phbwt.jtans.i18n.main");
        }
    }

    protected void start() {
        this.config = this.retrieveConfig();
        this.mainWindow = new MainWindow(this.config);
        this.configWindow = new ConfigWindow(this.config);
        this.infoWindow = new InfoWindowController();
        JFrame jFrame = new JFrame("jTans");
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                AbstractApplication.this.quit();
            }
        });
        this.mainWindow.fill(jFrame);
        JMenu jMenu = new JMenu(i18n.getString("menu.game"));
        jMenu.add(i18n.getString("menu.game.configure")).addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbstractApplication.this.configWindow.show();
            }
        });
        jMenu.add(i18n.getString("menu.game.quit")).addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbstractApplication.this.quit();
            }
        });
        JMenuBar jMenuBar = new JMenuBar();
        jMenuBar.add(jMenu);
        Iterator iterator = this.mainWindow.getMenus().iterator();
        while (iterator.hasNext()) {
            jMenuBar.add((JMenu)iterator.next());
        }
        this.mainWindow.addObserver(this);
        jFrame.setJMenuBar(jMenuBar);
        jFrame.pack();
        jFrame.setSize(jFrame.getPreferredSize());
        jFrame.show();
    }

    private void quit() {
        this.configWindow.abort();
        this.saveConfig(this.config);
        System.exit(0);
    }

    public void update(Observable observable, Object object) {
        if ("jtans.help".equals(object)) {
            this.infoWindow.showHelpWindow();
        } else if ("jtans.about".equals(object)) {
            this.infoWindow.showAboutWindow();
        }
    }

    protected abstract Config retrieveConfig();

    protected abstract void saveConfig(Config var1);
}

