/*
 * Decompiled with CFR 0.152.
 */
package net.phbwt.jtans.guiconfig;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Stroke;
import javax.swing.JLabel;
import net.phbwt.jtans.guicommon.Trait;

final class TraitExampleComponent
extends JLabel {
    private static Dimension preferredSize = new Dimension(30, 15);
    private static Dimension maxSize = new Dimension(500000, 200);
    private Trait trait;

    TraitExampleComponent(Trait trait) {
        this.setOpaque(true);
        this.trait = trait;
        this.setMinimumSize(preferredSize);
        this.setPreferredSize(preferredSize);
        this.setMaximumSize(maxSize);
    }

    protected void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Stroke stroke = graphics2D.getStroke();
        Insets insets = this.getInsets();
        graphics2D.setPaint(this.getBackground());
        graphics2D.fillRect(insets.left, insets.top, this.getWidth() - insets.right, this.getHeight() - insets.bottom);
        graphics2D.setPaint(this.trait.getColor());
        graphics2D.setStroke(this.trait.getStroke());
        int n = insets.top + (this.getHeight() - insets.top - insets.bottom) / 2;
        graphics2D.drawLine(insets.left, n, this.getWidth() - insets.right, n);
        graphics2D.setStroke(stroke);
    }
}

