/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400GenAuthTknDS;
import com.ibm.as400.access.AS400GenAuthTknReplyDS;
import com.ibm.as400.access.AS400Impl;
import com.ibm.as400.access.AS400ImplNative;
import com.ibm.as400.access.AS400Message;
import com.ibm.as400.access.AS400NoThreadServer;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.AS400Server;
import com.ibm.as400.access.AS400StrSvrDS;
import com.ibm.as400.access.AS400StrSvrReplyDS;
import com.ibm.as400.access.AS400Text;
import com.ibm.as400.access.AS400ThreadedServer;
import com.ibm.as400.access.AS400XChgRandSeedDS;
import com.ibm.as400.access.AS400XChgRandSeedReplyDS;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.ChangePasswordRep;
import com.ibm.as400.access.ChangePasswordReq;
import com.ibm.as400.access.ClassDecoupler;
import com.ibm.as400.access.ConnectionEvent;
import com.ibm.as400.access.ConnectionListener;
import com.ibm.as400.access.ConversionMaps;
import com.ibm.as400.access.ConverterImplRemote;
import com.ibm.as400.access.CurrentUser;
import com.ibm.as400.access.DataStream;
import com.ibm.as400.access.ExecutionEnvironment;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.NLSImpl;
import com.ibm.as400.access.NativeException;
import com.ibm.as400.access.PortMapper;
import com.ibm.as400.access.SSLOptions;
import com.ibm.as400.access.ServerStartupException;
import com.ibm.as400.access.ServerVersion;
import com.ibm.as400.access.SignonConverter;
import com.ibm.as400.access.SignonEndServerReq;
import com.ibm.as400.access.SignonExchangeAttributeRep;
import com.ibm.as400.access.SignonExchangeAttributeReq;
import com.ibm.as400.access.SignonGenAuthTokenReplyDS;
import com.ibm.as400.access.SignonGenAuthTokenRequestDS;
import com.ibm.as400.access.SignonInfo;
import com.ibm.as400.access.SignonInfoRep;
import com.ibm.as400.access.SignonInfoReq;
import com.ibm.as400.access.SocketContainer;
import com.ibm.as400.access.SocketProperties;
import com.ibm.as400.access.TokenManager;
import com.ibm.as400.access.TokenManager2;
import com.ibm.as400.access.Trace;
import com.ibm.as400.security.auth.ProfileTokenCredential;
import java.beans.PropertyVetoException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.Socket;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.GregorianCalendar;
import java.util.Vector;

class AS400ImplRemote
implements AS400Impl {
    private static final boolean PASSWORD_TRACE = false;
    private Vector[] serverPool_ = new Vector[]{new Vector(), new Vector(), new Vector(), new Vector(), new Vector(), new Vector(), new Vector()};
    private String systemName_ = "";
    private String userId_ = "";
    private boolean systemNameLocal_ = false;
    private byte[] bytes_ = null;
    private int byteType_ = 0;
    private Object gssCredential_ = null;
    private String gssName_ = "";
    int gssOption_;
    private byte[] adder_ = null;
    private byte[] mask_ = null;
    private SSLOptions useSSLConnection_ = null;
    private boolean canUseNativeOptimization_ = true;
    private boolean threadUsed_ = true;
    private int ccsid_ = 0;
    private boolean userOverrideCcsid_ = false;
    private String clientNlv_;
    private String secondaryLangLib_;
    private boolean isSkipFurtherSettingOfSecondaryLangLib_ = false;
    private SocketProperties socketProperties_ = null;
    private String ddmRDB_;
    private ServerVersion version_;
    private int serverLevel_;
    private boolean passwordType_ = false;
    private boolean isPasswordTypeSet_ = false;
    private SignonInfo signonInfo_;
    private byte[] signonJobBytes_;
    private String signonJobString_;
    private ConnectionListener dispatcher_;
    private byte[] proxySeed_ = null;
    private byte[] remoteSeed_ = null;
    AS400NoThreadServer signonServer_;
    byte[] serverSeed_;
    byte[] clientSeed_;
    private static final String CLASSNAME = "com.ibm.as400.access.AS400ImplRemote";
    private boolean mustUseNetSockets_ = false;
    private boolean mustUseSuppliedProfile_ = false;
    private static final int[] EPERM;
    private static final int[] INITPERM;
    private static final int[] OUTPERM;
    private static final int[] PPERM;
    private static final int[] PC1;
    private static final int[] PC2;
    private static final int[] S1;
    private static final int[] S2;
    private static final int[] S3;
    private static final int[] S4;
    private static final int[] S5;
    private static final int[] S6;
    private static final int[] S7;
    private static final int[] S8;

    AS400ImplRemote() {
    }

    public void addConnectionListener(ConnectionListener connectionListener) {
        if (Trace.traceOn_) {
            Trace.log(1, "Adding implementation connection listener.");
        }
        this.dispatcher_ = connectionListener;
    }

    public String ccsidToEncoding(int n) {
        if (Trace.traceOn_) {
            Trace.log(1, "Mapping to encoding implementation, CCSID:", n);
        }
        return ConversionMaps.ccsidToEncoding(n);
    }

    private static char[] trimUnicodeSpace(char[] cArray) {
        char c = cArray[cArray.length - 1];
        if (c != '\u0000' && c != ' ' && c != '\u3000') {
            return cArray;
        }
        int n = cArray.length - 1;
        while (cArray[n] == '\u0000' || cArray[n] == ' ' || cArray[n] == '\u3000') {
            --n;
        }
        char[] cArray2 = new char[n + 1];
        System.arraycopy(cArray, 0, cArray2, 0, cArray2.length);
        return cArray2;
    }

    private static byte[] generateShaToken(byte[] byArray, byte[] byArray2) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA");
            messageDigest.update(byArray);
            messageDigest.update(byArray2);
            byte[] byArray3 = messageDigest.digest();
            return byArray3;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            Trace.log(2, "Error getting instance of SHA-1 algorithm:", (Throwable)noSuchAlgorithmException);
            throw new InternalErrorException(10);
        }
    }

    private static byte[] generateShaSubstitute(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4, byte[] byArray5) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA");
            messageDigest.update(byArray);
            messageDigest.update(byArray2);
            messageDigest.update(byArray3);
            messageDigest.update(byArray4);
            messageDigest.update(byArray5);
            byte[] byArray6 = messageDigest.digest();
            return byArray6;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            Trace.log(2, "Error getting instance of SHA-1 algorithm:", (Throwable)noSuchAlgorithmException);
            throw new InternalErrorException(10);
        }
    }

    private static byte[] generateShaProtected(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4, byte[] byArray5, byte[] byArray6) {
        int n = ((byArray.length - 1) / 20 + 1) * 20;
        byte[] byArray7 = new byte[n];
        for (int i = 0; i < n; i += 20) {
            AS400ImplRemote.incrementString(byArray6);
            byte[] byArray8 = AS400ImplRemote.generateShaSubstitute(byArray2, byArray3, byArray4, byArray5, byArray6);
            for (int j = 0; j < 20; ++j) {
                byArray7[i + j] = i + j < byArray.length ? (byte)(byArray8[j] ^ byArray[i + j]) : byArray8[j];
            }
        }
        return byArray7;
    }

    public SignonInfo changePassword(String string, boolean bl, String string2, byte[] byArray, byte[] byArray2) throws AS400SecurityException, IOException {
        if (Trace.traceOn_) {
            Trace.log(1, "Change password implementation, system name: '" + string + "' user ID: '" + string2 + "'");
        }
        this.systemName_ = string;
        this.systemNameLocal_ = bl;
        this.userId_ = string2;
        char[] cArray = BinaryConverter.byteArrayToCharArray(AS400ImplRemote.decode(this.proxySeed_, this.remoteSeed_, byArray));
        char[] cArray2 = BinaryConverter.byteArrayToCharArray(AS400ImplRemote.decode(this.proxySeed_, this.remoteSeed_, byArray2));
        this.proxySeed_ = null;
        this.remoteSeed_ = null;
        boolean bl2 = this.signonServer_ == null;
        this.signonConnect();
        try {
            Object object;
            byte[] byArray3;
            byte[] byArray4;
            byte[] byArray5;
            byte[] byArray6;
            Object object2;
            Object object3;
            byte[] byArray7 = SignonConverter.stringToByteArray(string2);
            if (!this.passwordType_) {
                if (cArray.length > 10) {
                    Trace.log(2, "Length of parameter 'oldPassword' is not valid:", cArray.length);
                    throw new AS400SecurityException(10);
                }
                object3 = SignonConverter.stringToByteArray(new String(cArray).toUpperCase());
                if (cArray2.length > 10) {
                    Trace.log(2, "Length of parameter 'newPassword' is not valid:", cArray2.length);
                    throw new AS400SecurityException(16);
                }
                object2 = SignonConverter.stringToByteArray(new String(cArray2).toUpperCase());
                byArray6 = object3[8] == 64 && object3[9] == 64 ? new byte[8] : new byte[16];
                byArray5 = object2[8] == 64 && object2[9] == 64 ? new byte[8] : new byte[16];
                byArray4 = AS400ImplRemote.encryptNewPassword(byArray7, object3, (byte[])object2, byArray6, byArray5, this.clientSeed_, this.serverSeed_);
            } else {
                object3 = BinaryConverter.charArrayToByteArray(SignonConverter.byteArrayToCharArray(byArray7));
                if (cArray[0] == '*') {
                    Trace.log(2, "Parameter 'oldPassword' begins with a '*' character.");
                    throw new AS400SecurityException(63);
                }
                if (cArray2[0] == '*') {
                    Trace.log(2, "Parameter 'newPassword' begins with a '*' character.");
                    throw new AS400SecurityException(63);
                }
                object2 = BinaryConverter.charArrayToByteArray(AS400ImplRemote.trimUnicodeSpace(cArray));
                byte[] byArray8 = BinaryConverter.charArrayToByteArray(AS400ImplRemote.trimUnicodeSpace(cArray2));
                byArray3 = new byte[]{0, 0, 0, 0, 0, 0, 0, 1};
                object = AS400ImplRemote.generateShaToken(object3, (byte[])object2);
                byArray4 = AS400ImplRemote.generateShaSubstitute(object, this.serverSeed_, this.clientSeed_, object3, byArray3);
                byArray5 = AS400ImplRemote.generateShaProtected(byArray8, object, this.serverSeed_, this.clientSeed_, object3, byArray3);
                byte[] byArray9 = AS400ImplRemote.generateShaToken(object3, byArray8);
                byArray6 = AS400ImplRemote.generateShaProtected((byte[])object2, byArray9, this.serverSeed_, this.clientSeed_, object3, byArray3);
            }
            object3 = new ChangePasswordReq(byArray7, byArray4, byArray6, cArray.length * 2, byArray5, cArray2.length * 2, this.serverLevel_);
            object2 = (ChangePasswordRep)this.signonServer_.sendAndReceive((DataStream)object3);
            int n = ((ChangePasswordRep)object2).getRC();
            if (n == 0) {
                if (Trace.traceOn_) {
                    Trace.log(1, "Password change implementation successful.");
                }
                byArray3 = new byte[9];
                AS400.rng.nextBytes(byArray3);
                object = this.signon(string, bl, string2, AS400ImplRemote.encode(byArray3, this.exchangeSeed(byArray3), BinaryConverter.charArrayToByteArray(cArray2)), 0, this.gssName_, 1);
                if (bl2) {
                    this.signonDisconnect();
                }
                return object;
            }
            byArray3 = new byte[4];
            BinaryConverter.intToByteArray(n, byArray3, 0);
            Trace.log(2, "Change password implementation failed with return code:", byArray3);
            throw AS400ImplRemote.returnSecurityException(n, ((ChangePasswordRep)object2).getErrorMessages(ConverterImplRemote.getConverter(ExecutionEnvironment.getBestGuessAS400Ccsid(), this)));
        }
        catch (IOException iOException) {
            Trace.log(2, "Change password failed:", (Throwable)iOException);
            this.signonServer_.forceDisconnect();
            this.signonServer_ = null;
            throw iOException;
        }
        catch (AS400SecurityException aS400SecurityException) {
            Trace.log(2, "Change password failed:", (Throwable)aS400SecurityException);
            this.signonServer_.forceDisconnect();
            this.signonServer_ = null;
            throw aS400SecurityException;
        }
    }

    public void connect(int n) throws AS400SecurityException, IOException {
        if (n == 7) {
            this.signonConnect();
        } else {
            this.getConnection(n, false);
        }
    }

    private static byte[] decode(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        int n;
        byte[] byArray4 = new byte[byArray3.length];
        for (n = 0; n < byArray3.length; ++n) {
            byArray4[n] = (byte)(byArray2[n % 7] ^ byArray3[n]);
        }
        for (n = 0; n < byArray3.length; ++n) {
            byArray4[n] = (byte)(byArray4[n] - byArray[n % 9]);
        }
        return byArray4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect(int n) {
        if (n == 7) {
            this.signonDisconnect();
        } else {
            Vector vector;
            Vector vector2 = vector = this.serverPool_[n];
            synchronized (vector2) {
                while (!vector.isEmpty()) {
                    this.disconnectServer((AS400Server)vector.elementAt(0));
                }
            }
        }
        if (Trace.traceOn_) {
            Trace.log(1, "Service disconnected implementation: " + AS400.getServerName(n));
        }
    }

    void disconnectAllServices() {
        if (Trace.traceOn_) {
            Trace.log(1, "Disconnecting all services implementation...");
        }
        this.disconnect(0);
        this.disconnect(1);
        this.disconnect(3);
        this.disconnect(2);
        this.disconnect(4);
        this.disconnect(5);
        this.disconnect(6);
        this.disconnect(7);
        if (Trace.traceOn_) {
            Trace.log(1, "All services disconnected implementation.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void disconnectServer(AS400Server aS400Server) {
        aS400Server.forceDisconnect();
        int n = aS400Server.getService();
        if (n != 7) {
            Vector vector;
            Vector vector2 = vector = this.serverPool_[n];
            synchronized (vector2) {
                if (!vector.isEmpty()) {
                    vector.removeElement(aS400Server);
                    if (vector.isEmpty()) {
                        this.fireConnectEvent(false, n);
                    }
                }
            }
        }
        if (Trace.traceOn_) {
            Trace.log(1, "Server disconnected");
        }
    }

    private static byte[] encode(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        int n;
        byte[] byArray4 = new byte[byArray3.length];
        for (n = 0; n < byArray3.length; ++n) {
            byArray4[n] = (byte)(byArray3[n] + byArray[n % 9]);
        }
        for (n = 0; n < byArray3.length; ++n) {
            byArray4[n] = (byte)(byArray4[n] ^ byArray2[n % 7]);
        }
        return byArray4;
    }

    public byte[] exchangeSeed(byte[] byArray) {
        this.proxySeed_ = byArray;
        this.remoteSeed_ = new byte[7];
        AS400.rng.nextBytes(this.remoteSeed_);
        return this.remoteSeed_;
    }

    protected void finalize() throws Throwable {
        if (Trace.traceOn_) {
            Trace.log(1, "Finalize method for AS400 implementation invoked.");
        }
        this.disconnectAllServices();
        super.finalize();
    }

    private void fireConnectEvent(boolean bl, int n) {
        if (this.dispatcher_ != null) {
            ConnectionEvent connectionEvent = new ConnectionEvent(this, n);
            if (bl) {
                this.dispatcher_.connected(connectionEvent);
            } else {
                this.dispatcher_.disconnected(connectionEvent);
            }
        }
    }

    public void generateProfileToken(ProfileTokenCredential profileTokenCredential, String string) throws AS400SecurityException, IOException {
        this.signonConnect();
        try {
            byte[] byArray = SignonConverter.stringToByteArray(this.userId_);
            byte[] byArray2 = this.getPassword(this.clientSeed_, this.serverSeed_);
            int n = AS400Server.getServerId(7);
            AS400StrSvrDS aS400StrSvrDS = new AS400StrSvrDS(n, byArray, byArray2, this.byteType_);
            AS400StrSvrReplyDS aS400StrSvrReplyDS = (AS400StrSvrReplyDS)this.signonServer_.sendAndReceive(aS400StrSvrDS);
            if (aS400StrSvrReplyDS.getRC() != 0) {
                byte[] byArray3 = new byte[4];
                BinaryConverter.intToByteArray(aS400StrSvrReplyDS.getRC(), byArray3, 0);
                Trace.log(2, "Start server failed with return code:", byArray3);
                throw AS400ImplRemote.returnSecurityException(aS400StrSvrReplyDS.getRC());
            }
            SignonGenAuthTokenRequestDS signonGenAuthTokenRequestDS = new SignonGenAuthTokenRequestDS(BinaryConverter.charArrayToByteArray(string.toCharArray()), profileTokenCredential.getTokenType(), profileTokenCredential.getTimeoutInterval(), this.serverLevel_);
            SignonGenAuthTokenReplyDS signonGenAuthTokenReplyDS = (SignonGenAuthTokenReplyDS)this.signonServer_.sendAndReceive(signonGenAuthTokenRequestDS);
            int n2 = signonGenAuthTokenReplyDS.getRC();
            if (n2 != 0) {
                byte[] byArray4 = new byte[4];
                BinaryConverter.intToByteArray(n2, byArray4, 0);
                Trace.log(2, "Generate profile token failed with return code:", byArray4);
                throw AS400ImplRemote.returnSecurityException(n2, signonGenAuthTokenReplyDS.getErrorMessages(ConverterImplRemote.getConverter(ExecutionEnvironment.getBestGuessAS400Ccsid(), this)));
            }
            try {
                profileTokenCredential.setToken(signonGenAuthTokenReplyDS.getProfileTokenBytes());
            }
            catch (PropertyVetoException propertyVetoException) {
                Trace.log(2, "Unexpected PropertyVetoException:", (Throwable)propertyVetoException);
                throw new InternalErrorException(10);
            }
        }
        catch (IOException iOException) {
            Trace.log(2, "Generate profile token failed:", (Throwable)iOException);
            this.signonServer_.forceDisconnect();
            this.signonServer_ = null;
            throw iOException;
        }
        catch (AS400SecurityException aS400SecurityException) {
            Trace.log(2, "Generate profile token failed:", (Throwable)aS400SecurityException);
            this.signonServer_.forceDisconnect();
            this.signonServer_ = null;
            throw aS400SecurityException;
        }
    }

    public void generateProfileToken(ProfileTokenCredential profileTokenCredential, String string, byte[] byArray, int n) throws AS400SecurityException, IOException, InterruptedException {
        this.signonConnect();
        try {
            byte[] byArray2;
            int n2;
            Object object;
            byte[] byArray3 = SignonConverter.stringToByteArray(string);
            byte[] byArray4 = null;
            switch (n) {
                case 1: {
                    try {
                        byArray4 = this.gssCredential_ == null ? TokenManager.getGSSToken(this.systemName_, this.gssName_) : TokenManager2.getGSSToken(this.systemName_, this.gssCredential_);
                        break;
                    }
                    catch (Exception exception) {
                        Trace.log(2, "Error retrieving GSSToken:", (Throwable)exception);
                        throw new AS400SecurityException(62);
                    }
                }
                case 2: 
                case 3: {
                    byArray4 = AS400ImplRemote.decode(this.proxySeed_, this.remoteSeed_, byArray);
                    break;
                }
                default: {
                    object = BinaryConverter.byteArrayToCharArray(AS400ImplRemote.decode(this.proxySeed_, this.remoteSeed_, byArray));
                    this.proxySeed_ = null;
                    this.remoteSeed_ = null;
                    if (!this.passwordType_) {
                        if (((char[])object).length > 0 && Character.isDigit(object[0])) {
                            boolean bl = true;
                            for (n2 = 0; n2 < ((char[])object).length; ++n2) {
                                if (object[n2] >= '0' && object[n2] <= '9') continue;
                                bl = false;
                            }
                            if (bl) {
                                if (Trace.traceOn_) {
                                    Trace.log(1, "Prepending Q to numeric password.");
                                }
                                char[] cArray = new char[((char[])object).length + 1];
                                cArray[0] = 81;
                                System.arraycopy(object, 0, cArray, 1, ((char[])object).length);
                                object = cArray;
                            }
                        }
                        if (((char[])object).length > 10) {
                            Trace.log(2, "Length of parameter 'password' is not valid:", ((char[])object).length);
                            throw new AS400SecurityException(10);
                        }
                        byArray4 = AS400ImplRemote.encryptPassword(byArray3, SignonConverter.stringToByteArray(new String((char[])object).toUpperCase()), this.clientSeed_, this.serverSeed_);
                        break;
                    }
                    byte[] byArray5 = BinaryConverter.charArrayToByteArray(SignonConverter.byteArrayToCharArray(byArray3));
                    if (object[0] == '*') {
                        Trace.log(2, "Parameter 'password' begins with a '*' character.");
                        throw new AS400SecurityException(63);
                    }
                    byte[] byArray6 = BinaryConverter.charArrayToByteArray(AS400ImplRemote.trimUnicodeSpace(object));
                    byArray2 = new byte[]{0, 0, 0, 0, 0, 0, 0, 1};
                    byte[] byArray7 = AS400ImplRemote.generateShaToken(byArray5, byArray6);
                    byArray4 = AS400ImplRemote.generateShaSubstitute(byArray7, this.serverSeed_, this.clientSeed_, byArray5, byArray2);
                }
            }
            object = new AS400GenAuthTknDS(byArray3, byArray4, n, profileTokenCredential.getTokenType(), profileTokenCredential.getTimeoutInterval(), this.serverLevel_);
            AS400GenAuthTknReplyDS aS400GenAuthTknReplyDS = (AS400GenAuthTknReplyDS)this.signonServer_.sendAndReceive((DataStream)object);
            n2 = aS400GenAuthTknReplyDS.getRC();
            if (n2 != 0) {
                byArray2 = new byte[4];
                BinaryConverter.intToByteArray(n2, byArray2, 0);
                Trace.log(2, "Generate profile token failed with return code:", byArray2);
                throw AS400ImplRemote.returnSecurityException(n2, aS400GenAuthTknReplyDS.getErrorMessages(ConverterImplRemote.getConverter(ExecutionEnvironment.getBestGuessAS400Ccsid(), this)));
            }
            try {
                profileTokenCredential.setToken(aS400GenAuthTknReplyDS.getProfileTokenBytes());
            }
            catch (PropertyVetoException propertyVetoException) {
                Trace.log(2, "Unexpected PropertyVetoException:", (Throwable)propertyVetoException);
                throw new InternalErrorException(10);
            }
        }
        catch (IOException iOException) {
            Trace.log(2, "Generate profile token failed:", (Throwable)iOException);
            this.signonServer_.forceDisconnect();
            this.signonServer_ = null;
            throw iOException;
        }
        catch (AS400SecurityException aS400SecurityException) {
            Trace.log(2, "Generate profile token failed:", (Throwable)aS400SecurityException);
            this.signonServer_.forceDisconnect();
            this.signonServer_ = null;
            throw aS400SecurityException;
        }
    }

    int getCcsid() {
        if (this.ccsid_ != 0) {
            return this.ccsid_;
        }
        if (this.signonInfo_ != null) {
            this.ccsid_ = this.signonInfo_.serverCCSID;
        }
        if (this.ccsid_ != 0) {
            return this.ccsid_;
        }
        try {
            this.ccsid_ = this.getCcsidFromServer();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.ccsid_ != 0) {
            return this.ccsid_;
        }
        this.ccsid_ = ExecutionEnvironment.getBestGuessAS400Ccsid();
        return this.ccsid_;
    }

    int getUserOverrideCcsid() {
        if (this.userOverrideCcsid_) {
            return this.ccsid_;
        }
        return 0;
    }

    public int getCcsidFromServer() throws AS400SecurityException, IOException, InterruptedException {
        NLSImpl nLSImpl = (NLSImpl)this.loadImpl("com.ibm.as400.access.NLSImplNative", "com.ibm.as400.access.NLSImplRemote");
        nLSImpl.setSystem(this);
        nLSImpl.connect();
        nLSImpl.disconnect();
        return nLSImpl.getCcsid();
    }

    synchronized Socket getConnection(int n) throws IOException {
        Socket socket = new Socket(this.systemNameLocal_ ? "localhost" : this.systemName_, n);
        try {
            PortMapper.setSocketProperties(socket, this.socketProperties_);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(socket.getInputStream(), "ISO8859_1"));
            PrintWriter printWriter = new PrintWriter((Writer)new OutputStreamWriter(socket.getOutputStream(), "ISO8859_1"), true);
            this.readFTPLine(bufferedReader);
            printWriter.println("USER " + this.userId_);
            this.readFTPLine(bufferedReader);
            printWriter.println("PASS " + new String(BinaryConverter.byteArrayToCharArray(AS400ImplRemote.decode(this.adder_, this.mask_, this.bytes_))));
            if (!this.readFTPLine(bufferedReader).startsWith("230")) {
                throw new IOException();
            }
            return socket;
        }
        catch (IOException iOException) {
            Trace.log(2, "Establishing FTP connection failed:", (Throwable)iOException);
            try {
                socket.close();
            }
            catch (IOException iOException2) {
                Trace.log(2, "Error closing socket:", (Throwable)iOException2);
            }
            throw iOException;
        }
    }

    private String readFTPLine(BufferedReader bufferedReader) throws IOException {
        String string = bufferedReader.readLine();
        if (string == null || string.length() == 0) {
            throw new IOException();
        }
        String string2 = string.substring(0, 3);
        String string3 = string;
        while (string.length() <= 3 || !string.substring(0, 3).equals(string2) || string.charAt(3) != ' ') {
            string = bufferedReader.readLine();
            string3 = string3 + "\n" + string;
        }
        return string3;
    }

    synchronized Socket getConnection(int n, int n2) throws AS400SecurityException, IOException {
        if (Trace.traceOn_) {
            Trace.log(1, "Establishing connection to system at port:", n2);
        }
        Socket socket = new Socket(this.systemNameLocal_ ? "localhost" : this.systemName_, n2);
        int n3 = socket.hashCode();
        try {
            PortMapper.setSocketProperties(socket, this.socketProperties_);
            InputStream inputStream = socket.getInputStream();
            OutputStream outputStream = socket.getOutputStream();
            int n4 = AS400Server.getServerId(2);
            AS400XChgRandSeedDS aS400XChgRandSeedDS = new AS400XChgRandSeedDS(n4);
            if (Trace.traceOn_) {
                aS400XChgRandSeedDS.setConnectionID(n3);
            }
            aS400XChgRandSeedDS.write(outputStream);
            AS400XChgRandSeedReplyDS aS400XChgRandSeedReplyDS = new AS400XChgRandSeedReplyDS();
            if (Trace.traceOn_) {
                aS400XChgRandSeedReplyDS.setConnectionID(n3);
            }
            aS400XChgRandSeedReplyDS.read(inputStream);
            if (aS400XChgRandSeedReplyDS.getRC() != 0) {
                byte[] byArray = new byte[4];
                BinaryConverter.intToByteArray(aS400XChgRandSeedReplyDS.getRC(), byArray, 0);
                Trace.log(2, "Exchange of random seeds failed with return code:", byArray);
                throw AS400ImplRemote.returnSecurityException(aS400XChgRandSeedReplyDS.getRC());
            }
            if (Trace.traceOn_) {
                Trace.log(1, "Exchange of random seeds successful.");
            }
            byte[] byArray = aS400XChgRandSeedDS.getClientSeed();
            byte[] byArray2 = aS400XChgRandSeedReplyDS.getServerSeed();
            byte[] byArray3 = SignonConverter.stringToByteArray(this.userId_);
            byte[] byArray4 = this.getPassword(byArray, byArray2);
            AS400StrSvrDS aS400StrSvrDS = new AS400StrSvrDS(n4, byArray3, byArray4, this.byteType_);
            if (Trace.traceOn_) {
                aS400StrSvrDS.setConnectionID(n3);
            }
            aS400StrSvrDS.write(outputStream);
            AS400StrSvrReplyDS aS400StrSvrReplyDS = new AS400StrSvrReplyDS();
            if (Trace.traceOn_) {
                aS400StrSvrReplyDS.setConnectionID(n3);
            }
            aS400StrSvrReplyDS.read(inputStream);
            if (aS400StrSvrReplyDS.getRC() != 0) {
                byte[] byArray5 = new byte[4];
                BinaryConverter.intToByteArray(aS400StrSvrReplyDS.getRC(), byArray5, 0);
                Trace.log(2, "Start server failed with return code:", byArray5);
                throw AS400ImplRemote.returnSecurityException(aS400StrSvrReplyDS.getRC());
            }
            if (Trace.traceOn_) {
                Trace.log(1, "Server started successfully.");
            }
            return socket;
        }
        catch (IOException iOException) {
            Trace.log(2, "Establishing DHCP connection failed:", (Throwable)iOException);
            try {
                socket.close();
            }
            catch (IOException iOException2) {
                Trace.log(2, "Error closing socket:", (Throwable)iOException2);
            }
            throw iOException;
        }
        catch (AS400SecurityException aS400SecurityException) {
            Trace.log(2, "Establishing DHCP connection failed:", (Throwable)aS400SecurityException);
            try {
                socket.close();
            }
            catch (IOException iOException) {
                Trace.log(2, "Error closing socket:", (Throwable)iOException);
            }
            throw aS400SecurityException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getJobs(int n) {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting job names implementation, service:", n);
        }
        if (n == 7) {
            String[] stringArray;
            if (this.signonServer_ != null) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = this.signonJobString_;
            } else {
                stringArray = new String[]{};
            }
            return stringArray;
        }
        Vector vector = this.serverPool_[n];
        String[] stringArray = new String[vector.size()];
        Vector vector2 = vector;
        synchronized (vector2) {
            for (int i = 0; i < vector.size(); ++i) {
                stringArray[i] = ((AS400Server)vector.elementAt(i)).getJobString();
            }
        }
        return stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized AS400Server getConnection(int n, boolean bl) throws AS400SecurityException, IOException {
        if (Trace.traceOn_) {
            Trace.log(1, "Establishing connection to system: " + AS400.getServerName(n));
        }
        if (!this.isPasswordTypeSet_) {
            this.signonConnect();
            this.signonDisconnect();
        }
        AS400Server aS400Server = null;
        Vector vector = this.serverPool_[n];
        Object object = vector;
        synchronized (object) {
            if (!bl && !vector.isEmpty()) {
                aS400Server = (AS400Server)vector.firstElement();
                if (Trace.traceOn_) {
                    Trace.log(1, "Reusing previous server object...");
                }
                return aS400Server;
            }
        }
        object = PortMapper.getServerSocket(this.systemNameLocal_ ? "localhost" : this.systemName_, n, this.useSSLConnection_, this.socketProperties_, this.mustUseNetSockets_);
        int n2 = object.hashCode();
        String string = "";
        try {
            InputStream inputStream = ((SocketContainer)object).getInputStream();
            OutputStream outputStream = ((SocketContainer)object).getOutputStream();
            if (n == 5) {
                Object[] objectArray = ClassDecoupler.connectDDMPhase1(outputStream, inputStream, this.passwordType_, this.byteType_, n2);
                byte[] byArray = (byte[])objectArray[0];
                byte[] byArray2 = (byte[])objectArray[1];
                byte[] byArray3 = SignonConverter.stringToByteArray(this.userId_);
                byte[] byArray4 = this.getPassword(byArray, byArray2);
                byte[] byArray5 = null;
                if (this.ddmRDB_ != null) {
                    AS400Text aS400Text = new AS400Text(18, this.signonInfo_.serverCCSID);
                    byArray5 = aS400Text.toBytes(this.ddmRDB_);
                }
                ClassDecoupler.connectDDMPhase2(outputStream, inputStream, byArray3, byArray4, byArray5, this.byteType_, this.ddmRDB_, this.systemName_, n2);
            } else {
                int n3 = AS400Server.getServerId(n);
                AS400XChgRandSeedDS aS400XChgRandSeedDS = new AS400XChgRandSeedDS(n3);
                if (Trace.traceOn_) {
                    aS400XChgRandSeedDS.setConnectionID(n2);
                }
                aS400XChgRandSeedDS.write(outputStream);
                AS400XChgRandSeedReplyDS aS400XChgRandSeedReplyDS = new AS400XChgRandSeedReplyDS();
                if (Trace.traceOn_) {
                    aS400XChgRandSeedReplyDS.setConnectionID(n2);
                }
                aS400XChgRandSeedReplyDS.read(inputStream);
                if (aS400XChgRandSeedReplyDS.getRC() != 0) {
                    byte[] byArray = new byte[4];
                    BinaryConverter.intToByteArray(aS400XChgRandSeedReplyDS.getRC(), byArray, 0);
                    Trace.log(2, "Exchange of random seeds failed with return code:", byArray);
                    throw AS400ImplRemote.returnSecurityException(aS400XChgRandSeedReplyDS.getRC());
                }
                if (Trace.traceOn_) {
                    Trace.log(1, "Exchange of random seeds successful.");
                }
                byte[] byArray = aS400XChgRandSeedDS.getClientSeed();
                byte[] byArray6 = aS400XChgRandSeedReplyDS.getServerSeed();
                byte[] byArray7 = SignonConverter.stringToByteArray(this.userId_);
                byte[] byArray8 = this.getPassword(byArray, byArray6);
                AS400StrSvrDS aS400StrSvrDS = new AS400StrSvrDS(n3, byArray7, byArray8, this.byteType_);
                if (Trace.traceOn_) {
                    aS400StrSvrDS.setConnectionID(n2);
                }
                aS400StrSvrDS.write(outputStream);
                AS400StrSvrReplyDS aS400StrSvrReplyDS = new AS400StrSvrReplyDS();
                if (Trace.traceOn_) {
                    aS400StrSvrReplyDS.setConnectionID(n2);
                }
                aS400StrSvrReplyDS.read(inputStream);
                byte[] byArray9 = aS400StrSvrReplyDS.getJobNameBytes();
                ConverterImplRemote converterImplRemote = ConverterImplRemote.getConverter(this.signonInfo_.serverCCSID, this);
                string = converterImplRemote.byteArrayToString(byArray9);
                if (Trace.traceOn_) {
                    Trace.log(1, "System job: " + string);
                }
                if (aS400StrSvrReplyDS.getRC() != 0) {
                    byte[] byArray10 = new byte[4];
                    BinaryConverter.intToByteArray(aS400StrSvrReplyDS.getRC(), byArray10, 0);
                    Trace.log(2, "Start server failed with return code:", byArray10);
                    throw AS400ImplRemote.returnSecurityException(aS400StrSvrReplyDS.getRC());
                }
            }
        }
        catch (IOException iOException) {
            AS400ImplRemote.forceDisconnect(iOException, aS400Server, (SocketContainer)object);
            throw iOException;
        }
        catch (AS400SecurityException aS400SecurityException) {
            AS400ImplRemote.forceDisconnect(aS400SecurityException, aS400Server, (SocketContainer)object);
            throw aS400SecurityException;
        }
        catch (RuntimeException runtimeException) {
            AS400ImplRemote.forceDisconnect(runtimeException, aS400Server, (SocketContainer)object);
            throw runtimeException;
        }
        if (Trace.traceOn_) {
            Trace.log(1, "Server started successfully.");
        }
        aS400Server = this.threadUsed_ ? new AS400ThreadedServer(this, n, (SocketContainer)object, string) : new AS400NoThreadServer(this, n, (SocketContainer)object, string);
        vector.addElement(aS400Server);
        this.fireConnectEvent(true, n);
        return aS400Server;
    }

    private static void forceDisconnect(Exception exception, AS400Server aS400Server, SocketContainer socketContainer) {
        Trace.log(2, "Establishing connection failed:", (Throwable)exception);
        if (aS400Server != null) {
            try {
                aS400Server.forceDisconnect();
            }
            catch (Throwable throwable) {
                Trace.log(2, "Error closing socket:", throwable);
            }
        } else if (socketContainer != null) {
            try {
                socketContainer.close();
            }
            catch (Throwable throwable) {
                Trace.log(2, "Error closing socket:", throwable);
            }
        }
    }

    String getNLV() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting NLV implementation: " + this.clientNlv_);
        }
        return this.clientNlv_;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private byte[] getPassword(byte[] byArray, byte[] byArray2) throws AS400SecurityException, IOException {
        if (this.byteType_ == 1) {
            try {
                return this.gssCredential_ == null ? TokenManager.getGSSToken(this.systemName_, this.gssName_) : TokenManager2.getGSSToken(this.systemName_, this.gssCredential_);
            }
            catch (Throwable throwable) {
                Trace.log(2, "Error retrieving GSSToken:", throwable);
                throw new AS400SecurityException(62);
            }
        }
        if (this.byteType_ == 2) return AS400ImplRemote.decode(this.adder_, this.mask_, this.bytes_);
        if (this.byteType_ == 3) {
            return AS400ImplRemote.decode(this.adder_, this.mask_, this.bytes_);
        }
        byte[] byArray3 = null;
        if (Trace.traceOn_) {
            Trace.log(1, "Retrieving encrypted password.");
        }
        if (this.bytes_ == null) {
            if (AS400.onAS400 && AS400.currentUserAvailable() && this.userId_.equals(CurrentUser.getUserID(AS400.nativeVRM.getVersionReleaseModification()))) {
                return CurrentUser.getUserInfo(AS400.nativeVRM.getVersionReleaseModification(), byArray, byArray2);
            }
            Trace.log(2, "Password is null.");
            throw new AS400SecurityException(22);
        }
        byte[] byArray4 = SignonConverter.stringToByteArray(this.userId_);
        char[] cArray = BinaryConverter.byteArrayToCharArray(AS400ImplRemote.decode(this.adder_, this.mask_, this.bytes_));
        if (!this.passwordType_) {
            if (cArray.length > 0 && Character.isDigit(cArray[0])) {
                boolean bl = true;
                for (int i = 0; i < cArray.length; ++i) {
                    if (cArray[i] >= '0' && cArray[i] <= '9') continue;
                    bl = false;
                }
                if (bl) {
                    if (Trace.traceOn_) {
                        Trace.log(1, "Prepending Q to numeric password.");
                    }
                    char[] cArray2 = new char[cArray.length + 1];
                    cArray2[0] = 81;
                    System.arraycopy(cArray, 0, cArray2, 1, cArray.length);
                    cArray = cArray2;
                }
            }
            if (cArray.length > 10) {
                Trace.log(2, "Length of parameter 'password' is not valid:", cArray.length);
                throw new AS400SecurityException(10);
            }
            byte[] byArray5 = SignonConverter.stringToByteArray(new String(cArray).toUpperCase());
            return AS400ImplRemote.encryptPassword(byArray4, byArray5, byArray, byArray2);
        }
        byte[] byArray6 = BinaryConverter.charArrayToByteArray(SignonConverter.byteArrayToCharArray(byArray4));
        if (cArray[0] == '*') {
            Trace.log(2, "Parameter 'password' begins with a '*' character.");
            throw new AS400SecurityException(63);
        }
        byte[] byArray7 = BinaryConverter.charArrayToByteArray(AS400ImplRemote.trimUnicodeSpace(cArray));
        byte[] byArray8 = new byte[]{0, 0, 0, 0, 0, 0, 0, 1};
        byte[] byArray9 = AS400ImplRemote.generateShaToken(byArray6, byArray7);
        return AS400ImplRemote.generateShaSubstitute(byArray9, byArray2, byArray, byArray6, byArray8);
    }

    public int getServicePort(String string, int n) {
        return PortMapper.getServicePort(string, n, this.useSSLConnection_);
    }

    String getSecondaryLangLib() {
        return this.secondaryLangLib_;
    }

    String getSystemName() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting implementation system name: " + this.systemName_ + " is local:", this.systemNameLocal_);
        }
        return this.systemNameLocal_ ? "localhost" : this.systemName_;
    }

    String getUserId() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting implementation user ID: " + this.userId_);
        }
        return this.userId_;
    }

    int getVRM() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting implementation VRM.");
        }
        int n = this.signonInfo_.version.getVersionReleaseModification();
        if (Trace.traceOn_) {
            byte[] byArray = new byte[4];
            BinaryConverter.intToByteArray(n, byArray, 0);
            Trace.log(1, "Implementation VRM:", byArray);
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConnected(int n) {
        Vector vector;
        if (Trace.traceOn_) {
            Trace.log(1, "Checking for service connection implementation:", n);
        }
        if (n == 7) {
            return this.signonServer_ != null;
        }
        Vector vector2 = vector = this.serverPool_[n];
        synchronized (vector2) {
            for (int i = vector.size() - 1; i >= 0; --i) {
                if (!((AS400Server)vector.elementAt(i)).isConnected()) continue;
                return true;
            }
            return false;
        }
    }

    boolean isSkipFurtherSettingOfSecondaryLangLib() {
        return this.isSkipFurtherSettingOfSecondaryLangLib_;
    }

    boolean isThreadUsed() {
        if (Trace.traceOn_) {
            Trace.log(1, "Checking implementation if thread is used:", this.threadUsed_);
        }
        return this.threadUsed_;
    }

    Object loadImpl(String string, String string2) {
        Object object;
        if (this.canUseNativeOptimization_) {
            object = AS400.loadImpl(string);
            if (object != null) {
                return object;
            }
            if (Trace.traceOn_) {
                Trace.log(1, "Load of native implementation '" + string + "' failed, attempting to load remote implementation.");
            }
        }
        if ((object = AS400.loadImpl(string2)) != null) {
            return object;
        }
        Trace.log(1, "Load of remote implementation '" + string2 + "' failed.");
        throw new ExtendedIllegalStateException(string2, 11);
    }

    public void newConverter(int n) throws UnsupportedEncodingException {
        ConverterImplRemote.getConverter(n, this);
    }

    public void removeConnectionListener(ConnectionListener connectionListener) {
        if (Trace.traceOn_) {
            Trace.log(1, "Removing implementation connection listener.");
        }
        this.dispatcher_ = null;
    }

    static AS400SecurityException returnSecurityException(int n) throws ServerStartupException {
        return AS400ImplRemote.returnSecurityException(n, null);
    }

    static AS400SecurityException returnSecurityException(int n, AS400Message[] aS400MessageArray) throws ServerStartupException {
        switch (n) {
            case 65537: {
                throw new ServerStartupException(5);
            }
            case 65538: {
                throw new ServerStartupException(16);
            }
            case 65539: {
                throw new ServerStartupException(6);
            }
            case 65540: {
                throw new ServerStartupException(7);
            }
            case 65541: {
                throw new ServerStartupException(8);
            }
            case 65542: {
                throw new ServerStartupException(9);
            }
            case 65543: {
                return new AS400SecurityException(29, aS400MessageArray);
            }
            case 65544: {
                return new AS400SecurityException(10, aS400MessageArray);
            }
            case 65545: {
                throw new ServerStartupException(14);
            }
            case 65546: {
                throw new ServerStartupException(14);
            }
            case 65547: {
                return new AS400SecurityException(26, aS400MessageArray);
            }
            case 65548: {
                return new AS400SecurityException(5, aS400MessageArray);
            }
            case 65549: {
                return new AS400SecurityException(23, aS400MessageArray);
            }
            case 65550: {
                return new AS400SecurityException(16, aS400MessageArray);
            }
            case 65551: {
                return new AS400SecurityException(41, aS400MessageArray);
            }
            case 65552: {
                return new AS400SecurityException(42, aS400MessageArray);
            }
            case 65553: {
                return new AS400SecurityException(43, aS400MessageArray);
            }
            case 65554: {
                return new AS400SecurityException(42, aS400MessageArray);
            }
            case 131073: {
                return new AS400SecurityException(32, aS400MessageArray);
            }
            case 131074: {
                return new AS400SecurityException(31, aS400MessageArray);
            }
            case 131075: {
                return new AS400SecurityException(64, aS400MessageArray);
            }
            case 196609: {
                return new AS400SecurityException(19, aS400MessageArray);
            }
            case 196610: {
                return new AS400SecurityException(20, aS400MessageArray);
            }
            case 196611: {
                return new AS400SecurityException(18, aS400MessageArray);
            }
            case 196612: {
                return new AS400SecurityException(11, aS400MessageArray);
            }
            case 196613: {
                return new AS400SecurityException(12, aS400MessageArray);
            }
            case 196614: {
                return new AS400SecurityException(17, aS400MessageArray);
            }
            case 196615: {
                return new AS400SecurityException(15, aS400MessageArray);
            }
            case 196616: {
                return new AS400SecurityException(44, aS400MessageArray);
            }
            case 196617: {
                return new AS400SecurityException(13, aS400MessageArray);
            }
            case 196618: {
                return new AS400SecurityException(21, aS400MessageArray);
            }
            case 196619: {
                return new AS400SecurityException(8, aS400MessageArray);
            }
            case 196620: {
                return new AS400SecurityException(9, aS400MessageArray);
            }
            case 196621: {
                return new AS400SecurityException(7, aS400MessageArray);
            }
            case 196622: {
                return new AS400SecurityException(45, aS400MessageArray);
            }
            case 196623: {
                return new AS400SecurityException(39, aS400MessageArray);
            }
            case 196624: {
                return new AS400SecurityException(46, aS400MessageArray);
            }
            case 196625: {
                return new AS400SecurityException(65, aS400MessageArray);
            }
            case 196626: {
                return new AS400SecurityException(77, aS400MessageArray);
            }
            case 196627: {
                return new AS400SecurityException(78, aS400MessageArray);
            }
            case 262144: {
                return new AS400SecurityException(24, aS400MessageArray);
            }
            case 262145: {
                throw new ServerStartupException(17);
            }
            case 262146: {
                throw new ServerStartupException(18);
            }
            case 262147: {
                throw new ServerStartupException(19);
            }
            case 262148: {
                throw new ServerStartupException(20);
            }
            case 262149: {
                throw new ServerStartupException(21);
            }
            case 262150: {
                throw new ServerStartupException(22);
            }
            case 262151: {
                throw new ServerStartupException(23);
            }
            case 262152: {
                throw new ServerStartupException(24);
            }
            case 262153: {
                throw new ServerStartupException(25);
            }
            case 262154: {
                throw new ServerStartupException(26);
            }
            case 262155: {
                throw new ServerStartupException(27);
            }
            case 262156: {
                throw new ServerStartupException(28);
            }
            case 262157: {
                throw new ServerStartupException(29);
            }
            case 262158: {
                return new AS400SecurityException(66, aS400MessageArray);
            }
            case 262159: {
                return new AS400SecurityException(71, aS400MessageArray);
            }
            case 262160: {
                return new AS400SecurityException(72, aS400MessageArray);
            }
            case 262161: {
                return new AS400SecurityException(73, aS400MessageArray);
            }
            case 262162: {
                return new AS400SecurityException(74, aS400MessageArray);
            }
            case 262163: {
                return new AS400SecurityException(75, aS400MessageArray);
            }
            case 262164: {
                return new AS400SecurityException(76, aS400MessageArray);
            }
            case 327681: {
                return new AS400SecurityException(33, aS400MessageArray);
            }
            case 327682: {
                return new AS400SecurityException(34, aS400MessageArray);
            }
            case 327683: {
                return new AS400SecurityException(36, aS400MessageArray);
            }
            case 327684: {
                return new AS400SecurityException(35, aS400MessageArray);
            }
            case 393217: {
                return new AS400SecurityException(47, aS400MessageArray);
            }
            case 393218: {
                return new AS400SecurityException(48, aS400MessageArray);
            }
            case 393219: {
                return new AS400SecurityException(49, aS400MessageArray);
            }
            case 393220: {
                return new AS400SecurityException(50, aS400MessageArray);
            }
            case 393221: {
                return new AS400SecurityException(51, aS400MessageArray);
            }
            case 393222: {
                return new AS400SecurityException(52, aS400MessageArray);
            }
            case 393223: {
                return new AS400SecurityException(53, aS400MessageArray);
            }
            case 393224: {
                return new AS400SecurityException(54, aS400MessageArray);
            }
            case 393225: {
                return new AS400SecurityException(55, aS400MessageArray);
            }
            case 393226: {
                return new AS400SecurityException(56, aS400MessageArray);
            }
            case 393227: {
                return new AS400SecurityException(52, aS400MessageArray);
            }
            case 393228: {
                return new AS400SecurityException(58, aS400MessageArray);
            }
            case 393229: {
                return new AS400SecurityException(59, aS400MessageArray);
            }
            case 393230: {
                return new AS400SecurityException(60, aS400MessageArray);
            }
            case 393231: {
                return new AS400SecurityException(61, aS400MessageArray);
            }
            case 458753: {
                return new AS400SecurityException(67, aS400MessageArray);
            }
            case 458754: {
                return new AS400SecurityException(68, aS400MessageArray);
            }
            case 458755: {
                return new AS400SecurityException(69, aS400MessageArray);
            }
            case 458756: {
                return new AS400SecurityException(70, aS400MessageArray);
            }
        }
        return new AS400SecurityException(27, aS400MessageArray);
    }

    static AS400Message[] parseMessages(byte[] byArray, int n, ConverterImplRemote converterImplRemote) throws IOException {
        int n2 = n;
        int n3 = 0;
        while (n < byArray.length - 1) {
            if (BinaryConverter.byteArrayToShort(byArray, n + 4) != 4394) {
                n += BinaryConverter.byteArrayToInt(byArray, n);
                continue;
            }
            n3 = BinaryConverter.byteArrayToShort(byArray, n + 6);
            break;
        }
        if (n3 == 0) {
            return null;
        }
        AS400Message[] aS400MessageArray = new AS400Message[n3];
        n = n2;
        for (int i = 0; i < n3; ++i) {
            while (n < byArray.length - 1) {
                if (BinaryConverter.byteArrayToShort(byArray, n + 4) != 4395) {
                    n += BinaryConverter.byteArrayToInt(byArray, n);
                    continue;
                }
                aS400MessageArray[i] = AS400ImplRemote.parseMessage(byArray, n + 6, converterImplRemote);
                break;
            }
            n += BinaryConverter.byteArrayToInt(byArray, n);
        }
        return aS400MessageArray;
    }

    static AS400Message parseMessage(byte[] byArray, int n, ConverterImplRemote converterImplRemote) throws IOException {
        AS400Message aS400Message = new AS400Message();
        int n2 = BinaryConverter.byteArrayToInt(byArray, n);
        int n3 = BinaryConverter.byteArrayToInt(byArray, n += 4);
        aS400Message.setSeverity(BinaryConverter.byteArrayToUnsignedShort(byArray, n += 4));
        int n4 = BinaryConverter.byteArrayToInt(byArray, n += 2);
        aS400Message.setType((byArray[n += 4] & 0xF) * 10 + (byArray[n + 1] & 0xF));
        int n5 = BinaryConverter.byteArrayToInt(byArray, n += n4);
        aS400Message.setID(converterImplRemote.byteArrayToString(byArray, n += 4, n5));
        int n6 = BinaryConverter.byteArrayToInt(byArray, n += n5);
        aS400Message.setFileName(converterImplRemote.byteArrayToString(byArray, n += 4, n6).trim());
        int n7 = BinaryConverter.byteArrayToInt(byArray, n += n6);
        aS400Message.setLibraryName(converterImplRemote.byteArrayToString(byArray, n += 4, n7).trim());
        int n8 = BinaryConverter.byteArrayToInt(byArray, n += n7);
        aS400Message.setText(converterImplRemote.byteArrayToString(byArray, n += 4, n8));
        int n9 = BinaryConverter.byteArrayToInt(byArray, n += n8);
        byte[] byArray2 = new byte[n9];
        System.arraycopy(byArray, n += 4, byArray2, 0, n9);
        aS400Message.setSubstitutionData(byArray2);
        int n10 = BinaryConverter.byteArrayToInt(byArray, n += n9);
        aS400Message.setHelp(converterImplRemote.byteArrayToString(byArray, n += 4, n10));
        return aS400Message;
    }

    void setGSSCredential(Object object) {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting GSS credential into impl: '" + object + "'");
        }
        this.gssCredential_ = object;
    }

    void setSecondaryLangLib(String string) {
        this.secondaryLangLib_ = string;
    }

    void setSkipFurtherSettingOfSecondaryLangLib() {
        this.isSkipFurtherSettingOfSecondaryLangLib_ = true;
    }

    public void setServicePort(String string, int n, int n2) {
        PortMapper.setServicePort(string, n, n2, this.useSSLConnection_);
    }

    public void setServicePortsToDefault(String string) {
        PortMapper.setServicePortsToDefault(string);
    }

    public void setState(SSLOptions sSLOptions, boolean bl, boolean bl2, int n, String string, SocketProperties socketProperties, String string2, boolean bl3, boolean bl4) {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting up AS400 implementation object:");
            Trace.log(1, "  Enable SSL connections: " + sSLOptions);
            Trace.log(1, "  Native optimizations allowed:", bl);
            Trace.log(1, "  Use threaded communications:", bl2);
            Trace.log(1, "  User specified CCSID:", n);
            Trace.log(1, "  NLV: " + string);
            Trace.log(1, "  Socket properties: " + socketProperties);
            Trace.log(1, "  DDM RDB: " + string2);
            Trace.log(1, "  Must use net sockets: " + bl3);
            Trace.log(1, "  Must use supplied profile: " + bl4);
        }
        this.useSSLConnection_ = sSLOptions;
        this.canUseNativeOptimization_ = bl;
        this.threadUsed_ = bl2;
        if (n != 0) {
            this.userOverrideCcsid_ = true;
            this.ccsid_ = n;
        }
        this.clientNlv_ = string;
        this.socketProperties_ = socketProperties;
        this.ddmRDB_ = string2;
        this.mustUseNetSockets_ = bl3;
        this.mustUseSuppliedProfile_ = bl4;
    }

    public SignonInfo signon(String string, boolean bl, String string2, byte[] byArray, int n, String string3, int n2) throws AS400SecurityException, IOException {
        this.systemName_ = string;
        this.systemNameLocal_ = bl;
        this.userId_ = string2;
        this.gssName_ = string3;
        this.gssOption_ = n2;
        if (byArray != null) {
            if (n == 1) {
                this.bytes_ = byArray;
            } else {
                this.adder_ = new byte[9];
                AS400.rng.nextBytes(this.adder_);
                this.mask_ = new byte[7];
                AS400.rng.nextBytes(this.mask_);
                this.bytes_ = AS400ImplRemote.encode(this.adder_, this.mask_, AS400ImplRemote.decode(this.proxySeed_, this.remoteSeed_, byArray));
            }
            this.byteType_ = n;
        }
        this.proxySeed_ = null;
        this.remoteSeed_ = null;
        if (this.canUseNativeOptimization_) {
            byte[] byArray2 = new byte[12];
            byte[] byArray3 = new byte[12];
            boolean bl2 = this.swapTo(byArray2, byArray3);
            try {
                byte[] byArray4 = AS400ImplNative.signonNative((byte[])SignonConverter.stringToByteArray(string2));
                GregorianCalendar gregorianCalendar = new GregorianCalendar(BinaryConverter.byteArrayToUnsignedShort(byArray4, 0), byArray4[2] - 1, byArray4[3], byArray4[4], byArray4[5], byArray4[6]);
                this.signonInfo_ = new SignonInfo();
                this.signonInfo_.currentSignonDate = gregorianCalendar;
                this.signonInfo_.lastSignonDate = gregorianCalendar;
                this.signonInfo_.expirationDate = BinaryConverter.byteArrayToInt(byArray4, 8) == 0 ? null : new GregorianCalendar(BinaryConverter.byteArrayToUnsignedShort(byArray4, 8), byArray4[10] - 1, byArray4[11], byArray4[12], byArray4[13], byArray4[14]);
                this.signonInfo_.version = AS400.nativeVRM;
                try {
                    this.signonInfo_.serverCCSID = this.getCcsidFromServer();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            catch (NativeException nativeException) {
                throw this.mapNativeSecurityException(nativeException);
            }
            finally {
                if (bl2) {
                    this.swapBack(byArray2, byArray3);
                }
            }
        } else {
            if (Trace.traceOn_) {
                Trace.log(1, "Opening a socket to verify security...");
            }
            this.signonConnect();
            try {
                Object object;
                int n3;
                byte[] byArray5 = this.byteType_ == 0 ? SignonConverter.stringToByteArray(string2) : null;
                byte[] byArray6 = this.byteType_ == 1 ? this.bytes_ : this.getPassword(this.clientSeed_, this.serverSeed_);
                SignonInfoReq signonInfoReq = new SignonInfoReq(byArray5, byArray6, this.byteType_, this.serverLevel_);
                SignonInfoRep signonInfoRep = (SignonInfoRep)this.signonServer_.sendAndReceive(signonInfoReq);
                if (Trace.traceOn_) {
                    Trace.log(1, "Read security validation reply...");
                }
                if ((n3 = signonInfoRep.getRC()) != 0) {
                    byte[] byArray7 = new byte[4];
                    BinaryConverter.intToByteArray(n3, byArray7, 0);
                    Trace.log(2, "Security validation failed with return code:", byArray7);
                    throw AS400ImplRemote.returnSecurityException(n3, signonInfoRep.getErrorMessages(ConverterImplRemote.getConverter(ExecutionEnvironment.getBestGuessAS400Ccsid(), this)));
                }
                if (Trace.traceOn_) {
                    Trace.log(1, "Security validated successfully.");
                }
                this.signonInfo_ = new SignonInfo();
                this.signonInfo_.currentSignonDate = signonInfoRep.getCurrentSignonDate();
                this.signonInfo_.lastSignonDate = signonInfoRep.getLastSignonDate();
                this.signonInfo_.expirationDate = signonInfoRep.getExpirationDate();
                this.signonInfo_.version = this.version_;
                this.signonInfo_.serverCCSID = signonInfoRep.getServerCCSID();
                if (this.userId_.length() == 0 && (object = signonInfoRep.getUserIdBytes()) != null) {
                    this.signonInfo_.userId = this.userId_ = SignonConverter.byteArrayToString((byte[])object);
                }
                if (DataStream.getDefaultConverter() == null) {
                    if (Trace.traceOn_) {
                        Trace.log(1, "Signon server reports CCSID:", this.signonInfo_.serverCCSID);
                    }
                    DataStream.setDefaultConverter(ConverterImplRemote.getConverter(this.signonInfo_.serverCCSID, this));
                }
                object = ConverterImplRemote.getConverter(this.signonInfo_.serverCCSID, this);
                this.signonJobString_ = ((ConverterImplRemote)object).byteArrayToString(this.signonJobBytes_);
                this.signonServer_.setJobString(this.signonJobString_);
                if (Trace.traceOn_) {
                    Trace.log(1, "Signon server job: " + this.signonJobString_);
                }
            }
            catch (IOException iOException) {
                Trace.log(2, "Signon failed:", (Throwable)iOException);
                this.signonServer_.forceDisconnect();
                this.signonServer_ = null;
                throw iOException;
            }
            catch (AS400SecurityException aS400SecurityException) {
                Trace.log(2, "Signon failed:", (Throwable)aS400SecurityException);
                this.signonServer_.forceDisconnect();
                this.signonServer_ = null;
                throw aS400SecurityException;
            }
        }
        return this.signonInfo_;
    }

    private synchronized void signonConnect() throws AS400SecurityException, IOException {
        if (this.signonServer_ == null) {
            SocketContainer socketContainer = PortMapper.getServerSocket(this.systemNameLocal_ ? "localhost" : this.systemName_, 7, this.useSSLConnection_, this.socketProperties_, this.mustUseNetSockets_);
            this.signonServer_ = new AS400NoThreadServer(this, 7, socketContainer, "");
            int n = socketContainer.hashCode();
            try {
                InputStream inputStream = socketContainer.getInputStream();
                OutputStream outputStream = socketContainer.getOutputStream();
                this.clientSeed_ = this.byteType_ == 0 ? BinaryConverter.longToByteArray(System.currentTimeMillis()) : null;
                SignonExchangeAttributeReq signonExchangeAttributeReq = new SignonExchangeAttributeReq(this.clientSeed_);
                if (Trace.traceOn_) {
                    signonExchangeAttributeReq.setConnectionID(n);
                }
                signonExchangeAttributeReq.write(outputStream);
                SignonExchangeAttributeRep signonExchangeAttributeRep = new SignonExchangeAttributeRep();
                if (Trace.traceOn_) {
                    signonExchangeAttributeRep.setConnectionID(n);
                }
                signonExchangeAttributeRep.read(inputStream);
                if (signonExchangeAttributeRep.getRC() != 0) {
                    byte[] byArray = new byte[4];
                    BinaryConverter.intToByteArray(signonExchangeAttributeRep.getRC(), byArray, 0);
                    Trace.log(2, "Signon server exchange client/server attributes failed, return code:", byArray);
                    throw AS400ImplRemote.returnSecurityException(signonExchangeAttributeRep.getRC());
                }
                this.version_ = new ServerVersion(signonExchangeAttributeRep.getServerVersion());
                this.serverLevel_ = signonExchangeAttributeRep.getServerLevel();
                this.passwordType_ = signonExchangeAttributeRep.getPasswordLevel();
                this.isPasswordTypeSet_ = true;
                this.serverSeed_ = signonExchangeAttributeRep.getServerSeed();
                this.signonJobBytes_ = signonExchangeAttributeRep.getJobNameBytes();
                if (Trace.traceOn_) {
                    byte[] byArray = new byte[4];
                    BinaryConverter.intToByteArray(this.version_.getVersionReleaseModification(), byArray, 0);
                    Trace.log(1, "  Server vrm:", byArray);
                    Trace.log(1, "  Server level: ", this.serverLevel_);
                }
                this.fireConnectEvent(true, 7);
                if (Trace.traceOn_) {
                    Trace.log(1, "Socket opened successfully.");
                }
            }
            catch (IOException iOException) {
                Trace.log(2, "Signon server exchange client/server attributes failed:", (Throwable)iOException);
                this.signonServer_.forceDisconnect();
                this.signonServer_ = null;
                throw iOException;
            }
        }
    }

    private synchronized void signonDisconnect() {
        if (this.signonServer_ != null) {
            try {
                if (Trace.traceOn_) {
                    Trace.log(1, "Sending end job data stream to signon server...");
                }
                SignonEndServerReq signonEndServerReq = new SignonEndServerReq();
                this.signonServer_.send(signonEndServerReq);
                this.signonServer_.forceDisconnect();
            }
            catch (IOException iOException) {
                Trace.log(2, "Error sending end job data stream to signon server:", (Throwable)iOException);
            }
            this.signonServer_ = null;
            this.fireConnectEvent(false, 7);
        }
    }

    boolean swapTo(byte[] byArray, byte[] byArray2) throws AS400SecurityException, IOException {
        if (AS400.onAS400 && AS400.currentUserAvailable() && this.userId_.equals(CurrentUser.getUserID(AS400.nativeVRM.getVersionReleaseModification()))) {
            return false;
        }
        if (this.bytes_ == null) {
            Trace.log(2, "Password is null.");
            throw new AS400SecurityException(22);
        }
        try {
            byte[] byArray3 = AS400ImplRemote.decode(this.adder_, this.mask_, this.bytes_);
            if (byArray3[0] == 0 && byArray3[1] == 42) {
                Trace.log(2, "Parameter 'password' begins with a '*' character.");
                throw new AS400SecurityException(63);
            }
            AS400ImplNative.swapToNative((byte[])SignonConverter.stringToByteArray(this.userId_), (byte[])byArray3, (byte[])byArray, (byte[])byArray2);
        }
        catch (NativeException nativeException) {
            throw this.mapNativeSecurityException(nativeException);
        }
        return true;
    }

    void swapBack(byte[] byArray, byte[] byArray2) throws AS400SecurityException, IOException {
        try {
            AS400ImplNative.swapBackNative((byte[])byArray, (byte[])byArray2);
        }
        catch (NativeException nativeException) {
            throw this.mapNativeSecurityException(nativeException);
        }
    }

    private AS400SecurityException mapNativeSecurityException(NativeException nativeException) throws IOException {
        String string = ConverterImplRemote.getConverter(37, this).byteArrayToString(nativeException.data, 12, 7);
        if (string.equals("CPF2203") || string.equals("CPF2204")) {
            return new AS400SecurityException(32);
        }
        if (string.equals("CPF22E3")) {
            return new AS400SecurityException(31);
        }
        if (string.equals("CPF22E2") || string.equals("CPF22E5")) {
            return new AS400SecurityException(8);
        }
        if (string.equals("CPF22E4")) {
            return new AS400SecurityException(7);
        }
        return new AS400SecurityException(24);
    }

    private static byte[] encryptNewPassword(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4, byte[] byArray5, byte[] byArray6, byte[] byArray7) {
        byte[] byArray8;
        byte[] byArray9 = new byte[8];
        byte[] byArray10 = new byte[]{0, 0, 0, 0, 0, 0, 0, 1};
        byte[] byArray11 = AS400ImplRemote.generateToken(byArray, byArray2);
        byte[] byArray12 = AS400ImplRemote.generatePasswordSubstitute(byArray, byArray11, byArray9, byArray10, byArray6, byArray7);
        AS400ImplRemote.incrementString(byArray10);
        byte[] byArray13 = AS400ImplRemote.generatePasswordSubstitute(byArray, byArray11, byArray9, byArray10, byArray6, byArray7);
        AS400ImplRemote.xORArray(byArray13, byArray3, byArray5);
        if (byArray5.length == 16) {
            byArray8 = new byte[8];
            AS400ImplRemote.incrementString(byArray10);
            byArray13 = AS400ImplRemote.generatePasswordSubstitute(byArray, byArray11, byArray9, byArray10, byArray6, byArray7);
            for (int i = 0; i < 8; ++i) {
                byArray8[i] = 64;
            }
            byArray8[0] = byArray3[8];
            byArray8[1] = byArray3[9];
            byte[] byArray14 = new byte[8];
            AS400ImplRemote.xORArray(byArray13, byArray8, byArray14);
            System.arraycopy(byArray14, 0, byArray5, 8, 8);
        }
        byArray11 = AS400ImplRemote.generateToken(byArray, byArray3);
        AS400ImplRemote.incrementString(byArray10);
        byArray13 = AS400ImplRemote.generatePasswordSubstitute(byArray, byArray11, byArray9, byArray10, byArray6, byArray7);
        AS400ImplRemote.xORArray(byArray13, byArray2, byArray4);
        if (byArray4.length == 16) {
            byArray8 = new byte[8];
            AS400ImplRemote.incrementString(byArray10);
            byArray13 = AS400ImplRemote.generatePasswordSubstitute(byArray, byArray11, byArray9, byArray10, byArray6, byArray7);
            for (int i = 0; i < 8; ++i) {
                byArray8[i] = 64;
            }
            byArray8[0] = byArray2[8];
            byArray8[1] = byArray2[9];
            byte[] byArray15 = new byte[8];
            AS400ImplRemote.xORArray(byArray13, byArray8, byArray15);
            System.arraycopy(byArray15, 0, byArray4, 8, 8);
        }
        return byArray12;
    }

    private static byte[] encryptPassword(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4) {
        byte[] byArray5 = new byte[]{0, 0, 0, 0, 0, 0, 0, 1};
        byte[] byArray6 = new byte[8];
        byte[] byArray7 = AS400ImplRemote.generateToken(byArray, byArray2);
        byte[] byArray8 = AS400ImplRemote.generatePasswordSubstitute(byArray, byArray7, byArray6, byArray5, byArray3, byArray4);
        return byArray8;
    }

    private static byte[] generatePasswordSubstitute(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4, byte[] byArray5, byte[] byArray6) {
        byte[] byArray7 = new byte[8];
        byte[] byArray8 = new byte[8];
        byte[] byArray9 = new byte[8];
        AS400ImplRemote.addArray(byArray4, byArray6, byArray7, 8);
        byArray9 = AS400ImplRemote.enc_des(byArray2, byArray7);
        AS400ImplRemote.xORArray(byArray9, byArray5, byArray8);
        byArray9 = AS400ImplRemote.enc_des(byArray2, byArray8);
        System.arraycopy(byArray9, 0, byArray3, 0, 8);
        AS400ImplRemote.xORArray(byArray, byArray7, byArray8);
        AS400ImplRemote.xORArray(byArray8, byArray9, byArray8);
        byArray9 = AS400ImplRemote.enc_des(byArray2, byArray8);
        for (int i = 0; i < 8; ++i) {
            byArray8[i] = 64;
        }
        byArray8[0] = byArray[8];
        byArray8[1] = byArray[9];
        AS400ImplRemote.xORArray(byArray7, byArray8, byArray8);
        AS400ImplRemote.xORArray(byArray8, byArray9, byArray8);
        byArray9 = AS400ImplRemote.enc_des(byArray2, byArray8);
        AS400ImplRemote.xORArray(byArray4, byArray9, byArray8);
        return AS400ImplRemote.enc_des(byArray2, byArray8);
    }

    private static byte[] generateToken(byte[] byArray, byte[] byArray2) {
        byte[] byArray3 = new byte[8];
        byte[] byArray4 = new byte[10];
        byte[] byArray5 = new byte[]{64, 64, 64, 64, 64, 64, 64, 64, 64, 64};
        byte[] byArray6 = new byte[]{64, 64, 64, 64, 64, 64, 64, 64, 64, 64};
        System.arraycopy(byArray, 0, byArray4, 0, 10);
        int n = AS400ImplRemote.ebcdicStrLen(byArray, 10);
        if (n > 8) {
            byArray4[0] = (byte)(byArray4[0] ^ byArray4[8] & 0xC0);
            byArray4[1] = (byte)(byArray4[1] ^ (byArray4[8] & 0x30) << 2);
            byArray4[2] = (byte)(byArray4[2] ^ (byArray4[8] & 0xC) << 4);
            byArray4[3] = (byte)(byArray4[3] ^ (byArray4[8] & 3) << 6);
            byArray4[4] = (byte)(byArray4[4] ^ byArray4[9] & 0xC0);
            byArray4[5] = (byte)(byArray4[5] ^ (byArray4[9] & 0x30) << 2);
            byArray4[6] = (byte)(byArray4[6] ^ (byArray4[9] & 0xC) << 4);
            byArray4[7] = (byte)(byArray4[7] ^ (byArray4[9] & 3) << 6);
        }
        if ((n = AS400ImplRemote.ebcdicStrLen(byArray2, 10)) > 8) {
            System.arraycopy(byArray2, 0, byArray5, 0, 8);
            System.arraycopy(byArray2, 8, byArray6, 0, n - 8);
            AS400ImplRemote.xorWith0x55andLshift(byArray5);
            byArray5 = AS400ImplRemote.enc_des(byArray5, byArray4);
            AS400ImplRemote.xorWith0x55andLshift(byArray6);
            byArray6 = AS400ImplRemote.enc_des(byArray6, byArray4);
            AS400ImplRemote.xORArray(byArray5, byArray6, byArray3);
        } else {
            System.arraycopy(byArray2, 0, byArray5, 0, n);
            AS400ImplRemote.xorWith0x55andLshift(byArray5);
            byArray3 = AS400ImplRemote.enc_des(byArray5, byArray4);
        }
        return byArray3;
    }

    private static void addArray(byte[] byArray, byte[] byArray2, byte[] byArray3, int n) {
        int n2 = 0;
        for (int i = n - 1; i >= 0; --i) {
            int n3 = (byArray[i] & 0xFF) + (byArray2[i] & 0xFF) + n2;
            n2 = n3 >>> 8;
            byArray3[i] = (byte)n3;
        }
    }

    private static int ebcdicStrLen(byte[] byArray, int n) {
        int n2;
        for (n2 = 0; n2 < n && byArray[n2] != 64 && byArray[n2] != 0; ++n2) {
        }
        return n2;
    }

    private static void incrementString(byte[] byArray) {
        byte[] byArray2 = new byte[]{0, 0, 0, 0, 0, 0, 0, 1};
        AS400ImplRemote.addArray(byArray, byArray2, byArray, 8);
    }

    private static void xORArray(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        for (int i = 0; i < 8; ++i) {
            byArray3[i] = (byte)(byArray[i] ^ byArray2[i]);
        }
    }

    private static void xorWith0x55andLshift(byte[] byArray) {
        byArray[0] = (byte)(byArray[0] ^ 0x55);
        byArray[1] = (byte)(byArray[1] ^ 0x55);
        byArray[2] = (byte)(byArray[2] ^ 0x55);
        byArray[3] = (byte)(byArray[3] ^ 0x55);
        byArray[4] = (byte)(byArray[4] ^ 0x55);
        byArray[5] = (byte)(byArray[5] ^ 0x55);
        byArray[6] = (byte)(byArray[6] ^ 0x55);
        byArray[7] = (byte)(byArray[7] ^ 0x55);
        byArray[0] = (byte)(byArray[0] << 1 | (byArray[1] & 0x80) >>> 7);
        byArray[1] = (byte)(byArray[1] << 1 | (byArray[2] & 0x80) >>> 7);
        byArray[2] = (byte)(byArray[2] << 1 | (byArray[3] & 0x80) >>> 7);
        byArray[3] = (byte)(byArray[3] << 1 | (byArray[4] & 0x80) >>> 7);
        byArray[4] = (byte)(byArray[4] << 1 | (byArray[5] & 0x80) >>> 7);
        byArray[5] = (byte)(byArray[5] << 1 | (byArray[6] & 0x80) >>> 7);
        byArray[6] = (byte)(byArray[6] << 1 | (byArray[7] & 0x80) >>> 7);
        byArray[7] = (byte)(byArray[7] << 1);
    }

    private static byte[] enc_des(byte[] byArray, byte[] byArray2) {
        int n;
        byte[] byArray3 = new byte[65];
        byte[] byArray4 = new byte[65];
        for (n = 0; n < 8; ++n) {
            byArray3[8 * n + 1] = (byte)((byArray2[n] & 0x80) == 0 ? 48 : 49);
            byArray3[8 * n + 2] = (byte)((byArray2[n] & 0x40) == 0 ? 48 : 49);
            byArray3[8 * n + 3] = (byte)((byArray2[n] & 0x20) == 0 ? 48 : 49);
            byArray3[8 * n + 4] = (byte)((byArray2[n] & 0x10) == 0 ? 48 : 49);
            byArray3[8 * n + 5] = (byte)((byArray2[n] & 8) == 0 ? 48 : 49);
            byArray3[8 * n + 6] = (byte)((byArray2[n] & 4) == 0 ? 48 : 49);
            byArray3[8 * n + 7] = (byte)((byArray2[n] & 2) == 0 ? 48 : 49);
            byArray3[8 * n + 8] = (byte)((byArray2[n] & 1) == 0 ? 48 : 49);
        }
        for (n = 0; n < 8; ++n) {
            byArray4[8 * n + 1] = (byte)((byArray[n] & 0x80) == 0 ? 48 : 49);
            byArray4[8 * n + 2] = (byte)((byArray[n] & 0x40) == 0 ? 48 : 49);
            byArray4[8 * n + 3] = (byte)((byArray[n] & 0x20) == 0 ? 48 : 49);
            byArray4[8 * n + 4] = (byte)((byArray[n] & 0x10) == 0 ? 48 : 49);
            byArray4[8 * n + 5] = (byte)((byArray[n] & 8) == 0 ? 48 : 49);
            byArray4[8 * n + 6] = (byte)((byArray[n] & 4) == 0 ? 48 : 49);
            byArray4[8 * n + 7] = (byte)((byArray[n] & 2) == 0 ? 48 : 49);
            byArray4[8 * n + 8] = (byte)((byArray[n] & 1) == 0 ? 48 : 49);
        }
        byte[] byArray5 = new byte[65];
        byte[] byArray6 = new byte[58];
        for (int i = 1; i <= 56; ++i) {
            byArray6[i] = byArray4[PC1[i - 1]];
        }
        AS400ImplRemote.lshift1(byArray6);
        byte[] byArray7 = new byte[49];
        for (int i = 1; i <= 48; ++i) {
            byArray7[i] = byArray6[PC2[i - 1]];
        }
        byte[] byArray8 = new byte[49];
        AS400ImplRemote.lshift1(byArray6);
        for (int i = 1; i <= 48; ++i) {
            byArray8[i] = byArray6[PC2[i - 1]];
        }
        byte[] byArray9 = new byte[49];
        AS400ImplRemote.lshift2(byArray6);
        for (int i = 1; i <= 48; ++i) {
            byArray9[i] = byArray6[PC2[i - 1]];
        }
        byte[] byArray10 = new byte[49];
        AS400ImplRemote.lshift2(byArray6);
        for (int i = 1; i <= 48; ++i) {
            byArray10[i] = byArray6[PC2[i - 1]];
        }
        byte[] byArray11 = new byte[49];
        AS400ImplRemote.lshift2(byArray6);
        for (int i = 1; i <= 48; ++i) {
            byArray11[i] = byArray6[PC2[i - 1]];
        }
        byte[] byArray12 = new byte[49];
        AS400ImplRemote.lshift2(byArray6);
        for (int i = 1; i <= 48; ++i) {
            byArray12[i] = byArray6[PC2[i - 1]];
        }
        byte[] byArray13 = new byte[49];
        AS400ImplRemote.lshift2(byArray6);
        for (int i = 1; i <= 48; ++i) {
            byArray13[i] = byArray6[PC2[i - 1]];
        }
        byte[] byArray14 = new byte[49];
        AS400ImplRemote.lshift2(byArray6);
        for (int i = 1; i <= 48; ++i) {
            byArray14[i] = byArray6[PC2[i - 1]];
        }
        byte[] byArray15 = new byte[49];
        AS400ImplRemote.lshift1(byArray6);
        for (int i = 1; i <= 48; ++i) {
            byArray15[i] = byArray6[PC2[i - 1]];
        }
        byte[] byArray16 = new byte[49];
        AS400ImplRemote.lshift2(byArray6);
        for (int i = 1; i <= 48; ++i) {
            byArray16[i] = byArray6[PC2[i - 1]];
        }
        byte[] byArray17 = new byte[49];
        AS400ImplRemote.lshift2(byArray6);
        for (int i = 1; i <= 48; ++i) {
            byArray17[i] = byArray6[PC2[i - 1]];
        }
        byte[] byArray18 = new byte[49];
        AS400ImplRemote.lshift2(byArray6);
        for (int i = 1; i <= 48; ++i) {
            byArray18[i] = byArray6[PC2[i - 1]];
        }
        byte[] byArray19 = new byte[49];
        AS400ImplRemote.lshift2(byArray6);
        for (int i = 1; i <= 48; ++i) {
            byArray19[i] = byArray6[PC2[i - 1]];
        }
        byte[] byArray20 = new byte[49];
        AS400ImplRemote.lshift2(byArray6);
        for (int i = 1; i <= 48; ++i) {
            byArray20[i] = byArray6[PC2[i - 1]];
        }
        byte[] byArray21 = new byte[49];
        AS400ImplRemote.lshift2(byArray6);
        for (int i = 1; i <= 48; ++i) {
            byArray21[i] = byArray6[PC2[i - 1]];
        }
        byte[] byArray22 = new byte[49];
        AS400ImplRemote.lshift1(byArray6);
        for (int i = 1; i <= 48; ++i) {
            byArray22[i] = byArray6[PC2[i - 1]];
        }
        byte[] byArray23 = new byte[33];
        byte[] byArray24 = new byte[33];
        for (int i = 1; i <= 32; ++i) {
            byArray23[i] = byArray3[INITPERM[i - 1]];
            byArray24[i] = byArray3[INITPERM[i + 31]];
        }
        AS400ImplRemote.cipher(byArray7, byArray23, byArray24);
        AS400ImplRemote.cipher(byArray8, byArray23, byArray24);
        AS400ImplRemote.cipher(byArray9, byArray23, byArray24);
        AS400ImplRemote.cipher(byArray10, byArray23, byArray24);
        AS400ImplRemote.cipher(byArray11, byArray23, byArray24);
        AS400ImplRemote.cipher(byArray12, byArray23, byArray24);
        AS400ImplRemote.cipher(byArray13, byArray23, byArray24);
        AS400ImplRemote.cipher(byArray14, byArray23, byArray24);
        AS400ImplRemote.cipher(byArray15, byArray23, byArray24);
        AS400ImplRemote.cipher(byArray16, byArray23, byArray24);
        AS400ImplRemote.cipher(byArray17, byArray23, byArray24);
        AS400ImplRemote.cipher(byArray18, byArray23, byArray24);
        AS400ImplRemote.cipher(byArray19, byArray23, byArray24);
        AS400ImplRemote.cipher(byArray20, byArray23, byArray24);
        AS400ImplRemote.cipher(byArray21, byArray23, byArray24);
        AS400ImplRemote.cipher(byArray22, byArray23, byArray24);
        System.arraycopy(byArray24, 1, byArray5, 1, 32);
        System.arraycopy(byArray23, 1, byArray5, 33, 32);
        byte[] byArray25 = new byte[65];
        for (int i = 1; i <= 64; ++i) {
            byArray25[i] = byArray5[OUTPERM[i - 1]];
        }
        byte[] byArray26 = new byte[8];
        for (int i = 0; i < 8; ++i) {
            if (byArray25[8 * i + 1] == 49) {
                int n2 = i;
                byArray26[n2] = (byte)(byArray26[n2] | 0x80);
            }
            if (byArray25[8 * i + 2] == 49) {
                int n3 = i;
                byArray26[n3] = (byte)(byArray26[n3] | 0x40);
            }
            if (byArray25[8 * i + 3] == 49) {
                int n4 = i;
                byArray26[n4] = (byte)(byArray26[n4] | 0x20);
            }
            if (byArray25[8 * i + 4] == 49) {
                int n5 = i;
                byArray26[n5] = (byte)(byArray26[n5] | 0x10);
            }
            if (byArray25[8 * i + 5] == 49) {
                int n6 = i;
                byArray26[n6] = (byte)(byArray26[n6] | 8);
            }
            if (byArray25[8 * i + 6] == 49) {
                int n7 = i;
                byArray26[n7] = (byte)(byArray26[n7] | 4);
            }
            if (byArray25[8 * i + 7] == 49) {
                int n8 = i;
                byArray26[n8] = (byte)(byArray26[n8] | 2);
            }
            if (byArray25[8 * i + 8] != 49) continue;
            int n9 = i;
            byArray26[n9] = (byte)(byArray26[n9] | 1);
        }
        return byArray26;
    }

    private static void cipher(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        int n;
        byte[] byArray4 = new byte[49];
        byte[] byArray5 = new byte[49];
        byte[] byArray6 = new byte[33];
        byte[] byArray7 = new byte[33];
        int[] nArray = new int[9];
        int[] nArray2 = new int[9];
        for (n = 1; n <= 48; ++n) {
            byArray4[n] = byArray3[EPERM[n - 1]];
        }
        for (n = 1; n <= 48; ++n) {
            byArray5[n] = byArray4[n] != byArray[n] ? 49 : 48;
        }
        nArray[1] = (byArray5[1] == 49 ? 32 : 0) | (byArray5[6] == 49 ? 16 : 0) | (byArray5[2] == 49 ? 8 : 0) | (byArray5[3] == 49 ? 4 : 0) | (byArray5[4] == 49 ? 2 : 0) | (byArray5[5] == 49 ? 1 : 0);
        nArray[2] = (byArray5[7] == 49 ? 32 : 0) | (byArray5[12] == 49 ? 16 : 0) | (byArray5[8] == 49 ? 8 : 0) | (byArray5[9] == 49 ? 4 : 0) | (byArray5[10] == 49 ? 2 : 0) | (byArray5[11] == 49 ? 1 : 0);
        nArray[3] = (byArray5[13] == 49 ? 32 : 0) | (byArray5[18] == 49 ? 16 : 0) | (byArray5[14] == 49 ? 8 : 0) | (byArray5[15] == 49 ? 4 : 0) | (byArray5[16] == 49 ? 2 : 0) | (byArray5[17] == 49 ? 1 : 0);
        nArray[4] = (byArray5[19] == 49 ? 32 : 0) | (byArray5[24] == 49 ? 16 : 0) | (byArray5[20] == 49 ? 8 : 0) | (byArray5[21] == 49 ? 4 : 0) | (byArray5[22] == 49 ? 2 : 0) | (byArray5[23] == 49 ? 1 : 0);
        nArray[5] = (byArray5[25] == 49 ? 32 : 0) | (byArray5[30] == 49 ? 16 : 0) | (byArray5[26] == 49 ? 8 : 0) | (byArray5[27] == 49 ? 4 : 0) | (byArray5[28] == 49 ? 2 : 0) | (byArray5[29] == 49 ? 1 : 0);
        nArray[6] = (byArray5[31] == 49 ? 32 : 0) | (byArray5[36] == 49 ? 16 : 0) | (byArray5[32] == 49 ? 8 : 0) | (byArray5[33] == 49 ? 4 : 0) | (byArray5[34] == 49 ? 2 : 0) | (byArray5[35] == 49 ? 1 : 0);
        nArray[7] = (byArray5[37] == 49 ? 32 : 0) | (byArray5[42] == 49 ? 16 : 0) | (byArray5[38] == 49 ? 8 : 0) | (byArray5[39] == 49 ? 4 : 0) | (byArray5[40] == 49 ? 2 : 0) | (byArray5[41] == 49 ? 1 : 0);
        nArray[8] = (byArray5[43] == 49 ? 32 : 0) | (byArray5[48] == 49 ? 16 : 0) | (byArray5[44] == 49 ? 8 : 0) | (byArray5[45] == 49 ? 4 : 0) | (byArray5[46] == 49 ? 2 : 0) | (byArray5[47] == 49 ? 1 : 0);
        nArray2[1] = S1[nArray[1]];
        nArray2[2] = S2[nArray[2]];
        nArray2[3] = S3[nArray[3]];
        nArray2[4] = S4[nArray[4]];
        nArray2[5] = S5[nArray[5]];
        nArray2[6] = S6[nArray[6]];
        nArray2[7] = S7[nArray[7]];
        nArray2[8] = S8[nArray[8]];
        AS400ImplRemote.dectobin(nArray2[1], byArray6, 1);
        AS400ImplRemote.dectobin(nArray2[2], byArray6, 5);
        AS400ImplRemote.dectobin(nArray2[3], byArray6, 9);
        AS400ImplRemote.dectobin(nArray2[4], byArray6, 13);
        AS400ImplRemote.dectobin(nArray2[5], byArray6, 17);
        AS400ImplRemote.dectobin(nArray2[6], byArray6, 21);
        AS400ImplRemote.dectobin(nArray2[7], byArray6, 25);
        AS400ImplRemote.dectobin(nArray2[8], byArray6, 29);
        for (n = 1; n <= 32; ++n) {
            byArray7[n] = byArray6[PPERM[n - 1]];
        }
        byte[] byArray8 = new byte[33];
        System.arraycopy(byArray3, 1, byArray8, 1, 32);
        for (int i = 1; i <= 32; ++i) {
            byArray3[i] = byArray2[i] == byArray7[i] ? 48 : 49;
        }
        System.arraycopy(byArray8, 1, byArray2, 1, 32);
    }

    private static void dectobin(int n, byte[] byArray, int n2) {
        byArray[n2] = (byte)((n & 8) != 0 ? 49 : 48);
        byArray[n2 + 1] = (byte)((n & 4) != 0 ? 49 : 48);
        byArray[n2 + 2] = (byte)((n & 2) != 0 ? 49 : 48);
        byArray[n2 + 3] = (byte)((n & 1) != 0 ? 49 : 48);
    }

    private static void lshift1(byte[] byArray) {
        byte[] byArray2 = new byte[]{byArray[1], byArray[29]};
        System.arraycopy(byArray, 2, byArray, 1, 27);
        System.arraycopy(byArray, 30, byArray, 29, 27);
        byArray[28] = byArray2[0];
        byArray[56] = byArray2[1];
    }

    private static void lshift2(byte[] byArray) {
        byte[] byArray2 = new byte[]{byArray[1], byArray[2], byArray[29], byArray[30]};
        System.arraycopy(byArray, 3, byArray, 1, 27);
        System.arraycopy(byArray, 31, byArray, 29, 27);
        byArray[27] = byArray2[0];
        byArray[28] = byArray2[1];
        byArray[55] = byArray2[2];
        byArray[56] = byArray2[3];
    }

    static {
        if (Trace.traceOn_) {
            Trace.logLoadPath(CLASSNAME);
        }
        AS400Server.addReplyStream((DataStream)new ChangePasswordRep(), 7);
        AS400Server.addReplyStream((DataStream)new AS400StrSvrReplyDS(), 7);
        AS400Server.addReplyStream((DataStream)new SignonGenAuthTokenReplyDS(), 7);
        AS400Server.addReplyStream((DataStream)new AS400GenAuthTknReplyDS(), 7);
        AS400Server.addReplyStream((DataStream)new AS400XChgRandSeedReplyDS(), 7);
        AS400Server.addReplyStream((DataStream)new SignonInfoRep(), 7);
        AS400Server.addReplyStream((DataStream)new SignonExchangeAttributeRep(), 7);
        EPERM = new int[]{32, 1, 2, 3, 4, 5, 4, 5, 6, 7, 8, 9, 8, 9, 10, 11, 12, 13, 12, 13, 14, 15, 16, 17, 16, 17, 18, 19, 20, 21, 20, 21, 22, 23, 24, 25, 24, 25, 26, 27, 28, 29, 28, 29, 30, 31, 32, 1};
        INITPERM = new int[]{58, 50, 42, 34, 26, 18, 10, 2, 60, 52, 44, 36, 28, 20, 12, 4, 62, 54, 46, 38, 30, 22, 14, 6, 64, 56, 48, 40, 32, 24, 16, 8, 57, 49, 41, 33, 25, 17, 9, 1, 59, 51, 43, 35, 27, 19, 11, 3, 61, 53, 45, 37, 29, 21, 13, 5, 63, 55, 47, 39, 31, 23, 15, 7};
        OUTPERM = new int[]{40, 8, 48, 16, 56, 24, 64, 32, 39, 7, 47, 15, 55, 23, 63, 31, 38, 6, 46, 14, 54, 22, 62, 30, 37, 5, 45, 13, 53, 21, 61, 29, 36, 4, 44, 12, 52, 20, 60, 28, 35, 3, 43, 11, 51, 19, 59, 27, 34, 2, 42, 10, 50, 18, 58, 26, 33, 1, 41, 9, 49, 17, 57, 25};
        PPERM = new int[]{16, 7, 20, 21, 29, 12, 28, 17, 1, 15, 23, 26, 5, 18, 31, 10, 2, 8, 24, 14, 32, 27, 3, 9, 19, 13, 30, 6, 22, 11, 4, 25};
        PC1 = new int[]{57, 49, 41, 33, 25, 17, 9, 1, 58, 50, 42, 34, 26, 18, 10, 2, 59, 51, 43, 35, 27, 19, 11, 3, 60, 52, 44, 36, 63, 55, 47, 39, 31, 23, 15, 7, 62, 54, 46, 38, 30, 22, 14, 6, 61, 53, 45, 37, 29, 21, 13, 5, 28, 20, 12, 4};
        PC2 = new int[]{14, 17, 11, 24, 1, 5, 3, 28, 15, 6, 21, 10, 23, 19, 12, 4, 26, 8, 16, 7, 27, 20, 13, 2, 41, 52, 31, 37, 47, 55, 30, 40, 51, 45, 33, 48, 44, 49, 39, 56, 34, 53, 46, 42, 50, 36, 29, 32};
        S1 = new int[]{14, 4, 13, 1, 2, 15, 11, 8, 3, 10, 6, 12, 5, 9, 0, 7, 0, 15, 7, 4, 14, 2, 13, 1, 10, 6, 12, 11, 9, 5, 3, 8, 4, 1, 14, 8, 13, 6, 2, 11, 15, 12, 9, 7, 3, 10, 5, 0, 15, 12, 8, 2, 4, 9, 1, 7, 5, 11, 3, 14, 10, 0, 6, 13};
        S2 = new int[]{15, 1, 8, 14, 6, 11, 3, 4, 9, 7, 2, 13, 12, 0, 5, 10, 3, 13, 4, 7, 15, 2, 8, 14, 12, 0, 1, 10, 6, 9, 11, 5, 0, 14, 7, 11, 10, 4, 13, 1, 5, 8, 12, 6, 9, 3, 2, 15, 13, 8, 10, 1, 3, 15, 4, 2, 11, 6, 7, 12, 0, 5, 14, 9};
        S3 = new int[]{10, 0, 9, 14, 6, 3, 15, 5, 1, 13, 12, 7, 11, 4, 2, 8, 13, 7, 0, 9, 3, 4, 6, 10, 2, 8, 5, 14, 12, 11, 15, 1, 13, 6, 4, 9, 8, 15, 3, 0, 11, 1, 2, 12, 5, 10, 14, 7, 1, 10, 13, 0, 6, 9, 8, 7, 4, 15, 14, 3, 11, 5, 2, 12};
        S4 = new int[]{7, 13, 14, 3, 0, 6, 9, 10, 1, 2, 8, 5, 11, 12, 4, 15, 13, 8, 11, 5, 6, 15, 0, 3, 4, 7, 2, 12, 1, 10, 14, 9, 10, 6, 9, 0, 12, 11, 7, 13, 15, 1, 3, 14, 5, 2, 8, 4, 3, 15, 0, 6, 10, 1, 13, 8, 9, 4, 5, 11, 12, 7, 2, 14};
        S5 = new int[]{2, 12, 4, 1, 7, 10, 11, 6, 8, 5, 3, 15, 13, 0, 14, 9, 14, 11, 2, 12, 4, 7, 13, 1, 5, 0, 15, 10, 3, 9, 8, 6, 4, 2, 1, 11, 10, 13, 7, 8, 15, 9, 12, 5, 6, 3, 0, 14, 11, 8, 12, 7, 1, 14, 2, 13, 6, 15, 0, 9, 10, 4, 5, 3};
        S6 = new int[]{12, 1, 10, 15, 9, 2, 6, 8, 0, 13, 3, 4, 14, 7, 5, 11, 10, 15, 4, 2, 7, 12, 9, 5, 6, 1, 13, 14, 0, 11, 3, 8, 9, 14, 15, 5, 2, 8, 12, 3, 7, 0, 4, 10, 1, 13, 11, 6, 4, 3, 2, 12, 9, 5, 15, 10, 11, 14, 1, 7, 6, 0, 8, 13};
        S7 = new int[]{4, 11, 2, 14, 15, 0, 8, 13, 3, 12, 9, 7, 5, 10, 6, 1, 13, 0, 11, 7, 4, 9, 1, 10, 14, 3, 5, 12, 2, 15, 8, 6, 1, 4, 11, 13, 12, 3, 7, 14, 10, 15, 6, 8, 0, 5, 9, 2, 6, 11, 13, 8, 1, 4, 10, 7, 9, 5, 0, 15, 14, 2, 3, 12};
        S8 = new int[]{13, 2, 8, 4, 6, 15, 11, 1, 10, 9, 3, 14, 5, 0, 12, 7, 1, 15, 13, 8, 10, 3, 7, 4, 12, 5, 6, 11, 0, 14, 9, 2, 7, 11, 4, 1, 9, 12, 14, 2, 0, 6, 10, 13, 15, 3, 5, 8, 2, 1, 14, 7, 4, 10, 8, 13, 15, 12, 9, 0, 3, 5, 6, 11};
    }
}

