/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.ClientAccessDataStream;
import com.ibm.as400.access.ConvTable;
import com.ibm.as400.access.DBDSPool;
import com.ibm.as400.access.DBDataStreamException;
import com.ibm.as400.access.DBOverlay;
import com.ibm.as400.access.DBStorage;
import com.ibm.as400.access.DataStreamCompression;
import com.ibm.as400.access.JDError;
import com.ibm.as400.access.Trace;
import java.io.ByteArrayOutputStream;
import java.io.CharConversionException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.sql.SQLException;

abstract class DBBaseRequestDS
extends ClientAccessDataStream {
    private static final String copyright = "Copyright (C) 1997-2003 International Business Machines Corporation and others.";
    private int currentOffset_;
    private int lockedLength_;
    private int operationResultBitmap_;
    private int parameterCount_;
    private boolean rleCompressed_ = false;
    private final DBStorage storage_ = DBDSPool.storagePool_.getUnusedStorage();
    public static final int ORS_BITMAP_RETURN_DATA = Integer.MIN_VALUE;
    public static final int ORS_BITMAP_MESSAGE_ID = 0x40000000;
    public static final int ORS_BITMAP_FIRST_LEVEL_TEXT = 0x20000000;
    public static final int ORS_BITMAP_SECOND_LEVEL_TEXT = 0x10000000;
    public static final int ORS_BITMAP_DATA_FORMAT = 0x8000000;
    public static final int ORS_BITMAP_RESULT_DATA = 0x4000000;
    public static final int ORS_BITMAP_SQLCA = 0x2000000;
    public static final int ORS_BITMAP_SERVER_ATTRIBUTES = 0x1000000;
    public static final int ORS_BITMAP_PARAMETER_MARKER_FORMAT = 0x800000;
    public static final int ORS_BITMAP_PACKAGE_INFO = 0x100000;
    public static final int ORS_BITMAP_REQUEST_RLE_COMPRESSION = 524288;
    public static final int ORS_BITMAP_REPLY_RLE_COMPRESSION = 262144;
    public static final int ORS_BITMAP_EXTENDED_COLUMN_DESCRIPTORS = 131072;
    public static final int ORS_BITMAP_VARIABLE_LENGTH_FIELD_COMPRESSION = 65536;
    public static final int ORS_BITMAP_CURSOR_ATTRIBUTES = 32768;
    protected static final int SERVER_SQL = 57348;
    protected static final int SERVER_NDB = 57349;
    protected static final int SERVER_ROI = 57350;
    private static final int RLE_THRESHOLD_ = 1064;

    protected DBBaseRequestDS(int n, int n2, int n3, int n4) {
        this.initialize(n, n2, n3, n4);
    }

    void initialize(int n, int n2, int n3, int n4) {
        this.data_ = this.storage_.data_;
        this.currentOffset_ = 40;
        this.parameterCount_ = 0;
        this.operationResultBitmap_ = n3;
        this.rleCompressed_ = false;
        this.lockedLength_ = 0;
        this.setHeaderID(0);
        this.setCSInstance(0);
        this.setTemplateLen(20);
        this.setReqRepID(n);
        this.set32bit(n3, 20);
        this.set16bit(n2, 28);
        this.set16bit(n2, 30);
        this.setBasedOnORSHandle(0);
        this.set16bit(n2, 34);
        this.setParameterMarkerDescriptorHandle(n4);
    }

    public void addOperationResultBitmap(int n) {
        this.operationResultBitmap_ |= n;
        this.set32bit(this.operationResultBitmap_, 20);
    }

    protected void addParameter(int n, byte by) throws DBDataStreamException {
        this.lock(1, n);
        this.data_[this.currentOffset_] = by;
        this.unlock();
    }

    protected void addParameter(int n, short s) throws DBDataStreamException {
        this.lock(2, n);
        this.set16bit(s, this.currentOffset_);
        this.unlock();
    }

    protected void addParameter(int n, short s, int n2) throws DBDataStreamException {
        this.lock(6, n);
        this.set16bit(s, this.currentOffset_);
        this.set32bit(n2, this.currentOffset_ + 2);
        this.unlock();
    }

    protected void addParameter(int n, int n2) throws DBDataStreamException {
        this.lock(4, n);
        this.set32bit(n2, this.currentOffset_);
        this.unlock();
    }

    protected void addParameter(int n, byte[] byArray) throws DBDataStreamException {
        if (byArray == null) {
            this.lock(0, n);
            this.unlock();
            if (Trace.traceOn_) {
                Trace.log(1, "Value is null, sending only length and codepoint.");
            }
        } else {
            this.addParameter(n, byArray, 0, byArray.length);
        }
    }

    protected void addParameter(int n, byte[] byArray, int n2, int n3) throws DBDataStreamException {
        this.lock(n3, n);
        System.arraycopy(byArray, n2, this.data_, this.currentOffset_, n3);
        this.unlock();
    }

    protected void addParameter(int n, byte[] byArray, boolean bl) throws DBDataStreamException {
        this.addParameter(n, byArray, 0, byArray.length, bl);
    }

    protected void addParameter(int n, byte[] byArray, int n2, int n3, boolean bl) throws DBDataStreamException {
        this.lock(byArray.length + 6, n);
        this.set16bit(-1, this.currentOffset_);
        this.set32bit(n3, this.currentOffset_ + 2);
        System.arraycopy(byArray, n2, this.data_, this.currentOffset_ + 6, n3);
        this.unlock();
    }

    protected void addParameter(int n, String string) throws DBDataStreamException {
        char[] cArray = string.toCharArray();
        this.lock(cArray.length + 2, n);
        this.set16bit(37, this.currentOffset_);
        int n2 = this.currentOffset_ + 2;
        int n3 = 0;
        while (n3 < cArray.length) {
            this.data_[n2] = cArray[n3] == ' ' ? 64 : (byte)(cArray[n3] | 0xF0);
            ++n3;
            ++n2;
        }
        this.unlock();
    }

    protected void addParameter(int n, ConvTable convTable, String string, int n2) throws DBDataStreamException {
        this.lock(n2 + 2, n);
        this.set16bit(convTable.ccsid_, this.currentOffset_);
        try {
            convTable.stringToByteArray(string.substring(0, n2), this.data_, this.currentOffset_ + 2);
        }
        catch (CharConversionException charConversionException) {
            throw new DBDataStreamException();
        }
        this.unlock();
    }

    protected void addParameter(int n, ConvTable convTable, String string) throws DBDataStreamException, SQLException {
        byte[] byArray = convTable.stringToByteArray(string);
        if (byArray.length > 65535) {
            JDError.throwSQLException("54001");
        }
        this.lock(byArray.length + 4, n);
        this.set16bit(convTable.ccsid_, this.currentOffset_);
        this.set16bit(byArray.length, this.currentOffset_ + 2);
        try {
            System.arraycopy(byArray, 0, this.data_, this.currentOffset_ + 4, byArray.length);
        }
        catch (Exception exception) {
            throw new DBDataStreamException();
        }
        this.unlock();
    }

    protected void addParameter(int n, boolean bl, ConvTable convTable, String string) throws DBDataStreamException, SQLException {
        byte[] byArray = convTable.stringToByteArray(string);
        if (byArray.length > 0x200000) {
            JDError.throwSQLException("54001");
        }
        this.lock(byArray.length + 6, n);
        this.set16bit(convTable.ccsid_, this.currentOffset_);
        this.set32bit(byArray.length, this.currentOffset_ + 2);
        try {
            System.arraycopy(byArray, 0, this.data_, this.currentOffset_ + 6, byArray.length);
        }
        catch (Exception exception) {
            throw new DBDataStreamException();
        }
        this.unlock();
    }

    protected void addParameter(int n, ConvTable convTable, String string, boolean bl) throws DBDataStreamException, SQLException {
        if (bl) {
            byte[] byArray = convTable.stringToByteArray(string);
            if (byArray.length > 65535) {
                JDError.throwSQLException("54001");
            }
            this.lock(byArray.length + 4, n);
            this.set16bit(convTable.ccsid_, this.currentOffset_);
            try {
                System.arraycopy(byArray, 0, this.data_, this.currentOffset_ + 2, byArray.length);
            }
            catch (Exception exception) {
                throw new DBDataStreamException();
            }
            this.unlock();
        } else {
            this.addParameter(n, convTable, string);
        }
    }

    protected void addParameter(int n) throws DBDataStreamException {
        this.lock(0, n);
        this.unlock();
    }

    protected void addParameter(int n, ConvTable convTable, char[] cArray, String[] stringArray) throws DBDataStreamException {
        int n2;
        int n3 = 4;
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            n3 += 3 + stringArray[n2].length();
        }
        this.lock(n3, n);
        this.set16bit(convTable.ccsid_, this.currentOffset_);
        this.set16bit(stringArray.length, this.currentOffset_ + 2);
        n2 = 4;
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                Character c = new Character(cArray[i]);
                convTable.stringToByteArray(c.toString(), this.data_, this.currentOffset_ + n2);
                this.set16bit(stringArray[i].length(), this.currentOffset_ + n2 + 1);
                convTable.stringToByteArray(stringArray[i], this.data_, this.currentOffset_ + n2 + 3);
                n2 += 3 + stringArray[i].length();
            }
        }
        catch (CharConversionException charConversionException) {
            throw new DBDataStreamException();
        }
        this.unlock();
    }

    protected void addParameter(int n, ConvTable convTable, int n2, String string, String string2, String string3) throws DBDataStreamException {
        int n3;
        switch (n2) {
            default: {
                n3 = 2;
                break;
            }
            case 1: 
            case 2: {
                n3 = 7;
                break;
            }
            case 3: {
                n3 = 8 + string.length() + string2.length();
            }
        }
        this.lock(n3, n);
        this.set16bit(n2, this.currentOffset_);
        try {
            switch (n2) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    this.set16bit(convTable.ccsid_, this.currentOffset_ + 2);
                    convTable.stringToByteArray(string3, this.data_, this.currentOffset_ + 4);
                    break;
                }
                case 3: {
                    this.set16bit(convTable.ccsid_, this.currentOffset_ + 2);
                    this.set16bit(string.length(), this.currentOffset_ + 4);
                    convTable.stringToByteArray(string, this.data_, this.currentOffset_ + 6);
                    this.set16bit(string2.length(), this.currentOffset_ + 6 + string.length());
                    convTable.stringToByteArray(string2, this.data_, this.currentOffset_ + 8 + string.length());
                    break;
                }
            }
        }
        catch (CharConversionException charConversionException) {
            throw new DBDataStreamException();
        }
        this.unlock();
    }

    protected void addParameter(int n, DBOverlay dBOverlay) throws DBDataStreamException {
        this.lock(dBOverlay.getLength(), n);
        dBOverlay.overlay(this.data_, this.currentOffset_);
        this.unlock();
    }

    public void clearOperationResultBitmap(int n) {
        if ((this.operationResultBitmap_ & n) != 0) {
            this.operationResultBitmap_ ^= n;
            this.set32bit(this.operationResultBitmap_, 20);
        }
    }

    public void compress() {
        this.rleCompressed_ = true;
    }

    void dump(PrintStream printStream) {
        DBBaseRequestDS.dump(printStream, this.data_, this.currentOffset_);
        if (this.rleCompressed_) {
            printStream.println("Request was sent RLE compressed.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void dump(PrintStream printStream, byte[] byArray, int n) {
        PrintStream printStream2 = printStream;
        synchronized (printStream2) {
            int n2;
            StringBuffer stringBuffer = new StringBuffer();
            StringBuffer stringBuffer2 = new StringBuffer();
            for (n2 = 0; n2 < n; ++n2) {
                short s;
                String string = "00" + Integer.toHexString(byArray[n2]);
                String string2 = string.substring(string.length() - 2);
                stringBuffer.append(string2.toUpperCase());
                if (n2 % 4 == 3) {
                    stringBuffer.append(" ");
                }
                int n3 = (s = (short)(byArray[n2] >= 0 ? byArray[n2] : 256 + byArray[n2])) >= 129 && s <= 137 ? (int)(97 + s - 129) : (s >= 145 && s <= 153 ? (int)(106 + s - 145) : (s >= 162 && s <= 169 ? (int)(115 + s - 162) : (s >= 193 && s <= 201 ? (int)(65 + s - 193) : (s >= 209 && s <= 217 ? (int)(74 + s - 209) : (s >= 226 && s <= 233 ? (int)(83 + s - 226) : (s >= 240 && s <= 249 ? (int)((char)(48 + s - 240)) : (byArray[n2] == 64 ? 32 : (byArray[n2] >= 32 && byArray[n2] <= 126 ? (int)((char)byArray[n2]) : 46))))))));
                stringBuffer2.append((char)n3);
                if (n2 % 16 != 15) continue;
                printStream.println(stringBuffer + "  [" + stringBuffer2 + "]");
                stringBuffer = new StringBuffer();
                stringBuffer2 = new StringBuffer();
            }
            if (n2 % 16 != 0) {
                int n4;
                for (int i = n4 = stringBuffer.length(); i <= 35; ++i) {
                    stringBuffer.append(" ");
                }
                printStream.println(stringBuffer + "  [" + stringBuffer2 + "]");
            }
        }
    }

    public int getOperationResultBitmap() {
        return this.operationResultBitmap_;
    }

    protected void finalize() throws Throwable {
        if (this.storage_ != null) {
            this.storage_.inUse_ = false;
        }
        this.data_ = null;
        super.finalize();
    }

    private void lock(int n, int n2) throws DBDataStreamException {
        if (this.storage_.checkSize(this.currentOffset_ + n + 6)) {
            this.data_ = this.storage_.data_;
        }
        this.lockedLength_ = n;
        this.set32bit(n + 6, this.currentOffset_);
        this.set16bit(n2, this.currentOffset_ + 4);
        this.currentOffset_ += 6;
    }

    public void setBasedOnORSHandle(int n) {
        this.set16bit(n, 32);
    }

    private void unlock() {
        this.currentOffset_ += this.lockedLength_;
        ++this.parameterCount_;
    }

    public void setParameterMarkerDescriptorHandle(int n) {
        this.set16bit(n, 36);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    void write(OutputStream var1_1) throws IOException {
        this.setLength(this.currentOffset_);
        this.set16bit(this.parameterCount_, 38);
        if (this.rleCompressed_) {
            if (this.currentOffset_ > 1064) {
                var2_2 = DBDSPool.storagePool_.getUnusedStorage();
                try {
                    var2_2.checkSize(this.currentOffset_);
                    var3_3 = var2_2.data_;
                    var4_4 = this.currentOffset_ - 40;
                    var5_5 = DataStreamCompression.compressRLE(this.data_, 40, var4_4, var3_3, 50, (byte)27);
                    if (var5_5 > 0) {
                        var6_6 = var5_5 + 50;
                        BinaryConverter.intToByteArray(var6_6, var3_3, 0);
                        System.arraycopy(this.data_, 4, var3_3, 4, 36);
                        BinaryConverter.intToByteArray(var5_5 + 10, var3_3, 40);
                        BinaryConverter.shortToByteArray((short)14386, var3_3, 44);
                        BinaryConverter.intToByteArray(var4_4, var3_3, 46);
                        var7_7 = var1_1;
                        synchronized (var7_7) {
                            var1_1.write(var3_3, 0, var6_6);
                            var1_1.flush();
                        }
                        if (!Trace.traceOn_) ** GOTO lbl36
                        Trace.log(0, "Data stream sent (connID=" + this.connectionID_ + ") ...", var3_3, 0, var6_6);
                    }
                    this.rleCompressed_ = false;
                }
                finally {
                    var2_2.inUse_ = false;
                }
            } else {
                this.rleCompressed_ = false;
            }
        }
lbl36:
        // 6 sources

        if (!this.rleCompressed_) {
            this.clearOperationResultBitmap(524288);
            var2_2 = var1_1;
            synchronized (var2_2) {
                var1_1.write(this.data_, 0, this.currentOffset_);
                var1_1.flush();
            }
            if (Trace.traceOn_ && !(var1_1 instanceof ByteArrayOutputStream)) {
                Trace.log(0, "Data stream sent (connID=" + this.connectionID_ + ") ...", this.data_, 0, this.currentOffset_);
            }
        }
    }
}

