/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.Trace;

class DataStreamCompression {
    private static final String copyright = "Copyright (C) 1997-2001 International Business Machines Corporation and others.";
    static final byte DEFAULT_ESCAPE = 27;
    static final int ESCAPE_SIZE = 1;
    static final int REPEATER_SIZE = 2;
    static final int COUNT_SIZE = 2;
    static final int REPEATER_RECORD_SIZE = 5;
    static final int ESCAPE_RECORD_SIZE = 2;

    private DataStreamCompression() {
    }

    static byte[] compressRLE(byte[] byArray, int n, int n2, byte by) {
        if (byArray == null) {
            throw new NullPointerException("source");
        }
        if (n >= byArray.length) {
            throw new ExtendedIllegalArgumentException("sourceOffset", 2);
        }
        if (n2 <= 0) {
            throw new ExtendedIllegalArgumentException("length", 2);
        }
        boolean bl = Trace.isTraceOn() && Trace.isTraceDiagnosticOn();
        byte[] byArray2 = new byte[n2];
        int n3 = DataStreamCompression.compressRLEInternal(byArray, n, n2, byArray2, 0, by);
        if (n3 >= 0) {
            byte[] byArray3 = new byte[n3];
            System.arraycopy(byArray2, 0, byArray3, 0, n3);
            return byArray3;
        }
        return null;
    }

    static int compressRLE(byte[] byArray, int n, int n2, byte[] byArray2, int n3, byte by) {
        if (byArray == null) {
            throw new NullPointerException("source");
        }
        if (n >= byArray.length) {
            throw new ExtendedIllegalArgumentException("sourceOffset", 2);
        }
        if (n2 <= 0) {
            throw new ExtendedIllegalArgumentException("length", 2);
        }
        if (byArray2 == null) {
            throw new NullPointerException("destinationOffset");
        }
        if (n3 >= byArray2.length) {
            throw new ExtendedIllegalArgumentException("destinationOffset", 2);
        }
        return DataStreamCompression.compressRLEInternal(byArray, n, n2, byArray2, n3, by);
    }

    private static int compressRLEInternal(byte[] byArray, int n, int n2, byte[] byArray2, int n3, byte by) {
        boolean bl = Trace.isTraceOn() && Trace.isTraceDiagnosticOn();
        int n4 = -1;
        int n5 = n;
        int n6 = n3;
        boolean bl2 = false;
        int n7 = n + n2;
        int n8 = byArray2.length;
        if (bl) {
            Trace.log(1, "compressRLE() sourceLength: " + n7);
        }
        while (n5 < n7 && !bl2) {
            if (byArray[n5] == by) {
                if (n6 + 2 <= n8) {
                    byArray2[n6++] = by;
                    byArray2[n6++] = by;
                    ++n5;
                    continue;
                }
                if (bl) {
                    Trace.log(1, "Overflow when writing out escape record starting at dest " + n6 + " ...");
                }
                bl2 = true;
                continue;
            }
            if (n5 + 1 >= n7) {
                if (n6 < n8) {
                    byArray2[n6++] = byArray[n5++];
                    continue;
                }
                if (bl) {
                    Trace.log(1, "Overflow when writing out last byte before EOD to dest " + n6 + " ...");
                }
                bl2 = true;
                continue;
            }
            if (byArray[n5 + 1] == by) {
                if (n6 + 1 + 2 <= n8) {
                    byArray2[n6++] = byArray[n5++];
                    byArray2[n6++] = by;
                    byArray2[n6++] = by;
                    ++n5;
                    continue;
                }
                if (bl) {
                    Trace.log(1, "Overflow when writing out single byte and escape record starting at dest " + n6 + " ...");
                }
                bl2 = true;
                continue;
            }
            int n9 = n5;
            int n10 = ((byArray[n5] & 0xFF) << 8) + (byArray[n5 + 1] & 0xFF);
            int n11 = 1;
            n5 += 2;
            while (n5 + 1 < n7 && n10 == ((byArray[n5] & 0xFF) << 8) + (byArray[n5 + 1] & 0xFF) && n11 < 65535) {
                ++n11;
                n5 += 2;
            }
            int n12 = n11 * 2;
            if (n12 >= 10) {
                if (n6 + 5 <= n8) {
                    byArray2[n6] = by;
                    byArray2[++n6] = (byte)(n10 >>> 8);
                    byArray2[++n6] = (byte)n10;
                    byArray2[++n6] = (byte)(n11 >>> 8);
                    byArray2[++n6] = (byte)n11;
                    ++n6;
                    continue;
                }
                if (bl) {
                    Trace.log(1, "Overflow when writing out RLE repeater record starting at dest " + n6 + " ...");
                }
                bl2 = true;
                continue;
            }
            n5 = n9;
            if (n6 + (n12 - 1) < n8) {
                for (int i = 0; i < n12; ++i) {
                    byArray2[n6++] = byArray[n5++];
                }
                continue;
            }
            if (bl) {
                Trace.log(1, "Overflow when writing out non-repeating bytes to dest " + n6 + " ...");
            }
            bl2 = true;
        }
        n4 = n6 - n3;
        if (!bl2 && n4 < n2) {
            if (bl) {
                Trace.log(1, "compressRLE() length of compressed bytes returned: " + n6);
            }
        } else {
            n4 = -1;
            if (bl) {
                Trace.log(1, "compressRLE() returning null (compressed size >= decompressed size)");
            }
        }
        return n4;
    }

    static byte[] decompressRLE(byte[] byArray, int n, int n2, int n3, byte by) {
        if (byArray == null) {
            throw new NullPointerException("source");
        }
        if (n >= byArray.length) {
            throw new ExtendedIllegalArgumentException("sourceOffset", 2);
        }
        if (n2 <= 0) {
            throw new ExtendedIllegalArgumentException("length", 2);
        }
        if (n3 < 0) {
            throw new ExtendedIllegalArgumentException("decompressedLength", 2);
        }
        byte[] byArray2 = n3 == 0 ? new byte[2048] : new byte[n3];
        return DataStreamCompression.decompressRLEInternal(byArray, n, n2, byArray2, 0, by, true);
    }

    static void decompressRLE(byte[] byArray, int n, int n2, byte[] byArray2, int n3, byte by) {
        if (byArray == null) {
            throw new NullPointerException("source");
        }
        if (n >= byArray.length) {
            throw new ExtendedIllegalArgumentException("sourceOffset", 2);
        }
        if (n2 <= 0) {
            throw new ExtendedIllegalArgumentException("length", 2);
        }
        if (byArray2 == null) {
            throw new NullPointerException("destination");
        }
        if (n3 >= byArray2.length) {
            throw new ExtendedIllegalArgumentException("destinationOffset", 2);
        }
        DataStreamCompression.decompressRLEInternal(byArray, n, n2, byArray2, n3, by, false);
    }

    private static byte[] decompressRLEInternal(byte[] byArray, int n, int n2, byte[] byArray2, int n3, byte by, boolean bl) {
        int n4;
        int n5;
        boolean bl2 = Trace.isTraceOn() && Trace.isTraceDiagnosticOn();
        boolean bl3 = Trace.isTraceOn() && Trace.isTraceErrorOn();
        int n6 = n;
        int n7 = n3;
        int n8 = -1;
        int n9 = -1;
        boolean bl4 = false;
        int n10 = 0;
        int n11 = n + n2;
        int n12 = byArray2.length;
        if (bl2) {
            Trace.log(1, "decompressRLE() sourceLength: " + n11);
            Trace.log(1, "decompressRLE() destinationLength: " + n12);
        }
        while (n6 < n11) {
            if (byArray[n6] == by) {
                if (n6 + 1 < n11) {
                    if (byArray[n6 + 1] == by) {
                        if (n7 < n12) {
                            byArray2[n7] = by;
                        } else {
                            if (bl2) {
                                Trace.log(1, "Overflow while decompressing RLE escape record starting at " + n7 + " ...");
                            }
                            if (!bl4) {
                                n8 = n6;
                                n9 = n7;
                            }
                            bl4 = true;
                            ++n10;
                        }
                        n6 += 2;
                        ++n7;
                        continue;
                    }
                    if (n6 + 2 + 2 < n11) {
                        int n13 = ((byArray[n6 + 1] & 0xFF) << 8) + (byArray[n6 + 1 + 1] & 0xFF);
                        n5 = ((byArray[n6 + 1 + 2] & 0xFF) << 8) + (byArray[n6 + 1 + 2 + 1] & 0xFF);
                        if (n7 + n5 * 2 <= n12) {
                            for (n4 = 1; n4 <= n5; ++n4) {
                                byArray2[n7] = (byte)(n13 >>> 8);
                                byArray2[n7 + 1] = (byte)n13;
                                n7 += 2;
                            }
                        } else {
                            if (bl2) {
                                Trace.log(1, "Overflow while decompressing RLE repeater record starting at dest " + n7 + " ...");
                            }
                            if (!bl4) {
                                n8 = n6;
                                n9 = n7;
                            }
                            bl4 = true;
                            n10 += n5 * 2;
                            n7 += n5 * 2;
                        }
                        n6 += 5;
                        continue;
                    }
                    if (bl3) {
                        Trace.log(2, "Don't have a complete RLE repeater record before EOD ...");
                    }
                    throw new InternalErrorException(5);
                }
                if (bl3) {
                    Trace.log(2, "Don't have a complete RLE escape record before EOD ...");
                }
                throw new InternalErrorException(5);
            }
            if (n7 < n12) {
                byArray2[n7++] = byArray[n6++];
                continue;
            }
            if (bl2) {
                Trace.log(1, "Overflow when writing out single bytes ...");
            }
            if (!bl4) {
                n8 = n6;
                n9 = n7;
            }
            bl4 = true;
            ++n10;
            ++n6;
            ++n7;
        }
        if (bl4 && bl) {
            n7 = n9;
            byte[] byArray3 = new byte[n7 + n10];
            n5 = byArray3.length;
            if (bl2) {
                Trace.log(1, "Overflow. Size updated to " + n5 + " bytes.");
            }
            System.arraycopy(byArray2, 0, byArray3, 0, n7);
            n6 = n8;
            bl4 = false;
            while (n6 < n11) {
                if (byArray[n6] == by) {
                    if (n6 + 1 < n11) {
                        if (byArray[n6 + 1] == by) {
                            byArray3[n7++] = by;
                            n6 += 2;
                            continue;
                        }
                        if (n6 + 2 + 2 < n11) {
                            n4 = ((byArray[n6 + 1] & 0xFF) << 8) + (byArray[n6 + 1 + 1] & 0xFF);
                            int n14 = ((byArray[n6 + 1 + 2] & 0xFF) << 8) + (byArray[n6 + 1 + 2 + 1] & 0xFF);
                            for (int i = 1; i <= n14; ++i) {
                                byArray3[n7] = (byte)(n4 >>> 8);
                                byArray3[n7 + 1] = (byte)n4;
                                n7 += 2;
                            }
                            n6 += 5;
                            continue;
                        }
                        if (bl3) {
                            Trace.log(2, "Don't have a complete RLE repeater record before EOD ...");
                        }
                        throw new InternalErrorException(5);
                    }
                    if (bl3) {
                        Trace.log(2, "Don't have a complete RLE escape record before EOD ...");
                    }
                    throw new InternalErrorException(5);
                }
                byArray3[n7++] = byArray[n6++];
            }
            return byArray3;
        }
        if (byArray2.length > n7 && bl) {
            byte[] byArray4 = new byte[n7];
            System.arraycopy(byArray2, n3, byArray4, 0, byArray4.length);
            return byArray4;
        }
        return byArray2;
    }
}

