/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400JDBCConnection;
import com.ibm.as400.access.AS400JDBCResultSet;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.DBDSPool;
import com.ibm.as400.access.DBData;
import com.ibm.as400.access.DBDataFormat;
import com.ibm.as400.access.DBDataStreamException;
import com.ibm.as400.access.DBReplyRequestedDS;
import com.ibm.as400.access.DBReturnObjectInformationRequestDS;
import com.ibm.as400.access.JDError;
import com.ibm.as400.access.JDFieldMap;
import com.ibm.as400.access.JDHardcodedFieldMap;
import com.ibm.as400.access.JDMappedRow;
import com.ibm.as400.access.JDMappedRowCache;
import com.ibm.as400.access.JDServerRow;
import com.ibm.as400.access.JDServerRowCache;
import com.ibm.as400.access.JDSimpleFieldMap;
import com.ibm.as400.access.JDSimpleRowCache;
import com.ibm.as400.access.JDTrace;
import com.ibm.as400.access.SQLConversionSettings;
import com.ibm.as400.access.SQLData;
import com.ibm.as400.access.SQLVarchar;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

class JDUtilities {
    private static final String copyright = "Copyright (C) 1997-2001 International Business Machines Corporation and others.";
    private static final byte escape = 27;
    static final int vrm610 = AS400.generateVRM(6, 1, 0);
    static final int vrm540 = AS400.generateVRM(5, 4, 0);
    static final int vrm530 = AS400.generateVRM(5, 3, 0);
    static final int vrm520 = AS400.generateVRM(5, 2, 0);
    static final int vrm510 = AS400.generateVRM(5, 1, 0);
    static final int vrm450 = AS400.generateVRM(4, 5, 0);
    static final int vrm440 = AS400.generateVRM(4, 4, 0);
    static final int vrm430 = AS400.generateVRM(4, 3, 0);
    static int JDBCLevel_ = 10;
    static int JVMLevel_ = 120;
    private static final Object bigDecimalLock_ = new Object();
    static Method toPlainStringMethod;
    static Object[] emptyArgs;

    JDUtilities() {
    }

    static final void decompress(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        int n4 = n;
        int n5 = n3;
        int n6 = n + n2;
        while (n4 < n6) {
            if (byArray[n4] == 27) {
                if (byArray[n4 + 1] == 27) {
                    byArray2[n5++] = 27;
                    n4 += 2;
                    continue;
                }
                int n7 = BinaryConverter.byteArrayToInt(byArray, n4 + 2);
                for (int i = 1; i <= n7; ++i) {
                    byArray2[n5++] = byArray[n4 + 1];
                }
                n4 += 6;
                continue;
            }
            byArray2[n5++] = byArray[n4++];
        }
    }

    static final String padZeros(int n, int n2) {
        String string = "000000000" + Integer.toString(n);
        return string.substring(string.length() - n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final ResultSet getLibraries(Object object, AS400JDBCConnection aS400JDBCConnection, SQLConversionSettings sQLConversionSettings, boolean bl) throws SQLException {
        aS400JDBCConnection.checkOpen();
        JDMappedRowCache jDMappedRowCache = null;
        if (sQLConversionSettings == null) {
            sQLConversionSettings = new SQLConversionSettings(aS400JDBCConnection);
        }
        int n = aS400JDBCConnection.getID();
        try {
            DBReturnObjectInformationRequestDS dBReturnObjectInformationRequestDS = null;
            DBReplyRequestedDS dBReplyRequestedDS = null;
            try {
                dBReturnObjectInformationRequestDS = DBDSPool.getDBReturnObjectInformationRequestDS(6144, n, -1946157056, 0);
                if (!bl) {
                    dBReturnObjectInformationRequestDS.setLibraryName("%", aS400JDBCConnection.converter_);
                    dBReturnObjectInformationRequestDS.setLibraryNameSearchPatternIndicator(241);
                }
                dBReturnObjectInformationRequestDS.setLibraryReturnInfoBitmap(Integer.MIN_VALUE);
                dBReplyRequestedDS = aS400JDBCConnection.sendAndReceive(dBReturnObjectInformationRequestDS);
                int n2 = dBReplyRequestedDS.getErrorClass();
                if (n2 != 0) {
                    int n3 = dBReplyRequestedDS.getReturnCode();
                    JDError.throwSQLException(object, aS400JDBCConnection, n, n2, n3);
                }
                DBDataFormat dBDataFormat = dBReplyRequestedDS.getDataFormat();
                DBData dBData = dBReplyRequestedDS.getResultData();
                JDServerRow jDServerRow = new JDServerRow(aS400JDBCConnection, n, dBDataFormat, sQLConversionSettings);
                JDSimpleRowCache jDSimpleRowCache = new JDSimpleRowCache(new JDServerRowCache(jDServerRow, aS400JDBCConnection, n, 1, dBData, true, 1004));
                boolean bl2 = JDBCLevel_ >= 30;
                JDFieldMap[] jDFieldMapArray = null;
                String[] stringArray = null;
                SQLData[] sQLDataArray = null;
                int[] nArray = null;
                if (!bl2) {
                    stringArray = new String[]{"TABLE_SCHEM"};
                    sQLDataArray = new SQLData[]{new SQLVarchar(128, sQLConversionSettings)};
                    nArray = new int[]{0};
                    jDFieldMapArray = new JDFieldMap[1];
                } else {
                    stringArray = new String[]{"TABLE_SCHEM", "TABLE_CATALOG"};
                    sQLDataArray = new SQLData[]{new SQLVarchar(128, sQLConversionSettings), new SQLVarchar(128, sQLConversionSettings)};
                    nArray = new int[]{0, 1};
                    jDFieldMapArray = new JDFieldMap[2];
                }
                jDFieldMapArray[0] = new JDSimpleFieldMap(1);
                if (bl2) {
                    jDFieldMapArray[1] = new JDHardcodedFieldMap(aS400JDBCConnection.getCatalog());
                }
                JDMappedRow jDMappedRow = new JDMappedRow(stringArray, sQLDataArray, nArray, jDFieldMapArray);
                jDMappedRowCache = new JDMappedRowCache(jDMappedRow, jDSimpleRowCache);
                Object var20_21 = null;
                if (dBReturnObjectInformationRequestDS != null) {
                    dBReturnObjectInformationRequestDS.inUse_ = false;
                }
                if (dBReplyRequestedDS != null) {
                    dBReplyRequestedDS.inUse_ = false;
                }
            }
            catch (Throwable throwable) {
                Object var20_22 = null;
                if (dBReturnObjectInformationRequestDS != null) {
                    dBReturnObjectInformationRequestDS.inUse_ = false;
                }
                if (dBReplyRequestedDS != null) {
                    dBReplyRequestedDS.inUse_ = false;
                }
                throw throwable;
            }
        }
        catch (DBDataStreamException dBDataStreamException) {
            JDError.throwSQLException(object, "HY000", dBDataStreamException);
        }
        return new AS400JDBCResultSet(jDMappedRowCache, aS400JDBCConnection.getCatalog(), "Schemas");
    }

    static final String stripOuterDoubleQuotes(String string) {
        if (string.startsWith("\"") && string.endsWith("\"")) {
            string = string.substring(1, string.length() - 1);
        }
        return string;
    }

    static final String prepareForDoubleQuotes(String string) {
        if ((string = JDUtilities.stripOuterDoubleQuotes(string)).indexOf(34) == -1) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        for (int i = string.length() - 1; i >= 0; --i) {
            if (stringBuffer.charAt(i) != '\"') continue;
            stringBuffer.insert(i, '\"');
        }
        return stringBuffer.toString();
    }

    static final String prepareForSingleQuotes(String string, boolean bl) {
        if (string.startsWith("\"") && string.endsWith("\"")) {
            string = string.substring(1, string.length() - 1);
        } else if (bl && string.indexOf(39) == -1) {
            string = string.toUpperCase();
        }
        if (string.indexOf(34) == -1 && string.indexOf(39) == -1) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        for (int i = string.length() - 1; i >= 0; --i) {
            char c = stringBuffer.charAt(i);
            if (c == '\"') {
                if (i <= 0 || stringBuffer.charAt(i - 1) != '\"') continue;
                stringBuffer.deleteCharAt(i);
                --i;
                continue;
            }
            if (c != '\'') continue;
            stringBuffer.insert(i, '\'');
        }
        return stringBuffer.toString();
    }

    static final String stripOutDoubleEmbededQuotes(String string) {
        if (string.startsWith("\"") && string.endsWith("\"")) {
            string = string.substring(1, string.length() - 1);
        }
        if (string.indexOf(34) == -1) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        for (int i = string.length() - 1; i >= 0; --i) {
            char c = stringBuffer.charAt(i);
            if (c != '\"' || i <= 0 || stringBuffer.charAt(i - 1) != '\"') continue;
            stringBuffer.deleteCharAt(i);
            --i;
        }
        return stringBuffer.toString();
    }

    static final String readerToString(Reader reader, int n) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            int n2;
            char[] cArray = new char[n == 0 ? 1 : n];
            int n3 = 0;
            while (reader.ready() && (n2 = reader.read(cArray)) >= 0) {
                stringBuffer.append(new String(cArray, 0, n2));
                n3 += n2;
            }
            if (n3 != n) {
                JDError.throwSQLException("HY090");
            }
        }
        catch (IOException iOException) {
            JDError.throwSQLException("HY105");
        }
        return stringBuffer.toString();
    }

    static final void runCommand(Connection connection, String string, boolean bl) throws SQLException {
        Statement statement = connection.createStatement();
        String string2 = "0000000000" + string.length();
        string2 = string2.substring(string2.length() - 10) + ".00000";
        String string3 = bl ? "CALL QSYS.QCMDEXC('" : "CALL QSYS/QCMDEXC('";
        String string4 = string3 + string + "', " + string2 + ")";
        statement.executeUpdate(string4);
        statement.close();
    }

    static final byte[] streamToBytes(InputStream inputStream, int n) throws SQLException {
        byte[] byArray = new byte[n];
        try {
            byte[] byArray2 = new byte[n == 0 ? 1 : n];
            int n2 = 0;
            while (inputStream.available() > 0) {
                int n3 = inputStream.read(byArray2);
                if (n2 + n3 <= n) {
                    System.arraycopy(byArray2, 0, byArray, n2, n3);
                }
                n2 += n3;
            }
            if (n2 < n) {
                JDError.throwSQLException("07006");
            }
        }
        catch (IOException iOException) {
            JDError.throwSQLException("HY105");
        }
        return byArray;
    }

    static final String streamToString(InputStream inputStream, int n, String string) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            byte[] byArray = new byte[n == 0 ? 1 : n];
            int n2 = 0;
            while (inputStream.available() > 0) {
                int n3 = inputStream.read(byArray);
                stringBuffer.append(new String(byArray, 0, n3, string));
                n2 += n3;
            }
            if (n2 != n) {
                JDError.throwSQLException("HY090");
            }
        }
        catch (IOException iOException) {
            JDError.throwSQLException("HY105");
        }
        return stringBuffer.toString();
    }

    static final String upperCaseIfNotQuoted(String string) {
        if (string.startsWith("\"")) {
            return string;
        }
        return string.toUpperCase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String bigDecimalToPlainString(BigDecimal bigDecimal) {
        if (JVMLevel_ >= 150) {
            Object object;
            if (toPlainStringMethod == null) {
                object = bigDecimalLock_;
                synchronized (object) {
                    if (toPlainStringMethod == null) {
                        try {
                            Class<?> clazz = Class.forName("java.math.BigDecimal");
                            Class[] classArray = new Class[]{};
                            toPlainStringMethod = clazz.getMethod("toPlainString", classArray);
                            emptyArgs = new Object[0];
                        }
                        catch (Exception exception) {
                            if (JDTrace.isTraceOn()) {
                                JDTrace.logException(null, "Exception while calling BigDecimal.toPlainString.", exception);
                            }
                            toPlainStringMethod = null;
                            return bigDecimal.toString();
                        }
                    }
                }
            }
            try {
                object = (String)toPlainStringMethod.invoke((Object)bigDecimal, emptyArgs);
            }
            catch (Exception exception) {
                if (JDTrace.isTraceOn()) {
                    JDTrace.logException(null, "Exception while calling BigDecimal.toPlainString.", exception);
                }
                object = bigDecimal.toString();
            }
            return object;
        }
        return bigDecimal.toString();
    }

    static {
        try {
            Class.forName("java.sql.Blob");
            JDBCLevel_ = 20;
            Class.forName("java.sql.Savepoint");
            JDBCLevel_ = 30;
            Class.forName("java.util.concurrent.Semaphore");
            JVMLevel_ = 150;
            Class.forName("java.sql.SQLXML");
            JDBCLevel_ = 40;
            JVMLevel_ = 160;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        toPlainStringMethod = null;
    }
}

