/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.ConvTable;
import com.ibm.as400.access.LicenseBaseReply;
import com.ibm.as400.access.Trace;
import java.io.UnsupportedEncodingException;

class LicenseGetReply
extends LicenseBaseReply {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    static final int REPLY_USAGE_LIMIT_LOCATION = 26;
    static final int REPLY_USAGE_COUNT_LOCATION = 30;
    static final int REPLY_USAGE_TYPE_LOCATION = 34;
    static final int REPLY_COMPLIANCE_TYPE_LOCATION = 36;
    static final int REPLY_LICENSE_TERM_CCSID_LOCATION = 38;
    static final int REPLY_LICENSE_TERM_LOCATION = 42;
    static final int REPLY_RELEASE_LEVEL_CCSID_LOCATION = 48;
    static final int REPLY_RELEASE_LEVEL_LOCATION = 52;

    LicenseGetReply() {
    }

    public Object getNewDataStream() {
        return new LicenseGetReply();
    }

    public int hashCode() {
        return 4097;
    }

    public int getUsageLimit() {
        return this.get32bit(26);
    }

    public int getUsageCount() {
        return this.get32bit(30);
    }

    public int getUsageType() {
        return this.get16bit(34);
    }

    public int getComplianceType() {
        return this.get16bit(36);
    }

    public String getLicenseTerm() {
        try {
            return ConvTable.getTable(this.get32bit(38), null).byteArrayToString(this.data_, 42, 6, 0);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            if (Trace.isTraceOn()) {
                Trace.log(1, "Unable to convert the license term so return null.");
            }
            return null;
        }
    }

    public String getReleaseLevel() {
        try {
            return ConvTable.getTable(this.get32bit(48), null).byteArrayToString(this.data_, 52, 6, 0);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            if (Trace.isTraceOn()) {
                Trace.log(1, "Unable to convert the release level so return null.");
            }
            return null;
        }
    }
}

