/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.data;

import com.ibm.as400.access.Trace;
import com.ibm.as400.data.PcmlException;
import com.ibm.as400.data.SystemResourceFinder;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.xml.sax.SAXException;

class XPCMLHelper {
    private static final String copyright = "Copyright (C) 1997-2003 International Business Machines Corporation and others.";

    XPCMLHelper() {
    }

    static void doTransform(String string, InputStream inputStream, OutputStream outputStream) throws TransformerException, TransformerConfigurationException, SAXException, IOException, PcmlException {
        StreamSource streamSource = new StreamSource(SystemResourceFinder.getXPCMLTransformFile(string));
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer(streamSource);
        transformer.transform(new StreamSource(inputStream), new StreamResult(outputStream));
    }

    static void doCondenseTransform(String string, InputStream inputStream, OutputStream outputStream, String string2) throws TransformerException, TransformerConfigurationException, SAXException, IOException, PcmlException {
        StreamSource streamSource = new StreamSource(SystemResourceFinder.getXPCMLTransformFile(string));
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer(streamSource);
        transformer.setParameter("xsdFileName", string2);
        StreamSource streamSource2 = new StreamSource(inputStream);
        transformer.transform(streamSource2, new StreamResult(outputStream));
    }

    static void doSimplifyXSDTransform(InputStream inputStream, OutputStream outputStream) throws SAXException, IOException {
        try {
            StreamSource streamSource = new StreamSource(SystemResourceFinder.getXPCMLTransformFile("xpcml_xpcml.xsl"));
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer(streamSource);
            transformer.transform(new StreamSource(inputStream), new StreamResult(outputStream));
        }
        catch (TransformerException transformerException) {
            Trace.log(2, transformerException);
            throw new SAXException(transformerException);
        }
    }
}

