/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.vaccess;

import com.ibm.as400.access.Permission;
import com.ibm.as400.access.Trace;
import com.ibm.as400.vaccess.ErrorEvent;
import com.ibm.as400.vaccess.ErrorEventSupport;
import com.ibm.as400.vaccess.ErrorListener;
import com.ibm.as400.vaccess.PermissionTableModelDLO;
import com.ibm.as400.vaccess.PermissionTableModelQSYS;
import com.ibm.as400.vaccess.PermissionTableModelRoot;
import com.ibm.as400.vaccess.ResourceLoader;
import com.ibm.as400.vaccess.VObjectCellRenderer;
import com.ibm.as400.vaccess.VObjectEventSupport;
import com.ibm.as400.vaccess.VObjectListener;
import com.ibm.as400.vaccess.WorkingEventSupport;
import com.ibm.as400.vaccess.WorkingListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JTextField;

class PermissionMainPanel
extends JPanel
implements ActionListener,
KeyListener {
    private static final String copyright = "Copyright (C) 1997-2001 International Business Machines Corporation and others.";
    private JTextField objectField;
    private JTextField typeField;
    private JTextField ownerField;
    private JTextField groupField;
    private JTextField listField;
    private JTextField userNameField;
    private JButton addButton;
    private JButton removeButton;
    private JButton okButton;
    private JButton cancelButton;
    private JButton applyButton;
    private Permission permission_;
    private JFrame frame_;
    private JTable table_ = null;
    private JDialog removeDialog_;
    private JDialog addDialog_;
    private PermissionTableModelDLO tableModelDLO_;
    private PermissionTableModelQSYS tableModelQSYS_;
    private PermissionTableModelRoot tableModelRoot_;
    private boolean listChanged = false;
    private static String addLabel_ = ResourceLoader.getText("DLG_ADD");
    private static String cancelLabel_ = ResourceLoader.getText("DLG_CANCEL");
    private static String removeLabel_ = ResourceLoader.getText("DLG_REMOVE");
    private static String okLabel_ = ResourceLoader.getText("DLG_OK");
    private static String yesLabel_ = ResourceLoader.getText("DLG_YES");
    private static String noLabel_ = ResourceLoader.getText("DLG_NO");
    private static String applyLabel_ = ResourceLoader.getText("DLG_APPLY");
    private static String objectName_ = ResourceLoader.getText("OBJECT_NAME");
    private static String objectType_ = ResourceLoader.getText("OBJECT_TYPE");
    private static String objectOwner_ = ResourceLoader.getText("OBJECT_OWNER");
    private static String primaryGroup_ = ResourceLoader.getText("OBJECT_GROUP");
    private static String authorizationList_ = ResourceLoader.getText("OBJECT_AUTHORIZATION_LIST");
    private static String objectPermission_ = ResourceLoader.getText("OBJECT_PERMISSION");
    private static String addDialogTitle_ = ResourceLoader.getText("OBJECT_ADD_DIALOG_TITLE");
    private static String removeDialogTitle_ = ResourceLoader.getText("OBJECT_REMOVE_DIALOG_TITLE");
    private static String addDialogMessage_ = ResourceLoader.getText("OBJECT_ADD_MESSAGE");
    private static String removeDialogMessage_ = ResourceLoader.getText("OBJECT_REMOVE_MESSAGE");
    private static String commitDialogMessage_ = ResourceLoader.getText("OBJECT_COMMIT_DIALOG_MESSAGE");
    private static String commitDialogTitle_ = ResourceLoader.getText("OBJECT_COMMIT_DIALOG_TITLE");
    private static String typeNoDefined_ = ResourceLoader.getText("OBJECT_TYPE_NO_DEFINED");
    private static String permissionDialogMessage_ = ResourceLoader.getText("OBJECT_PERMISSION_DIALOG_MESSAGE");
    private static String permissionDialogTitle_ = ResourceLoader.getText("OBJECT_PERMISSION_DIALOG_TITLE");
    private ErrorEventSupport errorEventSupport_ = new ErrorEventSupport(this);
    private VObjectEventSupport objectEventSupport_ = new VObjectEventSupport(this);
    private WorkingEventSupport workingEventSupport_ = new WorkingEventSupport(this);

    public PermissionMainPanel(Permission permission) {
        this.permission_ = permission;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        int n;
        int n2;
        String string;
        this.workingEventSupport_.fireStartWorking();
        if (actionEvent.getSource().equals(this.addButton) && (string = JOptionPane.showInputDialog(new JFrame(), addDialogMessage_, addDialogTitle_, -1)) != null) {
            n2 = this.permission_.getType();
            switch (n2) {
                case 0: {
                    this.tableModelDLO_.addRow(string);
                    break;
                }
                case 1: {
                    this.tableModelQSYS_.addRow(string);
                    break;
                }
                case 2: {
                    this.tableModelRoot_.addRow(string);
                }
            }
        }
        if (actionEvent.getSource().equals(this.removeButton) && (n = this.table_.getSelectedRow()) >= 0) {
            this.removeButton.setEnabled(false);
            this.applyButton.setEnabled(true);
            n2 = this.permission_.getType();
            switch (n2) {
                case 0: {
                    this.tableModelDLO_.removeRow(this.table_.getSelectedRow());
                    break;
                }
                case 1: {
                    this.tableModelQSYS_.removeRow(this.table_.getSelectedRow());
                    break;
                }
                case 2: {
                    this.tableModelRoot_.removeRow(this.table_.getSelectedRow());
                }
            }
            this.table_.clearSelection();
        }
        if (actionEvent.getSource().equals(this.okButton)) {
            if (this.applyButton.isEnabled()) {
                try {
                    if (this.listChanged) {
                        this.permission_.setAuthorizationList(this.listField.getText());
                        this.listChanged = false;
                    }
                    this.permission_.commit();
                    this.frame_.dispose();
                }
                catch (Exception exception) {
                    Trace.log(2, "commit : " + exception);
                    this.errorEventSupport_.fireError(exception);
                }
            } else {
                this.frame_.dispose();
            }
        }
        if (actionEvent.getSource().equals(this.cancelButton)) {
            this.frame_.dispose();
        }
        if (actionEvent.getSource().equals(this.applyButton)) {
            try {
                if (this.listChanged) {
                    this.permission_.setAuthorizationList(this.listField.getText());
                    this.listChanged = false;
                }
                this.permission_.commit();
                this.applyButton.setEnabled(false);
            }
            catch (Exception exception) {
                Trace.log(2, "commit : " + exception);
                this.errorEventSupport_.fireError(exception);
            }
        }
        this.workingEventSupport_.fireStopWorking();
    }

    public void addErrorListener(ErrorListener errorListener) {
        this.errorEventSupport_.addErrorListener(errorListener);
    }

    public void addVObjectListener(VObjectListener vObjectListener) {
        this.objectEventSupport_.addVObjectListener(vObjectListener);
    }

    public void addWorkingListener(WorkingListener workingListener) {
        this.workingEventSupport_.addWorkingListener(workingListener);
    }

    void createPermissionMainPanel() {
        this.setLayout(new BorderLayout(5, 8));
        PermissionMainPanel permissionMainPanel = this;
        JPanel jPanel = new JPanel(new BorderLayout(0, 5));
        JPanel jPanel2 = new JPanel(new GridLayout(2, 1));
        JLabel jLabel = new JLabel(objectName_, 2);
        this.objectField = new JTextField(this.permission_.getObjectPath());
        this.objectField.setEditable(false);
        jPanel2.add(jLabel);
        jPanel2.add(this.objectField);
        jPanel.add((Component)jPanel2, "North");
        JPanel jPanel3 = new JPanel(new GridLayout(1, 4, 8, 0));
        JPanel jPanel4 = new JPanel(new GridLayout(2, 1));
        JPanel jPanel5 = new JPanel(new GridLayout(2, 1));
        JPanel jPanel6 = new JPanel(new GridLayout(2, 1));
        JPanel jPanel7 = new JPanel(new GridLayout(2, 1));
        JLabel jLabel2 = new JLabel(objectType_);
        int n = this.permission_.getType();
        this.typeField = new JTextField(typeNoDefined_);
        switch (n) {
            case 0: {
                this.typeField = new JTextField("DLO");
                break;
            }
            case 1: {
                this.typeField = new JTextField("QSYS");
                break;
            }
            case 2: {
                this.typeField = new JTextField("ROOT");
            }
        }
        this.typeField.setEditable(false);
        jPanel4.add(jLabel2);
        jPanel4.add(this.typeField);
        jPanel3.add(jPanel4);
        JLabel jLabel3 = new JLabel(objectOwner_);
        this.ownerField = new JTextField(this.permission_.getOwner());
        this.ownerField.setEditable(false);
        jPanel5.add(jLabel3);
        jPanel5.add(this.ownerField);
        jPanel3.add(jPanel5);
        JLabel jLabel4 = new JLabel(primaryGroup_);
        this.groupField = new JTextField(this.permission_.getPrimaryGroup());
        this.groupField.setEditable(false);
        jPanel6.add(jLabel4);
        jPanel6.add(this.groupField);
        jPanel3.add(jPanel6);
        JLabel jLabel5 = new JLabel(authorizationList_);
        this.listField = new JTextField(this.permission_.getAuthorizationList());
        this.listField.addKeyListener(this);
        jPanel7.add(jLabel5);
        jPanel7.add(this.listField);
        jPanel3.add(jPanel7);
        jPanel.add((Component)jPanel3, "Center");
        JPanel jPanel8 = new JPanel(new GridLayout(4, 1));
        jPanel8.add(new JLabel());
        jPanel8.add(new JLabel());
        jPanel8.add(new JSeparator());
        jPanel8.add(new JLabel());
        jPanel.add((Component)jPanel8, "South");
        JPanel jPanel9 = new JPanel(new BorderLayout(0, 10));
        JPanel jPanel10 = new JPanel(new GridLayout(1, 6, 5, 0));
        jPanel10.add(new JLabel());
        jPanel10.add(new JLabel());
        jPanel10.add(new JLabel());
        jPanel10.add(new JLabel());
        this.addButton = new JButton(addLabel_);
        this.removeButton = new JButton(removeLabel_);
        this.addButton.addActionListener(this);
        this.removeButton.addActionListener(this);
        this.removeButton.setEnabled(false);
        jPanel10.add(this.addButton);
        jPanel10.add(this.removeButton);
        jPanel9.add((Component)jPanel10, "North");
        jPanel9.add((Component)new JSeparator(), "Center");
        JPanel jPanel11 = new JPanel(new GridLayout(1, 6, 5, 0));
        jPanel11.add(new JLabel());
        jPanel11.add(new JLabel());
        jPanel11.add(new JLabel());
        this.okButton = new JButton(okLabel_);
        this.cancelButton = new JButton(cancelLabel_);
        this.applyButton = new JButton(applyLabel_);
        this.okButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.applyButton.addActionListener(this);
        this.applyButton.setEnabled(false);
        jPanel11.add(this.okButton);
        jPanel11.add(this.cancelButton);
        jPanel11.add(this.applyButton);
        jPanel9.add((Component)jPanel11, "South");
        permissionMainPanel.add((Component)jPanel, "North");
        permissionMainPanel.add((Component)jPanel9, "South");
        permissionMainPanel.add((Component)this.getTablePane(), "Center");
        this.frame_ = new JFrame(ResourceLoader.substitute(objectPermission_, this.permission_.getName()));
        this.frame_.getContentPane().add(permissionMainPanel);
        ((Component)this.frame_).setSize(650, 450);
        ((Component)this.frame_).setVisible(true);
    }

    void fireError(Exception exception) {
        this.errorEventSupport_.fireError(new ErrorEvent(this, exception));
    }

    public JButton getApplyButton() {
        return this.applyButton;
    }

    public String getAutList() {
        return this.listField.getText().trim();
    }

    public Insets getInsets() {
        return new Insets(5, 8, 5, 8);
    }

    public JTextField getListField() {
        return this.listField;
    }

    public JButton getRemoveButton() {
        return this.removeButton;
    }

    private JComponent getTablePane() {
        int n = this.permission_.getType();
        switch (n) {
            case 0: {
                this.tableModelDLO_ = new PermissionTableModelDLO(this, this.permission_);
                this.table_ = new JTable(this.tableModelDLO_);
                this.tableModelDLO_.setTableInstance(this.table_);
                this.table_.setAutoResizeMode(0);
                break;
            }
            case 1: {
                this.tableModelQSYS_ = new PermissionTableModelQSYS(this, this.permission_);
                this.table_ = new JTable(this.tableModelQSYS_);
                this.tableModelQSYS_.setTableInstance(this.table_);
                this.table_.setAutoResizeMode(0);
                break;
            }
            case 2: {
                this.tableModelRoot_ = new PermissionTableModelRoot(this, this.permission_);
                this.table_ = new JTable(this.tableModelRoot_);
                this.tableModelRoot_.setTableInstance(this.table_);
                this.table_.setAutoResizeMode(0);
            }
        }
        JScrollPane jScrollPane = null;
        if (this.table_ != null) {
            this.table_.setAutoCreateColumnsFromModel(false);
            this.table_.setDefaultRenderer(this.table_.getColumnClass(0), new VObjectCellRenderer());
            this.table_.setCellSelectionEnabled(true);
            this.table_.selectAll();
            this.table_.setSelectionMode(0);
            this.table_.setSelectionBackground(Color.gray);
            this.table_.setShowGrid(false);
            this.table_.clearSelection();
            if (this.table_.getFont() != null) {
                int n2 = ((Component)this.table_).getFontMetrics(this.table_.getFont()).charWidth('W');
                this.table_.getColumnModel().getColumn(0).setWidth(10 * (n2 + 2) + 16);
            }
            jScrollPane = new JScrollPane(this.table_);
        }
        return jScrollPane;
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
        block0 : switch (keyEvent.getKeyCode()) {
            case 9: 
            case 10: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 27: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 144: 
            case 145: 
            case 154: 
            case 155: {
                break;
            }
            default: {
                if (!this.listChanged) {
                    this.listChanged = true;
                    this.applyButton.setEnabled(true);
                }
                if (!this.listField.getText().trim().toUpperCase().equals("*NONE")) break;
                int n = this.permission_.getType();
                switch (n) {
                    case 0: {
                        this.tableModelDLO_.resetPublicAuthorizationList();
                        break block0;
                    }
                    case 1: {
                        this.tableModelQSYS_.resetPublicAuthorizationList();
                        break block0;
                    }
                    case 2: {
                        this.tableModelRoot_.resetPublicAuthorizationList();
                    }
                }
            }
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void removeErrorListener(ErrorListener errorListener) {
        this.errorEventSupport_.removeErrorListener(errorListener);
    }

    public void removeVObjectListener(VObjectListener vObjectListener) {
        this.objectEventSupport_.removeVObjectListener(vObjectListener);
    }

    public void removeWorkingListener(WorkingListener workingListener) {
        this.workingEventSupport_.removeWorkingListener(workingListener);
    }
}

