/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.ui.util;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.CharConverter;
import com.ibm.as400.ui.framework.java.IllegalUserDataException;
import com.ibm.as400.ui.framework.java.MessageLog;
import com.ibm.as400.ui.util.AS400Formatter;
import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;

public class AS400CnameFormatter
extends AS400Formatter {
    private int m_maxLength = 256;

    public AS400CnameFormatter(AS400 aS400) {
        super(aS400);
    }

    public Object parse(String string) throws IllegalUserDataException {
        String string2 = string.trim();
        String string3 = AS400Formatter.m_loader.getString("badAS400Cname");
        Object[] objectArray = new Object[]{string2};
        String string4 = MessageFormat.format(string3, objectArray);
        if (string2.length() == 0) {
            throw new IllegalUserDataException(AS400Formatter.m_loader.getString("badMinLength"));
        }
        if (string2.length() > this.m_maxLength) {
            String string5 = AS400Formatter.m_loader.getString("badMaxLength");
            Object[] objectArray2 = new Object[]{new Integer(this.m_maxLength)};
            String string6 = MessageFormat.format(string5, objectArray2);
            throw new IllegalUserDataException(string6);
        }
        byte[] byArray = null;
        try {
            CharConverter charConverter = new CharConverter(this.m_iCCSID, this.m_system);
            byArray = charConverter.stringToByteArray(string2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            MessageLog.logError((Object)("Converting " + string2 + " threw an UnsupportedEncodingException: " + unsupportedEncodingException));
            throw new IllegalUserDataException(string4);
        }
        if (byArray[0] != 124 && byArray[0] != 123 && byArray[0] != 91 && !this.isAllowedWildCard(byArray[0], 1 == byArray.length) && !this.isValidEbcdicAlpha(byArray[0], this.m_iCCSID)) {
            throw new IllegalUserDataException(string4);
        }
        int n = 1;
        while (n < byArray.length) {
            if (!(byArray[n] == 124 || byArray[n] == 123 || byArray[n] == 91 || this.isAllowedWildCard(byArray[n], n == byArray.length - 1) || this.isValidEbcdicAlpha(byArray[n], this.m_iCCSID) || byArray[n] >= -16 && byArray[n] <= -7)) {
                throw new IllegalUserDataException(string4);
            }
            ++n;
        }
        return string2;
    }

    public void setMaxLength(int n) throws IllegalArgumentException {
        if (n < 1 || n > 256) {
            throw new IllegalArgumentException(AS400Formatter.m_loader.getString("illegalMaxLength"));
        }
        this.m_maxLength = n;
    }

    public int getMaxLength() {
        return this.m_maxLength;
    }

    private static String getCopyright() {
        return "(C)Copyright IBM Corp. 1998, 1999";
    }
}

