/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.ui.util;

import com.ibm.as400.ui.util.ClPanel;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.JList;
import javax.swing.UIManager;

class ClList
extends JList {
    boolean m_enabled = true;
    Color m_foreground;
    Color m_background;
    Color m_selectionForeground;
    Color m_selectionBackground;

    ClList() {
        this.setFont(ClPanel.m_scaledFont);
        this.saveColors();
    }

    ClList(Vector vector) {
        super(vector);
        this.setFont(ClPanel.m_scaledFont);
        this.saveColors();
    }

    ClList(String[] stringArray) {
        super(stringArray);
        this.setFont(ClPanel.m_scaledFont);
        this.saveColors();
    }

    private void saveColors() {
        this.m_selectionForeground = this.getSelectionForeground();
        this.m_selectionBackground = this.getSelectionBackground();
    }

    public void processEvent(AWTEvent aWTEvent) {
        if (aWTEvent instanceof MouseEvent && !this.m_enabled) {
            return;
        }
        super.processEvent(aWTEvent);
    }

    public void setEnabled(boolean bl) {
        this.m_enabled = bl;
        if (!this.m_enabled) {
            if (ClPanel.m_disabledBackgroundColor == null) {
                ClPanel.m_disabledBackgroundColor = UIManager.getColor("Panel.background");
            }
            if (ClPanel.m_enabledBackgroundColor == null) {
                ClPanel.m_enabledBackgroundColor = UIManager.getColor("TextField.background");
            }
            this.setSelectedIndex(-1);
            if (this.m_foreground == null) {
                this.m_foreground = this.getForeground();
            }
            if (this.m_background == null) {
                this.m_background = this.getBackground();
            }
            this.setForeground((Color)UIManager.get("textInactiveText"));
            this.setBackground(ClPanel.m_disabledBackgroundColor);
            this.setSelectionBackground(this.getBackground());
            this.setSelectionForeground(this.getForeground());
        } else {
            this.setForeground(this.m_foreground);
            this.setBackground(this.m_background);
            this.setSelectionBackground(this.m_selectionBackground);
            this.setSelectionForeground(this.m_selectionForeground);
        }
    }

    public boolean isFocusTraversable() {
        return this.m_enabled && this.getModel().getSize() > 0;
    }

    private static String getCopyright() {
        return "(C)Copyright IBM Corp. 1998, 1999";
    }
}

