/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iseries.debug;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.CommandCall;
import com.ibm.iseries.debug.BreakpointDescriptor;
import com.ibm.iseries.debug.DebugConstants;
import com.ibm.iseries.debug.DebugFrame;
import com.ibm.iseries.debug.dialog.ISeriesMessageDialog;
import com.ibm.iseries.debug.event.ContextEvent;
import com.ibm.iseries.debug.manager.BreakpointManager;
import com.ibm.iseries.debug.manager.ContextManager;
import com.ibm.iseries.debug.manager.CursorManager;
import com.ibm.iseries.debug.manager.LAFManager;
import com.ibm.iseries.debug.manager.SettingsManager;
import com.ibm.iseries.debug.manager.SourceViewManager;
import com.ibm.iseries.debug.panel.ConsolePanel;
import com.ibm.iseries.debug.util.Action;
import com.ibm.iseries.debug.util.ActionGroup;
import com.ibm.iseries.debug.util.CommLink;
import com.ibm.iseries.debug.util.CommLinkEvent;
import com.ibm.iseries.debug.util.CommLinkListener;
import com.ibm.iseries.debug.util.DebugContext;
import com.ibm.iseries.debug.util.DebugDesktop;
import com.ibm.iseries.debug.util.DebugPgmEnv;
import com.ibm.iseries.debug.util.DebugSource;
import com.ibm.iseries.debug.util.Dialog;
import com.ibm.iseries.debug.util.MRI;
import com.ibm.iseries.debug.util.Manager;
import com.ibm.iseries.debug.util.Menubar;
import com.ibm.iseries.debug.util.Packet;
import com.ibm.iseries.debug.util.Request;
import com.ibm.iseries.debug.util.Settings;
import com.ibm.iseries.debug.util.TabPanel;
import com.ibm.iseries.debug.util.TabbedPane;
import com.ibm.iseries.debug.util.Tokenizer;
import com.ibm.iseries.debug.util.Toolbar;
import com.ibm.iseries.debug.util.Toolbox;
import com.ibm.iseries.debug.util.Util;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.UnknownHostException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;

public abstract class AbstractDebugContext
implements DebugContext,
CommLinkListener,
DebugConstants {
    protected static final int ANIMATION_TIMER = 750;
    protected DebugFrame m_frame;
    protected DebugContext m_partnerCtxt;
    protected Menubar m_menuBar;
    protected Toolbar m_toolBar;
    protected JSplitPane m_mainSplitPane;
    protected JSplitPane m_topSplitPane;
    protected JSplitPane m_botSplitPane;
    protected JSplitPane m_srcSplitPane;
    protected TabbedPane m_topTabPane;
    protected TabbedPane m_botMainTabPane;
    protected TabbedPane m_botOtherTabPane;
    protected DebugDesktop m_desktop;
    protected DebugSource m_disassembly;
    protected DebugPgmEnv m_pgmEnv;
    protected AnimationTimer m_animationTimer;
    protected boolean m_animationPending;
    protected boolean m_animationActive;
    protected CommLink m_commLink;
    protected int m_connectAttempts;
    protected ActionGroup m_actionGroup;
    protected HashMap m_panels;
    protected HashMap m_mgrs;
    protected SettingsManager m_settingsMgr;
    protected ContextManager m_ctxtMgr;
    protected CursorManager m_cursorMgr;
    protected Dialog m_activeDialog;
    protected TabPanel m_activePanel;
    protected DebugSource m_activeSource;
    protected int m_varMask;
    protected int m_lastRunAction;
    protected int m_clockDepth;
    protected boolean m_initialized;
    protected boolean m_closed;
    protected String m_sysArg = "";
    protected String m_userArg = System.getProperty("user.name");
    protected String m_pgmArg = "";
    protected String m_pgmParmsArg = "";
    protected String m_jobIdArg = "";
    protected int m_pidArg = -1;

    public abstract void parseArgs(String[] var1);

    protected abstract void loadSettings(String var1, String var2, String var3);

    protected abstract DebugPgmEnv loadPgmEnv(Settings var1);

    protected abstract void loadManagers(Settings var1);

    protected abstract ActionGroup loadActionGroup(Settings var1);

    protected abstract Menubar loadMenuBar(Settings var1);

    protected abstract Toolbar loadToolBar(Settings var1);

    protected abstract DebugDesktop loadDesktop(Settings var1);

    protected abstract DebugSource loadDisassembly(Settings var1);

    protected abstract CommLink createCommLink() throws UnknownHostException;

    public AbstractDebugContext(DebugFrame debugFrame) {
        this.m_frame = debugFrame;
        this.m_animationTimer = new AnimationTimer();
        this.m_animationTimer.init();
        this.m_mgrs = new HashMap();
        this.m_panels = new HashMap();
        MRI.init();
    }

    public JFrame getJFrame() {
        return this.m_frame;
    }

    public void bringToFront() {
        this.m_frame.bringToFront(this);
    }

    public String getSystem() {
        return this.m_sysArg;
    }

    public double getSystemVersion() {
        return this.m_commLink != null ? this.m_commLink.getSystemVersion() : 0.0;
    }

    public String getUser() {
        return this.m_userArg;
    }

    public void postClock() {
        if (++this.m_clockDepth == 1) {
            this.getComponent().setCursor(Cursor.getPredefinedCursor(3));
            if (this.m_cursorMgr != null) {
                this.m_cursorMgr.firePostCursor(2);
            }
        }
    }

    public void retractClock() {
        if (--this.m_clockDepth <= 0) {
            this.getComponent().setCursor(Cursor.getPredefinedCursor(0));
            this.m_clockDepth = 0;
            if (this.m_cursorMgr != null) {
                this.m_cursorMgr.firePostCursor(1);
            }
        }
    }

    public void cancelClock() {
        this.getComponent().setCursor(Cursor.getPredefinedCursor(0));
        this.m_clockDepth = 0;
        if (this.m_cursorMgr != null) {
            this.m_cursorMgr.firePostCursor(1);
        }
    }

    public Dialog getActiveDialog() {
        return this.m_activeDialog;
    }

    public void setActiveDialog(Dialog dialog) {
        this.m_activeDialog = dialog;
    }

    public boolean sendRequest(Request request) {
        boolean bl = false;
        if (this.m_commLink != null && this.m_commLink.isConnected()) {
            try {
                bl = this.m_commLink.sendRequest(request);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            request.cleanUp();
        }
        return bl;
    }

    public Packet sendRequestAndWait(Request request, int n) {
        Packet packet = null;
        if (this.m_commLink != null && this.m_commLink.isConnected()) {
            try {
                packet = this.m_commLink.sendRequestAndWait(request, n);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            request.cleanUp();
        }
        return packet;
    }

    public boolean isSupported(int n, double d) {
        return false;
    }

    public DebugFrame getDebugFrame() {
        return this.m_frame;
    }

    public boolean isInitialized() {
        return this.m_initialized;
    }

    public void close() {
        this.m_frame.close();
    }

    public boolean isClosed() {
        return this.m_closed;
    }

    public void cleanUp() {
        if (this.m_closed) {
            return;
        }
        this.m_closed = true;
        this.stopAnimation();
        this.closeCommLink();
        if (this.m_pgmEnv != null) {
            this.m_pgmEnv.autoSave();
            this.m_pgmEnv.cleanUp();
        }
        this.m_actionGroup.cleanUp();
        this.m_menuBar.cleanUp();
        this.m_toolBar.cleanUp();
        this.m_desktop.cleanUp();
        if (this.m_disassembly != null) {
            this.m_disassembly.cleanUp();
        }
        this.commitUserConfig();
        this.cleanUpTabbedPanes();
        this.cleanUpPanels();
        this.cleanUpManagers();
    }

    public void clear(int n) {
        this.stopAnimation();
        if (this.m_commLink != null) {
            this.setDebugIcon(n);
        }
        this.m_actionGroup.clearAllContexts();
        this.m_actionGroup.setDefaultEnablement();
        this.m_menuBar.setDefaultEnablement();
        this.m_pgmArg = "";
        this.m_jobIdArg = "";
        this.m_pidArg = -1;
        this.setTitle();
        this.clearMessage();
        this.m_desktop.clear();
        this.m_topTabPane.clearPanels();
        this.m_botMainTabPane.clearPanels();
        this.m_botOtherTabPane.clearPanels();
        if (this.m_disassembly != null) {
            if (this.m_activeSource == this.m_disassembly) {
                this.m_disassembly.setActiveSource(false);
                this.m_activeSource = null;
            }
            this.m_disassembly.clear();
            this.enableAction("showdsm", false);
            this.enableAction("hidedsm", true);
        }
        this.m_activeSource = null;
        this.m_actionGroup.setActiveSource(null);
        if (this.m_pgmEnv != null) {
            this.m_pgmEnv.autoSave();
        }
        this.clearManagers();
        this.commitUserConfig();
    }

    public boolean hasPeerContext() {
        return this.m_frame.hasMultipleContexts();
    }

    public boolean hasPartnerContext() {
        return this.m_partnerCtxt != null;
    }

    public DebugContext getPartnerContext() {
        return this.m_partnerCtxt;
    }

    public void setPartnerContext(DebugContext debugContext) {
        this.m_partnerCtxt = debugContext;
    }

    public void removePartnerContext() {
        if (this.m_partnerCtxt != null) {
            this.m_frame.removeDebugContext(this.m_partnerCtxt);
        }
    }

    public boolean isMasterContext() {
        return this.m_frame.isMasterContext(this);
    }

    public boolean isSlaveContext() {
        return this.m_frame.isSlaveContext(this);
    }

    public void firstContextEvent() {
    }

    public void changeSystem(String string) {
        this.postClock();
        this.m_sysArg = string;
        this.getUserConfig().setString("system", this.m_sysArg);
        this.closeCommLink();
        this.setDebugIcon(0, null);
        this.getAction("strdbg").run();
        this.retractClock();
    }

    public String getJobId() {
        return this.m_jobIdArg;
    }

    public int getPID() {
        return this.m_pidArg;
    }

    public String getPgmPath() {
        return this.m_pgmArg;
    }

    public ActionGroup getActionGroup() {
        return this.m_actionGroup;
    }

    public Action getAction(String string) {
        return (Action)this.m_actionGroup.get(string);
    }

    public void enableAction(String string, boolean bl) {
        Action action = (Action)this.m_actionGroup.get(string);
        if (action != null) {
            action.setEnabled(bl);
        }
    }

    public void supportAction(String string, boolean bl) {
        Action action = (Action)this.m_actionGroup.get(string);
        if (action != null) {
            action.setSupported(bl);
        }
    }

    public JComponent getComponent() {
        return this.m_mainSplitPane;
    }

    public Menubar getMenubar() {
        return this.m_menuBar;
    }

    public Toolbar getToolbar() {
        return this.m_toolBar;
    }

    public DebugDesktop getDesktop() {
        return this.m_desktop;
    }

    public JComponent getDesktopNextFocusComponent() {
        JComponent jComponent = this.m_disassembly != null && this.m_activeSource != this.m_disassembly ? this.m_disassembly.getViewComponent() : (MRI.isLtoR() ? this.m_botMainTabPane : this.m_topTabPane);
        return jComponent;
    }

    public Manager getManager(String string) {
        return (Manager)this.m_mgrs.get(string);
    }

    public TabPanel getPanel(String string) {
        return (TabPanel)this.m_panels.get(string);
    }

    public DebugPgmEnv getPgmEnv() {
        return this.m_pgmEnv;
    }

    public DebugSource getDisassembly() {
        return this.m_disassembly;
    }

    public boolean isDisassemblyShown() {
        return this.m_disassembly != null;
    }

    public boolean isDisassemblyActive() {
        return this.m_disassembly != null && this.m_activeSource == this.m_disassembly;
    }

    public void showDisassembly(boolean bl, boolean bl2) {
        int n = this.m_topSplitPane.getDividerLocation();
        if (bl) {
            if (this.m_disassembly == null) {
                this.m_disassembly = this.loadDisassembly(this.m_settingsMgr.getConfig());
                this.m_srcSplitPane = new JSplitPane(0);
                this.m_srcSplitPane.setOneTouchExpandable(true);
                this.m_srcSplitPane.setDividerLocation(0.75);
                this.m_srcSplitPane.setResizeWeight(0.75);
                this.m_topSplitPane.remove(this.m_desktop.getComponent());
                this.m_srcSplitPane.setTopComponent(this.m_desktop.getComponent());
                this.m_srcSplitPane.setBottomComponent(this.m_disassembly.getComponent());
                if (MRI.isLtoR()) {
                    this.m_topSplitPane.setRightComponent(this.m_srcSplitPane);
                } else {
                    this.m_topSplitPane.setLeftComponent(this.m_srcSplitPane);
                }
                this.m_topSplitPane.setDividerLocation(n);
                this.m_topSplitPane.validate();
                this.m_desktop.closeSource(this.m_disassembly.getViewId());
                if (bl2 && this.m_ctxtMgr.getAsmContextLineNum() > 0) {
                    SourceViewManager sourceViewManager = (SourceViewManager)this.getManager("srcmgr");
                    sourceViewManager.requestSourceViewContext(this.m_ctxtMgr.getAsmContextViewId(), this.m_ctxtMgr.getAsmContextLineNum());
                }
            }
        } else if (this.m_disassembly != null) {
            this.m_disassembly.cleanUp();
            this.m_disassembly = null;
            this.m_topSplitPane.remove(this.m_srcSplitPane);
            this.m_srcSplitPane.removeAll();
            this.m_srcSplitPane = null;
            if (MRI.isLtoR()) {
                this.m_topSplitPane.setRightComponent(this.m_desktop.getComponent());
            } else {
                this.m_topSplitPane.setLeftComponent(this.m_desktop.getComponent());
            }
            this.m_topSplitPane.setDividerLocation(n);
            this.m_topSplitPane.validate();
            if (this.m_disassembly == this.m_activeSource) {
                this.m_activeSource = null;
                this.setActiveSource(this.m_desktop.getActiveViewId());
            }
        }
        this.enableAction("showdsm", !bl);
        this.enableAction("hidedsm", bl);
    }

    public Settings getConfig() {
        return this.m_settingsMgr.getConfig();
    }

    public Settings getUserConfig() {
        return this.m_settingsMgr.getUserConfig();
    }

    public void commitUserConfig() {
        this.saveContextConfig();
        this.m_settingsMgr.commitUserConfig();
    }

    public TabPanel getActivePanel() {
        return this.m_activePanel;
    }

    public void clearActivePanel() {
        this.m_activePanel = null;
        this.m_actionGroup.setActivePanel(null);
    }

    public void setActivePanel(TabPanel tabPanel) {
        if (this.m_closed) {
            return;
        }
        if (this.m_activePanel != null && tabPanel != this.m_activePanel) {
            this.m_activePanel.setActivePanel(false);
        }
        this.m_activePanel = tabPanel;
        this.m_activePanel.setActivePanel(true);
        if (tabPanel.canDoSuspend()) {
            this.enableAction("supd", !tabPanel.isSuspended());
            this.enableAction("rupd", tabPanel.isSuspended());
        } else {
            this.enableAction("supd", false);
            this.enableAction("rupd", false);
        }
        this.enableAction("cols", tabPanel.canDoColumns());
        this.enableAction("find", tabPanel.canDoFind());
        this.enableAction("copy", tabPanel.canDoCopy());
        this.enableAction("cpypnl", tabPanel.canDoCopyPanel());
        this.enableAction("goline", false);
        this.enableAction("goaddr", false);
        this.enableAction("chgview", false);
        this.m_actionGroup.setActivePanel(this.m_activePanel);
    }

    public DebugSource getActiveSource() {
        return this.m_activeSource;
    }

    public void setActiveSource(DebugSource debugSource) {
        if (this.m_activeSource != null && debugSource != this.m_activeSource) {
            this.m_activeSource.setActiveSource(false);
        }
        this.m_activeSource = debugSource;
        if (this.m_activeSource != null) {
            this.m_activeSource.setActiveSource(true);
        }
        this.enableAction("cols", false);
        this.enableAction("supd", false);
        this.enableAction("rupd", false);
        this.enableAction("cpypnl", false);
        if (this.m_activeSource == null) {
            this.enableAction("goline", false);
            this.enableAction("gometh", false);
            this.enableAction("goaddr", false);
            this.enableAction("chgview", false);
        } else {
            this.enableAction("find", true);
            this.enableAction("chgview", true);
            this.enableAction("goline", !this.m_activeSource.isAssembler());
            this.enableAction("gometh", !this.m_activeSource.isAssembler());
            this.enableAction("goaddr", this.m_activeSource.isAssembler());
        }
        this.m_actionGroup.setActivePanel(null);
        this.m_actionGroup.setActiveSource(this.m_activeSource);
    }

    public void setActiveSource(String string) {
        if (this.m_closed) {
            return;
        }
        if (this.m_activePanel != null) {
            this.m_activePanel.setActivePanel(false);
            this.m_activePanel = null;
        }
        DebugSource debugSource = null;
        debugSource = this.m_disassembly != null && this.m_disassembly.getViewId().equals(string) ? this.m_disassembly : this.m_desktop.getActiveSource();
        this.setActiveSource(debugSource);
    }

    public void setMessage(String string) {
        this.m_frame.setMessage(this, string);
    }

    public void clearMessage() {
        this.m_frame.clearMessage(this);
    }

    public void setDebugIcon(int n) {
        this.m_frame.setDebugIcon(this, n);
    }

    public void setDebugIcon(int n, String string) {
        this.m_frame.setDebugIcon(this, n, string);
    }

    public void setDebugIconTooltip(String string) {
        this.m_frame.setDebugIconTooltip(this, string);
    }

    public void allowRunAction(boolean bl) {
        this.m_ctxtMgr.allowRun(bl);
    }

    public boolean runActionAllowed() {
        return this.m_ctxtMgr.runAllowed();
    }

    public void runActionInitiated(int n) {
        this.m_lastRunAction = n;
        this.m_ctxtMgr.runInitiated();
    }

    public void startAnimationTimer() {
        this.m_animationPending = true;
        this.m_animationTimer.start();
        this.m_frame.clearMessage(this);
    }

    public void startAnimation() {
        if (!this.m_animationActive) {
            this.m_animationPending = false;
            this.m_animationActive = true;
            this.m_frame.setDebugIcon(this, 1);
            this.getActionGroup().setPgmRunning(true);
            ContextEvent contextEvent = new ContextEvent(this, 3);
            this.m_ctxtMgr.fireContextEvent(contextEvent);
        }
    }

    public void stopAnimation() {
        if (this.m_animationPending) {
            this.m_animationPending = false;
            this.m_animationTimer.stop();
        }
        if (this.m_animationActive) {
            this.m_animationActive = false;
            this.m_actionGroup.setPgmRunning(false);
        }
    }

    public int getVariableDisplayMask() {
        return this.m_varMask;
    }

    public int addToVariableDisplayMask(int n) {
        this.m_varMask |= n;
        return this.m_varMask;
    }

    public int removeFromVariableDisplayMask(int n) {
        this.m_varMask &= ~n;
        return this.m_varMask;
    }

    public boolean isConnected() {
        boolean bl = false;
        if (this.m_commLink != null) {
            bl = this.m_commLink.isConnected();
        }
        return bl;
    }

    protected boolean startDebugHub() {
        boolean bl = false;
        ConsolePanel consolePanel = (ConsolePanel)this.m_panels.get("console");
        try {
            AS400 aS400 = Toolbox.instance().getAS400(this.m_sysArg, this.m_userArg);
            if (aS400 != null) {
                Object[] objectArray = new Object[]{this.m_sysArg};
                String string = MessageFormat.format(MRI.get("DBGMGR_STRTCPSVR_FMT"), objectArray);
                if (consolePanel != null) {
                    consolePanel.logMsg(string);
                }
                this.m_frame.setMessage(this, string);
                CommandCall commandCall = new CommandCall(aS400);
                bl = commandCall.run("QSYS/STRTCPSVR SERVER(*DBG)");
                if (!bl) {
                    bl = commandCall.run("CALL PGM(QSYS/QTESSTRSVR)");
                }
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            Object[] objectArray = new Object[]{Util.firstUpper(this.m_sysArg)};
            String string = MessageFormat.format(MRI.get("DBG_COMMUNICATION_ERROR_FMT"), objectArray);
            if (consolePanel != null) {
                consolePanel.logMsg(string);
            }
            this.m_frame.setMessage(this, string);
            this.m_frame.setDebugIcon(this, 2, string);
            Util.errorMessage(this.m_frame, MRI.get("DBG_ERROR"), string);
        }
        catch (Throwable throwable) {
            this.m_frame.clearMessage(this);
            this.m_frame.setDebugIcon(this, 2, null);
            throwable.printStackTrace();
        }
        return bl;
    }

    protected boolean startDebugServer() {
        return false;
    }

    protected void validateDebugServer(double d) {
        this.m_actionGroup.setSupported(d);
    }

    public boolean establishCommLink(String string) {
        this.m_sysArg = string;
        return this.establishCommLink();
    }

    public boolean establishCommLink() {
        boolean bl = true;
        int n = -1;
        this.postClock();
        this.clearMessage();
        try {
            this.m_connectAttempts = 0;
            this.m_commLink = this.createCommLink();
            this.m_commLink.addListener(this);
        }
        catch (UnknownHostException unknownHostException) {
            Object[] objectArray = new Object[]{Util.firstUpper(this.m_sysArg)};
            String string = MessageFormat.format(MRI.get("DBG_UNKNOWN_HOST_SYSTEM_FMT"), objectArray);
            String string2 = MRI.get("DBG_ERROR");
            Util.errorMessage(this.m_frame, string2, string);
            this.retractClock();
            return false;
        }
        ++this.m_connectAttempts;
        bl = this.m_commLink.connect(false);
        this.m_sysArg = this.m_commLink.getSystem();
        this.m_userArg = this.m_commLink.getUser();
        if (!bl && this.m_commLink.getStatus() == -1 && this.startDebugHub()) {
            ++this.m_connectAttempts;
            bl = this.m_commLink.connect(false);
            this.m_sysArg = this.m_commLink.getSystem();
            this.m_userArg = this.m_commLink.getUser();
        }
        if (bl && (bl = this.startDebugServer())) {
            bl = this.m_commLink.relay(true);
        }
        if (!bl) {
            this.closeCommLink();
            this.retractClock();
        } else {
            this.validateDebugServer(this.m_commLink.getSystemVersion());
        }
        this.setTitle();
        this.retractClock();
        return bl;
    }

    public void closeCommLink() {
        try {
            if (this.m_commLink != null) {
                this.m_commLink.removeListener(this);
                this.m_commLink.close();
                this.m_commLink.cleanUp();
                this.m_commLink = null;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public String getCommLinkId() {
        return this.m_commLink != null ? this.m_commLink.getSystem() : "";
    }

    public void updateBreakpointActions() {
        this.enableAction("dgrp", false);
        this.enableAction("grpp", false);
        this.enableAction("abrk", false);
        this.enableAction("rbrk", false);
        this.enableAction("ebrk", false);
        this.enableAction("dbrk", false);
        this.enableAction("brkp", false);
        this.enableAction("editbrk", false);
        BreakpointManager breakpointManager = (BreakpointManager)this.getManager("brkmgr");
        this.enableAction("rabrk", breakpointManager.hasBreakpoints());
        this.enableAction("gosrc", false);
    }

    public void updateBreakpointActions(BreakpointDescriptor breakpointDescriptor) {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        if (breakpointDescriptor != null) {
            switch (breakpointDescriptor.getState()) {
                case 1: {
                    bl5 = true;
                    bl4 = true;
                    bl2 = true;
                    break;
                }
                case 2: {
                    bl5 = true;
                    bl3 = true;
                    bl2 = true;
                    break;
                }
                case 0: {
                    bl = true;
                }
            }
        } else {
            bl = true;
        }
        this.enableAction("dgrp", false);
        this.enableAction("grpp", false);
        this.enableAction("abrk", bl);
        this.enableAction("rbrk", bl2);
        this.enableAction("ebrk", bl3);
        this.enableAction("dbrk", bl4);
        this.enableAction("brkp", bl5);
        this.enableAction("editbrk", bl5);
        BreakpointManager breakpointManager = (BreakpointManager)this.getManager("brkmgr");
        this.enableAction("rabrk", breakpointManager.hasBreakpoints());
        this.enableAction("gosrc", false);
    }

    public void updateBreakpointActions(boolean bl, int n, ArrayList arrayList) {
        Object object;
        int n2 = arrayList.size();
        boolean bl2 = false;
        boolean bl3 = n2 > 0;
        boolean bl4 = false;
        boolean bl5 = false;
        int n3 = 0;
        while (n3 < n2) {
            object = (BreakpointDescriptor)arrayList.get(n3);
            if (!bl4 && ((BreakpointDescriptor)object).isDisabled()) {
                bl4 = true;
                if (bl5) break;
            }
            if (!bl5 && ((BreakpointDescriptor)object).isEnabled()) {
                bl5 = true;
                if (bl4) break;
            }
            ++n3;
        }
        this.enableAction("dgrp", bl && n > 0);
        this.enableAction("grpp", bl && n == 1);
        this.enableAction("abrk", bl2);
        this.enableAction("rbrk", bl3);
        this.enableAction("ebrk", bl4);
        this.enableAction("dbrk", bl5);
        this.enableAction("brkp", n2 == 1);
        this.enableAction("editbrk", bl3);
        object = (BreakpointManager)this.getManager("brkmgr");
        this.enableAction("rabrk", ((BreakpointManager)object).hasBreakpoints());
        if (n2 == 1) {
            this.enableAction("gosrc", true);
            BreakpointDescriptor breakpointDescriptor = (BreakpointDescriptor)arrayList.get(0);
            this.getActionGroup().setGotoSrcContext(breakpointDescriptor.getViewId(), breakpointDescriptor.getLineNum());
        } else {
            this.enableAction("gosrc", false);
        }
    }

    public void setTitle(String string) {
        this.m_frame.setTitle(this, string);
    }

    public void loadConfig() {
        Settings settings = this.m_settingsMgr.getConfig();
        Settings settings2 = this.m_settingsMgr.getUserConfig();
        boolean bl = settings2.getBool("varsHex", false);
        boolean bl2 = settings2.getBool("varsEBCDIC", true);
        boolean bl3 = settings2.getBool("varsASCII", false);
        boolean bl4 = settings2.getBool("varsUNICODE", false);
        if (bl) {
            this.m_varMask |= 1;
        }
        if (bl2) {
            this.m_varMask |= 2;
        } else if (bl3) {
            this.m_varMask |= 4;
        } else if (bl4) {
            this.m_varMask |= 8;
        }
        String string = System.getProperty("os.name");
        String string2 = string.startsWith("Windows") ? "com.sun.java.swing.plaf.windows.WindowsLookAndFeel" : UIManager.getCrossPlatformLookAndFeelClassName();
        String string3 = settings2.getString("lookAndFeel", string2);
        LAFManager.instance().setLookAndFeel(string3, false);
        this.m_pgmEnv = this.loadPgmEnv(settings);
        this.loadManagers(settings);
        this.m_ctxtMgr = (ContextManager)this.m_mgrs.get("ctxtmgr");
        this.m_cursorMgr = (CursorManager)this.m_mgrs.get("cursormgr");
        this.m_actionGroup = this.loadActionGroup(settings);
        this.m_menuBar = this.loadMenuBar(settings);
        this.m_toolBar = this.loadToolBar(settings);
        this.m_desktop = this.loadDesktop(settings);
        this.m_topTabPane = new TabbedPane(this);
        this.m_botMainTabPane = new TabbedPane(this);
        this.m_botOtherTabPane = new TabbedPane(this);
        this.m_topSplitPane = MRI.isLtoR() ? new JSplitPane(1, this.m_topTabPane, this.m_desktop.getComponent()) : new JSplitPane(1, this.m_desktop.getComponent(), this.m_topTabPane);
        this.m_topSplitPane.setOneTouchExpandable(true);
        this.m_botSplitPane = MRI.isLtoR() ? new JSplitPane(1, this.m_botMainTabPane, this.m_botOtherTabPane) : new JSplitPane(1, this.m_botOtherTabPane, this.m_botMainTabPane);
        this.m_botSplitPane.setOneTouchExpandable(true);
        this.m_mainSplitPane = new JSplitPane(0, this.m_topSplitPane, this.m_botSplitPane);
        this.m_mainSplitPane.setOneTouchExpandable(true);
        this.loadTabs(settings);
        this.loadContextConfig();
    }

    protected void loadTabs(Settings settings) {
        this.loadTabPanels(this.m_topTabPane, settings, "topTabs");
        this.loadTabPanels(this.m_botMainTabPane, settings, "botMainTabs");
        this.loadTabPanels(this.m_botOtherTabPane, settings, "botOtherTabs");
    }

    protected void loadTabPanels(TabbedPane tabbedPane, Settings settings, String string) {
        String string2 = settings.getString("panelPkg", "");
        String[] stringArray = Tokenizer.tokenize(settings.getString(string, ""));
        int n = 0;
        while (n < stringArray.length) {
            String string3 = stringArray[n].startsWith("com.ibm.iseries") ? stringArray[n] : string2 + "." + stringArray[n];
            Object object = Util.loadObject(string3);
            if (object != null && object instanceof TabPanel) {
                TabPanel tabPanel = (TabPanel)object;
                tabbedPane.addTab(tabPanel);
                this.m_panels.put(tabPanel.getKey(), tabPanel);
            }
            ++n;
        }
    }

    protected void loadContextConfig() {
        Settings settings = this.m_settingsMgr.getUserConfig();
        Dimension dimension = new Dimension(0, 0);
        int n = settings.getInt("topWidth", 250);
        int n2 = settings.getInt("topHeight", 325);
        int n3 = settings.getInt("topDiv", 250);
        int n4 = settings.getInt("botDiv", 375);
        int n5 = settings.getInt("mainDiv", 325);
        this.m_topTabPane.setMinimumSize(dimension);
        this.m_topTabPane.setPreferredSize(new Dimension(n, n2));
        this.m_topSplitPane.setDividerLocation(n3);
        this.m_mainSplitPane.setDividerLocation(n5);
        n = settings.getInt("srcWidth", 500);
        n2 = settings.getInt("srcHeight", 325);
        this.m_desktop.getComponent().setMinimumSize(dimension);
        this.m_desktop.getComponent().setPreferredSize(new Dimension(n, n2));
        n = settings.getInt("botMainWidth", 375);
        n2 = settings.getInt("botMainHeight", 225);
        this.m_botMainTabPane.setMinimumSize(dimension);
        this.m_botMainTabPane.setPreferredSize(new Dimension(n, n2));
        this.m_botSplitPane.setDividerLocation(n4);
        n = settings.getInt("botOtherWidth", 375);
        n2 = settings.getInt("botOtherHeight", 225);
        this.m_botOtherTabPane.setMinimumSize(dimension);
        this.m_botOtherTabPane.setPreferredSize(new Dimension(n, n2));
    }

    protected void saveContextConfig() {
        Settings settings = this.m_settingsMgr.getUserConfig();
        Rectangle rectangle = this.m_frame.getBounds();
        Rectangle rectangle2 = this.m_desktop.getComponent().getBounds();
        Rectangle rectangle3 = this.m_topTabPane.getBounds();
        Rectangle rectangle4 = this.m_botMainTabPane.getBounds();
        Rectangle rectangle5 = this.m_botOtherTabPane.getBounds();
        int n = this.hasPartnerContext() ? this.getDebugFrame().getTabHeight() : 0;
        settings.setInt("windowTop", rectangle.y);
        settings.setInt("windowLeft", rectangle.x);
        settings.setInt("topWidth", rectangle3.width);
        settings.setInt("topHeight", rectangle3.height);
        settings.setInt("topDiv", this.m_topSplitPane.getDividerLocation());
        settings.setInt("botDiv", this.m_botSplitPane.getDividerLocation());
        settings.setInt("mainDiv", this.m_mainSplitPane.getDividerLocation());
        settings.setInt("srcWidth", rectangle2.width);
        settings.setInt("srcHeight", rectangle2.height);
        settings.setInt("botMainWidth", rectangle4.width);
        settings.setInt("botMainHeight", rectangle4.height + n);
        settings.setInt("botOtherWidth", rectangle5.width);
        settings.setInt("botOtherHeight", rectangle5.height + n);
        this.m_topTabPane.saveSettings();
        this.m_botMainTabPane.saveSettings();
        this.m_botOtherTabPane.saveSettings();
        settings.setString("lookAndFeel", LAFManager.instance().getLookAndFeel());
    }

    protected void clearManagers() {
        Iterator iterator = this.m_mgrs.values().iterator();
        while (iterator.hasNext()) {
            Manager manager = (Manager)iterator.next();
            manager.clear();
            manager.init();
        }
    }

    protected void cleanUpTabbedPanes() {
        this.m_topTabPane.cleanUp();
        this.m_botMainTabPane.cleanUp();
        this.m_botOtherTabPane.cleanUp();
    }

    protected void cleanUpManagers() {
        Iterator iterator = this.m_mgrs.values().iterator();
        while (iterator.hasNext()) {
            Manager manager = (Manager)iterator.next();
            manager.cleanUp();
        }
        this.m_mgrs.clear();
        this.m_mgrs = null;
    }

    protected void cleanUpPanels() {
        Iterator iterator = this.m_panels.values().iterator();
        while (iterator.hasNext()) {
            TabPanel tabPanel = (TabPanel)iterator.next();
            tabPanel.cleanUp();
        }
        this.m_panels.clear();
        this.m_panels = null;
    }

    public void commLinkStatusChanged(CommLinkEvent commLinkEvent) {
        if (this.m_closed || this.m_commLink == null) {
            return;
        }
        CommLink commLink = (CommLink)commLinkEvent.getSource();
        ConsolePanel consolePanel = (ConsolePanel)this.m_panels.get("console");
        switch (commLinkEvent.getType()) {
            case -1: {
                Object[] objectArray = new Object[]{Util.firstUpper(commLink.getSystem())};
                String string = MessageFormat.format(MRI.get("DBG_COMMUNICATION_ERROR_FMT"), objectArray);
                if (consolePanel != null) {
                    consolePanel.logMsg(string);
                }
                this.m_frame.setMessage(this, string);
                if (this.m_connectAttempts <= 1) break;
                Util.errorMessage(this.m_frame, MRI.get("DBG_ERROR"), string);
                break;
            }
            case 1: {
                Object[] objectArray = new Object[]{Util.firstUpper(commLink.getSystem()), commLink.getIp()};
                String string = MessageFormat.format(MRI.get("DBG_CONNECTING_FMT"), objectArray);
                if (consolePanel != null) {
                    consolePanel.logMsg(string);
                }
                this.m_frame.setMessage(this, string);
                break;
            }
            case 2: {
                Object[] objectArray = new Object[]{Util.firstUpper(commLink.getSystem()), commLink.getIp()};
                String string = MessageFormat.format(MRI.get("DBG_CONNECTED_FMT"), objectArray);
                if (consolePanel != null) {
                    consolePanel.logMsg(string);
                }
                this.m_frame.setMessage(this, string);
                break;
            }
            case 5: {
                String string = MRI.get("DBG_ACCEPTING_CONNECTION_FMT");
                if (consolePanel != null) {
                    consolePanel.logMsg(string);
                }
                this.m_frame.setMessage(this, string);
                break;
            }
            case 6: {
                Object[] objectArray = new Object[]{Util.firstUpper(commLink.getSystem()), commLink.getIp()};
                String string = MessageFormat.format(MRI.get("DBG_ACCEPTED_CONNECTION_FMT"), objectArray);
                if (consolePanel != null) {
                    consolePanel.logMsg(string);
                }
                this.m_frame.setMessage(this, string);
                break;
            }
            case 4: {
                Dialog dialog = this.getActiveDialog();
                if (dialog != null && !(dialog instanceof ISeriesMessageDialog)) {
                    dialog.dispose();
                }
                Object[] objectArray = new Object[]{Util.firstUpper(commLink.getSystem())};
                String string = MessageFormat.format(MRI.get("DBG_DROPPED_CONNECTION_FMT"), objectArray);
                this.clear(2);
                this.setDebugIconTooltip(string);
                if (consolePanel != null) {
                    consolePanel.logMsg(string);
                }
                this.m_frame.setMessage(this, string);
                Util.errorMessage(this.m_frame, MRI.get("DBG_ERROR"), string);
                this.closeCommLink();
                this.cancelClock();
                break;
            }
        }
    }

    public void commLinkPacket(CommLinkEvent commLinkEvent) {
        Packet packet = commLinkEvent.getPacket();
        if (packet != null) {
            SwingUtilities.invokeLater(packet);
        }
    }

    public abstract int getAddrOffsetSizeInBits();

    public abstract int getAddrSizeInBits();

    public abstract int getDebugOptions();

    public abstract String getDebuggerName();

    public abstract void setProgramInfo(Packet var1);

    public abstract void setTitle();

    public abstract void primePartnerStep();

    public abstract DebugContext clone(String[] var1);

    public abstract void init();

    public abstract int getHelpSetId();

    private class AnimationTimer
    extends Timer
    implements ActionListener {
        public AnimationTimer() {
            super(750, null);
            this.setRepeats(false);
        }

        public void init() {
            this.addActionListener(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AbstractDebugContext.this.startAnimation();
        }
    }
}

