/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iseries.debug;

import com.ibm.iseries.debug.memory.MemoryAddress;
import com.ibm.iseries.debug.util.CommLink;
import com.ibm.iseries.debug.util.MRI;
import com.ibm.iseries.debug.util.RequestPacketElement;
import com.ibm.iseries.debug.util.Util;
import java.io.IOException;
import java.text.MessageFormat;

public class BreakpointDescriptor
implements RequestPacketElement,
Comparable {
    public static final int DEFAULT = 0;
    public static final int SERVICE_ENTRY_POINT = 1;
    public static final int REMOVED = 0;
    public static final int ENABLED = 1;
    public static final int DISABLED = 2;
    public static final int ERROR = 3;
    private int m_style;
    private String m_viewId;
    private int m_lineNum;
    private int m_groupId;
    private int m_state;
    private String m_condition;
    private String m_threadId;
    private String m_user;
    private String m_addr;
    private BreakpointDescriptor m_next;

    public BreakpointDescriptor() {
        this.m_style = 0;
        this.m_viewId = "";
        this.m_lineNum = -1;
        this.m_groupId = -1;
        this.m_state = -1;
        this.m_condition = "";
        this.m_threadId = "";
        this.m_user = "";
    }

    public BreakpointDescriptor(String string, int n, int n2) {
        this.m_style = 0;
        this.m_viewId = string;
        this.m_lineNum = n;
        this.m_groupId = n2;
        this.m_state = -1;
        this.m_condition = "";
        this.m_threadId = "";
        this.m_user = "";
    }

    public BreakpointDescriptor(String string, int n, int n2, int n3, String string2, String string3) {
        this.m_style = 0;
        this.m_viewId = string;
        this.m_lineNum = n;
        this.m_groupId = n2;
        this.m_state = n3;
        this.m_condition = string2;
        this.m_threadId = string3;
        this.m_user = "";
    }

    public BreakpointDescriptor(BreakpointDescriptor breakpointDescriptor) {
        this.copy(breakpointDescriptor);
    }

    public String toString() {
        String string;
        if (this.m_style == 1) {
            Object[] objectArray = new Object[]{new Integer(this.m_lineNum), this.m_user};
            string = MessageFormat.format(MRI.get("DBG_LINE_SBREAK_FMT"), objectArray);
        } else if (this.m_addr == null) {
            if (this.m_condition.length() > 0) {
                if (this.m_threadId.length() > 0) {
                    Object[] objectArray = new Object[]{new Integer(this.m_lineNum), this.m_condition, this.m_threadId};
                    string = MessageFormat.format(MRI.get("DBG_LINE_COND_TBREAK_FMT"), objectArray);
                } else {
                    Object[] objectArray = new Object[]{new Integer(this.m_lineNum), this.m_condition};
                    string = MessageFormat.format(MRI.get("DBG_LINE_COND_BREAK_FMT"), objectArray);
                }
            } else if (this.m_threadId.length() > 0) {
                Object[] objectArray = new Object[]{new Integer(this.m_lineNum), this.m_threadId};
                string = MessageFormat.format(MRI.get("DBG_LINE_TBREAK_FMT"), objectArray);
            } else {
                Object[] objectArray = new Object[]{new Integer(this.m_lineNum)};
                string = MessageFormat.format(MRI.get("DBG_LINE_BREAK_FMT"), objectArray);
            }
        } else if (this.m_condition.length() > 0) {
            if (this.m_threadId.length() > 0) {
                Object[] objectArray = new Object[]{this.m_addr, this.m_condition, this.m_threadId};
                string = MessageFormat.format(MRI.get("DBG_ADDR_COND_TBREAK_FMT"), objectArray);
            } else {
                Object[] objectArray = new Object[]{this.m_addr, this.m_condition};
                string = MessageFormat.format(MRI.get("DBG_ADDR_COND_BREAK_FMT"), objectArray);
            }
        } else if (this.m_threadId.length() > 0) {
            Object[] objectArray = new Object[]{this.m_addr, this.m_threadId};
            string = MessageFormat.format(MRI.get("DBG_ADDR_TBREAK_FMT"), objectArray);
        } else {
            Object[] objectArray = new Object[]{this.m_addr};
            string = MessageFormat.format(MRI.get("DBG_ADDR_BREAK_FMT"), objectArray);
        }
        return string;
    }

    public void copy(BreakpointDescriptor breakpointDescriptor) {
        this.m_style = breakpointDescriptor.m_style;
        this.m_viewId = breakpointDescriptor.m_viewId;
        this.m_lineNum = breakpointDescriptor.m_lineNum;
        this.m_groupId = breakpointDescriptor.m_groupId;
        this.m_state = breakpointDescriptor.m_state;
        this.m_condition = breakpointDescriptor.m_condition;
        this.m_threadId = breakpointDescriptor.m_threadId;
        this.m_user = breakpointDescriptor.m_user;
        this.m_addr = breakpointDescriptor.m_addr;
    }

    public int getStyle() {
        return this.m_style;
    }

    public void setStyle(int n) {
        this.m_style = n;
    }

    public boolean isDefaultStyle() {
        return this.m_style == 0;
    }

    public boolean isServiceEntryPoint() {
        return this.m_style == 1;
    }

    public String getViewId() {
        return this.m_viewId;
    }

    public void setViewId(String string) {
        this.m_viewId = string;
    }

    public int getLineNum() {
        return this.m_lineNum;
    }

    public void setLineNum(int n) {
        this.m_lineNum = n;
    }

    public int getGroupId() {
        return this.m_groupId;
    }

    public void setGroupId(int n) {
        this.m_groupId = n;
    }

    public int getState() {
        return this.m_state;
    }

    public void setState(int n) {
        this.m_state = n;
    }

    public boolean isEnabled() {
        return this.m_state == 1;
    }

    public boolean isDisabled() {
        return this.m_state == 2;
    }

    public boolean isError() {
        return this.m_state == 3;
    }

    public String getCondition() {
        return this.m_condition;
    }

    public void setCondition(String string) {
        this.m_condition = string;
    }

    public String getThreadId() {
        return this.m_threadId;
    }

    public void setThreadId(String string) {
        this.m_threadId = string;
    }

    public String getUser() {
        return this.m_user;
    }

    public void setUser(String string) {
        this.m_user = string;
    }

    public String getAddress() {
        return this.m_addr;
    }

    public void setAddress(MemoryAddress memoryAddress) {
        this.m_addr = memoryAddress != null ? memoryAddress.toString() : null;
    }

    public void setAddress(String string) {
        this.m_addr = string;
    }

    public BreakpointDescriptor next() {
        return this.m_next;
    }

    public void setNext(BreakpointDescriptor breakpointDescriptor) {
        this.m_next = breakpointDescriptor;
    }

    public void read(CommLink commLink) throws IOException {
        this.m_viewId = commLink.readString();
        this.m_lineNum = commLink.readInt();
        this.m_groupId = commLink.readInt();
        this.m_state = commLink.readInt();
        this.m_condition = commLink.readString();
        this.m_threadId = commLink.readString();
        if (this.m_threadId.length() > 0 && this.m_threadId.startsWith("SBREAK ")) {
            this.m_style = 1;
            this.m_user = Util.firstUpper(this.m_threadId.substring(7));
            this.m_threadId = "";
        }
    }

    public int writeSize(CommLink commLink) {
        int n = 0;
        n += commLink.writeSize(this.m_viewId);
        n += 4;
        n += 4;
        n += 4;
        n += commLink.writeSize(this.m_condition);
        n = this.m_style == 1 ? (n += commLink.writeSize("SBREAK " + this.m_user)) : (n += commLink.writeSize(this.m_threadId));
        return n;
    }

    public void write(CommLink commLink) throws IOException {
        commLink.writeString(this.m_viewId);
        commLink.writeInt(this.m_lineNum);
        commLink.writeInt(this.m_groupId);
        commLink.writeInt(this.m_state);
        commLink.writeString(this.m_condition);
        if (this.m_style == 1) {
            commLink.writeString("SBREAK " + this.m_user.toUpperCase());
        } else {
            commLink.writeString(this.m_threadId);
        }
    }

    public int compareTo(Object object) {
        int n = 0;
        if (object instanceof BreakpointDescriptor) {
            if (this.m_lineNum < ((BreakpointDescriptor)object).m_lineNum) {
                n = -1;
            } else if (this.m_lineNum > ((BreakpointDescriptor)object).m_lineNum) {
                n = 1;
            }
        } else if (object instanceof Integer) {
            if (this.m_lineNum < (Integer)object) {
                n = -1;
            } else if (this.m_lineNum > (Integer)object) {
                n = 1;
            }
        }
        return n;
    }
}

