/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iseries.debug;

import com.ibm.iseries.debug.BreakpointDescriptor;
import java.util.ArrayList;
import java.util.Collections;

public class Breakpoints {
    protected static final int TABLE_SIZE = 10;
    protected BreakpointDescriptor[] m_table = new BreakpointDescriptor[this.m_tableSize];
    protected int m_tableSize = 10;
    protected int m_count = 0;
    protected int m_limit = (int)((double)this.m_tableSize * 0.75);

    public void cleanUp() {
        int n = 0;
        while (n < this.m_tableSize) {
            BreakpointDescriptor breakpointDescriptor = this.m_table[n];
            while (breakpointDescriptor != null) {
                BreakpointDescriptor breakpointDescriptor2 = breakpointDescriptor.next();
                breakpointDescriptor.setNext(null);
                breakpointDescriptor = breakpointDescriptor2;
            }
            this.m_table[n] = null;
            ++n;
        }
        this.m_table = null;
    }

    public int getCount() {
        return this.m_count;
    }

    int getCount(int n) {
        if (this.m_count == 0) {
            return 0;
        }
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.m_tableSize) {
            BreakpointDescriptor breakpointDescriptor = this.m_table[n3];
            while (breakpointDescriptor != null) {
                if (breakpointDescriptor.getGroupId() == n) {
                    ++n2;
                }
                breakpointDescriptor = breakpointDescriptor.next();
            }
            ++n3;
        }
        return n2;
    }

    boolean containsGroup(int n) {
        if (this.m_count == 0) {
            return false;
        }
        boolean bl = false;
        int n2 = 0;
        while (!bl && n2 < this.m_tableSize) {
            BreakpointDescriptor breakpointDescriptor = this.m_table[n2];
            while (breakpointDescriptor != null) {
                if (breakpointDescriptor.getGroupId() == n) {
                    bl = true;
                    break;
                }
                breakpointDescriptor = breakpointDescriptor.next();
            }
            ++n2;
        }
        return bl;
    }

    public boolean breakpointExists(int n) {
        return this.getDescriptor(n) != null;
    }

    public BreakpointDescriptor getDescriptor(int n) {
        if (this.m_count == 0) {
            return null;
        }
        BreakpointDescriptor breakpointDescriptor = null;
        int n2 = this.hash(n, this.m_table.length);
        BreakpointDescriptor breakpointDescriptor2 = this.m_table[n2];
        while (breakpointDescriptor2 != null) {
            if (breakpointDescriptor2.getLineNum() == n) {
                if (breakpointDescriptor2.getGroupId() < 0) break;
                breakpointDescriptor = breakpointDescriptor2;
                break;
            }
            breakpointDescriptor2 = breakpointDescriptor2.next();
        }
        return breakpointDescriptor;
    }

    public void getDescriptors(ArrayList arrayList) {
        if (this.m_count > 0) {
            ArrayList<BreakpointDescriptor> arrayList2 = new ArrayList<BreakpointDescriptor>(this.m_count);
            int n = 0;
            while (n < this.m_tableSize) {
                BreakpointDescriptor breakpointDescriptor = this.m_table[n];
                while (breakpointDescriptor != null) {
                    arrayList2.add(breakpointDescriptor);
                    breakpointDescriptor = breakpointDescriptor.next();
                }
                ++n;
            }
            Collections.sort(arrayList2);
            arrayList.addAll(arrayList2);
            arrayList2.clear();
        }
    }

    public ArrayList getDescriptors() {
        ArrayList arrayList = new ArrayList();
        this.getDescriptors(arrayList);
        return arrayList;
    }

    public void getDescriptors(ArrayList arrayList, int n) {
        if (this.m_count > 0) {
            ArrayList<BreakpointDescriptor> arrayList2 = new ArrayList<BreakpointDescriptor>(this.m_count);
            int n2 = 0;
            while (n2 < this.m_tableSize) {
                BreakpointDescriptor breakpointDescriptor = this.m_table[n2];
                while (breakpointDescriptor != null) {
                    if (breakpointDescriptor.getGroupId() == n) {
                        arrayList2.add(breakpointDescriptor);
                    }
                    breakpointDescriptor = breakpointDescriptor.next();
                }
                ++n2;
            }
            Collections.sort(arrayList2);
            arrayList.addAll(arrayList2);
            arrayList2.clear();
        }
    }

    public ArrayList getDescriptors(int n) {
        ArrayList arrayList = new ArrayList();
        this.getDescriptors(arrayList, n);
        return arrayList;
    }

    public void put(BreakpointDescriptor breakpointDescriptor) {
        int n = this.hash(breakpointDescriptor.getLineNum(), this.m_table.length);
        BreakpointDescriptor breakpointDescriptor2 = this.m_table[n];
        while (breakpointDescriptor2 != null) {
            if (breakpointDescriptor2.getLineNum() == breakpointDescriptor.getLineNum()) {
                breakpointDescriptor2.copy(breakpointDescriptor);
                return;
            }
            breakpointDescriptor2 = breakpointDescriptor2.next();
        }
        if (this.m_count >= this.m_limit) {
            this.rehash();
            n = this.hash(breakpointDescriptor.getLineNum(), this.m_table.length);
        }
        breakpointDescriptor.setNext(this.m_table[n]);
        this.m_table[n] = breakpointDescriptor;
        ++this.m_count;
    }

    public void remove(int n) {
        int n2 = this.hash(n, this.m_table.length);
        BreakpointDescriptor breakpointDescriptor = this.m_table[n2];
        BreakpointDescriptor breakpointDescriptor2 = null;
        while (breakpointDescriptor != null) {
            if (breakpointDescriptor.getLineNum() == n) {
                if (breakpointDescriptor2 != null) {
                    breakpointDescriptor2.setNext(breakpointDescriptor.next());
                } else {
                    this.m_table[n2] = breakpointDescriptor.next();
                }
                --this.m_count;
                break;
            }
            breakpointDescriptor2 = breakpointDescriptor;
            breakpointDescriptor = breakpointDescriptor.next();
        }
    }

    public void removeAll() {
        int n = 0;
        while (n < this.m_table.length) {
            this.m_table[n] = null;
            ++n;
        }
        this.m_count = 0;
    }

    protected void rehash() {
        int n = this.m_table.length;
        BreakpointDescriptor[] breakpointDescriptorArray = this.m_table;
        this.m_tableSize = this.m_tableSize * 2 + 1;
        this.m_table = new BreakpointDescriptor[this.m_tableSize];
        this.m_limit = (int)((double)this.m_tableSize * 0.75);
        int n2 = 0;
        while (n2 < n) {
            BreakpointDescriptor breakpointDescriptor = null;
            BreakpointDescriptor breakpointDescriptor2 = breakpointDescriptorArray[n2];
            while (breakpointDescriptor2 != null) {
                breakpointDescriptor = breakpointDescriptor2.next();
                int n3 = this.hash(breakpointDescriptor2.getLineNum(), this.m_tableSize);
                breakpointDescriptor2.setNext(this.m_table[n3]);
                this.m_table[n3] = breakpointDescriptor2;
                breakpointDescriptor2 = breakpointDescriptor;
            }
            breakpointDescriptorArray[n2] = null;
            ++n2;
        }
    }

    protected int hash(int n, int n2) {
        double d = (double)n * 0.6180339887;
        return (int)((double)n2 * (d - Math.floor(d)));
    }
}

