/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iseries.debug;

import com.ibm.iseries.debug.event.ContextEvent;
import com.ibm.iseries.debug.event.LAFEvent;
import com.ibm.iseries.debug.event.SettingsEvent;
import com.ibm.iseries.debug.event.SourceViewEvent;
import com.ibm.iseries.debug.listener.ContextListener;
import com.ibm.iseries.debug.listener.LAFListener;
import com.ibm.iseries.debug.listener.SettingsListener;
import com.ibm.iseries.debug.listener.SourceViewListener;
import com.ibm.iseries.debug.manager.PgmManager;
import com.ibm.iseries.debug.manager.SourceViewManager;
import com.ibm.iseries.debug.source.SourceFrame;
import com.ibm.iseries.debug.util.DebugContext;
import com.ibm.iseries.debug.util.DebugDesktop;
import com.ibm.iseries.debug.util.DebugSource;
import com.ibm.iseries.debug.util.MRI;
import java.awt.Component;
import java.awt.Rectangle;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JLayeredPane;
import javax.swing.UIManager;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;

public class Desktop
extends JDesktopPane
implements DebugDesktop,
SourceViewListener,
ContextListener,
SettingsListener,
LAFListener,
InternalFrameListener {
    protected static final String GIF = "/com/ibm/iseries/debug/dbg023.gif";
    protected DebugContext m_ctxt;
    protected PgmManager m_pgmMgr;
    protected SourceViewManager m_srcMgr;
    protected HashMap m_src;
    protected SourceFrame m_activeSrc;
    protected boolean m_ignoreRefresh;
    protected String m_contextViewId = "";
    protected int m_contextLineNum = -1;
    protected String m_asmContextViewId = "";
    protected int m_asmContextLineNum = -1;
    protected String m_scrollViewId = "";
    protected int m_scrollLineNum = -1;
    protected boolean m_scrollSelect = true;
    protected String m_scrollText;
    protected int m_windowX = 10;
    protected int m_windowY = 10;
    protected ImageIcon m_srcIcon;

    public Desktop(DebugContext debugContext) {
        this.m_ctxt = debugContext;
        this.m_pgmMgr = (PgmManager)this.m_ctxt.getManager("pgmmgr");
        this.m_srcMgr = (SourceViewManager)this.m_ctxt.getManager("srcmgr");
        this.m_src = new HashMap();
        this.m_srcIcon = MRI.getIcon(0, GIF);
        this.lookAndFeelModifications();
        this.m_ctxt.getManager("srcmgr").addListener(this);
        this.m_ctxt.getManager("ctxtmgr").addListener(this);
        this.m_ctxt.getManager("settmgr").addListener(this);
        this.m_ctxt.getManager("lafmgr").addListener(this);
    }

    public JComponent getComponent() {
        return this;
    }

    public void clear() {
        this.closeAll();
        this.m_contextViewId = "";
        this.m_contextLineNum = -1;
        this.m_asmContextViewId = "";
        this.m_asmContextLineNum = -1;
    }

    public void cleanUp() {
        this.m_ctxt.getManager("srcmgr").removeListener(this);
        this.m_ctxt.getManager("ctxtmgr").removeListener(this);
        this.m_ctxt.getManager("settmgr").removeListener(this);
        this.m_ctxt.getManager("lafmgr").removeListener(this);
        DebugSource[] debugSourceArray = this.getAllSource();
        int n = 0;
        while (n < debugSourceArray.length) {
            debugSourceArray[n].cleanUp();
            ++n;
        }
        this.m_src.clear();
        this.m_ctxt = null;
        this.m_srcMgr = null;
        this.m_src = null;
        this.m_activeSrc = null;
        this.m_srcIcon = null;
        this.m_contextViewId = null;
        this.m_asmContextViewId = null;
        this.m_scrollViewId = null;
        this.m_scrollText = null;
    }

    protected void lookAndFeelModifications() {
        DebugSource[] debugSourceArray = this.getAllSource();
        int n = 0;
        while (n < debugSourceArray.length) {
            debugSourceArray[n].lookAndFeelModifications();
            ++n;
        }
        if (this.m_ctxt.isDisassemblyShown()) {
            this.m_ctxt.getDisassembly().lookAndFeelModifications();
        }
        this.setBackground(UIManager.getColor("Panel.background"));
    }

    public boolean sourceExists(String string) {
        return this.m_src.get(string) != null;
    }

    public int getSourceCount() {
        return this.m_src.size();
    }

    public DebugSource getSource(String string) {
        return (DebugSource)this.m_src.get(string);
    }

    public DebugSource[] getAllSource() {
        int n = 0;
        DebugSource[] debugSourceArray = new DebugSource[this.m_src.size()];
        Iterator iterator = this.m_src.values().iterator();
        while (iterator.hasNext()) {
            debugSourceArray[n++] = (DebugSource)iterator.next();
        }
        return debugSourceArray;
    }

    protected SourceFrame[] getAllSourceFrames() {
        int n = 0;
        SourceFrame[] sourceFrameArray = new SourceFrame[this.m_src.size()];
        Iterator iterator = this.m_src.values().iterator();
        while (iterator.hasNext()) {
            sourceFrameArray[n++] = (SourceFrame)iterator.next();
        }
        return sourceFrameArray;
    }

    public DebugSource getActiveSource() {
        return this.m_activeSrc;
    }

    public String getActiveViewId() {
        if (this.m_activeSrc == null) {
            return "";
        }
        return this.m_activeSrc.getViewId();
    }

    public void activateSource(String string, int n) {
        DebugSource debugSource = (DebugSource)this.m_src.get(string);
        if (debugSource != null) {
            this.activateSource(debugSource, n);
        }
    }

    public void activateSource(DebugSource debugSource, int n) {
        SourceFrame sourceFrame = (SourceFrame)debugSource;
        if (sourceFrame != null) {
            try {
                if (sourceFrame != this.m_activeSrc) {
                    sourceFrame.setSelected(true);
                    if (sourceFrame.isIcon()) {
                        sourceFrame.setIcon(false);
                    }
                    sourceFrame.toFront();
                }
                if (n >= 0) {
                    sourceFrame.scrollToLineNum(n);
                }
                if (!this.m_ctxt.isDisassemblyActive()) {
                    sourceFrame.viewRequestFocus();
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    public void closeSource(String string) {
        SourceFrame sourceFrame = (SourceFrame)this.m_src.get(string);
        if (sourceFrame != null) {
            try {
                sourceFrame.setClosed(true);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    public void closeAll() {
        SourceFrame[] sourceFrameArray = this.getAllSourceFrames();
        this.m_ignoreRefresh = true;
        int n = 0;
        while (n < sourceFrameArray.length) {
            try {
                sourceFrameArray[n].setClosed(true);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            ++n;
        }
        this.m_ignoreRefresh = false;
        this.m_ctxt.getMenubar().refreshWindowMenu();
        this.m_windowY = 10;
        this.m_windowX = 10;
        this.m_activeSrc = null;
    }

    public void minimizeAll() {
        SourceFrame[] sourceFrameArray = this.getAllSourceFrames();
        int n = 0;
        while (n < sourceFrameArray.length) {
            try {
                sourceFrameArray[n].setIcon(true);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            ++n;
        }
    }

    public void setUserPointOfInterest(String string, int n, boolean bl, String string2) {
        this.m_scrollViewId = string;
        this.m_scrollLineNum = n;
        this.m_scrollSelect = bl;
        this.m_scrollText = string2;
    }

    public void sourceViewAvailable(SourceViewEvent sourceViewEvent) {
        String string = sourceViewEvent.getViewId();
        SourceFrame sourceFrame = (SourceFrame)this.m_src.get(string);
        boolean bl = sourceViewEvent.isAssemblerSource();
        DebugSource debugSource = this.m_ctxt.getDisassembly();
        if (bl && this.m_ctxt.isDisassemblyShown() && debugSource.getViewId().equals(string)) {
            this.loadSource(debugSource, sourceViewEvent);
            if (sourceFrame != null) {
                this.closeSource(string);
            }
            return;
        }
        if (sourceFrame == null) {
            sourceFrame = new SourceFrame(this.m_ctxt, sourceViewEvent, this.m_pgmMgr.getCompletePath(string));
            sourceFrame.addInternalFrameListener(this);
            this.add((Component)sourceFrame, JLayeredPane.DEFAULT_LAYER);
            this.loadSource(sourceFrame, sourceViewEvent);
            try {
                boolean bl2 = this.m_activeSrc != null ? this.m_activeSrc.isMaximum() : true;
                Rectangle rectangle = this.getBounds();
                if (this.m_windowX > rectangle.width - 350 || this.m_windowY > rectangle.height - 300) {
                    this.m_windowY = 10;
                    this.m_windowX = 10;
                }
                sourceFrame.setFrameIcon(this.m_srcIcon);
                sourceFrame.setBounds(this.m_windowX, this.m_windowY, 350, 300);
                sourceFrame.setSelected(true);
                sourceFrame.setMaximum(bl2);
                sourceFrame.setVisible(true);
                this.m_src.put(string, sourceFrame);
                this.m_ctxt.getMenubar().refreshWindowMenu();
                if (!this.m_ctxt.isDisassemblyActive()) {
                    this.m_ctxt.setActiveSource(sourceFrame);
                    sourceFrame.viewRequestFocus();
                }
                this.m_windowX += 20;
                this.m_windowY += 20;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        } else if (sourceFrame.containsLineNum(sourceViewEvent.getStartLineNum()) && sourceFrame.containsLineNum(sourceViewEvent.getEndLineNum())) {
            boolean bl3 = true;
            if (bl && sourceFrame.getViewId().equals(this.m_asmContextViewId) && this.sourceExists(this.m_contextViewId)) {
                bl3 = false;
            }
            if (bl3) {
                this.activateSource(sourceFrame, -1);
            }
        } else {
            this.loadSource(sourceFrame, sourceViewEvent);
            boolean bl4 = true;
            if (bl && sourceFrame.getViewId().equals(this.m_asmContextViewId) && this.sourceExists(this.m_contextViewId)) {
                bl4 = false;
            }
            if (bl4) {
                this.activateSource(sourceFrame, -1);
            }
        }
    }

    protected void loadSource(DebugSource debugSource, SourceViewEvent sourceViewEvent) {
        debugSource.setSourceCode(sourceViewEvent);
        String string = sourceViewEvent.isAssemblerSource() ? this.m_asmContextViewId : this.m_contextViewId;
        int n = sourceViewEvent.isAssemblerSource() ? this.m_asmContextLineNum : this.m_contextLineNum;
        String string2 = sourceViewEvent.getViewId();
        if (this.m_scrollViewId.length() > 0) {
            if (string2.equals(this.m_scrollViewId)) {
                if (string2.equals(string)) {
                    debugSource.setActiveLineNum(n);
                }
                if (this.m_scrollLineNum >= 0) {
                    if (this.m_scrollText != null) {
                        debugSource.findTextInLine(this.m_scrollText, this.m_scrollLineNum, false, false);
                        Object[] objectArray = new Object[]{this.m_scrollText, new Integer(this.m_scrollLineNum)};
                        String string3 = MessageFormat.format(MRI.get("DBG_FIND_SUCCESSFUL_FMT"), objectArray);
                        this.m_ctxt.setMessage(string3);
                    } else if (this.m_scrollSelect) {
                        debugSource.scrollToLineNum(this.m_scrollLineNum);
                    } else {
                        debugSource.scrollToLineNum(this.m_scrollLineNum, false);
                    }
                }
                this.m_scrollViewId = "";
                this.m_scrollLineNum = -1;
                this.m_scrollText = null;
            }
        } else if (string2.equals(string) && debugSource.containsLineNum(n)) {
            debugSource.scrollToLineNum(n, true);
        }
    }

    public void contextChanged(ContextEvent contextEvent) {
        switch (contextEvent.getType()) {
            case 0: 
            case 2: {
                this.m_contextViewId = contextEvent.getViewId();
                this.m_contextLineNum = contextEvent.getLineNum();
                this.m_asmContextViewId = contextEvent.getAsmViewId();
                this.m_asmContextLineNum = contextEvent.getAsmLineNum();
                if (this.m_contextLineNum > 0) {
                    SourceFrame sourceFrame = (SourceFrame)this.m_src.get(this.m_contextViewId);
                    if (sourceFrame == null) {
                        this.m_srcMgr.requestSourceViewContext(this.m_contextViewId, this.m_contextLineNum);
                        break;
                    }
                    this.activateSource(sourceFrame, -1);
                    break;
                }
                if (this.m_asmContextLineNum <= 0) break;
                SourceFrame sourceFrame = (SourceFrame)this.m_src.get(this.m_asmContextViewId);
                if (sourceFrame == null) {
                    if (this.m_ctxt.isDisassemblyShown()) break;
                    this.m_srcMgr.requestSourceViewContext(this.m_asmContextViewId, this.m_asmContextLineNum);
                    break;
                }
                this.activateSource(sourceFrame, -1);
                break;
            }
            case 1: 
            case 3: {
                break;
            }
            case 4: {
                SourceFrame sourceFrame;
                if (this.m_contextLineNum > 0) {
                    sourceFrame = (SourceFrame)this.m_src.get(this.m_contextViewId);
                    if (sourceFrame != null) {
                        sourceFrame.resetActiveLineNum();
                    }
                    this.m_contextViewId = "";
                    this.m_contextLineNum = -1;
                }
                if (this.m_asmContextLineNum <= 0) break;
                sourceFrame = (SourceFrame)this.m_src.get(this.m_asmContextViewId);
                if (sourceFrame != null) {
                    sourceFrame.resetActiveLineNum();
                }
                this.m_asmContextViewId = "";
                this.m_asmContextLineNum = -1;
            }
        }
    }

    public void lookAndFeelChanged(LAFEvent lAFEvent) {
        this.lookAndFeelModifications();
    }

    public void settingsChanged(SettingsEvent settingsEvent) {
        if (settingsEvent.generalChanged() || settingsEvent.colorsChanged() || settingsEvent.fontsChanged()) {
            DebugSource[] debugSourceArray = this.getAllSource();
            int n = settingsEvent.getType();
            int n2 = 0;
            while (n2 < debugSourceArray.length) {
                debugSourceArray[n2].settingsChanged(n);
                ++n2;
            }
        }
    }

    public void internalFrameClosed(InternalFrameEvent internalFrameEvent) {
        SourceFrame sourceFrame = (SourceFrame)internalFrameEvent.getSource();
        this.m_src.remove(sourceFrame.getViewId());
        sourceFrame.cleanUp();
        if (this.m_src.size() == 0) {
            this.m_windowY = 10;
            this.m_windowX = 10;
        }
        if (!this.m_ignoreRefresh) {
            this.m_ctxt.getMenubar().refreshWindowMenu();
        }
    }

    public void internalFrameActivated(InternalFrameEvent internalFrameEvent) {
        SourceFrame sourceFrame;
        this.m_activeSrc = sourceFrame = (SourceFrame)internalFrameEvent.getSource();
    }

    public void internalFrameDeactivated(InternalFrameEvent internalFrameEvent) {
        SourceFrame sourceFrame = (SourceFrame)internalFrameEvent.getSource();
        if (this.m_activeSrc == sourceFrame) {
            this.m_activeSrc = null;
        }
    }

    public void internalFrameDeiconified(InternalFrameEvent internalFrameEvent) {
        SourceFrame sourceFrame = (SourceFrame)internalFrameEvent.getSource();
        sourceFrame.moveToFront();
    }

    public void internalFrameOpened(InternalFrameEvent internalFrameEvent) {
    }

    public void internalFrameClosing(InternalFrameEvent internalFrameEvent) {
    }

    public void internalFrameIconified(InternalFrameEvent internalFrameEvent) {
    }
}

