/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iseries.debug.action;

import com.ibm.iseries.debug.DebugConstants;
import com.ibm.iseries.debug.event.VariableEvent;
import com.ibm.iseries.debug.manager.VariableManager;
import com.ibm.iseries.debug.request.SetOptionsRequest;
import com.ibm.iseries.debug.util.Action;
import com.ibm.iseries.debug.util.DebugContext;
import com.ibm.iseries.debug.util.MRI;
import com.ibm.iseries.debug.util.Settings;

public class IncBaseAction
extends Action
implements DebugConstants {
    private boolean m_checked = false;

    public IncBaseAction() {
        super("incbscls", MRI.get("DBG_BASE_CLASS_MENU"), 66, 3, true);
    }

    public void init(DebugContext debugContext, Settings settings) {
        super.init(debugContext, settings);
        this.m_checked = settings.getBool("varsIncBaseClass", false);
    }

    public boolean isSupported(double d) {
        return this.m_ctxt.isSupported(6, d);
    }

    public void setSupported(double d) {
        this.setSupported(this.isSupported(d));
        this.setEnabled(this.isDefaultEnabled());
    }

    public boolean isChecked() {
        return this.m_checked;
    }

    public void run() {
        this.m_checked = !this.m_checked;
        this.m_ctxt.getUserConfig().setBool("varsIncBaseClass", this.m_checked);
        SetOptionsRequest setOptionsRequest = new SetOptionsRequest(this.m_checked ? 4 : 0);
        this.m_ctxt.sendRequest(setOptionsRequest);
        this.firePropertyChange("incBaseClasses", new Boolean(!this.m_checked), new Boolean(this.m_checked));
        VariableManager variableManager = (VariableManager)this.m_ctxt.getManager("varmgr");
        variableManager.fireVariableEvent(new VariableEvent(this, 4));
        String string = this.m_checked ? MRI.get("DBG_BASE_CLASSES_INCLUDED") : MRI.get("DBG_BASE_CLASSES_NOT_INCLUDED");
        this.m_ctxt.setMessage(string);
    }
}

