/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iseries.debug.action;

import com.ibm.iseries.debug.VariableDescriptor;
import com.ibm.iseries.debug.ViewDescriptor;
import com.ibm.iseries.debug.manager.MemoryManager;
import com.ibm.iseries.debug.manager.PgmManager;
import com.ibm.iseries.debug.memory.MemoryAddress;
import com.ibm.iseries.debug.panel.MemoryAddrPanel;
import com.ibm.iseries.debug.util.Action;
import com.ibm.iseries.debug.util.DebugPanelFrame;
import com.ibm.iseries.debug.util.MRI;
import com.ibm.iseries.debug.util.Manager;
import com.ibm.iseries.debug.util.TabPanel;
import java.awt.Rectangle;
import java.io.Serializable;

public class NewMemAction
extends Action {
    private static boolean m_activated;

    public NewMemAction() {
        super("newmem", MRI.get("DBG_NEW_MEMORY_MENU"), 72, 1, false);
    }

    public static boolean wasActivated() {
        boolean bl = m_activated;
        m_activated = false;
        return bl;
    }

    public void run() {
        TabPanel tabPanel = this.m_ctxt.getActivePanel();
        if (tabPanel != null) {
            String string = tabPanel.getKey();
            if (string.equals("locals") || string.equals("monitors")) {
                this.NewMemoryFromVariable();
                m_activated = true;
            } else if (tabPanel instanceof MemoryAddrPanel) {
                this.NewMemoryFromMemory((MemoryAddrPanel)tabPanel);
            } else {
                this.NewMemoryFromAddress();
            }
        }
    }

    protected void NewMemoryFromVariable() {
        VariableDescriptor variableDescriptor = (VariableDescriptor)this.m_ctxt.getActionGroup().m_var;
        if (variableDescriptor != null) {
            Manager manager;
            ViewDescriptor viewDescriptor;
            MemoryAddrPanel memoryAddrPanel = (MemoryAddrPanel)this.m_ctxt.getPanel("memory");
            String string = variableDescriptor.getEvalName();
            if ((variableDescriptor.isValidPtr() || variableDescriptor.isString()) && (viewDescriptor = ((PgmManager)(manager = (PgmManager)this.m_ctxt.getManager("pgmmgr"))).getView(variableDescriptor.getViewId())).isCorCPP()) {
                string = "*(" + string + ")";
            }
            manager = (MemoryManager)this.m_ctxt.getManager("memmgr");
            ((MemoryManager)manager).requestMemoryRead(string, variableDescriptor.getViewId(), variableDescriptor.getLineNum(), memoryAddrPanel.getByteCount());
        }
    }

    protected void NewMemoryFromMemory(MemoryAddrPanel memoryAddrPanel) {
        Serializable serializable;
        MemoryAddrPanel memoryAddrPanel2 = new MemoryAddrPanel(this.m_ctxt);
        String string = memoryAddrPanel.getHexDataAtCursor(this.m_ctxt.getAddrSizeInBits() / 8);
        MemoryAddress memoryAddress = new MemoryAddress(string);
        if (!memoryAddress.canAdd(memoryAddrPanel.getByteCount())) {
            memoryAddress = memoryAddress.setMax().subtract(memoryAddrPanel.getByteCount() - 1);
        }
        memoryAddrPanel2.setAddress(memoryAddress);
        memoryAddrPanel2.setByteCount(memoryAddrPanel.getByteCount());
        memoryAddrPanel2.setCharacterMode(memoryAddrPanel.getCharacterMode(), false);
        memoryAddrPanel2.setBytesPerLine(memoryAddrPanel.getBytesPerLine(), false);
        memoryAddrPanel2.requestMemory();
        Rectangle rectangle = null;
        if (memoryAddrPanel.isInFrame()) {
            rectangle = memoryAddrPanel.getParentFrame().getBounds();
            rectangle.x += 20;
            rectangle.y += 20;
        } else {
            serializable = this.m_ctxt.getJFrame().getBounds();
            rectangle = memoryAddrPanel.getComponent().getBounds();
            rectangle.x = serializable.x + (serializable.width - rectangle.width) / 2;
            rectangle.y = serializable.y + (serializable.height - rectangle.height) / 2;
            rectangle.width += 15;
            rectangle.height += 30;
        }
        serializable = new DebugPanelFrame(memoryAddrPanel2, memoryAddrPanel2.getFrameTitle(), rectangle);
    }

    protected void NewMemoryFromAddress() {
        String string = this.m_ctxt.getActionGroup().m_address;
        if (string != null) {
            MemoryAddress memoryAddress = new MemoryAddress(string);
            MemoryAddrPanel memoryAddrPanel = (MemoryAddrPanel)this.m_ctxt.getPanel("memory");
            MemoryAddrPanel memoryAddrPanel2 = new MemoryAddrPanel(this.m_ctxt);
            if (!memoryAddress.canAdd(memoryAddrPanel.getByteCount())) {
                memoryAddress = memoryAddress.setMax().subtract(memoryAddrPanel.getByteCount() - 1);
            }
            memoryAddrPanel2.setAddress(memoryAddress);
            memoryAddrPanel2.setByteCount(memoryAddrPanel.getByteCount());
            memoryAddrPanel2.setCharacterMode(memoryAddrPanel.getCharacterMode(), false);
            memoryAddrPanel2.setBytesPerLine(memoryAddrPanel.getBytesPerLine(), false);
            memoryAddrPanel2.requestMemory();
            Rectangle rectangle = null;
            Rectangle rectangle2 = this.m_ctxt.getJFrame().getBounds();
            rectangle = memoryAddrPanel.getComponent().getBounds();
            rectangle.x = rectangle2.x + (rectangle2.width - rectangle.width) / 2;
            rectangle.y = rectangle2.y + (rectangle2.height - rectangle.height) / 2;
            rectangle.width += 15;
            rectangle.height += 30;
            DebugPanelFrame debugPanelFrame = new DebugPanelFrame(memoryAddrPanel2, memoryAddrPanel2.getFrameTitle(), rectangle);
        }
    }
}

