/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iseries.debug.dialog;

import com.ibm.iseries.debug.util.Dialog;
import com.ibm.iseries.debug.util.MRI;
import com.ibm.iseries.debug.util.Util;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.accessibility.Accessible;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class ArrayBoundsDialog
extends Dialog {
    private static final String LOW = "low";
    private static final String HI = "hi";
    private JPanel m_panel;
    private JPanel m_basePanel;
    private JPanel m_labelPanel;
    private JPanel m_ctrlPanel;
    private JTextField m_lowCtrl;
    private JTextField m_hiCtrl;
    private int m_low;
    private int m_hi;

    public ArrayBoundsDialog(JFrame jFrame, int n, int n2) {
        super(jFrame, MRI.get("DBG_SET_ARRAY_BOUNDS"), true, "");
        this.m_low = n;
        this.m_hi = n2;
        this.m_panel = new JPanel(new BorderLayout());
        this.m_basePanel = new JPanel(new BorderLayout());
        this.m_labelPanel = new JPanel(new GridLayout(0, 1, 0, 3));
        this.m_ctrlPanel = new JPanel(new GridLayout(0, 1, 0, 3));
        this.m_panel.setBorder(this.getEmptyBorder(0, 10, 10, 10));
        this.m_labelPanel.setBorder(this.getEmptyBorder(20, 10, 0, 10));
        this.m_ctrlPanel.setBorder(this.getEmptyBorder(20, 10, 0, 10));
        this.m_basePanel.add((Component)this.m_labelPanel, this.m_isLtoR ? "West" : "East");
        this.m_basePanel.add((Component)this.m_ctrlPanel, "Center");
        this.m_panel.add((Component)this.m_basePanel, "North");
        this.m_panel.add((Component)this.defaultButtons(MRI.get("DBG_OK"), true, false), "South");
        this.setContentPane(this.m_panel);
        this.addComponents();
        this.addWindowListener(new WndAdapter());
    }

    public void cleanUp() {
        super.cleanUp();
        this.m_panel = null;
        this.m_basePanel = null;
        this.m_labelPanel = null;
        this.m_ctrlPanel = null;
        this.m_lowCtrl = null;
        this.m_hiCtrl = null;
    }

    public int getLow() {
        return this.m_low;
    }

    public int getHi() {
        return this.m_hi;
    }

    private void addComponents() {
        this.listenForEscape(this.m_panel);
        JLabel jLabel = Util.getAccessibleLabel(MRI.get("DBG_LOWER_BOUND_LABEL"));
        JLabel jLabel2 = Util.getAccessibleLabel(MRI.get("DBG_UPPER_BOUND_LABEL"));
        this.m_labelPanel.add(jLabel);
        this.m_labelPanel.add(jLabel2);
        this.m_lowCtrl = new JTextField(String.valueOf(this.m_low), 6);
        this.m_lowCtrl.setActionCommand(LOW);
        this.m_lowCtrl.addActionListener(this);
        this.m_hiCtrl = new JTextField(String.valueOf(this.m_hi), 6);
        this.m_hiCtrl.setActionCommand(HI);
        this.m_hiCtrl.addActionListener(this);
        this.m_ctrlPanel.add(this.m_lowCtrl);
        this.m_ctrlPanel.add(this.m_hiCtrl);
        Util.setAccessible((Accessible)this.m_hiCtrl, jLabel);
        Util.setAccessible((Accessible)this.m_hiCtrl, jLabel);
        Util.setOrientation(this.m_lowCtrl, jLabel);
        Util.setOrientation(this.m_hiCtrl, jLabel2);
    }

    public void doOk() {
        String string = this.m_lowCtrl.getText().trim();
        String string2 = this.m_hiCtrl.getText().trim();
        int n = 0;
        int n2 = 0;
        if (string.length() == 0) {
            this.getToolkit().beep();
            this.m_lowCtrl.requestFocus();
            return;
        }
        try {
            n = Integer.parseInt(string);
        }
        catch (Throwable throwable) {
            this.getToolkit().beep();
            this.m_lowCtrl.requestFocus();
            return;
        }
        if (string2.length() == 0) {
            this.getToolkit().beep();
            this.m_hiCtrl.requestFocus();
            return;
        }
        try {
            n2 = Integer.parseInt(string2);
            if (n2 < n) {
                this.getToolkit().beep();
                this.m_hiCtrl.requestFocus();
                return;
            }
        }
        catch (Throwable throwable) {
            this.getToolkit().beep();
            this.m_hiCtrl.requestFocus();
            return;
        }
        this.m_low = n;
        this.m_hi = n2;
        this.setCanceled(false);
        this.dispose();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        super.actionPerformed(actionEvent);
        String string = actionEvent.getActionCommand();
        if (string.equals(LOW) || string.equals(HI) || string.equals("doit")) {
            this.doOk();
        }
    }

    private class WndAdapter
    extends WindowAdapter {
        private WndAdapter() {
        }

        public void windowOpened(WindowEvent windowEvent) {
            ArrayBoundsDialog.this.m_hiCtrl.requestFocus();
            ArrayBoundsDialog.this.m_hiCtrl.selectAll();
        }
    }
}

