/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iseries.debug.dialog;

import com.ibm.iseries.debug.util.Dialog;
import com.ibm.iseries.debug.util.MRI;
import com.ibm.iseries.debug.util.Util;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.accessibility.Accessible;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;

public class PickFromTableDialog
extends Dialog
implements MouseListener,
KeyListener {
    public static final int SELECT_NONE = -1;
    public static final int SELECT_ALL = -2;
    private JPanel m_panel;
    private JScrollPane m_scrollPane;
    private TblModel m_tableModel;
    private Tbl m_table;
    private String m_title;
    private String[][] m_items;
    private int m_rows;
    private int m_cols;
    private int m_select;
    private int[] m_selected;
    static /* synthetic */ Class class$java$lang$String;

    public PickFromTableDialog(JFrame jFrame, String string, String string2, String string3, String string4, String[][] stringArray, int n) {
        super(jFrame, string, true, string4);
        this.init(string, string2, string3, string4, stringArray, n);
    }

    public PickFromTableDialog(JDialog jDialog, String string, String string2, String string3, String string4, String[][] stringArray, int n) {
        super(jDialog, string, true, string4);
        this.init(string, string2, string3, string4, stringArray, n);
    }

    private void init(String string, String string2, String string3, String string4, String[][] stringArray, int n) {
        this.m_items = stringArray;
        this.m_title = string;
        this.m_rows = stringArray.length - 1;
        this.m_cols = stringArray[0].length;
        this.m_select = n;
        this.m_panel = new JPanel(new BorderLayout());
        this.m_panel.setBorder(this.getEmptyBorder(15, 15, 15, 15));
        JPanel jPanel = new JPanel(new GridLayout(0, 1));
        JLabel jLabel = Util.getAccessibleLabel(string2);
        jPanel.add(jLabel);
        jPanel.setBorder(this.getEmptyBorder(0, 0, 10, 0));
        jLabel.setAlignmentX(this.m_isLtoR ? 0.0f : 1.0f);
        this.m_tableModel = new TblModel();
        this.m_table = new Tbl(this.m_tableModel);
        this.m_scrollPane = new JScrollPane(this.m_table);
        this.m_scrollPane.getViewport().setBackground(this.m_table.getBackground());
        this.m_table.getTableHeader().setReorderingAllowed(false);
        int n2 = 0;
        FontMetrics fontMetrics = ((Component)this.m_table).getFontMetrics(this.m_table.getFont());
        int n3 = 0;
        while (n3 < this.m_cols) {
            int n4 = 0;
            int n5 = 0;
            while (n5 <= this.m_rows) {
                int n6 = fontMetrics.stringWidth(this.m_items[n5][n3]) + 20;
                if (n6 > n4) {
                    n4 = n6;
                }
                ++n5;
            }
            this.m_table.getColumnModel().getColumn(n3).setPreferredWidth(n4);
            n2 += n4;
            ++n3;
        }
        this.m_table.setOptimumWidth(n2);
        this.m_table.addMouseListener(this);
        this.m_table.addKeyListener(this);
        switch (n) {
            case -1: {
                break;
            }
            case -2: {
                this.m_table.selectAll();
                break;
            }
            default: {
                if (n < 0 || n >= this.m_rows) break;
                this.m_table.setRowSelectionInterval(n, n);
            }
        }
        Util.setAccessible((Accessible)this.m_table, jLabel);
        Util.setOrientation(jLabel);
        Util.setOrientation(this.m_scrollPane);
        this.m_panel.add((Component)jPanel, "North");
        this.m_panel.add((Component)this.m_scrollPane, "Center");
        if (string4 != null && string4.length() > 0) {
            this.m_panel.add((Component)this.defaultButtons(string3), "South");
        } else {
            this.m_panel.add((Component)this.defaultButtons(string3, true, false), "South");
        }
        this.setContentPane(this.m_panel);
        this.listenForEscape(this.m_panel);
        this.listenForEscape(this.m_table);
    }

    public void cleanUp() {
        super.cleanUp();
        this.m_panel = null;
        this.m_scrollPane = null;
        this.m_title = null;
        this.m_table = null;
    }

    public void setSingleSelect() {
        this.m_table.setSelectionMode(0);
        if (this.m_select >= 0 && this.m_select < this.m_table.getRowCount()) {
            this.m_table.setRowSelectionInterval(this.m_select, this.m_select);
        }
    }

    public void setMultiSelect() {
        this.m_table.setSelectionMode(2);
    }

    public int getSelectedIndex() {
        return this.m_selected.length > 0 ? this.m_selected[0] : -1;
    }

    public int[] getSelectedIndices() {
        return this.m_selected;
    }

    private void doIt() {
        if (this.m_table.getSelectedRowCount() == 0) {
            this.getToolkit().beep();
            Util.errorMessage(this, this.m_title, MRI.get("DBG_NO_ITEMS_SELECTED_ERROR"));
            return;
        }
        this.m_selected = this.m_table.getSelectedRows();
        this.setCanceled(false);
        this.dispose();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        super.actionPerformed(actionEvent);
        String string = actionEvent.getActionCommand();
        if (string.equals("doit")) {
            this.doIt();
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.getSource() == this.m_table && mouseEvent.getClickCount() == 2 && this.m_table.rowAtPoint(mouseEvent.getPoint()) >= 0) {
            this.doIt();
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getID() == 401 && keyEvent.getKeyCode() == 10) {
            this.doIt();
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected class TblModel
    extends AbstractTableModel {
        protected TblModel() {
        }

        public int getColumnCount() {
            return PickFromTableDialog.this.m_cols;
        }

        public int getRowCount() {
            return PickFromTableDialog.this.m_rows;
        }

        public String getColumnName(int n) {
            return PickFromTableDialog.this.m_items[0][n];
        }

        public Object getValueAt(int n, int n2) {
            return PickFromTableDialog.this.m_items[n + 1][n2];
        }

        public Class getColumnClass(int n) {
            return class$java$lang$String == null ? (class$java$lang$String = PickFromTableDialog.class$("java.lang.String")) : class$java$lang$String;
        }

        public boolean isCellEditable(int n, int n2) {
            return false;
        }
    }

    protected class Tbl
    extends JTable {
        private int m_optimumWidth;

        public Tbl(TblModel tblModel) {
            super(tblModel);
        }

        public void setOptimumWidth(int n) {
            Rectangle rectangle = PickFromTableDialog.this.getParent().getBounds();
            if (n <= rectangle.width) {
                this.m_optimumWidth = n;
            }
        }

        public Dimension getPreferredScrollableViewportSize() {
            Dimension dimension = super.getPreferredScrollableViewportSize();
            int n = PickFromTableDialog.this.m_rows < 20 ? PickFromTableDialog.this.m_rows : 20;
            dimension.height = n * this.getRowHeight();
            if (this.m_optimumWidth > dimension.width) {
                dimension.width = this.m_optimumWidth;
            }
            return dimension;
        }
    }
}

