/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iseries.debug.dialog;

import com.ibm.iseries.debug.panel.TreeTablePane;
import com.ibm.iseries.debug.util.Action;
import com.ibm.iseries.debug.util.DialogTabPanel;
import com.ibm.iseries.debug.util.MRI;
import com.ibm.iseries.debug.util.Menubar;
import com.ibm.iseries.debug.util.Settings;
import com.ibm.iseries.debug.util.SubMenu;
import com.ibm.iseries.debug.util.Util;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Iterator;
import javax.accessibility.Accessible;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class PreferencesKeysPage
extends DialogTabPanel
implements ActionListener,
TreeSelectionListener {
    private static final String KEY = "key";
    private static final String CONFIRM = "confirm";
    private static final String RESTORE = "restore";
    private Settings m_userCfg;
    private JPanel m_panel;
    private JPanel m_botPanel;
    private TreeTablePane m_pane;
    private JTree m_tree;
    private DefaultTreeModel m_treeModel;
    private ActionTreeNode m_root;
    private JTable m_table;
    private AbstractTableModel m_tableModel;
    private JCheckBox m_ctrl;
    private JCheckBox m_shift;
    private JCheckBox m_alt;
    private JTextField m_key;
    private JLabel m_keyLabel;
    private JButton m_confirm;
    private JButton m_restore;
    private HashMap m_actionToNode;
    private HashMap m_strokeToNode;
    private boolean m_modified;
    private boolean m_restored;
    static /* synthetic */ Class class$java$lang$String;

    public PreferencesKeysPage(Settings settings, Menubar menubar) {
        super(MRI.get("DBG_KEY_BINDINGS"), 8);
        this.m_userCfg = settings;
        this.m_actionToNode = new HashMap();
        this.m_strokeToNode = new HashMap();
        this.m_panel = new JPanel(new BorderLayout());
        this.m_botPanel = new JPanel(new BorderLayout());
        this.m_root = new ActionTreeNode("");
        this.m_treeModel = new DefaultTreeModel(this.m_root);
        this.m_tableModel = new TblModel();
        this.m_pane = new TreeTablePane(MRI.get("DBG_MENU"), this.m_treeModel, this.m_tableModel);
        this.m_tree = this.m_pane.getTree();
        this.m_table = this.m_pane.getTable();
        this.m_pane.getComponent().setPreferredSize(new Dimension(375, 200));
        this.m_tree.addTreeSelectionListener(this);
        this.m_tree.setCellRenderer(new ActionRenderer());
        this.populateTree(menubar);
        this.createSequenceArea();
        this.m_panel.add((Component)this.m_pane.getComponent(), "Center");
        this.m_panel.add((Component)this.m_botPanel, "South");
    }

    public JComponent getComponent() {
        return this.m_panel;
    }

    public void cleanUp() {
        this.m_pane.cleanUp();
        this.m_actionToNode.clear();
        this.m_strokeToNode.clear();
        this.m_userCfg = null;
        this.m_panel = null;
        this.m_botPanel = null;
        this.m_pane = null;
        this.m_root = null;
        this.m_tree = null;
        this.m_treeModel = null;
        this.m_table = null;
        this.m_tableModel = null;
        this.m_ctrl = null;
        this.m_shift = null;
        this.m_alt = null;
        this.m_key = null;
        this.m_keyLabel = null;
        this.m_confirm = null;
        this.m_restore = null;
        this.m_actionToNode = null;
        this.m_strokeToNode = null;
    }

    public boolean doOk() {
        if (this.m_modified) {
            Iterator iterator = this.m_actionToNode.values().iterator();
            while (iterator.hasNext()) {
                ActionTreeNode actionTreeNode = (ActionTreeNode)iterator.next();
                if (!this.m_restored && !actionTreeNode.m_removed && actionTreeNode.m_sequence == null) continue;
                actionTreeNode.m_action.setKeyStroke(actionTreeNode.m_keyStroke);
                if (actionTreeNode.m_removed || actionTreeNode.m_action.isDefaultKeyStroke()) {
                    this.m_userCfg.remove(actionTreeNode.m_action.getKey() + "Key");
                    continue;
                }
                if (actionTreeNode.m_sequence == null) continue;
                this.m_userCfg.setString(actionTreeNode.m_action.getKey() + "Key", actionTreeNode.m_sequence);
            }
        }
        return this.m_modified;
    }

    private void doConfirm() {
        TreePath treePath = this.m_tree.getSelectionPath();
        ActionTreeNode actionTreeNode = (ActionTreeNode)treePath.getLastPathComponent();
        String string = this.m_key.getText().trim().toUpperCase();
        if (string.length() == 0) {
            if (actionTreeNode.m_keyStroke != null) {
                int n = Util.confirm(this.getDialog(), MRI.get("DBG_ATTENTION"), MRI.get("DBG_REMOVE_KEYSTROKE"));
                if (n == 0) {
                    this.m_strokeToNode.remove(Action.getKeyStrokeString(actionTreeNode.m_keyStroke));
                    actionTreeNode.m_removed = true;
                    actionTreeNode.m_keyStroke = null;
                    actionTreeNode.m_sequence = null;
                    this.m_modified = true;
                    this.m_pane.refreshTreeAndTable();
                }
            } else {
                this.m_key.requestFocus();
                this.m_key.getToolkit().beep();
            }
            return;
        }
        String string2 = "";
        if (this.m_ctrl.isSelected()) {
            string2 = string2 + "ctrl ";
        }
        if (this.m_shift.isSelected()) {
            string2 = string2 + "shift ";
        }
        if (this.m_alt.isSelected()) {
            string2 = string2 + "alt ";
        }
        string2 = string2 + string;
        try {
            KeyStroke keyStroke = KeyStroke.getKeyStroke(string2);
            if (keyStroke != null) {
                String string3 = Action.getKeyStrokeString(keyStroke);
                ActionTreeNode actionTreeNode2 = (ActionTreeNode)this.m_strokeToNode.get(string3);
                if (actionTreeNode2 == null || actionTreeNode2 == actionTreeNode) {
                    this.m_modified = true;
                    this.m_strokeToNode.remove(Action.getKeyStrokeString(actionTreeNode.m_keyStroke));
                    this.m_strokeToNode.put(string3, actionTreeNode);
                    actionTreeNode.m_keyStroke = keyStroke;
                    actionTreeNode.m_sequence = string2;
                    this.m_pane.refreshTreeAndTable();
                } else {
                    Object[] objectArray = new Object[]{string3, actionTreeNode2.m_action.getName()};
                    String string4 = MessageFormat.format(MRI.get("DBG_KEYSTROKE_IN_USE_FMT"), objectArray);
                    Util.errorMessage(this.m_dialog, MRI.get("DBG_ERROR"), string4);
                }
            } else {
                Object[] objectArray = new Object[]{string};
                String string5 = MessageFormat.format(MRI.get("DBG_KEYSTROKE_ERROR_FMT"), objectArray);
                Util.errorMessage(this.m_dialog, MRI.get("DBG_ERROR"), string5);
            }
        }
        catch (Throwable throwable) {
            Object[] objectArray = new Object[]{string};
            String string6 = MessageFormat.format(MRI.get("DBG_KEYSTROKE_ERROR_FMT"), objectArray);
            Util.errorMessage(this.m_dialog, MRI.get("DBG_ERROR"), string6);
        }
    }

    private void doRestore() {
        this.m_modified = true;
        this.m_restored = true;
        Iterator iterator = this.m_actionToNode.values().iterator();
        while (iterator.hasNext()) {
            ActionTreeNode actionTreeNode = (ActionTreeNode)iterator.next();
            actionTreeNode.m_keyStroke = actionTreeNode.m_action.getDefaultKeyStroke();
            actionTreeNode.m_sequence = null;
            actionTreeNode.m_removed = false;
        }
        this.m_pane.refreshTreeAndTable();
    }

    private void populateTree(Menubar menubar) {
        int n = menubar.getMenuCount();
        int n2 = 0;
        while (n2 < n) {
            JMenu jMenu = menubar.getMenu(n2);
            this.populateTreeNode(this.m_root, jMenu, n2);
            ++n2;
        }
        this.m_treeModel.reload();
        this.m_tableModel.fireTableDataChanged();
        this.m_pane.refreshTreeAndTable();
    }

    private void populateTreeNode(ActionTreeNode actionTreeNode, JMenu jMenu, int n) {
        ActionTreeNode actionTreeNode2 = new ActionTreeNode(jMenu.getText());
        actionTreeNode.insert(actionTreeNode2, n);
        int n2 = jMenu.getItemCount();
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            JMenuItem jMenuItem;
            Action action;
            JMenuItem jMenuItem2 = jMenu.getItem(n4);
            if (jMenuItem2 instanceof JMenu) {
                if (!(jMenuItem2 instanceof SubMenu) || ((SubMenu)jMenuItem2).canCustomizeKeyStrokes()) {
                    this.populateTreeNode(actionTreeNode2, (JMenu)jMenuItem2, n3++);
                }
            } else if (jMenuItem2 instanceof JMenuItem && (action = (Action)(jMenuItem = jMenuItem2).getAction()) != null) {
                ActionTreeNode actionTreeNode3 = new ActionTreeNode(action);
                actionTreeNode2.insert(actionTreeNode3, n3++);
                String string = action.getKeyStrokeString();
                this.m_actionToNode.put(action, actionTreeNode3);
                if (string.length() > 0) {
                    this.m_strokeToNode.put(string, actionTreeNode3);
                }
            }
            ++n4;
        }
    }

    private void createSequenceArea() {
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel(new BorderLayout());
        JPanel jPanel3 = new JPanel(new FlowLayout(this.m_isLtoR ? 2 : 0, 3, 0));
        this.m_ctrl = new JCheckBox("Ctrl", false);
        this.m_shift = new JCheckBox("Shift", false);
        this.m_alt = new JCheckBox("Alt", false);
        jPanel3.add(this.m_ctrl);
        jPanel3.add(this.m_shift);
        jPanel3.add(this.m_alt);
        jPanel2.add((Component)jPanel3, "North");
        JPanel jPanel4 = new JPanel(new BorderLayout());
        JPanel jPanel5 = new JPanel(new GridLayout(0, 1, 0, 6));
        JPanel jPanel6 = new JPanel(new GridLayout(0, 1, 0, 6));
        jPanel5.setBorder(this.getEmptyBorder(0, 0, 10, 10));
        jPanel6.setBorder(this.getEmptyBorder(0, 10, 10, 10));
        jPanel4.add((Component)jPanel5, this.m_isLtoR ? "West" : "East");
        jPanel4.add((Component)jPanel6, "Center");
        this.m_keyLabel = Util.getAccessibleLabel(MRI.get("DBG_KEY_LABEL"));
        jPanel5.add(this.m_keyLabel);
        jPanel5.add(new JLabel());
        this.m_key = new JTextField();
        this.m_key.setActionCommand(KEY);
        this.m_key.addActionListener(this);
        this.m_confirm = new JButton(MRI.get("DBG_CONFIRM"));
        this.m_confirm.setActionCommand(CONFIRM);
        this.m_confirm.addActionListener(this);
        jPanel6.add(this.m_key);
        jPanel6.add(this.m_confirm);
        JPanel jPanel7 = new JPanel();
        this.m_restore = new JButton(MRI.get("DBG_RESTORE_DEFAULTS"));
        this.m_restore.setActionCommand(RESTORE);
        this.m_restore.addActionListener(this);
        jPanel7.setBorder(this.getEmptyBorder(10, 0, 0, 0));
        jPanel7.add(this.m_restore);
        Util.setAccessible((Accessible)this.m_ctrl, "Ctrl");
        Util.setAccessible((Accessible)this.m_shift, "Shift");
        Util.setAccessible((Accessible)this.m_alt, "Alt");
        Util.setAccessible((Accessible)this.m_key, this.m_keyLabel);
        Util.setAccessible((Accessible)this.m_confirm, this.m_confirm.getText());
        Util.setAccessible((Accessible)this.m_restore, this.m_restore.getText());
        Util.setOrientation(jPanel3);
        Util.setOrientation(this.m_ctrl);
        Util.setOrientation(this.m_shift);
        Util.setOrientation(this.m_alt);
        Util.setOrientation(this.m_key, this.m_keyLabel);
        Util.setOrientation(this.m_confirm);
        Util.setOrientation(this.m_restore);
        jPanel.setBorder(this.getTitledBorder(MRI.get("DBG_KEY_SEQUENCE")));
        jPanel.add((Component)jPanel2, this.m_isLtoR ? "West" : "East");
        jPanel.add((Component)jPanel4, this.m_isLtoR ? "East" : "West");
        this.m_botPanel.setBorder(this.getEmptyBorder(10, 10, 10, 10));
        this.m_botPanel.add((Component)jPanel, "North");
        this.m_botPanel.add((Component)jPanel7, "South");
        this.enableControls(false, 0);
    }

    private Action getAction(TreePath treePath) {
        ActionTreeNode actionTreeNode = (ActionTreeNode)treePath.getLastPathComponent();
        return actionTreeNode.m_action;
    }

    private Action getAction(int n) {
        TreePath treePath = this.m_tree.getPathForRow(n);
        if (treePath == null) {
            return null;
        }
        return this.getAction(treePath);
    }

    private KeyStroke getKeyStroke(TreePath treePath) {
        ActionTreeNode actionTreeNode = (ActionTreeNode)treePath.getLastPathComponent();
        return actionTreeNode.m_keyStroke;
    }

    private KeyStroke getKeyStroke(int n) {
        TreePath treePath = this.m_tree.getPathForRow(n);
        if (treePath == null) {
            return null;
        }
        return this.getKeyStroke(treePath);
    }

    private void enableControls(boolean bl, int n) {
        this.m_ctrl.setSelected((n & 2) != 0);
        this.m_shift.setSelected((n & 1) != 0);
        this.m_alt.setSelected((n & 8) != 0);
        this.m_ctrl.setEnabled(bl);
        this.m_shift.setEnabled(bl);
        this.m_alt.setEnabled(bl);
        this.m_keyLabel.setEnabled(bl);
        this.m_key.setEnabled(bl);
        this.m_key.setOpaque(bl);
        this.m_confirm.setEnabled(bl);
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        if (treeSelectionEvent.isAddedPath()) {
            Action action = this.getAction(this.m_tree.getSelectionPath());
            if (action != null) {
                KeyStroke keyStroke = this.getKeyStroke(this.m_tree.getSelectionPath());
                int n = 0;
                if (keyStroke != null) {
                    n = keyStroke.getModifiers();
                    this.m_key.setText(KeyEvent.getKeyText(keyStroke.getKeyCode()));
                } else {
                    this.m_key.setText("");
                }
                this.enableControls(true, n);
            } else {
                this.enableControls(false, 0);
                this.m_key.setText("");
            }
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(CONFIRM) || string.equals(KEY)) {
            this.doConfirm();
        } else if (string.equals(RESTORE)) {
            this.doRestore();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class TblModel
    extends AbstractTableModel {
        private final int COL_COUNT = 1;

        public int getColumnCount() {
            return 1;
        }

        public int getRowCount() {
            return PreferencesKeysPage.this.m_tree != null ? PreferencesKeysPage.this.m_tree.getRowCount() : 0;
        }

        public String getColumnName(int n) {
            return MRI.get("DBG_KEY_SEQUENCE");
        }

        public Object getValueAt(int n, int n2) {
            KeyStroke keyStroke = PreferencesKeysPage.this.getKeyStroke(n);
            if (keyStroke != null) {
                return Action.getKeyStrokeString(keyStroke);
            }
            return "";
        }

        public Class getColumnClass(int n) {
            return class$java$lang$String == null ? (class$java$lang$String = PreferencesKeysPage.class$("java.lang.String")) : class$java$lang$String;
        }

        public boolean isCellEditable(int n, int n2) {
            return false;
        }
    }

    private class ActionRenderer
    extends DefaultTreeCellRenderer {
        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            ImageIcon imageIcon;
            ActionTreeNode actionTreeNode;
            super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            if (object instanceof ActionTreeNode && (actionTreeNode = (ActionTreeNode)object).m_action != null && (imageIcon = actionTreeNode.m_action.getIcon()) != null) {
                this.setIcon(imageIcon);
            }
            return this;
        }
    }

    private class ActionTreeNode
    extends DefaultMutableTreeNode {
        private Action m_action;
        private KeyStroke m_keyStroke;
        private String m_sequence;
        private boolean m_removed;

        public ActionTreeNode(String string) {
            super(string);
        }

        public ActionTreeNode(Action action) {
            super(action);
            this.m_action = action;
            this.m_keyStroke = action.getKeyStroke();
        }
    }
}

