/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iseries.debug.manager;

import com.ibm.iseries.debug.BreakpointDescriptor;
import com.ibm.iseries.debug.Breakpoints;
import com.ibm.iseries.debug.DebugConstants;
import com.ibm.iseries.debug.ISeriesMessage;
import com.ibm.iseries.debug.dialog.ISeriesMessageDialog;
import com.ibm.iseries.debug.event.ContextEvent;
import com.ibm.iseries.debug.listener.ContextListener;
import com.ibm.iseries.debug.manager.BreakpointManager;
import com.ibm.iseries.debug.panel.BreakpointsPanel;
import com.ibm.iseries.debug.panel.MonitorsPanel;
import com.ibm.iseries.debug.request.MapContextRequest;
import com.ibm.iseries.debug.request.PauseRequest;
import com.ibm.iseries.debug.request.RefreshContextRequest;
import com.ibm.iseries.debug.util.DebugContext;
import com.ibm.iseries.debug.util.Dialog;
import com.ibm.iseries.debug.util.MRI;
import com.ibm.iseries.debug.util.Manager;
import com.ibm.iseries.debug.util.Toolbox;
import com.ibm.iseries.debug.util.Util;
import java.text.MessageFormat;

public class ContextManager
extends Manager
implements DebugConstants {
    public static final String KEY = "ctxtmgr";
    protected DebugContext m_ctxt;
    protected String m_contextViewId = "";
    protected int m_contextLineNum = -1;
    protected String m_asmContextViewId = "";
    protected int m_asmContextLineNum = -1;
    protected boolean m_firstContext = true;
    protected int m_runCount;
    protected boolean m_partnerSync;

    public ContextManager(DebugContext debugContext) {
        this.m_ctxt = debugContext;
    }

    public String getKey() {
        return KEY;
    }

    public void clear() {
        super.clear();
        this.m_contextViewId = "";
        this.m_contextLineNum = -1;
        this.m_asmContextViewId = "";
        this.m_asmContextLineNum = -1;
        this.m_firstContext = true;
        this.m_partnerSync = false;
        this.resetRunAllowed();
    }

    public void cleanUp() {
        super.cleanUp();
        this.m_ctxt = null;
        this.m_contextViewId = null;
        this.m_asmContextViewId = null;
    }

    public synchronized void allowRun(boolean bl) {
        if (bl) {
            if (this.m_runCount >= 100) {
                this.m_runCount -= 100;
                if (this.m_runCount < 0) {
                    this.m_runCount = 0;
                }
            }
        } else if (this.m_runCount < 100) {
            this.m_runCount += 100;
        }
    }

    public synchronized boolean runAllowed() {
        return this.m_runCount == 0;
    }

    protected synchronized void resetRunAllowed() {
        this.m_runCount = 0;
    }

    public synchronized void runInitiated() {
        ++this.m_runCount;
        if (this.m_ctxt.hasPartnerContext() && this.m_ctxt.getPartnerContext().runActionAllowed()) {
            this.m_ctxt.getPartnerContext().getActionGroup().setPgmRunning(false);
        }
    }

    protected synchronized void runCompleted() {
        if (--this.m_runCount < 0) {
            this.m_runCount = 0;
        }
        if (this.m_ctxt.hasPartnerContext()) {
            DebugContext debugContext = this.m_ctxt.getPartnerContext();
            if (!this.m_partnerSync) {
                debugContext.supportAction("pauset", true);
            }
            if (debugContext.runActionAllowed()) {
                debugContext.getActionGroup().setPgmRunning(true);
            }
        }
    }

    public boolean isValidContext() {
        return this.m_contextViewId.length() > 0 && this.m_contextLineNum > 0;
    }

    public String getContextViewId() {
        return this.m_contextViewId;
    }

    public int getContextLineNum() {
        return this.m_contextLineNum;
    }

    public String getAsmContextViewId() {
        return this.m_asmContextViewId;
    }

    public int getAsmContextLineNum() {
        return this.m_asmContextLineNum;
    }

    public void refreshContext(boolean bl) {
        if (bl) {
            this.m_ctxt.sendRequest(new RefreshContextRequest());
        } else {
            this.fireContextEvent(new ContextEvent(this, 1, this.m_contextViewId, this.m_contextLineNum));
        }
    }

    public void mapContext(String string, String string2) {
        if (this.isValidContext()) {
            String string3 = this.m_contextViewId.equals(string) ? string2 : this.m_contextViewId;
            MapContextRequest mapContextRequest = new MapContextRequest(this.m_contextViewId, this.m_contextLineNum, string3);
            this.m_ctxt.sendRequest(mapContextRequest);
        }
    }

    public void initializePartnerStep() {
        this.m_partnerSync = true;
    }

    public void synchronizePartnerStep() {
        this.m_partnerSync = true;
        this.m_ctxt.sendRequest(new PauseRequest());
    }

    public void fireContextEvent(ContextEvent contextEvent) {
        int n = contextEvent.getType();
        switch (n) {
            case 0: {
                this.m_contextViewId = contextEvent.getViewId();
                this.m_contextLineNum = contextEvent.getLineNum();
                this.m_asmContextViewId = contextEvent.getAsmViewId();
                this.m_asmContextLineNum = contextEvent.getAsmLineNum();
                if (this.m_firstContext) {
                    this.m_firstContext = false;
                    this.m_ctxt.firstContextEvent();
                }
                this.runCompleted();
                break;
            }
            case 1: 
            case 2: {
                this.m_contextViewId = contextEvent.getViewId();
                this.m_contextLineNum = contextEvent.getLineNum();
                this.m_asmContextViewId = contextEvent.getAsmViewId();
                this.m_asmContextLineNum = contextEvent.getAsmLineNum();
                break;
            }
            case 4: {
                this.m_firstContext = true;
                this.resetRunAllowed();
            }
        }
        int n2 = this.m_listeners.size();
        int n3 = 0;
        while (n3 < n2) {
            ContextListener contextListener = (ContextListener)this.m_listeners.get(n3);
            contextListener.contextChanged(contextEvent);
            ++n3;
        }
        if (n != 0) {
            return;
        }
        int n4 = contextEvent.getMask();
        if (contextEvent.isExceptionMask()) {
            Object object;
            Object object2;
            if (this.m_ctxt.hasPeerContext()) {
                this.m_ctxt.bringToFront();
            }
            ISeriesMessage iSeriesMessage = contextEvent.getMsgObj();
            String string = null;
            if (iSeriesMessage != null) {
                string = Toolbox.instance().getMsgText(this.m_ctxt, iSeriesMessage);
            }
            if (string == null || string.length() == 0) {
                object2 = new Object[]{new Integer(contextEvent.getLineNum())};
                string = MessageFormat.format(MRI.get("DBG_EXCEPTION_AT_FMT"), object2);
                iSeriesMessage = null;
            }
            this.m_ctxt.setDebugIcon(2, string);
            this.m_ctxt.setMessage(string);
            if (this.m_ctxt.getPgmPath().length() > 0) {
                object = new Object[]{this.m_ctxt.getPgmPath(), string};
                object2 = MessageFormat.format(MRI.get("DBG_EXCEPTION_DIALOG_FMT"), (Object[])object);
            } else {
                object = new Object[]{this.m_ctxt.getJobId(), string};
                object2 = MessageFormat.format(MRI.get("DBG_PROCESS_EXCEPTION_DIALOG_FMT"), (Object[])object);
            }
            if (iSeriesMessage != null) {
                object = new ISeriesMessageDialog(this.m_ctxt, (String)object2, Toolbox.instance().getMsgHelp(iSeriesMessage));
                ((Dialog)object).display(this.m_ctxt);
            } else {
                Util.errorMessage(this.m_ctxt.getJFrame(), MRI.get("DBG_ERROR"), (String)object2);
            }
        } else if (contextEvent.isBreakMask()) {
            Object object;
            Object object3;
            String string = "";
            String string2 = "";
            BreakpointManager breakpointManager = (BreakpointManager)this.m_ctxt.getManager("brkmgr");
            Breakpoints breakpoints = breakpointManager.getBreakpoints(contextEvent.getViewId());
            if (breakpoints != null && (object3 = breakpoints.getDescriptor(contextEvent.getLineNum())) != null) {
                string = ((BreakpointDescriptor)object3).getCondition();
                string2 = ((BreakpointDescriptor)object3).getThreadId();
                object = (BreakpointsPanel)this.m_ctxt.getPanel("breakpoints");
                ((BreakpointsPanel)object).selectBreakpoint((BreakpointDescriptor)object3);
            }
            if (string.length() > 0) {
                object = new Object[]{new Integer(contextEvent.getLineNum()), string, string2};
                object3 = string2.length() > 0 ? MessageFormat.format(MRI.get("DBG_COND_TBREAK_AT_FMT"), (Object[])object) : MessageFormat.format(MRI.get("DBG_COND_BREAK_AT_FMT"), (Object[])object);
            } else {
                object = new Object[]{new Integer(contextEvent.getLineNum()), string2};
                object3 = string2.length() > 0 ? MessageFormat.format(MRI.get("DBG_TBREAK_AT_FMT"), (Object[])object) : MessageFormat.format(MRI.get("DBG_BREAK_AT_FMT"), (Object[])object);
            }
            this.m_ctxt.setDebugIcon(5, (String)object3);
            this.m_ctxt.setMessage((String)object3);
            this.m_ctxt.bringToFront();
        } else if (contextEvent.isStepMask()) {
            if (this.m_ctxt.hasPeerContext()) {
                this.m_ctxt.bringToFront();
            }
            Object[] objectArray = new Object[]{new Integer(contextEvent.getLineNum())};
            String string = MessageFormat.format(MRI.get("DBG_STEP_COMPLETED_FMT"), objectArray);
            this.m_ctxt.setDebugIcon(0, string);
            this.m_ctxt.setMessage(string);
        } else if (contextEvent.isWatchMask()) {
            if (this.m_ctxt.hasPeerContext()) {
                this.m_ctxt.bringToFront();
            }
            MonitorsPanel monitorsPanel = (MonitorsPanel)this.m_ctxt.getPanel("monitors");
            String string = monitorsPanel.getWatchName(contextEvent.getWatchNum());
            String string3 = null;
            if (string.length() > 0) {
                Object[] objectArray = new Object[]{new Integer(contextEvent.getLineNum()), string};
                string3 = MessageFormat.format(MRI.get("DBG_WATCH_AT_FMT"), objectArray);
            } else {
                Object[] objectArray = new Object[]{new Integer(contextEvent.getLineNum()), new Integer(contextEvent.getWatchNum())};
                string3 = MessageFormat.format(MRI.get("DBG_WATCH_NUM_AT_FMT"), objectArray);
            }
            this.m_ctxt.setDebugIcon(4, string3);
            this.m_ctxt.setMessage(string3);
        } else if (contextEvent.isHaltMask()) {
            String string = null;
            int n5 = contextEvent.getWatchNum();
            if (this.m_partnerSync) {
                this.m_partnerSync = false;
                this.m_ctxt.getAction("stepin").run();
            } else {
                if (n5 > 0) {
                    if (this.m_ctxt.hasPeerContext()) {
                        this.m_ctxt.bringToFront();
                    }
                    String string4 = this.translateSignalName(n5);
                    Object[] objectArray = new Object[]{String.valueOf(n5), string4};
                    string = MessageFormat.format(MRI.get("DBG_PGM_RECEIVED_SIGNAL_FMT"), objectArray);
                    Util.warnMessage(this.m_ctxt.getJFrame(), string4, string);
                } else if (contextEvent.getLineNum() > 0) {
                    if (this.m_ctxt.hasPeerContext()) {
                        this.m_ctxt.bringToFront();
                    }
                    Object[] objectArray = new Object[]{new Integer(contextEvent.getLineNum())};
                    string = MessageFormat.format(MRI.get("DBG_STOP_API_FMT"), objectArray);
                } else if (contextEvent.getAsmLineNum() > 0 && this.m_ctxt.hasPeerContext()) {
                    this.m_ctxt.bringToFront();
                }
                this.m_ctxt.setDebugIcon(3, string);
                this.m_ctxt.setMessage(string);
            }
        } else if (contextEvent.isAsmExceptionMask()) {
            Object object;
            Object object4;
            if (this.m_ctxt.hasPeerContext()) {
                this.m_ctxt.bringToFront();
            }
            if (this.m_ctxt.isDisassemblyShown() && !this.m_ctxt.isDisassemblyActive()) {
                this.m_ctxt.setActiveSource(this.m_ctxt.getDisassembly());
            }
            ISeriesMessage iSeriesMessage = contextEvent.getMsgObj();
            String string = null;
            if (iSeriesMessage != null) {
                string = Toolbox.instance().getMsgText(this.m_ctxt, iSeriesMessage);
            }
            if (string == null || string.length() == 0) {
                object4 = new Object[]{contextEvent.getAsmAddress()};
                string = MessageFormat.format(MRI.get("DBG_ASM_EXCEPTION_AT_FMT"), object4);
                iSeriesMessage = null;
            }
            this.m_ctxt.setDebugIcon(2, string);
            this.m_ctxt.setMessage(string);
            if (this.m_ctxt.getPgmPath().length() > 0) {
                object = new Object[]{this.m_ctxt.getPgmPath(), string};
                object4 = MessageFormat.format(MRI.get("DBG_EXCEPTION_DIALOG_FMT"), (Object[])object);
            } else {
                object = new Object[]{this.m_ctxt.getJobId(), string};
                object4 = MessageFormat.format(MRI.get("DBG_PROCESS_EXCEPTION_DIALOG_FMT"), (Object[])object);
            }
            if (iSeriesMessage != null) {
                object = new ISeriesMessageDialog(this.m_ctxt, (String)object4, Toolbox.instance().getMsgHelp(iSeriesMessage));
                ((Dialog)object).display(this.m_ctxt);
            } else {
                Util.errorMessage(this.m_ctxt.getJFrame(), MRI.get("DBG_ERROR"), (String)object4);
            }
        } else if (contextEvent.isAsmStepMask()) {
            if (this.m_ctxt.hasPeerContext()) {
                this.m_ctxt.bringToFront();
            }
            Object[] objectArray = new Object[]{contextEvent.getAsmAddress()};
            String string = MessageFormat.format(MRI.get("DBG_ASM_STEP_COMPLETED_FMT"), objectArray);
            this.m_ctxt.setDebugIcon(0, string);
            this.m_ctxt.setMessage(string);
        } else if (contextEvent.isAsmBreakMask()) {
            Object object;
            Object[] objectArray;
            BreakpointManager breakpointManager;
            Breakpoints breakpoints;
            if (this.m_ctxt.hasPeerContext()) {
                this.m_ctxt.bringToFront();
            }
            if ((breakpoints = (breakpointManager = (BreakpointManager)this.m_ctxt.getManager("brkmgr")).getBreakpoints(contextEvent.getAsmViewId())) != null && (objectArray = breakpoints.getDescriptor(contextEvent.getAsmLineNum())) != null) {
                object = (BreakpointsPanel)this.m_ctxt.getPanel("breakpoints");
                ((BreakpointsPanel)object).selectBreakpoint((BreakpointDescriptor)objectArray);
            }
            objectArray = new Object[]{contextEvent.getAsmAddress()};
            object = MessageFormat.format(MRI.get("DBG_ASM_BREAK_AT_FMT"), objectArray);
            if (this.m_ctxt.isDisassemblyShown()) {
                if (!this.m_ctxt.isDisassemblyActive()) {
                    this.m_ctxt.getDisassembly().viewRequestFocus();
                    this.m_ctxt.setActiveSource(this.m_ctxt.getDisassembly());
                }
            } else if (!this.m_ctxt.getDesktop().sourceExists(contextEvent.getAsmViewId())) {
                this.m_ctxt.showDisassembly(true, true);
                this.m_ctxt.getDisassembly().viewRequestFocus();
                this.m_ctxt.setActiveSource(this.m_ctxt.getDisassembly());
            }
            this.m_ctxt.setDebugIcon(5, (String)object);
            this.m_ctxt.setMessage((String)object);
            this.m_ctxt.bringToFront();
        } else if (contextEvent.isAsmHaltMask()) {
            if (this.m_ctxt.hasPeerContext()) {
                this.m_ctxt.bringToFront();
            }
            Object[] objectArray = new Object[]{contextEvent.getAsmAddress()};
            String string = MessageFormat.format(MRI.get("DBG_ASM_HALT_FMT"), objectArray);
            if (this.m_ctxt.isDisassemblyShown() && !this.m_ctxt.isDisassemblyActive()) {
                this.m_ctxt.setActiveSource(this.m_ctxt.getDisassembly());
            }
            this.m_ctxt.setDebugIcon(3, string);
            this.m_ctxt.setMessage(string);
        } else if (contextEvent.isCurrentThreadMask()) {
            if (this.m_ctxt.hasPeerContext()) {
                this.m_ctxt.bringToFront();
            }
            this.m_ctxt.setDebugIconTooltip(MRI.get("DBG_CURRENT_THREAD_CHANGED"));
        } else if (n4 != 0) {
            if (this.m_ctxt.hasPeerContext()) {
                this.m_ctxt.bringToFront();
            }
            this.m_ctxt.setDebugIcon(0, null);
            this.m_ctxt.clearMessage();
        }
    }

    private String translateSignalName(int n) {
        String string;
        switch (n) {
            case 1: {
                string = "SIGHUP";
                break;
            }
            case 2: {
                string = "SIGINT";
                break;
            }
            case 3: {
                string = "SIGQUIT";
                break;
            }
            case 4: {
                string = "SIGILL";
                break;
            }
            case 5: {
                string = "SIGTRAP";
                break;
            }
            case 6: {
                string = "SIGABRT";
                break;
            }
            case 7: {
                string = "SIGEMT";
                break;
            }
            case 8: {
                string = "SIGFPE";
                break;
            }
            case 9: {
                string = "SIGKILL";
                break;
            }
            case 10: {
                string = "SIGBUS";
                break;
            }
            case 11: {
                string = "SIGSEGV";
                break;
            }
            case 12: {
                string = "SIGSYS";
                break;
            }
            case 13: {
                string = "SIGPIPE";
                break;
            }
            case 14: {
                string = "SIGALRM";
                break;
            }
            case 15: {
                string = "SIGTERM";
                break;
            }
            case 16: {
                string = "SIGURG";
                break;
            }
            case 17: {
                string = "SIGSTOP";
                break;
            }
            case 18: {
                string = "SIGTSTP";
                break;
            }
            case 19: {
                string = "SIGCONT";
                break;
            }
            case 20: {
                string = "SIGCHLD";
                break;
            }
            case 21: {
                string = "SIGTTIN";
                break;
            }
            case 22: {
                string = "SIGTTOU";
                break;
            }
            case 23: {
                string = "SIGIO";
                break;
            }
            case 24: {
                string = "SIGXCP";
                break;
            }
            case 25: {
                string = "SIGXFSZ";
                break;
            }
            case 27: {
                string = "SIGMSG";
                break;
            }
            case 28: {
                string = "SIGWINCH";
                break;
            }
            case 29: {
                string = "SIGPWR";
                break;
            }
            case 30: {
                string = "SIGUSR1";
                break;
            }
            case 31: {
                string = "SIGUSR2";
                break;
            }
            case 32: {
                string = "SIGPROF";
                break;
            }
            case 33: {
                string = "SIGDANGER";
                break;
            }
            case 34: {
                string = "SIGVTALRM";
                break;
            }
            case 35: {
                string = "SIGMIGRATE";
                break;
            }
            case 36: {
                string = "SIGPRE";
                break;
            }
            case 37: {
                string = "SIGVIRT";
                break;
            }
            case 38: {
                string = "SIGALRM1";
                break;
            }
            case 39: {
                string = "SIGWAITING";
                break;
            }
            case 59: {
                string = "SIGCPUFAIL";
                break;
            }
            case 60: {
                string = "SIGKAP/SIGGRANT";
                break;
            }
            case 61: {
                string = "SIGRETRACT";
                break;
            }
            case 62: {
                string = "SIGSOUND";
                break;
            }
            case 63: {
                string = "SIGSAK";
                break;
            }
            default: {
                string = MRI.get("DBG_UNKNOWN");
            }
        }
        return string;
    }
}

