/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iseries.debug.manager;

import com.ibm.iseries.debug.event.MemoryEvent;
import com.ibm.iseries.debug.event.VariableEvent;
import com.ibm.iseries.debug.listener.MemoryListener;
import com.ibm.iseries.debug.manager.VariableManager;
import com.ibm.iseries.debug.memory.MemoryAddress;
import com.ibm.iseries.debug.request.MemoryAddrReadRequest;
import com.ibm.iseries.debug.request.MemoryAddrWriteRequest;
import com.ibm.iseries.debug.request.MemoryExpReadRequest;
import com.ibm.iseries.debug.request.MemoryExpWriteRequest;
import com.ibm.iseries.debug.util.DebugContext;
import com.ibm.iseries.debug.util.Manager;

public class MemoryManager
extends Manager {
    public static final String KEY = "memmgr";
    protected DebugContext m_ctxt;

    public MemoryManager(DebugContext debugContext) {
        this.m_ctxt = debugContext;
    }

    public void cleanUp() {
        int n = this.m_listeners.size();
        int n2 = 0;
        while (n2 < n) {
            MemoryListener memoryListener = (MemoryListener)this.m_listeners.get(n2);
            memoryListener.memoryMgrCleanUp();
            ++n2;
        }
        super.cleanUp();
        this.m_ctxt = null;
    }

    public String getKey() {
        return KEY;
    }

    public void clear() {
        super.clear();
        int n = this.m_listeners.size();
        int n2 = 0;
        while (n2 < n) {
            MemoryListener memoryListener = (MemoryListener)this.m_listeners.get(n2);
            memoryListener.memoryMgrClear();
            ++n2;
        }
    }

    public void requestMemoryRead(MemoryAddress memoryAddress, int n) {
        MemoryAddrReadRequest memoryAddrReadRequest = new MemoryAddrReadRequest(memoryAddress, n);
        this.m_ctxt.sendRequest(memoryAddrReadRequest);
    }

    public void requestMemoryWrite(MemoryAddress memoryAddress, String string, String string2) {
        MemoryAddrWriteRequest memoryAddrWriteRequest = new MemoryAddrWriteRequest(memoryAddress, string, string2);
        this.m_ctxt.sendRequest(memoryAddrWriteRequest);
    }

    public void requestMemoryRead(String string, String string2, int n, int n2) {
        MemoryExpReadRequest memoryExpReadRequest = new MemoryExpReadRequest(string, string2, n, n2);
        this.m_ctxt.sendRequest(memoryExpReadRequest);
    }

    public void requestMemoryWrite(String string, String string2, int n, String string3, String string4) {
        MemoryExpWriteRequest memoryExpWriteRequest = new MemoryExpWriteRequest(string, string2, n, string3, string4);
        this.m_ctxt.sendRequest(memoryExpWriteRequest);
    }

    public void fireMemoryEvent(MemoryEvent memoryEvent) {
        Object object;
        int n = this.m_listeners.size();
        int n2 = 0;
        while (n2 < n) {
            object = (MemoryListener)this.m_listeners.get(n2);
            switch (memoryEvent.getType()) {
                case 1: {
                    object.memoryAvailable(memoryEvent);
                    break;
                }
                case 3: {
                    object.memoryNotAvailable(memoryEvent);
                    break;
                }
                case 2: {
                    object.memoryChanged(memoryEvent);
                    break;
                }
                case 4: {
                    object.memoryNotChanged(memoryEvent);
                    break;
                }
                case 5: {
                    object.memoryPossiblyChanged(memoryEvent);
                }
            }
            ++n2;
        }
        if (memoryEvent.getType() == 2 && (object = (VariableManager)this.m_ctxt.getManager("varmgr")) != null) {
            ((VariableManager)object).fireVariableEvent(new VariableEvent(this, 4));
        }
    }

    public void fireMemoryAddressSizeChanged(int n, int n2) {
        int n3 = this.m_listeners.size();
        int n4 = 0;
        while (n4 < n3) {
            MemoryListener memoryListener = (MemoryListener)this.m_listeners.get(n4);
            memoryListener.memoryAddressSizeChanged(n, n2);
            ++n4;
        }
    }
}

