/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iseries.debug.memory;

import com.ibm.iseries.debug.DebugConstants;
import com.ibm.iseries.debug.manager.SettingsManager;
import com.ibm.iseries.debug.memory.MemoryAddrEditListener;
import com.ibm.iseries.debug.memory.MemoryAddress;
import com.ibm.iseries.debug.util.Util;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import javax.swing.ComboBoxEditor;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;

public class MemoryAddrControl
extends JComboBox
implements DebugConstants {
    private static final int MAX_REMEMBER = 20;
    private static Color s_fg = UIManager.getColor("TextField.foreground");
    private static Color s_bg = UIManager.getColor("TextField.background");
    private static Color s_caret = UIManager.getColor("TextField.caretForeground");
    private MemoryAddress m_addr;
    private Editor m_editor = new Editor();
    private boolean m_editing;
    private MemoryAddrEditListener m_listener;
    private int m_gap;
    private int m_cursorDirection = 1;
    private boolean m_ignore;
    private boolean m_cancelEnabled = true;
    private boolean m_enterPressed;
    private int m_hackSize = 0;

    public MemoryAddrControl(int n, int n2) {
        this.setEditor(this.m_editor);
        this.setEditable(true);
        this.setMaximumRowCount(20);
        this.addActionListener(this.m_editor);
        if (n2 > 0 && n > n2) {
            this.m_gap = n / 4 - n2 / 4;
        }
        this.setAddress(new MemoryAddress("0000000000000000000000000000000000000000000000000000000000000000".substring(0, n / 4)));
    }

    public MemoryAddrControl(MemoryAddress memoryAddress, int n) {
        this.setEditor(this.m_editor);
        this.setEditable(true);
        this.setMaximumRowCount(20);
        this.addActionListener(this.m_editor);
        int n2 = memoryAddress.toString().length() * 4;
        if (n > 0 && n2 > n) {
            this.m_gap = n2 / 4 - n / 4;
        }
        this.setAddress(memoryAddress);
    }

    public void cleanUp() {
        this.removeActionListener(this.m_editor);
        this.m_editor = null;
        this.m_listener = null;
    }

    public int getAddressSizeInBits() {
        return this.m_addr.getBitCount();
    }

    public int getAddressSizeInNibbles() {
        return this.m_addr.getNibbleCount();
    }

    public int getAddressSizeInBytes() {
        return this.m_addr.getByteCount();
    }

    public MemoryAddress getAddress() {
        return this.m_addr;
    }

    public MemoryAddress getEditAddress() {
        String string = this.unFormatAddress();
        if (string.length() == 0) {
            return this.getAddress();
        }
        MemoryAddress memoryAddress = new MemoryAddress(string);
        return memoryAddress;
    }

    public void setAddress(MemoryAddress memoryAddress) {
        String string = this.formatAddress(memoryAddress.toString());
        switch (this.getItemCount()) {
            case 0: {
                this.addItem(string);
                break;
            }
            case 1: {
                if (!this.m_addr.isZero()) break;
                this.removeAllItems();
                this.addItem(string);
            }
        }
        this.m_addr = memoryAddress;
        this.selectItem(string);
        JTextField jTextField = new JTextField(string);
        Dimension dimension = jTextField.getPreferredSize();
        int n = dimension.width + 20;
        if (dimension.width != this.m_hackSize) {
            dimension.width = n;
            this.setPreferredSize(dimension);
            this.m_hackSize = n;
        }
    }

    public void insertAddress(MemoryAddress memoryAddress) {
        String string = this.formatAddress(memoryAddress.toString());
        if (this.getItemCount() == 1 && this.m_addr.isZero()) {
            this.removeAllItems();
        }
        this.removeItem(string);
        this.insertItemAt(string, 0);
        this.m_addr = memoryAddress;
        this.selectItem(string);
        if (this.getItemCount() > 20) {
            this.removeItemAt(20);
        }
    }

    public void appendAddress(MemoryAddress memoryAddress) {
        String string = this.formatAddress(memoryAddress.toString());
        this.removeItem(string);
        this.insertItemAt(string, this.getItemCount());
        if (this.getItemCount() > 20) {
            this.removeItemAt(0);
        }
    }

    public void clearAddressHistory() {
        int n = this.m_addr.getNibbleCount();
        this.removeAllItems();
        this.setAddress(new MemoryAddress("0000000000000000000000000000000000000000000000000000000000000000".substring(0, n)));
    }

    public void resetAddressSize(int n, int n2) {
        this.removeAllItems();
        this.m_gap = n2 > 0 && n > n2 ? n / 4 - n2 / 4 : 0;
        this.m_hackSize = 0;
        this.setAddress(new MemoryAddress("0000000000000000000000000000000000000000000000000000000000000000".substring(0, n / 4)));
    }

    protected String formatAddress(String string) {
        if (this.m_gap > 0) {
            return string.substring(0, this.m_gap) + " " + string.substring(this.m_gap);
        }
        return string;
    }

    protected String unFormatAddress() {
        String string = this.m_editor.getText();
        if (string.length() > 0 && this.m_gap > 0) {
            string = string.substring(0, this.m_gap) + string.substring(this.m_gap + 1);
        }
        return string;
    }

    public void setEditListener(MemoryAddrEditListener memoryAddrEditListener) {
        this.m_listener = memoryAddrEditListener;
    }

    public void enableCancel(boolean bl) {
        this.m_cancelEnabled = bl;
    }

    public boolean isEditing() {
        return this.m_editing;
    }

    public boolean enterWasPressed() {
        return this.m_enterPressed;
    }

    public void initiateEdit() {
        if (!this.m_editing) {
            this.m_editing = true;
            this.m_editor.setEditColors(true);
            if (this.m_listener != null) {
                this.m_listener.addressEditInitiated(this);
            }
        }
    }

    public void acceptEdit() {
        if (this.m_editing) {
            this.m_editing = false;
            this.m_editor.setEditColors(false);
            String string = this.unFormatAddress();
            if (string.length() == 0) {
                this.setAddress(this.m_addr);
                return;
            }
            this.m_addr = new MemoryAddress(string);
            string = this.m_editor.getText();
            this.removeItem(string);
            this.insertItemAt(string, 0);
            this.selectItem(string);
            if (this.getItemCount() > 20) {
                this.removeItemAt(20);
            }
            if (this.m_listener != null) {
                this.m_listener.addressEditCommitted(this);
            }
        }
    }

    public void cancelEdit() {
        if (this.m_editing && this.m_cancelEnabled) {
            this.m_editing = false;
            this.m_editor.setEditColors(false);
            this.setAddress(this.m_addr);
            if (this.m_listener != null) {
                this.m_listener.addressEditAborted(this);
            }
        }
    }

    public void addItem(Object object) {
        this.m_ignore = true;
        super.addItem(object);
        this.m_ignore = false;
    }

    public void insertItemAt(Object object, int n) {
        this.m_ignore = true;
        super.insertItemAt(object, n);
        this.m_ignore = false;
    }

    public void removeItem(Object object) {
        this.m_ignore = true;
        super.removeItem(object);
        this.m_ignore = false;
    }

    public void removeItemAt(int n) {
        this.m_ignore = true;
        super.removeItemAt(n);
        this.m_ignore = false;
    }

    public void removeAllItems() {
        this.m_ignore = true;
        super.removeAllItems();
        this.m_ignore = false;
    }

    public void selectItem(Object object) {
        this.m_ignore = true;
        this.setSelectedItem(object);
        this.m_editor.setCaretPosition(0);
        this.m_ignore = false;
    }

    public void updateUI() {
        super.updateUI();
        this.setFont(SettingsManager.getFixedPitchFont());
    }

    private class Editor
    extends JTextField
    implements ComboBoxEditor,
    ActionListener,
    CaretListener {
        public Editor() {
            this.addCaretListener(this);
        }

        public Component getEditorComponent() {
            return this;
        }

        public void setItem(Object object) {
            if (object != null) {
                this.setText(object.toString());
                this.setCaretPosition(0);
            } else {
                this.setText("");
            }
        }

        public Object getItem() {
            return this.getText();
        }

        public void selectAll() {
            super.selectAll();
            this.requestFocus();
        }

        public boolean hasSelection() {
            return this.getSelectionStart() != this.getSelectionEnd();
        }

        public void setEditColors(boolean bl) {
            if (bl) {
                this.setBackground(s_fg);
                this.setForeground(s_bg);
                this.setCaretColor(s_bg);
            } else {
                this.setBackground(s_bg);
                this.setForeground(s_fg);
                this.setCaretColor(s_caret);
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (!MemoryAddrControl.this.m_ignore) {
                MemoryAddrControl.this.m_editing = true;
                MemoryAddrControl.this.m_enterPressed = false;
                MemoryAddrControl.this.acceptEdit();
            }
            MemoryAddrControl.this.m_ignore = false;
        }

        public void caretUpdate(CaretEvent caretEvent) {
            try {
                int n = this.getDocument().getLength();
                int n2 = caretEvent.getDot();
                if (n > 0 && !this.hasSelection()) {
                    if (n2 < n) {
                        String string = this.getText(n2, 1);
                        if (string.length() > 0 && string.charAt(0) == ' ') {
                            this.setCaretPosition(n2 + MemoryAddrControl.this.m_cursorDirection);
                        }
                    } else {
                        this.setCaretPosition(0);
                    }
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }

        protected void processKeyEvent(KeyEvent keyEvent) {
            boolean bl = keyEvent.getID() == 401;
            switch (keyEvent.getKeyCode()) {
                case 8: 
                case 37: 
                case 226: {
                    if (bl) {
                        MemoryAddrControl.this.m_cursorDirection = -1;
                        int n = this.getCaretPosition();
                        if (n == 0) {
                            this.setCaretPosition(this.getDocument().getLength() - 1);
                        } else {
                            this.setCaretPosition(n - 1);
                        }
                    }
                    keyEvent.consume();
                    break;
                }
                case 36: {
                    if (bl) {
                        this.setCaretPosition(0);
                    }
                    keyEvent.consume();
                    break;
                }
                case 35: {
                    if (bl) {
                        this.setCaretPosition(this.getDocument().getLength() - 1);
                    }
                    keyEvent.consume();
                    break;
                }
                case 127: {
                    if (bl) {
                        this.getToolkit().beep();
                    }
                    keyEvent.consume();
                    break;
                }
                case 40: 
                case 225: {
                    if (!bl) break;
                    if (!MemoryAddrControl.this.isPopupVisible()) {
                        MemoryAddrControl.this.setPopupVisible(true);
                        keyEvent.consume();
                        break;
                    }
                    MemoryAddrControl.this.initiateEdit();
                    MemoryAddrControl.this.m_ignore = true;
                    break;
                }
                case 38: 
                case 224: {
                    if (!bl || !MemoryAddrControl.this.isPopupVisible()) break;
                    MemoryAddrControl.this.initiateEdit();
                    MemoryAddrControl.this.m_ignore = true;
                    break;
                }
                case 27: {
                    if (!bl || MemoryAddrControl.this.isPopupVisible()) break;
                    if (MemoryAddrControl.this.m_editing) {
                        MemoryAddrControl.this.cancelEdit();
                    }
                    keyEvent.consume();
                    break;
                }
                case 10: {
                    if (!bl) break;
                    if (!MemoryAddrControl.this.isPopupVisible()) {
                        if (MemoryAddrControl.this.m_editing) {
                            MemoryAddrControl.this.m_enterPressed = true;
                            MemoryAddrControl.this.acceptEdit();
                        }
                        keyEvent.consume();
                        break;
                    }
                    MemoryAddrControl.this.m_ignore = false;
                    break;
                }
                case 9: {
                    if (bl && !MemoryAddrControl.this.m_cancelEnabled) {
                        MemoryAddrControl.this.m_ignore = true;
                    }
                }
                default: {
                    MemoryAddrControl.this.m_cursorDirection = 1;
                }
            }
            super.processKeyEvent(keyEvent);
        }

        protected boolean processKeyBinding(KeyStroke keyStroke, KeyEvent keyEvent, int n, boolean bl) {
            if (keyEvent.getKeyChar() == '\b') {
                return true;
            }
            boolean bl2 = super.processKeyBinding(keyStroke, keyEvent, n, bl);
            return bl2 || bl && Character.isLetterOrDigit(keyEvent.getKeyChar());
        }

        public void cut() {
        }

        public void replaceSelection(String string) {
            int n = this.getCaretPosition();
            int n2 = string.length();
            if (n2 == 0 || n >= this.getDocument().getLength()) {
                this.getToolkit().beep();
                return;
            }
            if ((string = Util.validateHexData(string)) == null) {
                return;
            }
            n2 = string.length();
            if (n2 > 1 && n + n2 > this.getDocument().getLength()) {
                string = string.substring(0, this.getDocument().getLength() - n);
            }
            if (this.hasSelection()) {
                this.setCaretPosition(this.getSelectionEnd());
                n = this.getCaretPosition();
            }
            try {
                if (n2 == 1) {
                    this.getDocument().remove(n, n2);
                    this.getDocument().insertString(n, string, null);
                } else {
                    String string2 = MemoryAddrControl.this.unFormatAddress();
                    StringBuffer stringBuffer = new StringBuffer(string2);
                    if (MemoryAddrControl.this.m_gap > 0 && MemoryAddrControl.this.m_gap < string2.length() && n > MemoryAddrControl.this.m_gap) {
                        --n;
                    }
                    if (n + n2 > string2.length()) {
                        n2 = string2.length() - n;
                        string = string.substring(0, n2);
                    }
                    MemoryAddrControl.this.m_ignore = true;
                    stringBuffer.replace(n, n + n2, string);
                    MemoryAddrControl.this.setSelectedItem(MemoryAddrControl.this.formatAddress(stringBuffer.toString()));
                    MemoryAddrControl.this.m_ignore = false;
                }
                if (!MemoryAddrControl.this.m_editing) {
                    MemoryAddrControl.this.initiateEdit();
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }

        public void setBorder(Border border) {
        }
    }
}

