/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iseries.debug.memory;

import com.ibm.iseries.debug.DebugConstants;
import com.ibm.iseries.debug.manager.SettingsManager;
import com.ibm.iseries.debug.memory.MemoryExpEditListener;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import javax.swing.ComboBoxEditor;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.border.Border;

public class MemoryExpControl
extends JComboBox
implements DebugConstants {
    private static final int MAX_REMEMBER = 20;
    private static final int MAX_WIDTH = 375;
    private static Color s_fg = UIManager.getColor("TextField.foreground");
    private static Color s_bg = UIManager.getColor("TextField.background");
    private static Color s_caret = UIManager.getColor("TextField.caretForeground");
    private String m_exp;
    private Editor m_editor = new Editor();
    private boolean m_editing;
    private MemoryExpEditListener m_listener;
    private boolean m_ignore;
    private int m_maxWidth;

    public MemoryExpControl() {
        this.setEditor(this.m_editor);
        this.setEditable(true);
        this.setMaximumRowCount(20);
        this.addActionListener(this.m_editor);
        Dimension dimension = super.getPreferredSize();
        this.m_maxWidth = dimension.width * 3;
        if (this.m_maxWidth > 375) {
            this.m_maxWidth = 375;
        }
    }

    public void cleanUp() {
        this.removeActionListener(this.m_editor);
        this.m_editor = null;
        this.m_listener = null;
    }

    public String getExpression() {
        return this.m_exp;
    }

    public void setExpression(String string) {
        this.m_exp = string;
        this.selectItem(string);
    }

    public void insertExpression(String string) {
        this.removeItem(string);
        this.insertItemAt(string, 0);
        this.m_exp = string;
        this.selectItem(string);
        if (this.getItemCount() > 20) {
            this.removeItemAt(20);
        }
    }

    public void removeExpression(String string) {
        this.removeItem(string);
        if (this.m_exp.equals(string)) {
            this.m_exp = "";
        }
    }

    public void clearExpressionHistory() {
        this.m_exp = "";
        this.removeAllItems();
    }

    public void setEditListener(MemoryExpEditListener memoryExpEditListener) {
        this.m_listener = memoryExpEditListener;
    }

    public boolean isEditing() {
        return this.m_editing;
    }

    public void initiateEdit() {
        if (!this.m_editing) {
            this.m_editing = true;
            this.m_editor.setEditColors(true);
            if (this.m_listener != null) {
                this.m_listener.expressionEditInitiated(this);
            }
        }
    }

    public void acceptEdit() {
        if (this.m_editing) {
            this.m_editing = false;
            this.m_editor.setEditColors(false);
            this.insertExpression(this.m_editor.getText());
            if (this.m_listener != null) {
                this.m_listener.expressionEditCommitted(this);
            }
        }
    }

    public void cancelEdit() {
        if (this.m_editing) {
            this.m_editing = false;
            this.m_editor.setEditColors(false);
            this.selectItem(this.m_exp);
            if (this.m_listener != null) {
                this.m_listener.expressionEditAborted(this);
            }
        }
    }

    protected boolean processKeyBinding(KeyStroke keyStroke, KeyEvent keyEvent, int n, boolean bl) {
        boolean bl2 = super.processKeyBinding(keyStroke, keyEvent, n, bl);
        return bl2 || bl && Character.isLetterOrDigit(keyEvent.getKeyChar());
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        if (dimension.width > this.m_maxWidth) {
            dimension.width = this.m_maxWidth;
        }
        return dimension;
    }

    public void addItem(Object object) {
        this.m_ignore = true;
        super.addItem(object);
        this.m_ignore = false;
    }

    public void insertItemAt(Object object, int n) {
        this.m_ignore = true;
        super.insertItemAt(object, n);
        this.m_ignore = false;
    }

    public void removeItem(Object object) {
        this.m_ignore = true;
        super.removeItem(object);
        this.m_ignore = false;
    }

    public void removeItemAt(int n) {
        this.m_ignore = true;
        super.removeItemAt(n);
        this.m_ignore = false;
    }

    public void removeAllItems() {
        this.m_ignore = true;
        super.removeAllItems();
        this.m_ignore = false;
    }

    public void selectItem(Object object) {
        this.m_ignore = true;
        this.setSelectedItem(object);
        this.m_ignore = false;
    }

    public void updateUI() {
        super.updateUI();
        this.setFont(SettingsManager.getFixedPitchFont());
    }

    private class Editor
    extends JTextField
    implements ComboBoxEditor,
    ActionListener {
        public Component getEditorComponent() {
            return this;
        }

        public void setItem(Object object) {
            if (object != null) {
                this.setText(object.toString());
            } else {
                this.setText("");
            }
        }

        public Object getItem() {
            return this.getText();
        }

        public void selectAll() {
            super.selectAll();
            this.requestFocus();
        }

        public void setEditColors(boolean bl) {
            if (bl) {
                this.setBackground(s_fg);
                this.setForeground(s_bg);
                this.setCaretColor(s_bg);
            } else {
                this.setBackground(s_bg);
                this.setForeground(s_fg);
                this.setCaretColor(s_caret);
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (!MemoryExpControl.this.m_ignore) {
                MemoryExpControl.this.m_editing = true;
                MemoryExpControl.this.acceptEdit();
            }
            MemoryExpControl.this.m_ignore = false;
        }

        protected void processKeyEvent(KeyEvent keyEvent) {
            boolean bl = keyEvent.getID() == 401;
            switch (keyEvent.getKeyCode()) {
                case 27: {
                    if (!bl || MemoryExpControl.this.isPopupVisible()) break;
                    if (MemoryExpControl.this.m_editing) {
                        MemoryExpControl.this.cancelEdit();
                    }
                    keyEvent.consume();
                    break;
                }
                case 10: {
                    if (!bl) break;
                    if (!MemoryExpControl.this.isPopupVisible()) {
                        if (MemoryExpControl.this.m_editing) {
                            MemoryExpControl.this.acceptEdit();
                        }
                        keyEvent.consume();
                        break;
                    }
                    MemoryExpControl.this.m_ignore = false;
                    break;
                }
                case 8: 
                case 127: {
                    if (MemoryExpControl.this.m_editing || this.getDocument().getLength() <= 0) break;
                    MemoryExpControl.this.initiateEdit();
                    break;
                }
                case 38: 
                case 40: 
                case 224: 
                case 225: {
                    if (!bl || !MemoryExpControl.this.isPopupVisible()) break;
                    MemoryExpControl.this.initiateEdit();
                    MemoryExpControl.this.m_ignore = true;
                }
            }
            super.processKeyEvent(keyEvent);
        }

        public void replaceSelection(String string) {
            super.replaceSelection(string);
            if (!MemoryExpControl.this.m_editing) {
                MemoryExpControl.this.initiateEdit();
            }
        }

        public void setBorder(Border border) {
        }
    }
}

