/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iseries.debug.menu;

import com.ibm.iseries.debug.util.ActionGroup;
import com.ibm.iseries.debug.util.DebugContext;
import com.ibm.iseries.debug.util.DebugSource;
import com.ibm.iseries.debug.util.MRI;
import com.ibm.iseries.debug.util.SubMenu;
import com.ibm.iseries.debug.util.Util;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import javax.accessibility.Accessible;
import javax.swing.JMenuItem;

public class WindowMenu
extends SubMenu
implements ActionListener {
    private DebugContext m_ctxt;
    private int m_defaultMenuItems;

    public WindowMenu(DebugContext debugContext) {
        super(MRI.get("DBG_WINDOW_MENU"));
        this.m_ctxt = debugContext;
        ActionGroup actionGroup = this.m_ctxt.getActionGroup();
        this.addAction(actionGroup, "clsa");
        this.addAction(actionGroup, "mina");
        this.addSeparator();
        ++this.m_defaultMenuItems;
    }

    public void cleanUp() {
    }

    public void refresh() {
        DebugSource[] debugSourceArray = this.m_ctxt.getDesktop().getAllSource();
        boolean bl = false;
        int n = this.getItemCount();
        int n2 = n - 1;
        while (n2 >= this.m_defaultMenuItems) {
            this.getItem(n2).removeActionListener(this);
            this.remove(n2);
            --n2;
        }
        if (debugSourceArray.length > 0) {
            ArrayList<FrameMenu> arrayList = new ArrayList<FrameMenu>();
            int n3 = 0;
            while (n3 < debugSourceArray.length) {
                FrameMenu frameMenu = new FrameMenu(debugSourceArray[n3].getCompletePath());
                frameMenu.addActionListener(this);
                frameMenu.setActionCommand(debugSourceArray[n3].getViewId());
                arrayList.add(frameMenu);
                Util.setAccessible((Accessible)frameMenu, debugSourceArray[n3].getCompletePath());
                Util.setOrientation(frameMenu);
                ++n3;
            }
            Collections.sort(arrayList);
            int n4 = 0;
            while (n4 < debugSourceArray.length) {
                JMenuItem jMenuItem = (JMenuItem)arrayList.get(n4);
                String string = String.valueOf(n4 + 1) + "  ";
                jMenuItem.setText(string + jMenuItem.getText());
                if (n4 + 1 < 10) {
                    jMenuItem.setMnemonic(string.charAt(0));
                }
                this.add(jMenuItem);
                ++n4;
            }
            arrayList.clear();
            bl = true;
        }
        this.m_ctxt.getAction("clsa").setEnabled(bl);
        this.m_ctxt.getAction("mina").setEnabled(bl);
    }

    public JMenuItem addAction(ActionGroup actionGroup, String string) {
        JMenuItem jMenuItem = super.addAction(actionGroup, string);
        if (jMenuItem != null) {
            ++this.m_defaultMenuItems;
        }
        return jMenuItem;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        DebugSource debugSource = this.m_ctxt.getDesktop().getSource(string);
        if (debugSource != null) {
            this.m_ctxt.getDesktop().activateSource(debugSource, -1);
            debugSource.viewRequestFocus();
        }
    }

    private class FrameMenu
    extends JMenuItem
    implements Comparable {
        public FrameMenu(String string) {
            super(string);
        }

        public int compareTo(Object object) {
            return this.getText().compareTo(((FrameMenu)object).getText());
        }
    }
}

