/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iseries.debug.packet;

import com.ibm.iseries.debug.BreakpointDescriptor;
import com.ibm.iseries.debug.ISeriesMessage;
import com.ibm.iseries.debug.dialog.ISeriesMessageDialog;
import com.ibm.iseries.debug.event.BreakpointEvent;
import com.ibm.iseries.debug.manager.BreakpointGroupManager;
import com.ibm.iseries.debug.manager.BreakpointManager;
import com.ibm.iseries.debug.manager.PgmManager;
import com.ibm.iseries.debug.manager.SourceViewManager;
import com.ibm.iseries.debug.packet.DebuggerPacket;
import com.ibm.iseries.debug.util.CommLink;
import com.ibm.iseries.debug.util.DebugSource;
import com.ibm.iseries.debug.util.Toolbox;
import java.io.IOException;

public class LnBrkPacket
extends DebuggerPacket {
    public static final int ADDED = 1;
    public static final int REMOVED = 2;
    public static final int ENABLED = 3;
    public static final int DISABLED = 4;
    private int m_action;
    private BreakpointDescriptor[] m_descriptors;
    private ISeriesMessage m_msgObj;

    public LnBrkPacket() {
        super(1505);
    }

    public void cleanUp() {
        super.cleanUp();
        int n = 0;
        while (n < this.m_descriptors.length) {
            this.m_descriptors[n] = null;
            ++n;
        }
        this.m_descriptors = null;
        this.m_msgObj = null;
    }

    public void read(CommLink commLink, int n) throws IOException {
        this.m_action = commLink.readInt();
        int n2 = commLink.readInt();
        this.m_descriptors = new BreakpointDescriptor[n2];
        int n3 = 0;
        while (n3 < n2) {
            BreakpointDescriptor breakpointDescriptor = new BreakpointDescriptor();
            breakpointDescriptor.read(commLink);
            if (breakpointDescriptor.getGroupId() == -1) {
                BreakpointGroupManager breakpointGroupManager = (BreakpointGroupManager)this.m_ctxt.getManager("brkgrpmgr");
                breakpointDescriptor.setGroupId(breakpointGroupManager.getCurrentGroupId());
            }
            this.m_descriptors[n3] = breakpointDescriptor;
            ++n3;
        }
        int n4 = commLink.readInt();
        if (n4 == 1) {
            this.m_msgObj = new ISeriesMessage();
            this.m_msgObj.read(commLink);
        }
    }

    public void run() {
        String string;
        BreakpointEvent breakpointEvent = new BreakpointEvent((Object)this, this.m_action, this.m_descriptors);
        PgmManager pgmManager = (PgmManager)this.m_ctxt.getManager("pgmmgr");
        BreakpointManager breakpointManager = (BreakpointManager)this.m_ctxt.getManager("brkmgr");
        boolean bl = breakpointManager.hasPendingBreakpoints();
        int n = this.m_descriptors.length;
        int n2 = 0;
        while (n2 < n) {
            this.m_descriptors[n2].setAddress(pgmManager.getViewAddress(this.m_descriptors[n2].getViewId(), this.m_descriptors[n2].getLineNum()));
            ++n2;
        }
        breakpointManager.fireBreakpointEvent(breakpointEvent);
        if (this.m_msgObj != null) {
            string = Toolbox.instance().getMsgText(this.m_ctxt, this.m_msgObj);
            this.m_ctxt.setMessage(string);
            if (!bl) {
                ISeriesMessageDialog iSeriesMessageDialog = new ISeriesMessageDialog(this.m_ctxt, this.m_msgObj);
                iSeriesMessageDialog.display(this.m_ctxt);
            }
        }
        if (this.m_action == 1 && this.m_descriptors.length == 1 && this.m_ctxt.getActivePanel() == null) {
            string = this.m_descriptors[0].getViewId();
            int n3 = this.m_descriptors[0].getLineNum();
            DebugSource debugSource = this.m_ctxt.getActiveSource();
            if (debugSource != null && debugSource.getViewId().equals(string)) {
                if (debugSource.isFullSource() || debugSource.containsLineNum(n3)) {
                    if (!debugSource.isLineNumVisible(n3)) {
                        debugSource.scrollToLineNum(n3, false);
                    }
                } else {
                    SourceViewManager sourceViewManager = (SourceViewManager)this.m_ctxt.getManager("srcmgr");
                    sourceViewManager.requestSourceViewScroll(string, n3);
                }
            }
        }
        breakpointEvent.cleanUp();
        this.cleanUp();
    }
}

