/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iseries.debug.packet;

import com.ibm.iseries.debug.ISeriesMessage;
import com.ibm.iseries.debug.PgmDescriptor;
import com.ibm.iseries.debug.ThreadDescriptor;
import com.ibm.iseries.debug.manager.PgmManager;
import com.ibm.iseries.debug.packet.DebuggerPacket;
import com.ibm.iseries.debug.panel.ThreadsPanel;
import com.ibm.iseries.debug.util.CommLink;
import java.io.IOException;

public class ModifyThreadPacket
extends DebuggerPacket {
    public static final int DISABLED = 0;
    public static final int ENABLED = 1;
    public static final int SET_CURRENT = 2;
    private int m_action;
    private ThreadDescriptor m_descriptor;
    private ISeriesMessage m_msgObj;

    public ModifyThreadPacket() {
        super(1515);
    }

    public void cleanUp() {
        super.cleanUp();
        this.m_descriptor = null;
        this.m_msgObj = null;
    }

    public void read(CommLink commLink, int n) throws IOException {
        int n2;
        PgmManager pgmManager = (PgmManager)this.m_ctxt.getManager("pgmmgr");
        this.m_action = commLink.readInt();
        this.m_descriptor = new ThreadDescriptor();
        this.m_descriptor.read(commLink);
        if (PgmDescriptor.isUnixPgm(this.m_descriptor.getPgmType())) {
            this.m_descriptor.setAddress(pgmManager.getViewAddress(this.m_descriptor.getViewId(), this.m_descriptor.getLineNum()));
        }
        if ((n2 = commLink.readInt()) == 1) {
            this.m_msgObj = new ISeriesMessage();
            this.m_msgObj.read(commLink);
        }
    }

    public void run() {
        if (this.m_msgObj != null) {
            this.displayMessage(this.m_msgObj);
        }
        ThreadsPanel threadsPanel = (ThreadsPanel)this.m_ctxt.getPanel("threads");
        threadsPanel.threadModified(this.m_action, this.m_descriptor);
        this.cleanUp();
    }
}

