/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iseries.debug.packet;

import com.ibm.iseries.debug.DebugConstants;
import com.ibm.iseries.debug.ISeriesMessage;
import com.ibm.iseries.debug.PgmDescriptor;
import com.ibm.iseries.debug.manager.ContextManager;
import com.ibm.iseries.debug.manager.SettingsManager;
import com.ibm.iseries.debug.packet.DebuggerPacket;
import com.ibm.iseries.debug.request.CommandRequest;
import com.ibm.iseries.debug.util.CommLink;
import com.ibm.iseries.debug.util.MRI;
import com.ibm.iseries.debug.util.Request;
import com.ibm.iseries.debug.util.Util;
import java.io.IOException;
import java.text.MessageFormat;

public class StartDebugPacket
extends DebuggerPacket
implements DebugConstants {
    private static final int STRDBG_CMD = 0;
    private static final int GUI = 1;
    private static final String JOB_NOT_FOUND = "CPF3520";
    private String m_pgmLib;
    private String m_pgmName;
    private int m_pgmType;
    private String m_pgmParms;
    private String m_jobId;
    private int m_PID;
    private int m_options;
    private int m_initiatedFrom;
    private boolean m_pgmCanBeEnded;
    private ISeriesMessage m_msgObj;

    public StartDebugPacket() {
        super(1500);
    }

    public String getPgmLib() {
        return this.m_pgmLib;
    }

    public String getPgmName() {
        return this.m_pgmName;
    }

    public int getPgmType() {
        return this.m_pgmType;
    }

    public String getJobId() {
        return this.m_jobId;
    }

    public int getPID() {
        return this.m_PID;
    }

    public int getDebugOptions() {
        return this.m_options;
    }

    public boolean initiatedFromGUI() {
        return this.m_initiatedFrom == 1;
    }

    public boolean initiatedFromSTRDBG() {
        return this.m_initiatedFrom == 0;
    }

    public boolean strdbgFailed() {
        return this.m_msgObj != null;
    }

    public void cleanUp() {
        super.cleanUp();
        this.m_jobId = null;
        this.m_msgObj = null;
    }

    public void read(CommLink commLink, int n) throws IOException {
        int n2;
        this.m_pgmLib = commLink.readString();
        this.m_pgmName = commLink.readString();
        this.m_pgmType = commLink.readInt();
        this.m_pgmParms = commLink.readString();
        this.m_jobId = commLink.readString();
        if (commLink.getSystemVersion() >= 5.30002) {
            this.m_PID = commLink.readInt();
            this.m_options = commLink.readInt();
        }
        this.m_initiatedFrom = commLink.readInt();
        this.m_pgmCanBeEnded = commLink.readInt() == 1;
        this.m_jobId = Util.firstUpperJobId(this.m_jobId);
        if (this.m_pgmType == 0 || this.m_pgmType == 1) {
            this.m_pgmLib = Util.firstUpper(this.m_pgmLib);
            this.m_pgmName = Util.firstUpper(this.m_pgmName);
        }
        if (this.m_pgmParms.length() > 0 && this.m_pgmParms.indexOf("''") >= 0) {
            StringBuffer stringBuffer = new StringBuffer(this.m_pgmParms);
            int n3 = 0;
            while (n3 < stringBuffer.length()) {
                if (stringBuffer.charAt(n3) == '\'' && n3 + 1 < stringBuffer.length() && stringBuffer.charAt(n3 + 1) == '\'') {
                    stringBuffer.deleteCharAt(n3);
                }
                ++n3;
            }
            this.m_pgmParms = stringBuffer.toString();
        }
        if ((n2 = commLink.readInt()) == 1) {
            this.m_msgObj = new ISeriesMessage();
            this.m_msgObj.read(commLink);
        }
    }

    public void run() {
        this.m_ctxt.retractClock();
        this.m_ctxt.clearMessage();
        this.m_ctxt.setProgramInfo(this);
        if (this.m_msgObj != null) {
            this.displayMessage(this.m_msgObj, 2);
            this.m_ctxt.enableAction("chgsys", true);
            this.m_ctxt.enableAction("strdbg", true);
            this.m_ctxt.enableAction("strpdbg", false);
            this.m_ctxt.getMenubar().enablePgmMenu(true);
            if (this.m_ctxt.hasPartnerContext()) {
                if (this.m_ctxt.isMasterContext()) {
                    this.m_ctxt.removePartnerContext();
                } else if (this.m_ctxt.isSlaveContext()) {
                    this.m_ctxt.getDebugFrame().removeDebugContext(this.m_ctxt);
                }
            }
        } else {
            Object object;
            String string;
            this.m_ctxt.allowRunAction(true);
            this.m_ctxt.getActionGroup().setPgmRunning(false);
            this.m_ctxt.enableAction("chgsys", false);
            this.m_ctxt.enableAction("strdbg", false);
            this.m_ctxt.enableAction("enddbg", this.initiatedFromGUI() && this.m_ctxt.isMasterContext());
            this.m_ctxt.enableAction("endpgm", this.m_pgmCanBeEnded);
            this.m_ctxt.enableAction("addpgm", true);
            this.m_ctxt.enableAction("ngrp", true);
            this.m_ctxt.enableAction("oenv", true);
            this.m_ctxt.enableAction("senv", true);
            this.m_ctxt.enableAction("senvas", true);
            this.m_ctxt.getMenubar().enableEnvMenu(true);
            this.m_ctxt.getMenubar().enablePgmMenu(false);
            this.m_ctxt.supportAction("pause", this.initiatedFromGUI());
            if (this.initiatedFromSTRDBG() && this.m_ctxt.isSupported(6, this.m_ctxt.getSystemVersion())) {
                boolean bl = this.m_ctxt.getUserConfig().getBool("varsIncBaseClass", false);
                string = bl ? "__EXPBASECLSON_" : "__EXPBASECLSOFF";
                object = new CommandRequest("0", 1, string);
                this.m_ctxt.sendRequest((Request)object);
            }
            if (this.initiatedFromGUI()) {
                SettingsManager settingsManager = (SettingsManager)this.m_ctxt.getManager("settmgr");
                settingsManager.insertRecentPgm(new PgmDescriptor(this.m_pgmLib, this.m_pgmName, this.m_pgmType, this.m_pgmParms));
                if ((this.m_options & 0x10) != 0 && this.m_ctxt.isSupported(9, this.m_ctxt.getSystemVersion())) {
                    this.m_ctxt.getAction("strpdbg").run();
                }
            }
            this.m_ctxt.enableAction("strpdbg", !this.m_ctxt.hasPartnerContext() && this.m_ctxt.isSupported(9, this.m_ctxt.getSystemVersion()));
            if (this.m_ctxt.hasPartnerContext() && this.m_ctxt.isSlaveContext()) {
                Object[] objectArray = new Object[]{this.m_ctxt.getPgmPath()};
                string = MessageFormat.format(MRI.get("DBG_PGM_STRDBG_FMT"), objectArray);
                this.m_ctxt.getPartnerContext().setMessage(string);
                object = (ContextManager)this.m_ctxt.getManager("ctxtmgr");
                ((ContextManager)object).initializePartnerStep();
            }
        }
    }
}

