/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iseries.debug.panel;

import com.ibm.iseries.debug.DebugConstants;
import com.ibm.iseries.debug.event.ContextEvent;
import com.ibm.iseries.debug.event.LAFEvent;
import com.ibm.iseries.debug.event.MemoryEvent;
import com.ibm.iseries.debug.listener.ContextListener;
import com.ibm.iseries.debug.listener.LAFListener;
import com.ibm.iseries.debug.listener.MemoryListener;
import com.ibm.iseries.debug.manager.MemoryManager;
import com.ibm.iseries.debug.memory.MemoryAddress;
import com.ibm.iseries.debug.memory.MemoryEditListener;
import com.ibm.iseries.debug.memory.MemoryExpCtrlView;
import com.ibm.iseries.debug.memory.MemoryPane;
import com.ibm.iseries.debug.util.ContextMenu;
import com.ibm.iseries.debug.util.DebugContext;
import com.ibm.iseries.debug.util.DebugPanelFrame;
import com.ibm.iseries.debug.util.MRI;
import com.ibm.iseries.debug.util.Settings;
import com.ibm.iseries.debug.util.TabPanel;
import com.ibm.iseries.debug.util.TabbedPane;
import com.ibm.iseries.debug.util.Util;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.MessageFormat;
import javax.accessibility.Accessible;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class MemoryExpPanel
extends TabPanel
implements ContextListener,
MemoryListener,
MemoryEditListener,
LAFListener,
MouseListener,
ActionListener,
DebugConstants {
    public static final String KEY = "memory";
    private static final String GIF = "/com/ibm/iseries/debug/dbg073.gif";
    private static final String SAVE = "save";
    private static final String CANCEL = "cancel";
    private MemoryManager m_memMgr;
    private JPanel m_panel;
    private MemoryExpCtrlView m_ctrls;
    private MemoryPane m_memory;
    private JPanel m_buttons;
    private JButton m_save;
    private JButton m_cancel;
    private ContextMenu m_contextMenu;
    private boolean m_notCurrent;
    private boolean m_editing;
    private boolean m_enabled = true;

    public MemoryExpPanel() {
        super(MRI.get("DBG_MEMORY"), MRI.getIcon(0, GIF));
        this.addComponents();
    }

    public MemoryExpPanel(DebugContext debugContext) {
        super(MRI.get("DBG_MEMORY"), MRI.getIcon(0, GIF));
        this.addComponents();
        this.init(debugContext, null);
    }

    private void addComponents() {
        this.m_panel = new JPanel(new BorderLayout());
        this.m_buttons = new JPanel();
        this.m_save = new JButton(MRI.get("DBG_SAVE"));
        this.m_cancel = new JButton(MRI.get("DBG_CANCEL"));
        this.m_save.setActionCommand(SAVE);
        this.m_cancel.setActionCommand(CANCEL);
        this.m_save.addActionListener(this);
        this.m_cancel.addActionListener(this);
        Insets insets = new Insets(0, 5, 0, 5);
        this.m_save.setMargin(insets);
        this.m_cancel.setMargin(insets);
        this.m_save.setEnabled(false);
        this.m_cancel.setEnabled(false);
        this.m_buttons.setLayout(new BoxLayout(this.m_buttons, 0));
        this.m_buttons.setBorder(BorderFactory.createEmptyBorder(3, 0, 3, 0));
        Dimension dimension = new Dimension(3, 0);
        this.m_buttons.add(Box.createHorizontalGlue());
        this.m_buttons.add(this.m_save);
        this.m_buttons.add(Box.createRigidArea(dimension));
        this.m_buttons.add(this.m_cancel);
        this.m_buttons.add(Box.createHorizontalGlue());
        Util.setAccessible((Accessible)this.m_save, this.m_save.getText());
        Util.setAccessible((Accessible)this.m_cancel, this.m_cancel.getText());
        Util.setOrientation(this.m_buttons);
        Util.setOrientation(this.m_save);
        Util.setOrientation(this.m_cancel);
    }

    private void lookAndFeelModifications() {
        Settings settings = this.m_ctxt.getConfig();
        this.m_contextMenu = (ContextMenu)Util.loadObject(settings.getString("memoryContextMenu", null));
        this.m_contextMenu.init(this.m_ctxt.getActionGroup());
    }

    public void requestMemory() {
        String string = this.m_ctrls.getExpression();
        if (string != null && string.length() > 0) {
            this.m_memMgr.requestMemoryRead(string, this.m_ctrls.getViewId(), this.m_ctrls.getLineNum(), this.m_ctrls.getByteCount());
        }
    }

    public void saveEdit() {
        this.m_memory.acceptEdit();
        this.cleanUpEdit();
        this.m_memMgr.requestMemoryWrite(this.m_ctrls.getExpression(), this.m_ctrls.getViewId(), this.m_ctrls.getLineNum(), this.m_memory.getHexData(), this.m_memory.getTags());
    }

    public void cancelEdit() {
        this.m_memory.cancelEdit();
        this.cleanUpEdit();
        this.m_ctxt.setMessage(MRI.get("DBG_MEMORY_EDIT_CANCELED"));
    }

    private void cleanUpEdit() {
        this.m_editing = false;
        this.m_ctrls.enableExpressionControls(true);
        this.m_save.setEnabled(false);
        this.m_cancel.setEnabled(false);
    }

    public void setEnabled(boolean bl) {
        if (bl != this.m_enabled) {
            this.m_enabled = bl;
            this.m_ctrls.enableExpressionControls(this.m_enabled);
            this.m_memory.setEnabled(this.m_enabled);
        }
    }

    public String getExpression() {
        return this.m_ctrls.getExpression();
    }

    public void setExpression(String string, String string2, int n) {
        this.m_ctrls.setExpression(string, string2, n);
        if (this.isInFrame()) {
            this.getParentFrame().setTitle(this.getFrameTitle());
        }
    }

    public void insertExpression(String string, String string2, int n) {
        this.m_ctrls.insertExpression(string, string2, n);
        if (this.isInFrame()) {
            this.getParentFrame().setTitle(this.getFrameTitle());
        }
    }

    public void clearExpressionHistory() {
        this.m_ctrls.clearExpressionHistory();
        if (this.isInFrame()) {
            this.getParentFrame().setTitle(this.getFrameTitle());
        }
    }

    public int getByteCount() {
        int n = this.m_ctrls.getByteCount();
        if (n < 0) {
            n = this.m_memory.getByteCount();
        }
        return n;
    }

    public void setByteCount(int n) {
        this.m_ctrls.setByteCount(n);
    }

    public int getCharacterMode() {
        return this.m_ctrls.getCharacterMode();
    }

    public void setCharacterMode(int n, boolean bl) {
        this.m_ctrls.setCharacterMode(n);
        this.m_memory.setCharacterMode(n, bl);
    }

    public int getBytesPerLine() {
        return this.m_ctrls.getBytesPerLine();
    }

    public void setBytesPerLine(int n, boolean bl) {
        this.m_ctrls.setBytesPerLine(n);
        this.m_memory.setBytesPerLine(n, bl);
    }

    public String getHexData() {
        return this.m_memory.getHexData();
    }

    public void clearActionContext() {
    }

    public void prepareActionContext() {
    }

    public void init(DebugContext debugContext, TabbedPane tabbedPane) {
        this.m_memMgr = (MemoryManager)debugContext.getManager("memmgr");
        this.m_memory = new MemoryPane(debugContext, 0);
        this.m_memory.setTagsReadOnly(true);
        this.m_memory.setEditListener(this);
        Settings settings = debugContext.getConfig();
        this.m_ctrls = (MemoryExpCtrlView)Util.loadObject(settings.getString("memControls", ""));
        this.m_ctrls.init(debugContext, this.m_memory);
        super.init(debugContext, tabbedPane);
        this.m_ctrls.addMouseListener(this);
        this.m_memory.addMouseListener(this);
        this.m_buttons.addMouseListener(this);
        this.m_memory.addFocusListener(this);
        this.m_panel.add((Component)this.m_ctrls.getComponent(), "North");
        this.m_panel.add((Component)this.m_memory.getComponent(), "Center");
        this.m_panel.add((Component)this.m_buttons, "South");
        this.lookAndFeelModifications();
        this.m_ctxt.getManager("ctxtmgr").addListener(this);
        this.m_ctxt.getManager("memmgr").addListener(this);
        this.m_ctxt.getManager("lafmgr").addListener(this);
    }

    public void cleanUp() {
        this.m_ctxt.getManager("ctxtmgr").removeListener(this);
        this.m_ctxt.getManager("memmgr").removeListener(this);
        this.m_ctxt.getManager("lafmgr").removeListener(this);
        this.m_ctrls.removeMouseListener(this);
        this.m_memory.removeMouseListener(this);
        this.m_buttons.removeMouseListener(this);
        this.m_memory.removeFocusListener(this);
        this.m_ctrls.cleanUp();
        this.m_memory.cleanUp();
        this.m_memMgr = null;
        this.m_panel = null;
        this.m_ctrls = null;
        this.m_memory = null;
        this.m_buttons = null;
        this.m_save = null;
        this.m_cancel = null;
        this.m_contextMenu = null;
        super.cleanUp();
    }

    public String getHelpId() {
        return "dbgmemory_p";
    }

    public String getKey() {
        return KEY;
    }

    public JComponent getComponent() {
        return this.m_panel;
    }

    public void requestFocus() {
        this.m_memory.getView().getHexComponent().requestFocus();
    }

    public void setActivePanel(boolean bl) {
        super.setActivePanel(bl);
        if (bl) {
            this.prepareActionContext();
        } else {
            this.clearActionContext();
        }
    }

    public void setExposed(boolean bl) {
        super.setExposed(bl);
        if (bl && this.m_notCurrent && !this.isSuspended()) {
            this.requestMemory();
        }
    }

    public void clear(boolean bl) {
        if (!bl) {
            this.m_memory.clear();
            this.clearExpressionHistory();
            this.m_notCurrent = false;
        }
    }

    public boolean canDoSuspend() {
        return true;
    }

    public void setSuspended(boolean bl) {
        super.setSuspended(bl);
        this.m_memory.setSuspended(bl);
        this.m_ctrls.enableExpressionControls(!bl);
        if (!bl) {
            this.requestMemory();
        }
    }

    public boolean canClone() {
        return true;
    }

    public DebugPanelFrame cloneFrame(int n, int n2) {
        MemoryExpPanel memoryExpPanel = new MemoryExpPanel(this.m_ctxt);
        memoryExpPanel.insertExpression(this.m_ctrls.getExpression(), this.m_ctrls.getViewId(), this.m_ctrls.getLineNum());
        memoryExpPanel.setByteCount(this.m_ctrls.getByteCount());
        memoryExpPanel.setCharacterMode(this.m_ctrls.getCharacterMode(), false);
        memoryExpPanel.setBytesPerLine(this.m_ctrls.getBytesPerLine(), false);
        memoryExpPanel.m_memory.setHexData(this.m_memory.getAddress(), this.m_memory.getHexData(), this.m_memory.getTags(), this.m_memory.isEditable());
        Rectangle rectangle = null;
        if (this.m_memory.getByteCount() == 0) {
            rectangle = this.getComponent().getBounds();
            rectangle.x = n - rectangle.width / 2;
            rectangle.y = n2;
            rectangle.width += 15;
            rectangle.height += 30;
        } else {
            Dimension dimension = this.getComponent().getPreferredSize();
            rectangle = new Rectangle(n - dimension.width / 2, n2, dimension.width + 10, dimension.height + 20);
            Rectangle rectangle2 = this.m_ctxt.getJFrame().getBounds();
            if (rectangle.height > rectangle2.height - 100) {
                rectangle.height = rectangle2.height - 100;
            }
        }
        return new DebugPanelFrame(memoryExpPanel, this.getFrameTitle(), rectangle);
    }

    public String getFrameTitle() {
        String string = this.m_ctrls.getExpression();
        if (string == null) {
            string = "";
        }
        Object[] objectArray = new Object[]{string};
        String string2 = MessageFormat.format(MRI.get("DBG_MEMORY_EXP_TITLE_BAR_FMT"), objectArray);
        return string2;
    }

    public boolean canDoCopyPanel() {
        return true;
    }

    public void copyPanel() {
        this.m_memory.copyAll();
    }

    public void contextChanged(ContextEvent contextEvent) {
        switch (contextEvent.getType()) {
            case 0: 
            case 1: {
                if (!this.isSuspended() && this.isExposed()) {
                    this.requestMemory();
                } else {
                    this.m_notCurrent = true;
                }
                this.setEnabled(true);
                break;
            }
            case 3: {
                this.setEnabled(false);
                break;
            }
            case 4: {
                this.clear(true);
                break;
            }
        }
    }

    public void memoryAvailable(MemoryEvent memoryEvent) {
        if (!this.isSuspended() && !this.m_memory.isEditing()) {
            int n = this.m_ctrls.getByteCount();
            if (memoryEvent.getExpression().equals(this.m_ctrls.getExpression()) && memoryEvent.getViewId().equals(this.m_ctrls.getViewId()) && memoryEvent.getLineNum() == this.m_ctrls.getLineNum() && (n == -1 || memoryEvent.getByteCount() == n)) {
                this.m_memory.setHexData(new MemoryAddress("0000"), memoryEvent.getHexData(), memoryEvent.getTags(), !memoryEvent.dataReadOnly());
                if (this.isInFrame()) {
                    this.getParentFrame().setTitle(this.getFrameTitle());
                }
            }
        }
    }

    public void memoryNotAvailable(MemoryEvent memoryEvent) {
        if (memoryEvent.getExpression().equals(this.m_ctrls.getExpression()) && memoryEvent.getViewId().equals(this.m_ctrls.getViewId()) && memoryEvent.getLineNum() == this.m_ctrls.getLineNum()) {
            this.m_memory.clear();
            String string = memoryEvent.getErrorMessage();
            if (memoryEvent != null) {
                this.m_memory.setPaneText(string);
            }
        }
    }

    public void memoryChanged(MemoryEvent memoryEvent) {
        this.memoryAvailable(memoryEvent);
    }

    public void memoryPossiblyChanged(MemoryEvent memoryEvent) {
        if (this.m_memory.getByteCount() > 0) {
            if (!this.isSuspended() && this.isExposed()) {
                this.requestMemory();
            } else {
                this.m_notCurrent = true;
            }
        }
    }

    public void memoryNotChanged(MemoryEvent memoryEvent) {
        this.requestMemory();
    }

    public void memoryAddressSizeChanged(int n, int n2) {
    }

    public void memoryMgrCleanUp() {
        if (this.isInFrame()) {
            this.getParentFrame().dispose();
        }
    }

    public void memoryMgrClear() {
        if (this.isInFrame()) {
            this.clear(false);
        }
    }

    public void memoryEditInitiated() {
        if (!this.m_editing) {
            this.m_editing = true;
            this.m_ctrls.enableExpressionControls(false);
            this.m_save.setEnabled(true);
            this.m_cancel.setEnabled(true);
        }
    }

    public void memoryEditCommitted() {
        this.saveEdit();
    }

    public void memoryEditAborted() {
        this.cancelEdit();
    }

    public void lookAndFeelChanged(LAFEvent lAFEvent) {
        this.lookAndFeelModifications();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(SAVE)) {
            this.saveEdit();
        } else if (string.equals(CANCEL)) {
            this.cancelEdit();
        }
    }

    private boolean handlePopupMenu(MouseEvent mouseEvent) {
        boolean bl = false;
        if (mouseEvent.isPopupTrigger()) {
            JComponent jComponent = (JComponent)mouseEvent.getSource();
            if (jComponent == this.m_memory.getView().getHexComponent()) {
                this.prepareActionContext();
            } else {
                this.clearActionContext();
            }
            this.m_contextMenu.show(jComponent, mouseEvent.getX(), mouseEvent.getY());
            bl = true;
        }
        return bl;
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.m_ctxt.setActivePanel(this);
        ((JComponent)mouseEvent.getSource()).requestFocus();
        this.handlePopupMenu(mouseEvent);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.handlePopupMenu(mouseEvent);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }
}

