/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iseries.debug.panel;

import com.ibm.iseries.debug.DebugConstants;
import com.ibm.iseries.debug.VariableDescriptor;
import com.ibm.iseries.debug.event.ContextEvent;
import com.ibm.iseries.debug.event.LAFEvent;
import com.ibm.iseries.debug.event.VariableEvent;
import com.ibm.iseries.debug.event.WatchEvent;
import com.ibm.iseries.debug.listener.ContextListener;
import com.ibm.iseries.debug.listener.LAFListener;
import com.ibm.iseries.debug.listener.VariableListener;
import com.ibm.iseries.debug.manager.VariableManager;
import com.ibm.iseries.debug.panel.TreeTablePane;
import com.ibm.iseries.debug.util.ContextMenu;
import com.ibm.iseries.debug.util.DebugContext;
import com.ibm.iseries.debug.util.MRI;
import com.ibm.iseries.debug.util.TabPanel;
import com.ibm.iseries.debug.util.TabbedPane;
import com.ibm.iseries.debug.util.Util;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import javax.accessibility.Accessible;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public abstract class VariablesPanel
extends TabPanel
implements ContextListener,
VariableListener,
LAFListener,
DebugConstants,
TreeSelectionListener,
TreeExpansionListener,
MouseListener,
ClipboardOwner {
    protected static final String STRUCT_GIF = "/com/ibm/iseries/debug/dbg024.gif";
    protected static final String ARRAY_GIF = "/com/ibm/iseries/debug/dbg025.gif";
    protected static final String PTR_GIF = "/com/ibm/iseries/debug/dbg046.gif";
    protected static final String CHAR_GIF = "/com/ibm/iseries/debug/dbg049.gif";
    protected static final String STR_GIF = "/com/ibm/iseries/debug/dbg051.gif";
    protected static final String INT_GIF = "/com/ibm/iseries/debug/dbg050.gif";
    protected static final String FLOAT_GIF = "/com/ibm/iseries/debug/dbg048.gif";
    protected static final String SIMPLE_GIF = "/com/ibm/iseries/debug/dbg026.gif";
    protected static final String UNDERSCORE = "_";
    protected VariableManager m_varMgr;
    protected TreeTablePane m_pane;
    protected JTree m_tree;
    protected DefaultTreeModel m_treeModel;
    protected DefaultMutableTreeNode m_root;
    protected JTable m_table;
    protected AbstractTableModel m_tableModel;
    protected ContextMenu m_contextMenu;
    protected VariableRenderer m_varRenderer;
    protected VariableComparator m_varComparator;
    protected boolean m_notCurrent;
    protected int m_panelId;
    protected String m_viewId;
    protected int m_lineNum;
    protected int m_procId;
    protected boolean m_validate;
    protected DefaultMutableTreeNode m_actionNode;
    protected TreePath m_actionPath;
    protected HashMap m_expanded;
    protected HashMap m_derefed;
    protected HashMap m_bounded;
    protected HashMap m_forget;
    protected HashMap m_nodes;
    protected HashMap m_paths;

    public VariablesPanel(int n, String string, ImageIcon imageIcon) {
        super(string, imageIcon);
        this.m_panelId = n;
        this.m_viewId = "";
        this.m_root = new DefaultMutableTreeNode("");
        this.m_treeModel = new DefaultTreeModel(this.m_root);
        this.m_tableModel = this.createTableModel();
        this.m_pane = new TreeTablePane(MRI.get("DBG_NAME"), this.m_treeModel, this.m_tableModel);
        this.m_tree = this.m_pane.getTree();
        this.m_table = this.m_pane.getTable();
        this.m_tree.addTreeSelectionListener(this);
        this.m_tree.addTreeExpansionListener(this);
        this.m_tree.addMouseListener(this);
        this.m_table.addMouseListener(this);
        this.m_pane.getViewport().addMouseListener(this);
        this.m_tree.addFocusListener(this);
        this.m_table.addFocusListener(this);
        this.m_pane.getViewport().addFocusListener(this);
        Util.setAccessible((Accessible)this.m_tree, this.m_name);
        Util.setAccessible((Accessible)this.m_table, this.m_name);
        this.m_expanded = new HashMap();
        this.m_derefed = new HashMap();
        this.m_bounded = new HashMap();
        this.m_forget = new HashMap();
        this.m_nodes = new HashMap();
        this.m_paths = new HashMap();
        this.m_varComparator = new VariableComparator();
    }

    protected void lookAndFeelModifications() {
        this.m_varRenderer = new VariableRenderer();
        this.m_tree.setCellRenderer(this.m_varRenderer);
    }

    public void clear(boolean bl) {
        this.m_notCurrent = false;
        if (!bl) {
            this.clearAllAttributes();
        }
        this.m_root.removeAllChildren();
        this.m_nodes.clear();
        this.m_treeModel.reload();
        this.m_tableModel.fireTableDataChanged();
        this.m_pane.refreshTreeAndTable();
        this.clearActionContext();
    }

    protected void requestEvalVariables() {
        if (this.m_derefed.size() > 0 || this.m_bounded.size() > 0) {
            Object object;
            Object object2;
            ArrayList<VariableDescriptor> arrayList = new ArrayList<VariableDescriptor>(this.m_derefed.size() + this.m_bounded.size());
            Iterator iterator = this.m_derefed.keySet().iterator();
            while (iterator.hasNext()) {
                boolean bl;
                object2 = (String)iterator.next();
                object = (VariableDescriptor)this.m_derefed.get(object2);
                boolean bl2 = bl = this.m_nodes.get(object2) != null;
                if (!bl) continue;
                if (((VariableDescriptor)object).isPtr()) {
                    if (!((VariableDescriptor)object).isValidPtr()) continue;
                    arrayList.add(new VariableDescriptor((VariableDescriptor)object));
                    continue;
                }
                arrayList.add(new VariableDescriptor((VariableDescriptor)object));
            }
            object2 = this.m_bounded.keySet().iterator();
            while (object2.hasNext()) {
                boolean bl;
                object = (String)object2.next();
                VariableDescriptor variableDescriptor = (VariableDescriptor)this.m_bounded.get(object);
                boolean bl3 = bl = this.m_nodes.get(object) != null;
                if (!bl) continue;
                if (variableDescriptor.isPtr()) {
                    if (!variableDescriptor.isValidPtr()) continue;
                    arrayList.add(new VariableDescriptor(variableDescriptor));
                    continue;
                }
                arrayList.add(new VariableDescriptor(variableDescriptor));
            }
            if (arrayList.size() > 0) {
                this.m_ctxt.postClock();
                Collections.sort(arrayList, this.m_varComparator);
                this.m_varMgr.requestEvals(this.m_panelId, arrayList, this.m_ctxt.getVariableDisplayMask());
            }
        }
    }

    protected void forgetEvalVariables() {
        if (this.m_forget.size() > 0) {
            Iterator iterator = this.m_forget.values().iterator();
            while (iterator.hasNext()) {
                VariableDescriptor variableDescriptor = (VariableDescriptor)iterator.next();
                String string = this.key(variableDescriptor);
                this.forgetDerefed(string);
                this.forgetBounded(string);
            }
            this.m_forget.clear();
        }
    }

    protected abstract AbstractTableModel createTableModel();

    protected abstract DefaultMutableTreeNode createTreeNode(DefaultMutableTreeNode var1, VariableDescriptor var2);

    protected abstract String key(VariableDescriptor var1);

    protected abstract void requestVariables();

    protected VariableDescriptor getVariableDescriptor(DefaultMutableTreeNode defaultMutableTreeNode) {
        return (VariableDescriptor)defaultMutableTreeNode.getUserObject();
    }

    protected VariableDescriptor getVariableDescriptor(int n) {
        TreePath treePath = this.m_tree.getPathForRow(n);
        if (treePath == null) {
            return null;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        VariableDescriptor variableDescriptor = (VariableDescriptor)defaultMutableTreeNode.getUserObject();
        return variableDescriptor;
    }

    protected VariableDescriptor setVariableDescriptor(DefaultMutableTreeNode defaultMutableTreeNode, VariableDescriptor variableDescriptor) {
        String string = this.key(variableDescriptor);
        VariableDescriptor variableDescriptor2 = this.getVariableDescriptor(defaultMutableTreeNode);
        defaultMutableTreeNode.setUserObject(variableDescriptor);
        if (this.isExpanded(string)) {
            this.rememberExpanded(string, variableDescriptor, null);
        }
        if (this.isDerefed(string)) {
            this.rememberDerefed(string, variableDescriptor, false);
        }
        if (this.isBounded(string)) {
            this.rememberBounded(string, variableDescriptor, false);
            if (variableDescriptor.getBounds().length() == 0) {
                variableDescriptor.setBounds(variableDescriptor2.getBounds());
            }
        }
        return variableDescriptor2;
    }

    protected void restoreTreeState(boolean bl) {
        if (bl) {
            this.m_treeModel.reload();
        }
        this.m_tableModel.fireTableDataChanged();
        if (this.m_paths.size() > 0) {
            this.m_tree.removeTreeExpansionListener(this);
            Iterator iterator = this.m_paths.values().iterator();
            while (iterator.hasNext()) {
                TreePath treePath = (TreePath)iterator.next();
                if (this.m_tree.isExpanded(treePath)) continue;
                this.m_tree.expandPath(treePath);
            }
            this.m_tree.addTreeExpansionListener(this);
        }
        if (this.m_actionPath != null) {
            this.m_tree.setSelectionPath(this.m_actionPath);
            this.prepareActionContext(this.m_tree.getRowForPath(this.m_actionPath));
            this.m_actionPath = null;
        }
    }

    protected void prepareActionContext(int n) {
        if (!this.m_tree.hasFocus() && !this.m_table.hasFocus()) {
            return;
        }
        this.m_ctxt.getActionGroup().clearVarContext();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        if (n >= 0) {
            TreePath treePath = this.m_tree.getPathForRow(n);
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            VariableDescriptor variableDescriptor = this.getVariableDescriptor(defaultMutableTreeNode);
            String string = this.key(variableDescriptor);
            this.m_actionNode = defaultMutableTreeNode;
            switch (variableDescriptor.getType()) {
                case 10: {
                    if (variableDescriptor.isValidPtr()) {
                        bl = !variableDescriptor.hasChildren();
                        bl2 = true;
                        bl4 = true;
                    }
                    if (!this.isDerefed(string) && !this.isBounded(string)) break;
                    bl3 = true;
                    break;
                }
                case 101: {
                    bl = !variableDescriptor.hasChildren();
                    bl2 = false;
                    bl4 = false;
                    if (!this.isDerefed(string)) break;
                    bl3 = true;
                    break;
                }
                case 14: {
                    bl4 = true;
                    bl2 = true;
                    if (!this.isBounded(string)) break;
                    bl3 = true;
                    break;
                }
                default: {
                    bl4 = true;
                }
            }
            this.m_ctxt.getActionGroup().setVarContext(variableDescriptor);
            bl5 = true;
        }
        this.m_ctxt.enableAction("dref", bl);
        this.m_ctxt.enableAction("abnds", bl2);
        this.m_ctxt.enableAction("reset", bl3);
        this.m_ctxt.enableAction("gotomem", bl4);
        this.m_ctxt.enableAction("newmem", bl4);
        this.m_ctxt.enableAction("godsm", bl5);
        this.m_ctxt.enableAction("copy", n >= 0);
    }

    protected void clearActionContext() {
        this.m_ctxt.enableAction("dref", false);
        this.m_ctxt.enableAction("abnds", false);
        this.m_ctxt.enableAction("reset", false);
        this.m_ctxt.enableAction("gotomem", false);
        this.m_ctxt.enableAction("newmem", false);
        this.m_ctxt.enableAction("godsm", false);
        this.m_ctxt.enableAction("copy", false);
    }

    public void forgetAllAttributes(VariableDescriptor variableDescriptor) {
        if (this.m_actionNode != null) {
            this.clearAllAttributes(variableDescriptor, false);
            this.m_actionNode.removeAllChildren();
            this.m_treeModel.reload(this.m_actionNode);
            this.m_tableModel.fireTableDataChanged();
            this.m_pane.refreshTreeAndTable();
            TreePath treePath = new TreePath(this.m_actionNode.getPath());
            this.m_tree.setSelectionPath(treePath);
            this.prepareActionContext(this.m_tree.getRowForPath(treePath));
        }
    }

    public void clearAllAttributes() {
        this.m_expanded.clear();
        this.m_derefed.clear();
        this.m_bounded.clear();
        this.m_forget.clear();
        this.m_nodes.clear();
        this.m_paths.clear();
        this.m_actionNode = null;
        this.m_actionPath = null;
    }

    protected void clearAllAttributes(VariableDescriptor variableDescriptor, boolean bl) {
        String string = this.key(variableDescriptor);
        if (bl) {
            this.m_nodes.remove(string);
        }
        this.forgetDerefed(string);
        this.forgetBounded(string);
        if (variableDescriptor.hasChildren()) {
            this.forgetExpanded(string);
            VariableDescriptor[] variableDescriptorArray = variableDescriptor.getChildren();
            int n = 0;
            while (n < variableDescriptorArray.length) {
                String string2 = this.key(variableDescriptorArray[n]);
                this.clearAllAttributes(variableDescriptorArray[n], true);
                ++n;
            }
            variableDescriptor.removeChildren();
        }
    }

    public void rememberExpanded(String string, VariableDescriptor variableDescriptor, TreePath treePath) {
        this.m_expanded.put(string, variableDescriptor);
        if (treePath != null) {
            this.m_paths.put(string, treePath);
        }
    }

    public void forgetExpanded(String string) {
        this.m_expanded.remove(string);
        this.m_paths.remove(string);
    }

    public boolean isExpanded(String string) {
        return this.m_expanded.get(string) != null;
    }

    public void rememberDerefed(String string, VariableDescriptor variableDescriptor, boolean bl) {
        if (string == null) {
            string = this.key(variableDescriptor);
        }
        this.m_derefed.put(string, variableDescriptor);
        variableDescriptor.setBounds("");
        if (bl) {
            this.forgetBounded(string);
        }
    }

    public void forgetDerefed(VariableDescriptor variableDescriptor) {
        this.forgetDerefed(this.key(variableDescriptor));
    }

    public void forgetDerefed(String string) {
        this.m_derefed.remove(string);
    }

    public boolean isDerefed(String string) {
        return this.m_derefed.get(string) != null;
    }

    public void rememberBounded(String string, VariableDescriptor variableDescriptor, boolean bl) {
        if (string == null) {
            string = this.key(variableDescriptor);
        }
        this.m_bounded.put(string, variableDescriptor);
        if (bl) {
            this.forgetDerefed(string);
        }
    }

    public void forgetBounded(VariableDescriptor variableDescriptor) {
        this.forgetBounded(this.key(variableDescriptor));
    }

    public void forgetBounded(String string) {
        this.m_bounded.remove(string);
    }

    public boolean isBounded(String string) {
        return this.m_bounded.get(string) != null;
    }

    protected void tempForgetAttributes(DefaultMutableTreeNode defaultMutableTreeNode, VariableDescriptor variableDescriptor, String string) {
        if (string == null) {
            string = this.key(variableDescriptor);
        }
        switch (variableDescriptor.getType()) {
            case 10: {
                if (!this.isDerefed(string) && !this.isBounded(string)) break;
                this.m_forget.put(string, variableDescriptor);
                break;
            }
            case 101: {
                if (!this.isDerefed(string)) break;
                this.m_forget.put(string, variableDescriptor);
                break;
            }
            case 14: {
                if (!this.isBounded(string)) break;
                this.m_forget.put(string, variableDescriptor);
            }
        }
        int n = defaultMutableTreeNode.getChildCount();
        int n2 = 0;
        while (n2 < n) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(n2);
            VariableDescriptor variableDescriptor2 = this.getVariableDescriptor(defaultMutableTreeNode2);
            String string2 = this.key(variableDescriptor2);
            if (variableDescriptor2.hasChildren()) {
                this.forgetExpanded(string2);
            }
            this.tempForgetAttributes(defaultMutableTreeNode2, variableDescriptor2, string2);
            ++n2;
        }
    }

    protected void tempUnforgetAttributes(TreePath treePath, VariableDescriptor variableDescriptor, String string) {
        Enumeration<TreePath> enumeration;
        if (string == null) {
            string = this.key(variableDescriptor);
        }
        if ((enumeration = this.m_tree.getExpandedDescendants(treePath)) != null) {
            while (enumeration.hasMoreElements()) {
                TreePath treePath2 = enumeration.nextElement();
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath2.getLastPathComponent();
                VariableDescriptor variableDescriptor2 = this.getVariableDescriptor(defaultMutableTreeNode);
                String string2 = this.key(variableDescriptor2);
                switch (variableDescriptor2.getType()) {
                    case 10: 
                    case 14: 
                    case 101: {
                        this.m_forget.remove(string2);
                    }
                }
                this.rememberExpanded(string2, variableDescriptor2, treePath2);
            }
        }
    }

    protected DefaultMutableTreeNode insertVariableNode(DefaultMutableTreeNode defaultMutableTreeNode, VariableDescriptor variableDescriptor, int n, boolean bl) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = this.createTreeNode(defaultMutableTreeNode, variableDescriptor);
        String string = this.key(variableDescriptor);
        this.m_nodes.put(string, defaultMutableTreeNode2);
        if (bl) {
            this.m_treeModel.insertNodeInto(defaultMutableTreeNode2, defaultMutableTreeNode, n);
        } else {
            defaultMutableTreeNode.insert(defaultMutableTreeNode2, n);
        }
        if ((variableDescriptor.isValidPtr() || (variableDescriptor.isArray() || variableDescriptor.isJavaClass()) && !variableDescriptor.hasChildren()) && (this.isDerefed(string) || this.isBounded(string))) {
            VariableDescriptor variableDescriptor2 = null;
            if (this.isDerefed(string)) {
                variableDescriptor2 = (VariableDescriptor)this.m_derefed.get(string);
                this.rememberDerefed(string, variableDescriptor, false);
            } else {
                variableDescriptor2 = (VariableDescriptor)this.m_bounded.get(string);
                this.rememberBounded(string, variableDescriptor, false);
            }
            variableDescriptor.setBounds(variableDescriptor2.getBounds());
            if (variableDescriptor2.hasChildren()) {
                if (this.isExpanded(string)) {
                    this.m_paths.put(string, new TreePath(defaultMutableTreeNode2.getPath()));
                }
                defaultMutableTreeNode2.setUserObject(variableDescriptor2);
                VariableDescriptor[] variableDescriptorArray = variableDescriptor2.getChildren();
                int n2 = 0;
                while (n2 < variableDescriptorArray.length) {
                    this.insertVariableNode(defaultMutableTreeNode2, variableDescriptorArray[n2], n2, bl);
                    ++n2;
                }
            }
            return defaultMutableTreeNode2;
        }
        if (variableDescriptor.isPtr() || variableDescriptor.isArray() || variableDescriptor.isJavaClass()) {
            if (this.isDerefed(string)) {
                this.rememberDerefed(string, variableDescriptor, false);
            }
            if (this.isBounded(string)) {
                this.rememberBounded(string, variableDescriptor, false);
            }
        }
        if (variableDescriptor.hasChildren()) {
            VariableDescriptor[] variableDescriptorArray = variableDescriptor.getChildren();
            if (this.isExpanded(string)) {
                this.m_paths.put(string, new TreePath(defaultMutableTreeNode2.getPath()));
            }
            int n3 = 0;
            int n4 = variableDescriptorArray.length - 1;
            if (variableDescriptor.isArray() && this.isBounded(string)) {
                n3 = variableDescriptor.getLowBound();
                n4 = variableDescriptor.getHiBound();
            }
            int n5 = n3;
            while (n5 <= n4) {
                this.insertVariableNode(defaultMutableTreeNode2, variableDescriptorArray[n5], n5, bl);
                ++n5;
            }
        }
        return defaultMutableTreeNode2;
    }

    protected void updateVariableNode(VariableDescriptor variableDescriptor) {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.m_nodes.get(this.key(variableDescriptor));
        if (defaultMutableTreeNode != null) {
            this.setVariableDescriptor(defaultMutableTreeNode, variableDescriptor);
            if (variableDescriptor.hasChildren()) {
                VariableDescriptor[] variableDescriptorArray = variableDescriptor.getChildren();
                int n = 0;
                while (n < variableDescriptorArray.length) {
                    this.updateVariableNode(variableDescriptorArray[n]);
                    ++n;
                }
            } else if (!variableDescriptor.isValidPtr() && defaultMutableTreeNode.getChildCount() > 0) {
                defaultMutableTreeNode.removeAllChildren();
                this.m_treeModel.reload(defaultMutableTreeNode);
            }
        }
    }

    protected void updateVariableNode(VariableDescriptor variableDescriptor, String string) {
        VariableDescriptor variableDescriptor2 = new VariableDescriptor(string, variableDescriptor.getLineNum(), variableDescriptor.getName(), variableDescriptor.getEvalName(), variableDescriptor.getType());
        String string2 = this.key(variableDescriptor2);
        String string3 = this.key(variableDescriptor);
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.m_nodes.get(string2);
        if (defaultMutableTreeNode != null) {
            defaultMutableTreeNode.setUserObject(variableDescriptor);
            this.m_nodes.remove(string2);
            this.m_nodes.put(string3, defaultMutableTreeNode);
        }
    }

    public void init(DebugContext debugContext, TabbedPane tabbedPane) {
        super.init(debugContext, tabbedPane);
        ToolTipManager.sharedInstance().registerComponent(this.m_tree);
        this.lookAndFeelModifications();
        this.m_varMgr = (VariableManager)this.m_ctxt.getManager("varmgr");
        this.m_ctxt.getManager("ctxtmgr").addListener(this);
        this.m_ctxt.getManager("varmgr").addListener(this);
        this.m_ctxt.getManager("lafmgr").addListener(this);
    }

    public void cleanUp() {
        ToolTipManager.sharedInstance().unregisterComponent(this.m_tree);
        this.m_pane.cleanUp();
        this.m_ctxt.getManager("ctxtmgr").removeListener(this);
        this.m_ctxt.getManager("varmgr").removeListener(this);
        this.m_ctxt.getManager("lafmgr").removeListener(this);
        this.m_tree.removeFocusListener(this);
        this.m_table.removeFocusListener(this);
        this.m_pane.getViewport().removeFocusListener(this);
        this.m_varMgr = null;
        this.m_pane = null;
        this.m_tree = null;
        this.m_treeModel = null;
        this.m_root = null;
        this.m_table = null;
        this.m_tableModel = null;
        this.m_contextMenu = null;
        this.m_varRenderer = null;
        this.m_varComparator = null;
        this.m_viewId = null;
        this.m_actionNode = null;
        this.m_actionPath = null;
        this.m_expanded = null;
        this.m_derefed = null;
        this.m_bounded = null;
        this.m_forget = null;
        this.m_nodes = null;
        this.m_paths = null;
        super.cleanUp();
    }

    public JComponent getComponent() {
        return this.m_pane.getComponent();
    }

    public void setActivePanel(boolean bl) {
        super.setActivePanel(bl);
        if (bl) {
            TreePath treePath;
            if (this.m_tree.getRowCount() > 0 && this.m_actionNode != null && (treePath = new TreePath(this.m_actionNode.getPath())) != null) {
                this.m_tree.setSelectionPath(treePath);
                this.prepareActionContext(this.m_tree.getRowForPath(treePath));
            }
        } else {
            this.clearActionContext();
        }
    }

    public void setExposed(boolean bl) {
        super.setExposed(bl);
        if (bl && this.m_notCurrent && !this.isSuspended()) {
            this.requestVariables();
        }
    }

    public boolean canDoCopy() {
        return this.m_table.getSelectedRow() > 0;
    }

    public void copy() {
        TreePath treePath = this.m_tree.getSelectionPath();
        if (treePath != null) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            VariableDescriptor variableDescriptor = this.getVariableDescriptor(defaultMutableTreeNode);
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            StringSelection stringSelection = new StringSelection(variableDescriptor.getEvalName());
            clipboard.setContents(stringSelection, this);
        }
    }

    public boolean canDoCopyPanel() {
        return true;
    }

    public void copyPanel() {
        Object object;
        int n;
        Object object2;
        int n2 = this.m_tree.getRowCount() + 1;
        int n3 = this.m_tableModel.getColumnCount() + 1;
        if (n2 == 1) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer(500);
        String[][] stringArray = new String[n2][n3];
        int[] nArray = new int[n3];
        stringArray[0][0] = MRI.get("DBG_NAME");
        nArray[0] = stringArray[0][0].length();
        int n4 = 1;
        while (n4 < n3) {
            stringArray[0][n4] = this.m_tableModel.getColumnName(n4 - 1);
            nArray[n4] = stringArray[0][n4].length();
            ++n4;
        }
        int n5 = 1;
        while (n5 < n2) {
            object2 = this.getVariableDescriptor(n5 - 1);
            stringArray[n5][0] = ((VariableDescriptor)object2).getEvalName();
            if (stringArray[n5][0].length() > nArray[0]) {
                nArray[0] = stringArray[n5][0].length();
            }
            n = 1;
            while (n < n3) {
                object = this.m_tableModel.getValueAt(n5 - 1, n - 1);
                stringArray[n5][n] = object instanceof Boolean ? ((Boolean)object == true ? "x" : "") : (String)object;
                if (stringArray[n5][n].length() > nArray[n]) {
                    nArray[n] = stringArray[n5][n].length();
                }
                ++n;
            }
            ++n5;
        }
        object2 = "                                                            ";
        n = 0;
        while (n < n2) {
            int n6 = 0;
            while (n6 < n3) {
                int n7 = nArray[n6] - stringArray[n][n6].length() + 3;
                while (n7 > ((String)object2).length()) {
                    object2 = (String)object2 + (String)object2;
                }
                stringBuffer.append(stringArray[n][n6]);
                stringBuffer.append(((String)object2).substring(0, n7));
                ++n6;
            }
            stringBuffer.append('\n');
            ++n;
        }
        object = Toolkit.getDefaultToolkit().getSystemClipboard();
        StringSelection stringSelection = new StringSelection(stringBuffer.toString());
        ((Clipboard)object).setContents(stringSelection, this);
    }

    public boolean canDoSuspend() {
        return true;
    }

    public void setSuspended(boolean bl) {
        super.setSuspended(bl);
        if (bl) {
            this.clear(true);
        } else {
            this.requestVariables();
        }
        this.m_pane.setPaneText(bl ? MRI.get("DBG_SUSPENDED") : null);
    }

    public int getId() {
        return this.m_panelId;
    }

    public void variablesAvailable(VariableEvent variableEvent) {
    }

    public void variablesEvaled(VariableEvent variableEvent) {
        int n = variableEvent.getDescriptorCount();
        int n2 = 0;
        while (n2 < n) {
            VariableDescriptor variableDescriptor = variableEvent.getDescriptorAt(n2);
            String string = this.key(variableDescriptor);
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.m_nodes.get(string);
            if (defaultMutableTreeNode != null) {
                VariableDescriptor[] variableDescriptorArray;
                VariableDescriptor variableDescriptor2 = this.setVariableDescriptor(defaultMutableTreeNode, variableDescriptor);
                DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
                if (defaultMutableTreeNode2 != this.m_root) {
                    variableDescriptorArray = this.getVariableDescriptor(defaultMutableTreeNode2);
                    variableDescriptorArray.replaceChild(variableDescriptor2, variableDescriptor);
                }
                if (variableDescriptor.hasChildren()) {
                    int n3;
                    variableDescriptorArray = variableDescriptor.getChildren();
                    if (defaultMutableTreeNode.getChildCount() == 0) {
                        this.m_actionPath = new TreePath(defaultMutableTreeNode.getPath());
                        this.rememberExpanded(string, variableDescriptor, this.m_actionPath);
                        n3 = 0;
                        while (n3 < variableDescriptorArray.length) {
                            this.insertVariableNode(defaultMutableTreeNode, variableDescriptorArray[n3], n3, true);
                            ++n3;
                        }
                        if (variableDescriptor.isPtr() && variableDescriptorArray[0].isStruct()) {
                            DefaultMutableTreeNode defaultMutableTreeNode3 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(0);
                            TreePath treePath = new TreePath(defaultMutableTreeNode3.getPath());
                            String string2 = this.key(variableDescriptorArray[0]);
                            this.rememberExpanded(string2, variableDescriptorArray[0], treePath);
                        }
                    } else if (!this.m_validate || variableDescriptor.equals(variableDescriptor2)) {
                        n3 = 0;
                        while (n3 < variableDescriptorArray.length) {
                            this.updateVariableNode(variableDescriptorArray[n3]);
                            ++n3;
                        }
                    } else {
                        defaultMutableTreeNode.removeAllChildren();
                        n3 = 0;
                        while (n3 < variableDescriptorArray.length) {
                            this.insertVariableNode(defaultMutableTreeNode, variableDescriptorArray[n3], n3, false);
                            ++n3;
                        }
                        this.m_treeModel.reload(defaultMutableTreeNode);
                    }
                } else if (defaultMutableTreeNode.getChildCount() > 0) {
                    defaultMutableTreeNode.removeAllChildren();
                    this.m_treeModel.reload(defaultMutableTreeNode);
                }
            }
            ++n2;
        }
        this.restoreTreeState(false);
    }

    public void variablesRefresh(VariableEvent variableEvent) {
        if (!this.isSuspended() && this.isExposed()) {
            this.requestVariables();
        } else {
            this.m_notCurrent = true;
        }
    }

    public void variableModified(VariableEvent variableEvent) {
        VariableDescriptor variableDescriptor = variableEvent.getDescriptorAt(0);
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.m_nodes.get(this.key(variableDescriptor));
        if (defaultMutableTreeNode != null) {
            this.setVariableDescriptor(defaultMutableTreeNode, variableDescriptor);
            this.m_tableModel.fireTableDataChanged();
            Object[] objectArray = new Object[]{variableDescriptor.getEvalName()};
            String string = MessageFormat.format(MRI.get("DBG_VAR_MODIFIED_FMT"), objectArray);
            this.m_ctxt.setMessage(string);
        }
        this.requestVariables();
    }

    public void displayMaskChanged(VariableEvent variableEvent) {
        if (!this.isSuspended() && this.isExposed()) {
            this.requestVariables();
        } else {
            this.m_notCurrent = true;
        }
    }

    public void monitorCreated(VariableEvent variableEvent) {
    }

    public void watchAdded(WatchEvent watchEvent) {
    }

    public void watchRemoved(WatchEvent watchEvent) {
    }

    public void watchError(WatchEvent watchEvent) {
    }

    public void allWatchesRemoved(WatchEvent watchEvent) {
    }

    public void contextChanged(ContextEvent contextEvent) {
        switch (contextEvent.getType()) {
            case 0: {
                this.m_viewId = contextEvent.getViewId();
                this.m_lineNum = contextEvent.getLineNum();
                if (!this.isSuspended() && this.isExposed()) {
                    this.requestVariables();
                    break;
                }
                this.m_notCurrent = true;
                break;
            }
            case 2: {
                if (this.m_panelId != 1) break;
                this.m_viewId = contextEvent.getViewId();
                this.m_lineNum = contextEvent.getLineNum();
                if (!this.isSuspended() && this.isExposed()) {
                    this.requestVariables();
                    break;
                }
                this.m_notCurrent = true;
                break;
            }
            case 4: {
                this.clear(true);
                break;
            }
        }
    }

    public void lookAndFeelChanged(LAFEvent lAFEvent) {
        this.lookAndFeelModifications();
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        TreePath treePath = treeSelectionEvent.getPath();
        if (treePath != null) {
            this.prepareActionContext(this.m_tree.getRowForPath(treePath));
        }
    }

    public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
        TreePath treePath = treeExpansionEvent.getPath();
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        VariableDescriptor variableDescriptor = this.getVariableDescriptor(defaultMutableTreeNode);
        String string = this.key(variableDescriptor);
        this.rememberExpanded(string, variableDescriptor, treePath);
        this.tempUnforgetAttributes(treePath, variableDescriptor, string);
    }

    public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
        TreePath treePath = treeExpansionEvent.getPath();
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        VariableDescriptor variableDescriptor = this.getVariableDescriptor(defaultMutableTreeNode);
        String string = this.key(variableDescriptor);
        this.forgetExpanded(string);
        this.tempForgetAttributes(defaultMutableTreeNode, variableDescriptor, string);
    }

    public void lostOwnership(Clipboard clipboard, Transferable transferable) {
    }

    protected boolean handlePopupMenu(MouseEvent mouseEvent) {
        boolean bl = false;
        if (mouseEvent.isPopupTrigger()) {
            JComponent jComponent = (JComponent)mouseEvent.getSource();
            if (jComponent == this.m_table) {
                int n = this.m_table.rowAtPoint(mouseEvent.getPoint());
                if (n >= 0) {
                    if (this.m_table.isRowSelected(n)) {
                        this.prepareActionContext(n);
                    } else {
                        this.m_table.setRowSelectionInterval(n, n);
                    }
                }
            } else if (jComponent == this.m_tree) {
                int n = this.m_tree.getRowForLocation(mouseEvent.getPoint().x, mouseEvent.getPoint().y);
                if (n >= 0) {
                    if (this.m_tree.isRowSelected(n)) {
                        this.prepareActionContext(n);
                    } else {
                        this.m_tree.setSelectionRow(n);
                    }
                }
            } else {
                this.prepareActionContext(-1);
            }
            this.m_contextMenu.show(jComponent, mouseEvent.getX(), mouseEvent.getY());
            bl = true;
        }
        return bl;
    }

    public void mousePressed(MouseEvent mouseEvent) {
        int n;
        this.m_ctxt.setActivePanel(this);
        ((JComponent)mouseEvent.getSource()).requestFocus();
        if (!this.handlePopupMenu(mouseEvent) && (n = this.m_table.rowAtPoint(mouseEvent.getPoint())) >= 0) {
            if (this.m_table.isRowSelected(n)) {
                this.prepareActionContext(n);
            } else {
                this.m_table.setRowSelectionInterval(n, n);
            }
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.handlePopupMenu(mouseEvent);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    protected class VariableRenderer
    extends DefaultTreeCellRenderer {
        private ImageIcon m_structIcon = MRI.getIcon(0, "/com/ibm/iseries/debug/dbg024.gif");
        private ImageIcon m_arrayIcon = MRI.getIcon(0, "/com/ibm/iseries/debug/dbg025.gif");
        private ImageIcon m_ptrIcon = MRI.getIcon(0, "/com/ibm/iseries/debug/dbg046.gif");
        private ImageIcon m_charIcon = MRI.getIcon(0, "/com/ibm/iseries/debug/dbg049.gif");
        private ImageIcon m_strIcon = MRI.getIcon(0, "/com/ibm/iseries/debug/dbg051.gif");
        private ImageIcon m_intIcon = MRI.getIcon(0, "/com/ibm/iseries/debug/dbg050.gif");
        private ImageIcon m_floatIcon = MRI.getIcon(0, "/com/ibm/iseries/debug/dbg048.gif");
        private ImageIcon m_simpleIcon = MRI.getIcon(0, "/com/ibm/iseries/debug/dbg026.gif");

        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            Object object2 = ((DefaultMutableTreeNode)object).getUserObject();
            if (object2 instanceof VariableDescriptor) {
                VariableDescriptor variableDescriptor = (VariableDescriptor)object2;
                switch (variableDescriptor.getType()) {
                    case 13: {
                        this.setIcon(this.m_structIcon);
                        this.setToolTipText(variableDescriptor.getEvalName());
                        break;
                    }
                    case 101: {
                        if (variableDescriptor.getChildCount() > 0) {
                            this.setIcon(this.m_structIcon);
                        } else {
                            this.setIcon(this.m_simpleIcon);
                        }
                        this.setToolTipText(variableDescriptor.getEvalName());
                        break;
                    }
                    case 14: {
                        this.setIcon(this.m_arrayIcon);
                        this.setToolTipText(variableDescriptor.getEvalName());
                        break;
                    }
                    case 10: 
                    case 11: {
                        this.setIcon(this.m_ptrIcon);
                        this.setToolTipText(variableDescriptor.getEvalName());
                        break;
                    }
                    case 1: 
                    case 2: {
                        this.setIcon(this.m_charIcon);
                        this.setToolTipText(variableDescriptor.getEvalName());
                        break;
                    }
                    case 16: {
                        this.setIcon(this.m_strIcon);
                        this.setToolTipText(variableDescriptor.getEvalName());
                        break;
                    }
                    case 31: 
                    case 32: 
                    case 33: {
                        this.setIcon(this.m_strIcon);
                        this.setToolTipText("*" + variableDescriptor.getEvalName());
                        break;
                    }
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 17: 
                    case 18: 
                    case 19: 
                    case 20: 
                    case 21: 
                    case 22: 
                    case 23: 
                    case 24: 
                    case 30: 
                    case 34: 
                    case 35: 
                    case 36: 
                    case 37: {
                        this.setIcon(this.m_intIcon);
                        this.setToolTipText(variableDescriptor.getEvalName());
                        break;
                    }
                    case 8: 
                    case 9: {
                        this.setIcon(this.m_floatIcon);
                        this.setToolTipText(variableDescriptor.getEvalName());
                        break;
                    }
                    default: {
                        this.setIcon(this.m_simpleIcon);
                        this.setToolTipText(variableDescriptor.getEvalName());
                    }
                }
            }
            return this;
        }
    }

    protected class VariableComparator
    implements Comparator {
        public int compare(Object object, Object object2) {
            VariableDescriptor variableDescriptor = (VariableDescriptor)object;
            VariableDescriptor variableDescriptor2 = (VariableDescriptor)object2;
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)VariablesPanel.this.m_nodes.get(VariablesPanel.this.key(variableDescriptor));
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)VariablesPanel.this.m_nodes.get(VariablesPanel.this.key(variableDescriptor2));
            if (defaultMutableTreeNode != null && defaultMutableTreeNode2 != null) {
                int n;
                if (defaultMutableTreeNode.isNodeDescendant(defaultMutableTreeNode2)) {
                    return -1;
                }
                if (defaultMutableTreeNode.isNodeAncestor(defaultMutableTreeNode2)) {
                    return 1;
                }
                TreeNode[] treeNodeArray = defaultMutableTreeNode.getPath();
                TreeNode[] treeNodeArray2 = defaultMutableTreeNode2.getPath();
                int n2 = VariablesPanel.this.m_root.getIndex(treeNodeArray[1]);
                if (n2 < (n = VariablesPanel.this.m_root.getIndex(treeNodeArray2[1]))) {
                    return -1;
                }
                if (n2 > n) {
                    return 1;
                }
            }
            return 0;
        }

        public boolean equals(Object object) {
            return object == this;
        }
    }
}

