/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iseries.debug.source;

import com.ibm.iseries.debug.BreakpointDescriptor;
import com.ibm.iseries.debug.BreakpointIcon;
import com.ibm.iseries.debug.Breakpoints;
import com.ibm.iseries.debug.event.SettingsEvent;
import com.ibm.iseries.debug.event.SourceViewEvent;
import com.ibm.iseries.debug.manager.BreakpointGroupManager;
import com.ibm.iseries.debug.manager.BreakpointManager;
import com.ibm.iseries.debug.manager.SettingsManager;
import com.ibm.iseries.debug.source.SourceRowHeader;
import com.ibm.iseries.debug.source.SourceView;
import com.ibm.iseries.debug.util.Action;
import com.ibm.iseries.debug.util.ContextMenu;
import com.ibm.iseries.debug.util.DebugContext;
import com.ibm.iseries.debug.util.MRI;
import com.ibm.iseries.debug.util.Util;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;

public class SourceBreakpointHeader
extends JPanel
implements SourceRowHeader,
MouseListener {
    protected static final int LEFT_MARGIN = 2;
    protected static final int RIGHT_MARGIN = 8;
    protected static final String EMPTY_VALUE = "";
    protected DebugContext m_ctxt;
    protected SettingsManager m_settingsMgr;
    protected BreakpointGroupManager m_brkgrpMgr;
    protected Breakpoints m_breakpoints;
    protected FontUIResource m_font;
    protected FontMetrics m_fontMetrics;
    protected ContextMenu m_contextMenu;
    protected int m_fontHeight;
    protected int m_fontAscent;
    protected int m_lineCount;
    protected int m_width;
    protected int m_iconOffset;
    protected int m_iconSize;
    protected BreakpointIcon m_icon;
    protected MouseClickTimer m_timer;
    protected String m_viewId = "";
    protected int m_startLine = 1;
    protected int m_endLine;
    protected BreakpointDescriptor m_descriptor = new BreakpointDescriptor();

    public String getViewId() {
        return this.m_viewId;
    }

    public JComponent getComponent() {
        return this;
    }

    public void lookAndFeelModifications(ContextMenu contextMenu) {
        this.m_contextMenu = contextMenu;
        this.setBackground(UIManager.getColor("TextArea.background"));
        this.setForeground(UIManager.getColor("TextArea.foreground"));
        this.settingsChanged(15);
    }

    public void settingsChanged(int n) {
        if (SettingsEvent.generalChanged(n)) {
            this.m_timer.setDelay(this.m_settingsMgr.m_srcDblClick);
        }
        if (SettingsEvent.fontsChanged(n)) {
            this.m_font = this.m_settingsMgr.m_srcFont;
            this.m_fontMetrics = ((Component)this).getFontMetrics(this.m_font);
            this.m_fontHeight = this.m_fontMetrics.getHeight();
            this.m_fontAscent = this.m_fontMetrics.getMaxAscent();
            this.m_iconSize = this.m_fontMetrics.getAscent() + this.m_fontMetrics.getDescent();
            if (this.m_iconSize % 2 == 0) {
                --this.m_iconSize;
            }
            this.m_iconOffset = this.m_fontHeight - this.m_iconSize - 1;
            if (this.m_icon == null) {
                this.m_icon = new BreakpointIcon(this.m_iconSize);
            } else {
                this.m_icon.setSize(this.m_iconSize);
            }
            this.adjustWidth();
        }
    }

    public void init(DebugContext debugContext, SourceView sourceView) {
        this.m_ctxt = debugContext;
        this.m_brkgrpMgr = (BreakpointGroupManager)this.m_ctxt.getManager("brkgrpmgr");
        this.m_settingsMgr = (SettingsManager)this.m_ctxt.getManager("settmgr");
        this.setMouseBehavior();
        ToolTipManager.sharedInstance().registerComponent(this);
    }

    public void cleanUp() {
        ToolTipManager.sharedInstance().unregisterComponent(this);
        this.m_ctxt = null;
        this.m_brkgrpMgr = null;
        this.m_settingsMgr = null;
        this.m_contextMenu = null;
        this.m_font = null;
        this.m_fontMetrics = null;
        this.m_timer = null;
        this.m_breakpoints = null;
        this.m_icon = null;
        this.m_descriptor = null;
    }

    public void setAccessibleDescription(String string) {
        Util.setAccessible(this, MRI.get("DBG_SOURCE_CODE_VIEW"), string);
    }

    public void setSourceInfo(SourceViewEvent sourceViewEvent) {
        BreakpointManager breakpointManager = (BreakpointManager)this.m_ctxt.getManager("brkmgr");
        this.m_viewId = sourceViewEvent.getViewId();
        this.m_startLine = sourceViewEvent.getStartLineNum();
        this.m_endLine = sourceViewEvent.getEndLineNum();
        this.m_lineCount = this.m_endLine - this.m_startLine + 1;
        this.m_breakpoints = breakpointManager.getBreakpoints(this.m_viewId);
        this.adjustWidth();
        this.repaint();
    }

    public void clearSourceInfo() {
        this.m_viewId = EMPTY_VALUE;
        this.m_startLine = 1;
        this.m_endLine = 0;
        this.m_lineCount = 0;
        this.m_breakpoints = null;
        this.repaint();
    }

    public boolean containsLineNum(int n) {
        return n >= this.m_startLine && n <= this.m_endLine;
    }

    public void repaint() {
        this.repaint(this.getVisibleRect());
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (this.m_font == null) {
            return;
        }
        graphics.setFont(this.m_font);
        Rectangle rectangle = graphics.getClipBounds();
        int n = rectangle.y / this.m_fontHeight;
        int n2 = (rectangle.y + rectangle.height) / this.m_fontHeight;
        int n3 = n;
        while (n3 <= n2 && n3 < this.m_lineCount) {
            BreakpointDescriptor breakpointDescriptor;
            String string = this.getDisplayValue(this.m_startLine + n3);
            int n4 = this.m_fontMetrics.stringWidth(string);
            int n5 = n3 * this.m_fontHeight;
            graphics.drawString(string, this.m_width - n4 - 8, n5 + this.m_fontAscent);
            if (this.m_breakpoints.getCount() > 0 && (breakpointDescriptor = this.m_breakpoints.getDescriptor(this.m_startLine + n3)) != null) {
                this.m_icon.setGradient(breakpointDescriptor.isServiceEntryPoint());
                this.m_icon.paint(breakpointDescriptor.isEnabled(), this.m_brkgrpMgr.getGroupColor(breakpointDescriptor.getGroupId()), graphics, 2, n5 + this.m_iconOffset);
            }
            ++n3;
        }
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        BreakpointDescriptor breakpointDescriptor;
        int n = this.m_startLine + mouseEvent.getY() / this.m_fontHeight;
        if (this.m_breakpoints != null && (breakpointDescriptor = this.m_breakpoints.getDescriptor(n)) != null) {
            return breakpointDescriptor.toString();
        }
        return null;
    }

    protected String getDisplayValue(int n) {
        return EMPTY_VALUE;
    }

    protected void adjustWidth() {
        if (this.m_lineCount > 0) {
            String string = this.getDisplayValue(this.m_startLine + this.m_lineCount);
            this.m_width = 2 + this.m_iconSize + 4 + this.m_fontMetrics.stringWidth(string) + 8;
            Dimension dimension = new Dimension(this.m_width, this.m_fontHeight * this.m_lineCount);
            this.setPreferredSize(dimension);
            this.setSize(dimension);
        }
    }

    protected void setMouseBehavior() {
        if (this.m_timer == null) {
            this.m_timer = new MouseClickTimer();
            this.addMouseListener(this);
        }
    }

    protected boolean isValidBreakpointLineNum(int n) {
        return true;
    }

    protected void prepareBreakpointDescriptor(int n, BreakpointDescriptor breakpointDescriptor) {
        breakpointDescriptor.setViewId(this.m_viewId);
        breakpointDescriptor.setLineNum(n);
        breakpointDescriptor.setGroupId(this.m_brkgrpMgr.getCurrentGroupId());
        breakpointDescriptor.setState(0);
    }

    protected boolean handlePopupMenu(MouseEvent mouseEvent) {
        boolean bl = false;
        if (mouseEvent.isPopupTrigger()) {
            int n = this.m_startLine + mouseEvent.getY() / this.m_fontHeight;
            this.m_ctxt.getActionGroup().clearLnBrkContext();
            if (this.isValidBreakpointLineNum(n)) {
                BreakpointDescriptor breakpointDescriptor = this.m_breakpoints.getDescriptor(n);
                this.m_ctxt.updateBreakpointActions(breakpointDescriptor);
                if (breakpointDescriptor == null) {
                    breakpointDescriptor = this.m_descriptor;
                    this.prepareBreakpointDescriptor(n, breakpointDescriptor);
                }
                this.m_ctxt.getActionGroup().setLnBrkContext(breakpointDescriptor.getViewId(), breakpointDescriptor.getLineNum(), breakpointDescriptor);
            } else {
                this.m_ctxt.updateBreakpointActions();
            }
            this.m_contextMenu.show(this, mouseEvent.getX(), mouseEvent.getY());
            bl = true;
        }
        return bl;
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (this.handlePopupMenu(mouseEvent)) {
            return;
        }
        if (!SwingUtilities.isLeftMouseButton(mouseEvent) || this.m_lineCount == 0) {
            return;
        }
        this.m_ctxt.setActiveSource(this.m_viewId);
        int n = this.m_startLine + mouseEvent.getY() / this.m_fontHeight;
        if (this.isValidBreakpointLineNum(n)) {
            if (this.m_timer.m_tm.isRunning()) {
                this.m_timer.m_tm.stop();
                if (n == this.m_timer.m_lineNum) {
                    this.m_timer.doubleClick();
                }
            } else {
                this.m_timer.m_lineNum = n;
                this.m_timer.m_tm.restart();
            }
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.handlePopupMenu(mouseEvent)) {
            return;
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    protected class MouseClickTimer
    implements ActionListener {
        public Timer m_tm = null;
        public int m_lineNum = -1;

        public MouseClickTimer() {
            this.m_tm = new Timer(SourceBreakpointHeader.this.m_settingsMgr.m_srcDblClick, this);
        }

        public void setDelay(int n) {
            this.m_tm.setDelay(n);
            this.m_tm.setInitialDelay(n);
        }

        public void singleClick() {
            Action action = null;
            BreakpointDescriptor breakpointDescriptor = SourceBreakpointHeader.this.m_breakpoints.getDescriptor(this.m_lineNum);
            if (breakpointDescriptor == null) {
                action = SourceBreakpointHeader.this.m_ctxt.getAction("abrk");
                breakpointDescriptor = SourceBreakpointHeader.this.m_descriptor;
                SourceBreakpointHeader.this.prepareBreakpointDescriptor(this.m_lineNum, breakpointDescriptor);
            } else {
                action = SourceBreakpointHeader.this.m_ctxt.getAction("rbrk");
            }
            SourceBreakpointHeader.this.m_ctxt.getActionGroup().clearLnBrkContext();
            SourceBreakpointHeader.this.m_ctxt.getActionGroup().setLnBrkContext(breakpointDescriptor.getViewId(), breakpointDescriptor.getLineNum(), breakpointDescriptor);
            if (action != null) {
                action.run();
            }
        }

        public void doubleClick() {
            Action action = null;
            BreakpointDescriptor breakpointDescriptor = SourceBreakpointHeader.this.m_breakpoints.getDescriptor(this.m_lineNum);
            if (breakpointDescriptor == null) {
                action = SourceBreakpointHeader.this.m_ctxt.getAction("abrk");
                breakpointDescriptor = SourceBreakpointHeader.this.m_descriptor;
                SourceBreakpointHeader.this.prepareBreakpointDescriptor(this.m_lineNum, breakpointDescriptor);
            } else {
                switch (breakpointDescriptor.getState()) {
                    case 1: {
                        action = SourceBreakpointHeader.this.m_ctxt.getAction("dbrk");
                        break;
                    }
                    case 2: {
                        action = SourceBreakpointHeader.this.m_ctxt.getAction("ebrk");
                    }
                }
            }
            SourceBreakpointHeader.this.m_ctxt.getActionGroup().clearLnBrkContext();
            SourceBreakpointHeader.this.m_ctxt.getActionGroup().setLnBrkContext(breakpointDescriptor.getViewId(), breakpointDescriptor.getLineNum(), breakpointDescriptor);
            if (action != null) {
                action.run();
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.m_tm.stop();
            this.singleClick();
        }
    }
}

