/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iseries.debug.source;

import com.ibm.iseries.debug.event.SourceViewEvent;
import com.ibm.iseries.debug.memory.MemoryAddress;
import com.ibm.iseries.debug.source.SourcePane;
import com.ibm.iseries.debug.util.DebugContext;
import com.ibm.iseries.debug.util.DebugSource;
import com.ibm.iseries.debug.util.MRI;
import com.ibm.iseries.debug.util.Util;
import java.beans.PropertyVetoException;
import java.text.MessageFormat;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;

public class SourceFrame
extends JInternalFrame
implements DebugSource {
    private String m_completePath;
    private SourcePane m_srcPane;
    private boolean m_isActive;

    public SourceFrame(DebugContext debugContext, SourceViewEvent sourceViewEvent, String string) {
        super("", true, true, true, true);
        this.setDefaultCloseOperation(2);
        this.m_completePath = string;
        this.m_srcPane = new SourcePane(debugContext, sourceViewEvent);
        this.m_srcPane.setAccessibleDescription(this.m_completePath);
        Util.setOrientation(this);
        Util.setAccessible(this, MRI.get("DBG_SOURCE_CODE_VIEW"), this.m_completePath);
        this.setTitle(this.m_completePath);
        this.setContentPane(this.m_srcPane.getComponent());
    }

    public void lookAndFeelModifications() {
        this.m_srcPane.lookAndFeelModifications();
    }

    public void settingsChanged(int n) {
        this.m_srcPane.settingsChanged(n);
        if (this.isVisible()) {
            this.repaint(this.getVisibleRect());
        }
    }

    public JComponent getComponent() {
        return this;
    }

    public JComponent getViewComponent() {
        return this.m_srcPane.getViewComponent();
    }

    public void clear() {
        this.m_srcPane.clearSourceCode();
    }

    public void cleanUp() {
        DebugContext debugContext = this.m_srcPane.getContext();
        if (debugContext.getActiveSource() == this) {
            debugContext.setActiveSource((DebugSource)null);
        }
        this.m_srcPane.cleanUp();
        this.m_srcPane = null;
        this.m_completePath = null;
    }

    public String getCompletePath() {
        return this.m_completePath;
    }

    public void setViewId(String string) {
        this.m_srcPane.setViewId(string);
    }

    public String getViewId() {
        return this.m_srcPane.getViewId();
    }

    public boolean isAssembler() {
        return this.m_srcPane.isAssembler();
    }

    public void setSourceCode(SourceViewEvent sourceViewEvent) {
        this.m_srcPane.setSourceCode(sourceViewEvent);
        this.updateTitle(sourceViewEvent);
    }

    public int getCursorLineNum() {
        return this.m_srcPane.getCursorLineNum();
    }

    public void setActiveLineNum(int n) {
        this.m_srcPane.setActiveLineNum(n);
    }

    public void resetActiveLineNum() {
        this.m_srcPane.resetActiveLineNum();
    }

    public boolean isFullSource() {
        return this.m_srcPane.getStartLineNum() == 1 && this.m_srcPane.getEndLineNum() == this.m_srcPane.getTotalLineCount();
    }

    public int getStartLineNum() {
        return this.m_srcPane.getStartLineNum();
    }

    public int getEndLineNum() {
        return this.m_srcPane.getEndLineNum();
    }

    public int getTotalLineCount() {
        return this.m_srcPane.getTotalLineCount();
    }

    public boolean containsLineNum(int n) {
        return n >= this.m_srcPane.getStartLineNum() && n <= this.m_srcPane.getEndLineNum();
    }

    public boolean isLineNumVisible(int n) {
        return this.m_srcPane.isLineNumVisible(n);
    }

    public void scrollToLineNum(int n) {
        this.m_srcPane.scrollToLineNum(n);
    }

    public void scrollToLineNum(int n, boolean bl) {
        this.m_srcPane.scrollToLineNum(n, bl);
    }

    public String getSelectedText() {
        return this.m_srcPane.getSelectedText();
    }

    public int findText(String string, int n, boolean bl, boolean bl2) {
        return this.m_srcPane.findText(string, n, bl, bl2);
    }

    public int findTextInLine(String string, int n, boolean bl, boolean bl2) {
        return this.m_srcPane.findTextInLine(string, n, bl, bl2);
    }

    public void gotoLine(int n) {
        this.m_srcPane.gotoLine(n);
    }

    public void copy() {
        this.m_srcPane.copy();
    }

    public void displayAutoEvalTooltip(String string) {
        this.m_srcPane.displayAutoEvalTooltip(string);
    }

    public boolean viewHasFocus() {
        return this.m_srcPane.viewHasFocus();
    }

    public void viewRequestFocus() {
        this.m_srcPane.viewRequestFocus();
    }

    public void setActiveSource(boolean bl) {
        if (bl != this.m_isActive) {
            this.m_isActive = bl;
            if (this.m_isActive) {
                this.m_srcPane.viewRequestFocus();
            }
        }
    }

    public boolean isActiveSource() {
        return this.m_isActive;
    }

    protected void updateTitle(SourceViewEvent sourceViewEvent) {
        if (!this.isFullSource()) {
            String string = null;
            if (sourceViewEvent.isAssemblerSource()) {
                MemoryAddress memoryAddress = sourceViewEvent.getStartAddress();
                Object[] objectArray = new Object[]{this.m_completePath, memoryAddress.toString(), memoryAddress.add((this.m_srcPane.getEndLineNum() - this.m_srcPane.getStartLineNum()) * 4).toString()};
                string = MessageFormat.format(MRI.get("DBG_DSM_WINDOW_TITLE_FMT"), objectArray);
            } else {
                Object[] objectArray = new Object[]{this.m_completePath, new Integer(this.m_srcPane.getStartLineNum()), new Integer(this.m_srcPane.getEndLineNum()), new Integer(this.m_srcPane.getTotalLineCount())};
                string = MessageFormat.format(MRI.get("DBG_SOURCE_WINDOW_TITLE_FMT"), objectArray);
            }
            this.setTitle(string);
        }
    }

    public void setSelected(boolean bl) throws PropertyVetoException {
        if (this.m_srcPane != null) {
            this.m_srcPane.viewIgnoreFocus(true);
            super.setSelected(bl);
            this.m_srcPane.viewIgnoreFocus(false);
        } else {
            super.setSelected(bl);
        }
    }
}

