/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iseries.debug.util;

import com.ibm.iseries.debug.util.DebugWindow;
import com.ibm.iseries.debug.util.Dialog;
import com.ibm.iseries.debug.util.MRI;
import com.ibm.iseries.debug.util.Util;
import java.awt.Window;
import java.net.URL;
import javax.help.DefaultHelpBroker;
import javax.help.HelpBroker;
import javax.help.HelpSet;

public class Help {
    public static final String OVERVIEW = "dbgoverview";
    public static final String SOURCE_VIEW = "dbgsource_p";
    public static final String BREAKPOINTS = "dbgbrkpts_p";
    public static final String PROGRAMS = "dbgpgms_p";
    public static final String LOCALS = "dbglcl_p";
    public static final String MONITORS = "dbgmonitor_p";
    public static final String CONSOLE = "dbgcon_p";
    public static final String CALLSTACK = "dbgcallstk_p";
    public static final String THREADS = "dbgthread_p";
    public static final String MEMORY = "dbgmemory_p";
    public static final String IO = "dbgio_p";
    public static final String UNIX_SOURCE_FILES = "dbgfiles_p";
    public static final String UNIX_METHODS = "dbgmethods_p";
    public static final String UNIX_LOADMAP = "dbgloadmap_p";
    public static final String UNIX_REGISTERS = "dbgregs_p";
    public static final String UNIX_GPR_REGS = "dbggprreg_p";
    public static final String UNIX_FPR_REGS = "dbgfprreg_p";
    public static final String UNIX_STATUS_REGS = "dbgstatusreg_p";
    public static final String SIGNON_DIALOG = "signon";
    public static final String STARTDEBUG_DIALOG = "dbgstrdbg";
    public static final String ADDPGM_DIALOG = "dbgaddobj";
    public static final String RMVPGM_DIALOG = "dbgrmvobj";
    public static final String BRK_DIALOG = "dbgbrkprop";
    public static final String EDIT_BRK_DIALOG = "dbgeditbrk";
    public static final String NEWGRP_DIALOG = "dbgnewgrp";
    public static final String DLTGRP_DIALOG = "dbgrmvgrp";
    public static final String BRKGRP_DIALOG = "dbgbrkptsprop";
    public static final String COLUMNS_DIALOG = "dbgcolumns";
    public static final String CHGVIEW_DIALOG = "dbgchgsrcview";
    public static final String PREFERENCES_DIALOG = "preferences";
    public static final String BROWSE_JOB_DIALOG = "dbgbrowsejobs";
    public static final String STARTPASEDEBUG_DIALOG = "dbgstrpasedbg";
    public static final String BROWSE_PROCESS_DIALOG = "dbgbrowseproc";
    public static final String DEBUG_OPTS_DIALOG = "dbgopts";
    public static final String DBGMGR_OVERVIEW = "dbgmgroverview";
    public static final String DBGMGR_ADDSYS_DIALOG = "dbgmgraddsys";
    public static final String DBGMGR_RMVSYS_DIALOG = "dbgmgrrmvsys";
    public static final String DBGMGR_ADDUSER_DIALOG = "dbgmgraddusr";
    public static final String DBGMGR_RMVUSER_DIALOG = "dbgmgrrmvusr";
    public static final int IDBG_HELPSET = 0;
    public static final int IDBGMGR_HELPSET = 0;
    public static final int PASE_HELPSET = 1;
    public static final int PIRANHA_HELPSET = 2;
    private static Help[] s_instance = new Help[3];
    private static String[] s_helpSet = new String[]{"com/ibm/iseries/debug/Help/TES_HelpSet.hs", "com/ibm/iseries/debug/Help/PASETES_HelpSet.hs", "com/ibm/iseries/debug/Help/Piranha_HelpSet.hs"};
    private int m_helpSetId;
    private HelpSet m_helpSet;
    private HelpBroker m_helpBroker;

    public static Help instance(int n) {
        if (s_instance[n] == null) {
            Help.s_instance[n] = new Help(n);
        }
        return s_instance[n];
    }

    public Help(int n) {
        this.m_helpSetId = n;
    }

    public void displayHelp(String string, DebugWindow debugWindow) {
        if (this.m_helpBroker == null) {
            if (debugWindow != null) {
                debugWindow.postClock();
            }
            try {
                URL uRL = HelpSet.findHelpSet(null, (String)s_helpSet[this.m_helpSetId]);
                if (uRL != null) {
                    this.m_helpSet = new HelpSet(null, uRL);
                    this.m_helpBroker = this.m_helpSet.createHelpBroker();
                } else {
                    Util.errorMessage(debugWindow.getJFrame(), MRI.get("DBG_ERROR"), MRI.get("DBG_JAVA_HELP_ID_NOT_FOUND"));
                }
            }
            catch (Throwable throwable) {
                Util.errorMessage(debugWindow.getJFrame(), MRI.get("DBG_ERROR"), MRI.get("DBG_JAVA_HELP_NOT_FOUND"));
            }
            if (debugWindow != null) {
                debugWindow.retractClock();
            }
        }
        if (this.m_helpBroker != null) {
            try {
                ((DefaultHelpBroker)this.m_helpBroker).setActivationWindow((Window)debugWindow.getJFrame());
                this.m_helpBroker.setCurrentID(string);
                this.m_helpBroker.setDisplayed(true);
            }
            catch (Throwable throwable) {
                Util.errorMessage(debugWindow.getJFrame(), MRI.get("DBG_ERROR"), MRI.get("DBG_JAVA_HELP_ID_NOT_FOUND"));
            }
        }
    }

    public void displayHelp(String string, Dialog dialog) {
        if (this.m_helpBroker == null) {
            if (dialog != null) {
                dialog.postClock();
            }
            try {
                URL uRL = HelpSet.findHelpSet(null, (String)s_helpSet[this.m_helpSetId]);
                if (uRL != null) {
                    this.m_helpSet = new HelpSet(null, uRL);
                    this.m_helpBroker = this.m_helpSet.createHelpBroker();
                } else {
                    Util.errorMessage(dialog, MRI.get("DBG_ERROR"), MRI.get("DBG_JAVA_HELP_ID_NOT_FOUND"));
                }
            }
            catch (Throwable throwable) {
                Util.errorMessage(dialog, MRI.get("DBG_ERROR"), MRI.get("DBG_JAVA_HELP_NOT_FOUND"));
            }
            if (dialog != null) {
                dialog.retractClock();
            }
        }
        if (this.m_helpBroker != null) {
            try {
                ((DefaultHelpBroker)this.m_helpBroker).setActivationWindow((Window)dialog);
                this.m_helpBroker.setCurrentID(string);
                this.m_helpBroker.setDisplayed(true);
            }
            catch (Throwable throwable) {
                Util.errorMessage(dialog, MRI.get("DBG_ERROR"), MRI.get("DBG_JAVA_HELP_ID_NOT_FOUND"));
            }
        }
    }
}

