/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iseries.debugmanager;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.CommandCall;
import com.ibm.iseries.debug.event.LAFEvent;
import com.ibm.iseries.debug.listener.LAFListener;
import com.ibm.iseries.debug.manager.LAFManager;
import com.ibm.iseries.debug.manager.SettingsManager;
import com.ibm.iseries.debug.manager.SourceViewManager;
import com.ibm.iseries.debug.util.Action;
import com.ibm.iseries.debug.util.CommLink;
import com.ibm.iseries.debug.util.CommLinkEvent;
import com.ibm.iseries.debug.util.CommLinkListener;
import com.ibm.iseries.debug.util.DebugFile;
import com.ibm.iseries.debug.util.DebugWindow;
import com.ibm.iseries.debug.util.Dialog;
import com.ibm.iseries.debug.util.MRI;
import com.ibm.iseries.debug.util.Menubar;
import com.ibm.iseries.debug.util.Packet;
import com.ibm.iseries.debug.util.PacketInflater;
import com.ibm.iseries.debug.util.PasswordSecurity;
import com.ibm.iseries.debug.util.Request;
import com.ibm.iseries.debug.util.Settings;
import com.ibm.iseries.debug.util.Toolbar;
import com.ibm.iseries.debug.util.Toolbox;
import com.ibm.iseries.debug.util.Util;
import com.ibm.iseries.debugmanager.DebugManagerContextMenu;
import com.ibm.iseries.debugmanager.DebugManagerMenubar;
import com.ibm.iseries.debugmanager.DebugManagerToolbar;
import com.ibm.iseries.debugmanager.action.DebugManagerActionGroup;
import com.ibm.iseries.debugmanager.packet.DebugManagerPacketInflater;
import com.ibm.iseries.debugmanager.request.DeregisterUsersRequest;
import com.ibm.iseries.debugmanager.request.RegisterUsersRequest;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class DebugManager
extends JFrame
implements DebugWindow,
CommLinkListener,
LAFListener,
MouseListener,
ActionListener,
ListSelectionListener,
ChangeListener {
    private static final String USER_CACHE = ".idbgmgrcache";
    private static final String GIF = "/com/ibm/iseries/debugmanager/dbg064.gif";
    private static final String MESSAGES_GIF = "/com/ibm/iseries/debug/dbg020.gif";
    private static final String CONNECTED_GIF = "/com/ibm/iseries/debugmanager/dbg027.gif";
    private static final String CONNECTING_GIF = "/com/ibm/iseries/debugmanager/dbg028.gif";
    private static final String DISCONNECTED_GIF = "/com/ibm/iseries/debugmanager/dbg029.gif";
    private static final String FAILED_GIF = "/com/ibm/iseries/debugmanager/dbg030.gif";
    private static final int COLUMN_COUNT = 4;
    private static final int COLUMN_DEBUG = 0;
    private static final int COLUMN_SYSTEM = 1;
    private static final int COLUMN_USERS = 2;
    private static final int COLUMN_STATUS = 3;
    private static final String DELETE = "delete";
    private static final double VERSION = 5.40001;
    private static DebugManager s_instance = null;
    private SettingsManager m_settingsMgr;
    private SettingsManager m_paseSettingsMgr;
    private DebugManagerActionGroup m_actionGroup;
    private Menubar m_menuBar;
    private Toolbar m_toolBar;
    private JPanel m_contentPane;
    private JSplitPane m_splitPane;
    private Tbl m_table;
    private TblModel m_tableModel;
    private JScrollPane m_tableScroll;
    private DebugManagerContextMenu m_contextMenu;
    private JTabbedPane m_tabPane;
    private JTabbedPane m_logPane;
    private LogText m_log;
    private JScrollPane m_logScroll;
    private JPanel m_piranha;
    private WatchThread m_thread;
    private PacketInflater m_inflater;
    private int[] m_columns;
    private Vector m_systems;
    private File m_file;
    private Dialog m_activeDialog;
    private int m_watchInterval;
    private int m_portArg;
    private boolean m_isLtoR;
    private boolean m_closing;
    static /* synthetic */ Class class$com$ibm$iseries$debugmanager$DebugManager;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$String;

    public static boolean instanceValid() {
        return s_instance != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DebugManager instance() {
        if (s_instance == null) {
            Class clazz = class$com$ibm$iseries$debugmanager$DebugManager == null ? (class$com$ibm$iseries$debugmanager$DebugManager = DebugManager.class$("com.ibm.iseries.debugmanager.DebugManager")) : class$com$ibm$iseries$debugmanager$DebugManager;
            synchronized (clazz) {
                if (s_instance == null) {
                    s_instance = new DebugManager();
                }
            }
        }
        return s_instance;
    }

    public DebugManager() {
        Util.registerApp();
        this.setDefaultCloseOperation(2);
        MRI.init();
        this.m_settingsMgr = SettingsManager.instance(0);
        this.m_paseSettingsMgr = SettingsManager.instance(1);
        this.m_settingsMgr.init("com/ibm/iseries/debug/idbg.cfg", ".idbg", SettingsManager.IDBG_COMMENT);
        this.m_paseSettingsMgr.init("com/ibm/iseries/pase/idbgpase.cfg", ".idbgpase", SettingsManager.PASE_COMMENT);
        String string = MRI.get("DBGMGR_TITLE_BAR");
        ImageIcon imageIcon = MRI.getIcon(2, GIF);
        imageIcon.setDescription(string);
        this.setTitle(string);
        ((Frame)this).setIconImage(imageIcon.getImage());
        this.m_inflater = new DebugManagerPacketInflater();
        this.m_isLtoR = MRI.isLtoR();
        this.m_columns = new int[4];
        int n = 0;
        while (n < 4) {
            this.m_columns[this.mapColIndex((int)n)] = n;
            ++n;
        }
        this.m_file = new File(System.getProperty("user.home"), USER_CACHE);
        this.m_portArg = -1;
        this.m_systems = new Vector();
    }

    public SettingsManager getSettingsManager() {
        return this.m_settingsMgr;
    }

    public Settings getUserConfig() {
        return this.m_settingsMgr.getUserConfig();
    }

    public DebugManagerActionGroup getActionGroup() {
        return this.m_actionGroup;
    }

    public Action getAction(String string) {
        return this.m_actionGroup.getAction(string);
    }

    public Menubar getMenubar() {
        return this.m_menuBar;
    }

    public void loadConfig() {
        Settings settings = this.m_settingsMgr.getUserConfig();
        this.m_watchInterval = settings.getInt("dbgmgrWatchInterval", 15);
        String string = System.getProperty("os.name");
        String string2 = string.startsWith("Windows") ? "com.sun.java.swing.plaf.windows.WindowsLookAndFeel" : UIManager.getCrossPlatformLookAndFeelClassName();
        String string3 = settings.getString("lookAndFeel", string2);
        LAFManager.instance().setLookAndFeel(string3, false);
        this.m_actionGroup = new DebugManagerActionGroup(settings);
        this.m_menuBar = new DebugManagerMenubar(this.m_actionGroup);
        this.m_toolBar = new DebugManagerToolbar(this.m_actionGroup);
        this.setJMenuBar(this.m_menuBar);
        this.m_tableModel = new TblModel();
        this.m_table = new Tbl(this.m_tableModel);
        this.m_tableScroll = new JScrollPane(this.m_table);
        if (this.m_table.getRowHeight() < 18) {
            this.m_table.setRowHeight(18);
        }
        this.m_table.registerKeyboardAction(this, DELETE, KeyStroke.getKeyStroke(127, 0), 2);
        String string4 = MRI.get("DBGMGR_MESSAGES_DESCRIPTION");
        ImageIcon imageIcon = MRI.getIcon(0, MESSAGES_GIF);
        this.m_log = new LogText();
        this.m_logScroll = new JScrollPane(this.m_log);
        this.m_logPane = new JTabbedPane();
        this.m_logPane.addTab(string4, imageIcon, this.m_logScroll);
        this.m_table.getSelectionModel().addListSelectionListener(this);
        this.m_table.addMouseListener(this);
        this.m_tableScroll.getViewport().addMouseListener(this);
        this.m_log.addMouseListener(this);
        LAFManager.instance().addListener(this);
        Util.setOrientation(this);
        Util.setOrientation(this.m_logPane);
        Util.setOrientation(this.m_tableScroll);
        Util.setOrientation(this.m_logScroll);
        Util.setOrientation(this.m_log);
        this.m_splitPane = new JSplitPane(0, this.m_tableScroll, this.m_logPane);
        this.m_splitPane.setOneTouchExpandable(true);
        this.m_contentPane = new JPanel(new BorderLayout());
        this.m_contentPane.add((Component)this.m_toolBar, "North");
        try {
            Class<?> clazz = Class.forName("com.ibm.piranha.debugmanager.JPiranhaDebugMgr");
            this.m_piranha = (JPanel)clazz.newInstance();
            this.m_tabPane = new JTabbedPane();
            this.m_tabPane.add("OS/400", this.m_splitPane);
            this.m_tabPane.add("Piranha", this.m_piranha);
            this.m_tabPane.addChangeListener(this);
            this.m_tabPane.addChangeListener((ChangeListener)((Object)this.m_piranha));
            this.m_contentPane.add((Component)this.m_tabPane, "Center");
        }
        catch (Throwable throwable) {
            this.m_contentPane.add((Component)this.m_splitPane, "Center");
        }
        this.setContentPane(this.m_contentPane);
        this.lookAndFeelModifications();
        this.loadMgrConfig();
    }

    private void lookAndFeelModifications() {
        this.m_tableScroll.getViewport().setBackground(this.m_table.getBackground());
        this.m_table.getTableHeader().setReorderingAllowed(false);
        this.m_contextMenu = new DebugManagerContextMenu(this.m_actionGroup);
    }

    public void parseArgs(String[] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            boolean bl;
            block9: {
                block8: {
                    char c = stringArray[n].charAt(0);
                    int n2 = stringArray[n].length() > 1 ? (int)stringArray[n].charAt(1) : 32;
                    bl = false;
                    if (c != '-') break block8;
                    switch (n2) {
                        case 112: {
                            if ((stringArray[n].equals("-p") || stringArray[n].equals("-port")) && ++n < stringArray.length) {
                                this.m_portArg = Integer.parseInt(stringArray[n]);
                                break;
                            }
                            bl = true;
                            break;
                        }
                        case 115: {
                            if (stringArray[n].equals("-srcUnicode") && ++n < stringArray.length) {
                                String string = stringArray[n].toUpperCase();
                                SourceViewManager.setUnicodeSrc(string.equals("YES"));
                            } else {
                                break;
                            }
                        }
                    }
                    break block9;
                }
                bl = true;
            }
            if (bl) {
                System.out.println("Bad argument:" + stringArray[n]);
            }
            ++n;
        }
    }

    public void init() {
        this.m_thread = new WatchThread();
        this.m_thread.setDaemon(true);
        this.m_thread.start();
        this.m_table.requestFocus();
    }

    public void close() {
        if (s_instance == null) {
            return;
        }
        Util.deregisterApp();
        this.m_closing = true;
        if (this.m_thread != null) {
            this.m_thread.halt();
            this.m_thread.interrupt();
            this.m_thread = null;
        }
        int n = this.m_systems.size();
        int n2 = 0;
        while (n2 < n) {
            SystemRec systemRec = (SystemRec)this.m_systems.elementAt(n2);
            this.closeCommLink(systemRec);
            ++n2;
        }
        this.commitMgrConfig();
        this.m_menuBar.cleanUp();
        this.m_toolBar.cleanUp();
        LAFManager.instance().removeListener(this);
        s_instance = null;
        if (this.m_piranha != null) {
            this.m_piranha.equals("CLOSING");
        }
        if (Util.getAppCount() == 0) {
            System.exit(0);
        } else {
            this.dispose();
        }
    }

    private void loadMgrConfig() {
        int n;
        Settings settings = this.m_settingsMgr.getUserConfig();
        Dimension dimension = this.getToolkit().getScreenSize();
        int n2 = settings.getInt("dbgmgrWindowTop", 100);
        int n3 = settings.getInt("dbgmgrWindowLeft", 100);
        if (n2 < 0 || n2 > dimension.height) {
            n2 = 0;
        }
        if (n3 < 0 || n3 > dimension.width) {
            n3 = 0;
        }
        ((Component)this).setLocation(n3, n2);
        int n4 = settings.getInt("dbgmgrTableWidth", 500);
        int n5 = settings.getInt("dbgmgrTableHeight", 50);
        int n6 = settings.getInt("dbgmgrTableDiv", 50);
        this.m_table.setPreferredScrollableViewportSize(new Dimension(n4, n5));
        this.m_tableScroll.setMinimumSize(new Dimension(100, 37));
        this.m_splitPane.setDividerLocation(n6);
        int n7 = settings.getInt("dbgmgrDebugColWidth", -1);
        int n8 = settings.getInt("dbgmgrSystemColWidth", -1);
        int n9 = settings.getInt("dbgmgrUserColWidth", -1);
        int n10 = settings.getInt("dbgmgrStatusColWidth", -1);
        if (n7 >= 0) {
            TableColumn tableColumn = this.m_table.getColumnModel().getColumn(this.mapColIndex(0));
            n = ((Component)this.m_table).getFontMetrics(this.m_table.getFont()).stringWidth(MRI.get("DBGMGR_DEBUG"));
            tableColumn.setMinWidth(n + 10);
            tableColumn.setMaxWidth(n + 10);
            tableColumn.setPreferredWidth(n7);
        }
        if (n8 >= 0) {
            this.m_table.getColumnModel().getColumn(this.mapColIndex(1)).setPreferredWidth(n8);
        }
        if (n9 >= 0) {
            this.m_table.getColumnModel().getColumn(this.mapColIndex(2)).setPreferredWidth(n9);
        }
        if (n10 >= 0) {
            this.m_table.getColumnModel().getColumn(this.mapColIndex(3)).setPreferredWidth(n10);
        }
        int n11 = settings.getInt("dbgmgrLogWidth", 500);
        n = settings.getInt("dbgmgrLogHeight", 50);
        this.m_logScroll.setMinimumSize(new Dimension(100, 20));
        this.m_logScroll.setPreferredSize(new Dimension(n11, n));
        try {
            if (this.m_file.exists() && this.m_file.canRead()) {
                DebugFile debugFile = new DebugFile(this.m_file);
                int n12 = debugFile.readInt();
                int n13 = -1;
                int n14 = 0;
                while (n14 < n12) {
                    SystemRec systemRec = new SystemRec(debugFile);
                    if (n13 < 0 && systemRec.m_debug) {
                        n13 = n14;
                    }
                    this.m_systems.addElement(systemRec);
                    ++n14;
                }
                debugFile.close();
                Collections.sort(this.m_systems);
                if (n13 > 0) {
                    this.m_table.setRowSelectionInterval(n13, n13);
                } else if (n12 > 0) {
                    this.m_table.setRowSelectionInterval(0, 0);
                }
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    private void commitMgrConfig() {
        Settings settings = this.m_settingsMgr.getUserConfig();
        Rectangle rectangle = this.getBounds();
        Rectangle rectangle2 = this.m_tableScroll.getViewportBorderBounds();
        Dimension dimension = this.m_logScroll.getSize();
        settings.setInt("dbgmgrWindowTop", rectangle.y);
        settings.setInt("dbgmgrWindowLeft", rectangle.x);
        settings.setInt("dbgmgrTableWidth", rectangle2.width);
        settings.setInt("dbgmgrTableHeight", rectangle2.height);
        settings.setInt("dbgmgrTableDiv", this.m_splitPane.getDividerLocation());
        settings.setInt("dbgmgrDebugColWidth", this.m_table.getColumnModel().getColumn(this.mapColIndex(0)).getWidth());
        settings.setInt("dbgmgrSystemColWidth", this.m_table.getColumnModel().getColumn(this.mapColIndex(1)).getWidth());
        settings.setInt("dbgmgrUserColWidth", this.m_table.getColumnModel().getColumn(this.mapColIndex(2)).getWidth());
        settings.setInt("dbgmgrStatusColWidth", this.m_table.getColumnModel().getColumn(this.mapColIndex(3)).getWidth());
        settings.setInt("dbgmgrLogWidth", dimension.width);
        settings.setInt("dbgmgrLogHeight", dimension.height);
        settings.setString("lookAndFeel", LAFManager.instance().getLookAndFeel());
        settings.commit();
        this.m_paseSettingsMgr.commitUserConfig();
        try {
            DebugFile debugFile = new DebugFile(this.m_file, 5.40001);
            int n = this.m_systems.size();
            debugFile.writeInt(n);
            int n2 = 0;
            while (n2 < n) {
                SystemRec systemRec = (SystemRec)this.m_systems.elementAt(n2);
                systemRec.write(debugFile);
                ++n2;
            }
            debugFile.close();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public void refresh() {
        this.m_menuBar.repaint(this.m_menuBar.getVisibleRect());
        this.m_toolBar.repaint(this.m_toolBar.getVisibleRect());
        this.m_logPane.repaint(this.m_logPane.getVisibleRect());
        this.m_table.repaint(this.m_table.getVisibleRect());
        this.m_tableScroll.repaint(this.m_tableScroll.getVisibleRect());
    }

    public void removeSystems(String[] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            int n2 = Collections.binarySearch(this.m_systems, stringArray[n]);
            if (n2 >= 0) {
                SystemRec systemRec = (SystemRec)this.m_systems.elementAt(n2);
                this.m_systems.removeElementAt(n2);
                this.m_tableModel.fireTableRowsDeleted(n2, n2);
            }
            ++n;
        }
        this.m_table.clearSelection();
        this.prepareActionContext();
    }

    public void logMsg(String string) {
        this.m_log.logMsg(string);
    }

    public void clearMessages() {
        this.m_log.clear();
    }

    public String[] getSelectedSystems() {
        int[] nArray = this.m_table.getSelectedRows();
        String[] stringArray = new String[nArray.length];
        int n = 0;
        while (n < nArray.length) {
            SystemRec systemRec = (SystemRec)this.m_systems.elementAt(nArray[n]);
            stringArray[n] = systemRec.m_systemName;
            ++n;
        }
        return stringArray;
    }

    public String[] getUsers(String string) {
        String[] stringArray = null;
        int n = Collections.binarySearch(this.m_systems, string);
        if (n >= 0) {
            SystemRec systemRec = (SystemRec)this.m_systems.elementAt(n);
            stringArray = systemRec.getUsers();
        }
        return stringArray;
    }

    public void addUserToSystem(String string, String string2, boolean bl) {
        string = Util.firstUpper(string);
        string2 = Util.firstUpper(string2);
        SystemRec systemRec = null;
        int n = Collections.binarySearch(this.m_systems, string);
        boolean bl2 = false;
        if (n < 0) {
            n = n * -1 - 1;
            systemRec = new SystemRec(string, true);
            this.m_systems.insertElementAt(systemRec, n);
            this.m_tableModel.fireTableRowsInserted(n, n);
            bl2 = systemRec.m_debug;
        } else {
            systemRec = (SystemRec)this.m_systems.elementAt(n);
        }
        if (systemRec != null) {
            systemRec.addUser(string2, bl);
            this.m_tableModel.fireTableRowsUpdated(n, n);
            this.m_table.setRowSelectionInterval(n, n);
        }
        if (bl2) {
            this.createCommLink(systemRec, true);
        } else {
            String[] stringArray = new String[]{string2};
            this.registerUsers(systemRec, stringArray);
        }
        this.prepareActionContext();
    }

    public void removeUsersFromSystem(String string, String[] stringArray) {
        int n = Collections.binarySearch(this.m_systems, string);
        if (n >= 0) {
            SystemRec systemRec = (SystemRec)this.m_systems.elementAt(n);
            systemRec.removeUsers(stringArray);
            this.deregisterUsers(systemRec, stringArray);
            if (systemRec.getUserCount() == 0) {
                this.closeCommLink(systemRec);
                systemRec.m_debug = false;
                systemRec.m_commLink = null;
            }
            this.m_tableModel.fireTableRowsUpdated(n, n);
            this.m_table.setRowSelectionInterval(n, n);
        }
        this.prepareActionContext();
    }

    private boolean sendRequest(SystemRec systemRec, Request request) {
        boolean bl = false;
        if (systemRec.m_commLink != null) {
            try {
                bl = systemRec.m_commLink.sendRequest(request);
                request.cleanUp();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
        return bl;
    }

    private void registerUsers(SystemRec systemRec, String[] stringArray) {
        if (systemRec.m_commLink == null || !systemRec.m_commLink.isConnected() || stringArray.length == 0) {
            return;
        }
        this.sendRequest(systemRec, new RegisterUsersRequest(stringArray));
    }

    private void deregisterUsers(SystemRec systemRec, String[] stringArray) {
        if (systemRec.m_commLink == null || !systemRec.m_commLink.isConnected() || stringArray.length == 0) {
            return;
        }
        this.sendRequest(systemRec, new DeregisterUsersRequest(stringArray));
    }

    private void clearActionContext() {
        if (this.m_closing) {
            return;
        }
        this.m_actionGroup.getAction("strdbg2").setEnabled(false);
        this.m_actionGroup.getAction("strpasedbg").setEnabled(false);
        this.m_actionGroup.getAction("rmvsys").setEnabled(false);
        this.m_actionGroup.getAction("addusr").setEnabled(false);
        this.m_actionGroup.getAction("rmvusr").setEnabled(false);
    }

    private void prepareActionContext() {
        if (this.m_closing) {
            return;
        }
        int[] nArray = this.m_table.getSelectedRows();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        this.m_actionGroup.clearSystemContext();
        if (nArray.length > 0) {
            if (nArray.length == 1) {
                bl4 = true;
                SystemRec systemRec = (SystemRec)this.m_systems.elementAt(nArray[0]);
                if (systemRec != null) {
                    this.m_actionGroup.setSystemContext(systemRec.m_systemName, systemRec.getUsers());
                    if (systemRec.m_debug && systemRec.m_commLink != null && systemRec.m_commLink.isConnected()) {
                        bl = true;
                        bl2 = this.isSupported(1, systemRec.m_commLink.getSystemVersion());
                    }
                    if (systemRec.m_users.size() > 0) {
                        bl5 = true;
                    }
                }
            }
            bl3 = true;
        }
        this.m_actionGroup.getAction("strdbg2").setEnabled(bl);
        this.m_actionGroup.getAction("strpasedbg").setEnabled(bl2);
        this.m_actionGroup.getAction("rmvsys").setEnabled(bl3);
        this.m_actionGroup.getAction("addusr").setEnabled(bl4);
        this.m_actionGroup.getAction("rmvusr").setEnabled(bl5);
    }

    private void createCommLink(SystemRec systemRec, boolean bl) {
        try {
            Object object;
            if (systemRec.m_commLink == null) {
                object = "";
                if (systemRec.m_users.size() > 0) {
                    UserRec userRec = (UserRec)systemRec.m_users.elementAt(0);
                    object = userRec.m_user;
                }
                systemRec.m_commLink = new CommLink(this, systemRec.m_systemName, (String)object, this.m_portArg, "as-debug", this.m_inflater);
                systemRec.m_commLink.addListener(this);
            }
            if (bl) {
                object = new ConnectThread(systemRec);
                ((Thread)object).start();
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    private void closeCommLink(SystemRec systemRec) {
        if (systemRec.m_commLink != null) {
            this.deregisterUsers(systemRec, systemRec.getUsers());
            systemRec.m_commLink.close();
        }
    }

    private boolean attemptConnect(SystemRec systemRec) {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        block7: while (!bl && !bl2) {
            systemRec.m_commLink.connect(true);
            switch (systemRec.m_commLink.getStatus()) {
                case 2: {
                    String[] stringArray = systemRec.getUsers();
                    if (stringArray.length == 0) {
                        systemRec.addUser(Util.firstUpper(systemRec.m_commLink.getUser()), PasswordSecurity.instance().rememberPassword());
                        this.m_table.repaint(this.m_table.getVisibleRect());
                    }
                    this.registerUsers(systemRec, systemRec.getUsers());
                    bl = true;
                    break;
                }
                case -1: {
                    String[] stringArray;
                    if (!bl3 && systemRec.m_users.size() > 0) {
                        stringArray = systemRec.getUsers();
                        try {
                            AS400 aS400 = Toolbox.instance().getAS400(systemRec.m_systemName, stringArray[0]);
                            if (aS400 == null) continue block7;
                            Object[] objectArray = new Object[]{systemRec.m_systemName};
                            String string = MessageFormat.format(MRI.get("DBGMGR_STRTCPSVR_FMT"), objectArray);
                            this.m_log.logMsg(string);
                            CommandCall commandCall = new CommandCall(aS400);
                            bl3 = true;
                            if (commandCall.run("QSYS/STRTCPSVR SERVER(*DBG)")) continue block7;
                            bl2 = !commandCall.run("CALL PGM(QSYS/QTESSTRSVR)");
                        }
                        catch (Throwable throwable) {
                            bl2 = true;
                        }
                        continue block7;
                    }
                    bl2 = true;
                    break;
                }
                case 7: {
                    systemRec.m_debug = false;
                    bl2 = true;
                    break;
                }
                default: {
                    bl2 = true;
                }
            }
        }
        return bl;
    }

    private int mapColIndex(int n) {
        if (!this.m_isLtoR) {
            n = 4 - n - 1;
        }
        return n;
    }

    protected void processWindowEvent(WindowEvent windowEvent) {
        super.processWindowEvent(windowEvent);
        if (windowEvent.getID() == 202) {
            this.close();
        }
    }

    public JFrame getJFrame() {
        return this;
    }

    public int getHelpSetId() {
        return 0;
    }

    public String getSystem() {
        return this.m_actionGroup.getSystem();
    }

    public double getSystemVersion() {
        double d = 0.0;
        int n = this.m_table.getSelectedRow();
        if (n >= 0) {
            SystemRec systemRec = (SystemRec)this.m_systems.elementAt(n);
            if (systemRec.m_commLink != null && systemRec.m_commLink.isConnected()) {
                d = systemRec.m_commLink.getSystemVersion();
            }
        }
        return d;
    }

    public boolean isSupported(int n, double d) {
        switch (n) {
            case 1: {
                return d >= 5.20002;
            }
            case 2: 
            case 3: 
            case 4: {
                return d >= 5.10002 && d < 5.20001 || d >= 5.20002;
            }
            case 8: {
                return d >= 5.20003;
            }
            case 9: {
                return d >= 5.30002;
            }
        }
        return false;
    }

    public String getUser() {
        return this.m_actionGroup.getUser();
    }

    public void postClock() {
        this.setCursor(Cursor.getPredefinedCursor(3));
    }

    public void retractClock() {
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    public void cancelClock() {
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    public Dialog getActiveDialog() {
        return this.m_activeDialog;
    }

    public void setActiveDialog(Dialog dialog) {
        this.m_activeDialog = dialog;
    }

    public boolean sendRequest(Request request) {
        boolean bl = false;
        if (this.m_table.getSelectedRowCount() == 1) {
            int n = this.m_table.getSelectedRow();
            SystemRec systemRec = (SystemRec)this.m_systems.elementAt(n);
            if (systemRec.m_commLink == null || !systemRec.m_commLink.isConnected() || !systemRec.m_debug) {
                systemRec.m_debug = true;
                this.createCommLink(systemRec, true);
                this.prepareActionContext();
                this.m_table.repaint(this.m_table.getVisibleRect());
            }
            int n2 = 0;
            while (n2 < 5) {
                if (!systemRec.m_commLink.isConnected()) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                if (systemRec.m_commLink.isConnected()) {
                    bl = this.sendRequest(systemRec, request);
                    break;
                }
                if (systemRec.m_commLink.isFailed()) {
                    request.cleanUp();
                    break;
                }
                ++n2;
            }
        }
        return bl;
    }

    public void commLinkStatusChanged(CommLinkEvent commLinkEvent) {
        if (this.m_closing) {
            return;
        }
        this.m_table.repaint(this.m_table.getVisibleRect());
        CommLink commLink = (CommLink)commLinkEvent.getSource();
        switch (commLinkEvent.getType()) {
            case -1: {
                Object[] objectArray = new Object[]{Util.firstUpper(commLink.getSystem())};
                String string = MessageFormat.format(MRI.get("DBG_COMMUNICATION_ERROR_FMT"), objectArray);
                this.m_log.logMsg(string);
                break;
            }
            case 1: {
                Object[] objectArray = new Object[]{Util.firstUpper(commLink.getSystem()), commLink.getIp()};
                String string = MessageFormat.format(MRI.get("DBG_CONNECTING_FMT"), objectArray);
                this.m_log.logMsg(string);
                break;
            }
            case 2: {
                Object[] objectArray = new Object[]{Util.firstUpper(commLink.getSystem()), commLink.getIp()};
                String string = MessageFormat.format(MRI.get("DBG_CONNECTED_FMT"), objectArray);
                this.m_log.logMsg(string);
                break;
            }
            case 4: {
                Object[] objectArray = new Object[]{Util.firstUpper(commLink.getSystem())};
                String string = MessageFormat.format(MRI.get("DBG_DROPPED_CONNECTION_FMT"), objectArray);
                this.m_log.logMsg(string);
            }
        }
        this.prepareActionContext();
    }

    public void commLinkPacket(CommLinkEvent commLinkEvent) {
        Packet packet = commLinkEvent.getPacket();
        if (packet != null) {
            SwingUtilities.invokeLater(packet);
        }
    }

    public void lookAndFeelChanged(LAFEvent lAFEvent) {
        this.lookAndFeelModifications();
    }

    private boolean handlePopupMenu(MouseEvent mouseEvent) {
        boolean bl = false;
        if (mouseEvent.isPopupTrigger()) {
            Component component = (Component)mouseEvent.getSource();
            if (component == this.m_table) {
                int n = this.m_table.rowAtPoint(mouseEvent.getPoint());
                if (n >= 0) {
                    if (this.m_table.isRowSelected(n)) {
                        this.prepareActionContext();
                    } else {
                        this.m_table.setRowSelectionInterval(n, n);
                    }
                } else {
                    this.clearActionContext();
                }
            } else {
                this.clearActionContext();
            }
            this.m_contextMenu.show(component, mouseEvent.getX(), mouseEvent.getY());
            bl = true;
        } else {
            this.prepareActionContext();
        }
        return bl;
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.handlePopupMenu(mouseEvent);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.handlePopupMenu(mouseEvent);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Action action;
        String string = actionEvent.getActionCommand();
        if (string.equals(DELETE) && this.m_table.hasFocus() && (action = this.m_actionGroup.getAction("rmvsys")).isEnabled()) {
            action.run();
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.prepareActionContext();
    }

    public void stateChanged(ChangeEvent changeEvent) {
        if (this.m_tabPane.getSelectedComponent() == this.m_splitPane) {
            this.setJMenuBar(this.m_menuBar);
            Component[] componentArray = this.m_contentPane.getComponents();
            int n = 0;
            while (n < componentArray.length) {
                if (componentArray[n] instanceof JToolBar) {
                    this.m_contentPane.remove(n);
                    this.m_contentPane.add((Component)this.m_toolBar, "North");
                    break;
                }
                ++n;
            }
        }
    }

    public static void main(String[] stringArray) {
        DebugManager debugManager = DebugManager.instance();
        debugManager.loadConfig();
        debugManager.parseArgs(stringArray);
        debugManager.pack();
        ((Component)debugManager).setVisible(true);
        debugManager.init();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class LogText
    extends JTextArea
    implements Runnable {
        private ArrayList m_msgs;
        private int m_fontHeight;
        private DateFormat m_dateFmt;

        public LogText() {
            this.setEditable(false);
            this.m_msgs = new ArrayList();
            this.m_fontHeight = ((Component)this).getFontMetrics(this.getFont()).getHeight();
            this.m_dateFmt = DateFormat.getInstance();
            Util.setAccessible((Accessible)this, MRI.get("DBGMGR_MESSAGES_DESCRIPTION"));
        }

        public void clear() {
            this.setText("");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void logMsg(String string) {
            Class clazz = class$com$ibm$iseries$debugmanager$DebugManager == null ? (class$com$ibm$iseries$debugmanager$DebugManager = DebugManager.class$("com.ibm.iseries.debugmanager.DebugManager")) : class$com$ibm$iseries$debugmanager$DebugManager;
            synchronized (clazz) {
                this.m_msgs.add(string);
                SwingUtilities.invokeLater(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            String string = null;
            Class clazz = class$com$ibm$iseries$debugmanager$DebugManager == null ? (class$com$ibm$iseries$debugmanager$DebugManager = DebugManager.class$("com.ibm.iseries.debugmanager.DebugManager")) : class$com$ibm$iseries$debugmanager$DebugManager;
            synchronized (clazz) {
                string = (String)this.m_msgs.get(0);
                this.m_msgs.remove(0);
            }
            this.append("<" + this.m_dateFmt.format(new Date()) + "> ");
            if (string.endsWith("\n")) {
                this.append(string);
            } else {
                this.append(string + "\n");
            }
            Rectangle rectangle = this.getVisibleRect();
            rectangle.y = (this.getLineCount() + 1) * this.m_fontHeight - rectangle.height;
            if (rectangle.y > 0) {
                this.scrollRectToVisible(rectangle);
            }
        }

        public boolean isManagingFocus() {
            return false;
        }
    }

    private class TblModel
    extends AbstractTableModel {
        private TblModel() {
        }

        public int getColumnCount() {
            return 4;
        }

        public int getRowCount() {
            return DebugManager.this.m_systems.size();
        }

        public String getColumnName(int n) {
            switch (DebugManager.this.m_columns[n]) {
                case 0: {
                    return MRI.get("DBGMGR_DEBUG");
                }
                case 1: {
                    return MRI.get("DBGMGR_SYSTEM");
                }
                case 2: {
                    return MRI.get("DBGMGR_USER");
                }
                case 3: {
                    return MRI.get("DBGMGR_STATUS");
                }
            }
            return " ";
        }

        public Object getValueAt(int n, int n2) {
            SystemRec systemRec = (SystemRec)DebugManager.this.m_systems.elementAt(n);
            Object object = null;
            switch (DebugManager.this.m_columns[n2]) {
                case 0: {
                    object = new Boolean(systemRec.m_debug);
                    break;
                }
                case 1: {
                    object = systemRec.m_systemName;
                    break;
                }
                case 2: {
                    object = systemRec.m_userStr;
                    break;
                }
                case 3: {
                    if (systemRec.m_commLink != null) {
                        switch (systemRec.m_commLink.getStatus()) {
                            case 1: {
                                object = MRI.get("DBGMGR_CONNECTING");
                                break;
                            }
                            case 2: {
                                object = MRI.get("DBGMGR_READY");
                                break;
                            }
                            case 3: {
                                object = MRI.get("DBGMGR_DISCONNECTING");
                                break;
                            }
                            case 0: 
                            case 7: {
                                object = "";
                                break;
                            }
                            case 8: {
                                object = MRI.get("DBGMGR_PORT_NOT_MAPPED");
                                systemRec.m_label.setText(MRI.get("DBGMGR_PORT_NOT_MAPPED"));
                                break;
                            }
                            case -1: 
                            case 4: {
                                object = systemRec.m_debug ? MRI.get("DBGMGR_FAILED") : "";
                            }
                        }
                        break;
                    }
                    object = "";
                }
            }
            return object;
        }

        public void setValueAt(Object object, int n, int n2) {
            if (DebugManager.this.m_columns[n2] == 0) {
                SystemRec systemRec = (SystemRec)DebugManager.this.m_systems.elementAt(n);
                boolean bl = (Boolean)object;
                if (systemRec.m_debug != bl) {
                    systemRec.m_debug = bl;
                    if (systemRec.m_debug) {
                        DebugManager.this.createCommLink(systemRec, true);
                    } else {
                        DebugManager.this.closeCommLink(systemRec);
                    }
                    DebugManager.this.prepareActionContext();
                    DebugManager.this.m_table.repaint(DebugManager.this.m_table.getVisibleRect());
                }
            }
        }

        public Class getColumnClass(int n) {
            switch (DebugManager.this.m_columns[n]) {
                case 0: {
                    return class$java$lang$Boolean == null ? (class$java$lang$Boolean = DebugManager.class$("java.lang.Boolean")) : class$java$lang$Boolean;
                }
                case 1: 
                case 2: 
                case 3: {
                    return class$java$lang$String == null ? (class$java$lang$String = DebugManager.class$("java.lang.String")) : class$java$lang$String;
                }
            }
            return class$java$lang$String == null ? (class$java$lang$String = DebugManager.class$("java.lang.String")) : class$java$lang$String;
        }

        public boolean isCellEditable(int n, int n2) {
            return DebugManager.this.m_columns[n2] == 0;
        }
    }

    private class Tbl
    extends JTable {
        private DefaultTableCellRenderer m_renderer;
        private ImageIcon m_connectingIcon;
        private ImageIcon m_connectedIcon;
        private ImageIcon m_disconnectedIcon;
        private ImageIcon m_failedIcon;

        public Tbl(AbstractTableModel abstractTableModel) {
            super(abstractTableModel);
            Util.setAccessible((Accessible)this, MRI.get("DBGMGR_LIST_DESCRIPTION"));
            this.m_renderer = new DefaultTableCellRenderer();
            this.m_renderer.setIconTextGap(10);
            this.m_connectingIcon = MRI.getIcon(2, DebugManager.CONNECTING_GIF);
            this.m_connectedIcon = MRI.getIcon(2, DebugManager.CONNECTED_GIF);
            this.m_disconnectedIcon = MRI.getIcon(2, DebugManager.DISCONNECTED_GIF);
            this.m_failedIcon = MRI.getIcon(2, DebugManager.FAILED_GIF);
            this.m_connectingIcon.setDescription(MRI.get("DBGMGR_CONNECTING"));
            this.m_connectedIcon.setDescription(MRI.get("DBGMGR_READY"));
            this.m_disconnectedIcon.setDescription(MRI.get("DBGMGR_DISCONNECTED"));
            this.m_failedIcon.setDescription(MRI.get("DBGMGR_FAILED"));
        }

        public TableCellRenderer getCellRenderer(int n, int n2) {
            if (DebugManager.this.m_columns[n2] == 3) {
                SystemRec systemRec = (SystemRec)DebugManager.this.m_systems.elementAt(n);
                if (systemRec.m_commLink != null) {
                    switch (systemRec.m_commLink.getStatus()) {
                        case 1: {
                            this.m_renderer.setIcon(this.m_connectingIcon);
                            break;
                        }
                        case 2: {
                            this.m_renderer.setIcon(this.m_connectedIcon);
                            break;
                        }
                        case 0: 
                        case 3: 
                        case 7: {
                            this.m_renderer.setIcon(this.m_disconnectedIcon);
                            break;
                        }
                        case -1: 
                        case 4: 
                        case 8: {
                            this.m_renderer.setIcon(this.m_failedIcon);
                        }
                    }
                } else {
                    this.m_renderer.setIcon(this.m_disconnectedIcon);
                }
                return this.m_renderer;
            }
            return super.getCellRenderer(n, n2);
        }
    }

    private class WatchThread
    extends Thread {
        private int m_sleepTime;
        private boolean m_halt;

        private WatchThread() {
            this.m_sleepTime = 60 * DebugManager.this.m_watchInterval * 1000;
            this.m_halt = false;
        }

        public void halt() {
            this.m_halt = true;
        }

        public void run() {
            while (!this.m_halt) {
                int n = DebugManager.this.m_systems.size();
                int n2 = 0;
                while (n2 < n) {
                    SystemRec systemRec = (SystemRec)DebugManager.this.m_systems.elementAt(n2);
                    if (systemRec.m_debug && (systemRec.m_commLink == null || !systemRec.m_commLink.isConnected() && !systemRec.m_commLink.isConnecting())) {
                        DebugManager.this.createCommLink(systemRec, true);
                    }
                    ++n2;
                }
                try {
                    Thread.sleep(this.m_sleepTime);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    private class ConnectThread
    extends Thread {
        private SystemRec m_sys = null;

        public ConnectThread(SystemRec systemRec) {
            this.m_sys = systemRec;
        }

        public void run() {
            if (this.m_sys != null) {
                DebugManager.this.attemptConnect(this.m_sys);
            }
        }
    }

    private class SystemRec
    implements Comparable {
        public String m_systemName = "";
        public CommLink m_commLink = null;
        public boolean m_debug = false;
        public Vector m_users = null;
        public String m_userStr = "";
        public JLabel m_label = null;

        public SystemRec(String string, boolean bl) {
            this.m_systemName = string;
            this.m_debug = bl;
            this.m_users = new Vector();
            this.m_label = new JLabel();
        }

        public SystemRec(DebugFile debugFile) throws IOException {
            this.m_label = new JLabel();
            this.m_systemName = debugFile.readString();
            this.m_debug = debugFile.readBoolean();
            int n = debugFile.readInt();
            this.m_users = new Vector();
            int n2 = 0;
            while (n2 < n) {
                String string = debugFile.readString();
                boolean bl = debugFile.readBoolean();
                UserRec userRec = new UserRec(string, bl);
                this.m_users.addElement(userRec);
                this.genUserStr();
                ++n2;
            }
            Collections.sort(this.m_users);
        }

        public void write(DebugFile debugFile) throws IOException {
            debugFile.writeString(this.m_systemName);
            debugFile.writeBoolean(this.m_debug);
            int n = this.m_users.size();
            debugFile.writeInt(n);
            int n2 = 0;
            while (n2 < n) {
                UserRec userRec = (UserRec)this.m_users.elementAt(n2);
                debugFile.writeString(userRec.m_user);
                debugFile.writeBoolean(userRec.m_rememberPassword);
                ++n2;
            }
        }

        public int getUserCount() {
            return this.m_users.size();
        }

        public String[] getUsers() {
            int n = this.m_users.size();
            String[] stringArray = new String[n];
            int n2 = 0;
            while (n2 < n) {
                UserRec userRec = (UserRec)this.m_users.elementAt(n2);
                stringArray[n2] = userRec.m_user;
                ++n2;
            }
            return stringArray;
        }

        public void addUser(String string, boolean bl) {
            int n = Collections.binarySearch(this.m_users, string);
            if (n < 0) {
                this.m_users.insertElementAt(new UserRec(string, bl), n * -1 - 1);
                this.genUserStr();
            }
        }

        public void removeUsers(String[] stringArray) {
            int n = 0;
            while (n < stringArray.length) {
                int n2 = Collections.binarySearch(this.m_users, stringArray[n]);
                if (n2 >= 0) {
                    this.m_users.removeElementAt(n2);
                }
                ++n;
            }
            this.genUserStr();
        }

        public void genUserStr() {
            StringBuffer stringBuffer = new StringBuffer(50);
            int n = this.m_users.size();
            int n2 = 0;
            while (n2 < n) {
                UserRec userRec = (UserRec)this.m_users.elementAt(n2);
                if (n2 > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(userRec.m_user);
                ++n2;
            }
            this.m_userStr = stringBuffer.toString();
        }

        public int compareTo(Object object) {
            int n = object instanceof String ? this.m_systemName.compareTo((String)object) : this.m_systemName.compareTo(((SystemRec)object).m_systemName);
            return n;
        }
    }

    private class UserRec
    implements Comparable {
        public String m_user = "";
        public boolean m_rememberPassword;

        public UserRec(String string, boolean bl) {
            this.m_user = string;
            this.m_rememberPassword = bl;
        }

        public int compareTo(Object object) {
            int n = object instanceof String ? this.m_user.compareTo((String)object) : this.m_user.compareTo(((UserRec)object).m_user);
            return n;
        }
    }
}

